/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.relpessoacontato;

import com.touchcomp.basementor.constants.enums.pessoa.EnumConstTipoPessoaComplementar;
import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementor.model.vo.ClienteContSistemas;
import com.touchcomp.basementor.model.vo.Complemento;
import com.touchcomp.basementor.model.vo.EmailPessoa;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.UsuarioClienteContSistemas;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.tools.DateUtil;
import org.hibernate.query.Query;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

class UtilRegistraUsuarioTouch {
    UtilRegistraUsuarioTouch() {
    }

    public String registrarAtualizarUsuario(String mensagem) throws Exception {
        Document d = new SAXBuilder().build((InputStream)new ByteArrayInputStream(mensagem.getBytes()));
        Element root = d.getRootElement();
        Element emp = root.getChild("emp");
        Element user = root.getChild("user");
        UsuarioClienteContSistemas usuario = this.getUsuarioCliente(user, emp);
        Format f = Format.getPrettyFormat();
        f.setEncoding("ISO-8859-1");
        Element el = new Element("mentor");
        Document doc = new Document(el);
        Element codUsuarioMentor = new Element("codUsuarioMentor");
        codUsuarioMentor.setText(usuario.getIdentificador().toString());
        el.addContent((Content)codUsuarioMentor);
        return new XMLOutputter(f).outputString(doc);
    }

    public UsuarioClienteContSistemas getUsuarioCliente(Element user, Element empresa) throws ExceptionService, ExceptionDatabase {
        String cnpjUser;
        String cnpjEmp = empresa.getChild("complemento").getChildText("cnpj");
        UsuarioClienteContSistemas found = this.findUser(cnpjEmp, cnpjUser = user.getChild("complemento").getChildText("cnpj"));
        if (found == null) {
            found = this.findUserFiliais(cnpjEmp, cnpjUser);
        }
        found = this.createUser(found, user, empresa);
        return found;
    }

    private UsuarioClienteContSistemas findUser(String cnpjEmp, String cnpjUser) {
        String query = "select u from UsuarioClienteContSistemas u inner join u.pessoa pU  inner join pU.complemento cU inner join u.clienteContSistemas c inner join c.tomadorPrestadorRps t inner join t.pessoa p inner join p.complemento c where c.cnpj = :cnpjEmp and cU.cnpj = :cnpjUser order by u.identificador";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(query);
        q.setString("cnpjEmp", cnpjEmp);
        q.setString("cnpjUser", cnpjUser);
        q.setMaxResults(1);
        System.out.println("Pesquisando usuairo por cpf/cnpj empresa: " + cnpjUser + "/" + cnpjEmp);
        return (UsuarioClienteContSistemas)q.uniqueResult();
    }

    private UsuarioClienteContSistemas findUserFiliais(String cnpjEmp, String cnpjUser) {
        String query = "select u from UsuarioClienteContSistemas u inner join u.pessoa pU  inner join pU.complemento cU inner join u.clienteContSistemas c inner join c.clienteContSistCnpj resp inner join resp.pessoa p inner join p.complemento c where c.cnpj = :cnpjEmp and cU.cnpj = :cnpjUser order by u.identificador";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(query);
        q.setString("cnpjEmp", cnpjEmp);
        q.setString("cnpjUser", cnpjUser);
        q.setMaxResults(1);
        System.out.println("Pesquisando usuairo por cpf/cnpj empresa: " + cnpjUser + "/" + cnpjEmp);
        return (UsuarioClienteContSistemas)q.uniqueResult();
    }

    private UsuarioClienteContSistemas createUser(UsuarioClienteContSistemas found, Element user, Element empresa) throws ExceptionService, ExceptionDatabase {
        String cnpjEmp = empresa.getChild("complemento").getChildText("cnpj");
        String cnpjUser = user.getChild("complemento").getChildText("cnpj");
        ClienteContSistemas cl = this.findCliente(cnpjEmp);
        if (cl == null) {
            cl = this.findClienteEmpCNPJFiliais(cnpjEmp);
        }
        if (cl == null) {
            throw new ExceptionService("Cliente ainda n\u00e3o cadastrado em nossa base de dados " + cnpjEmp);
        }
        Pessoa p = this.findPessoa(cnpjUser);
        p = this.createPessoa(p, user);
        if (found != null) {
            System.out.println("Usuario encontrado: " + found.getIdentificador());
            return found;
        }
        System.out.println("Usuario n\u00e3o encontrado com o cpf e cnpj da empresa " + cnpjUser + "/" + cnpjEmp);
        UsuarioClienteContSistemas ret = found;
        ret = new UsuarioClienteContSistemas();
        ret.setClienteContSistemas(cl);
        ret.setPessoa(p);
        ret = (UsuarioClienteContSistemas)CoreDAOFactory.getInstance().getDAOUsuario().saveOrUpdate(ret);
        return ret;
    }

    private Pessoa createPessoa(Pessoa pessoa, Element user) throws ExceptionService {
        Endereco e;
        Complemento c;
        Pessoa p = pessoa;
        if (p == null) {
            p = new Pessoa();
            c = new Complemento();
            e = new Endereco();
        } else {
            c = p.getComplemento();
            e = p.getEndereco();
        }
        p.setAtivo(Short.valueOf((short)1));
        p.setDataCadastro(new Date());
        p.setDataInicioRelacionamento(p.getDataCadastro());
        p.setNome(user.getChildText("nome"));
        p.setNomeFantasia(user.getChildText("nomeFantasia"));
        Element compEL = user.getChild("complemento");
        c.setAtivo(Short.valueOf((short)1));
        c.setCel1(compEL.getChildText("cel1"));
        c.setCel2(compEL.getChildText("cel2"));
        c.setCnpj(compEL.getChildText("cnpj"));
        c.setTipoPessoa(this.getPessoaFisicaJuridica(c.getCnpj()));
        c.setDataNascimento(DateUtil.strToDate(compEL.getChildText("dataNascimento")));
        c.setFax1(compEL.getChildText("fax1"));
        c.setFax2(compEL.getChildText("fax2"));
        c.setFone1(compEL.getChildText("fone1"));
        c.setFone2(compEL.getChildText("fone2"));
        c.setEmailPrincipal(compEL.getChildText("emailPrincipal"));
        c.setPessoa(p);
        p.setComplemento(c);
        this.setEmails(c, compEL);
        Element endEL = user.getChild("endereco");
        e.setBairro(endEL.getChildText("bairro"));
        e.setCep(endEL.getChildText("cep"));
        e.setComplemento(endEL.getChildText("complemento"));
        e.setLogradouro(endEL.getChildText("logradouro"));
        e.setNumero(endEL.getChildText("numero"));
        e.setCidade(this.getCidade(endEL.getChildText("codIBGECidade")));
        p.setEndereco(e);
        return p;
    }

    private void setEmails(Complemento c, Element compEL) {
        Element emails = compEL.getChild("emails");
        for (Element email : emails.getChildren()) {
            String ativo = email.getAttributeValue("ativo");
            String descEmail = email.getAttributeValue("descricao");
            String emailEnd = email.getAttributeValue("email");
            EmailPessoa em = this.getEmailPessoa(c, emailEnd);
            if (em == null) {
                em = new EmailPessoa();
            }
            em.setComplemento(c);
            if (ativo != null && ativo.trim().length() > 0) {
                em.setAtivo(Short.valueOf(ativo));
            }
            em.setDescricao(descEmail);
            em.setEmail(emailEnd);
            em.setEnviarDadosCotacao(Short.valueOf((short)0));
            em.setEnviarDadosCte(Short.valueOf((short)0));
            em.setEnviarDadosNfe(Short.valueOf((short)0));
            em.setEnviarDadosRelacionamento(Short.valueOf((short)0));
            c.getEmails().add(em);
        }
    }

    private EmailPessoa getEmailPessoa(Complemento c, String emailEnd) {
        for (EmailPessoa e : c.getEmails()) {
            if (e.getEmail() == null || !e.getEmail().equalsIgnoreCase(emailEnd)) continue;
            return e;
        }
        return null;
    }

    private Cidade getCidade(String codIBGE) throws ExceptionService {
        return CoreDAOFactory.getInstance().getDAOCidade().findCidadeCodMunicipio(codIBGE);
    }

    private Pessoa findPessoa(String cnpj) {
        String query = "select p from Pessoa p inner join p.complemento c where c.cnpj = :cnpj and p.ativo=:sim";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(query);
        q.setString("cnpj", cnpj);
        q.setShort("sim", (short)1);
        q.setMaxResults(1);
        return (Pessoa)q.uniqueResult();
    }

    private ClienteContSistemas findCliente(String cnpjEmp) {
        String query = "select c from ClienteContSistemas c inner join c.tomadorPrestadorRps t inner join t.pessoa p inner join p.complemento cc where cc.cnpj = :cnpjEmp";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(query);
        q.setString("cnpjEmp", cnpjEmp);
        q.setMaxResults(1);
        return (ClienteContSistemas)q.uniqueResult();
    }

    private ClienteContSistemas findClienteEmpCNPJFiliais(String cnpjEmp) {
        String query = "select c from ClienteContSistemas c inner join c.clienteContSistCnpj t inner join t.pessoa p inner join p.complemento cc where cc.cnpj = :cnpjEmp";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(query);
        q.setString("cnpjEmp", cnpjEmp);
        q.setMaxResults(1);
        return (ClienteContSistemas)q.uniqueResult();
    }

    private Short getPessoaFisicaJuridica(String cnpj) {
        if (cnpj != null && cnpj.trim().length() == 14) {
            return EnumConstTipoPessoaComplementar.JURIDICA.getEnumId();
        }
        return EnumConstTipoPessoaComplementar.FISICA.getEnumId();
    }
}

