/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.renegociacaotitulos;

import com.touchcomp.basementor.constants.enums.baixatitulo.EnumConstTipoBaixaTitulos;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.ContasBaixa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.EmpresaFinanceiro;
import com.touchcomp.basementor.model.vo.GrupoDeBaixa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixaFormas;
import com.touchcomp.basementor.model.vo.OpcoesContabeisBaixaTitulos;
import com.touchcomp.basementor.model.vo.OpcoesGerenciais;
import com.touchcomp.basementor.model.vo.RenegociacaoTitulos;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorservice.helpers.impl.baixatitulos.HelperBaixaTitulos;
import com.touchcomp.basementorservice.helpers.impl.grupodebaixa.HelperGrupoDeBaixa;
import com.touchcomp.basementorservice.service.impl.opcoescontabeisbaixatitulos.ServiceOpcoesContabeisBaixaTitulosImpl;
import com.touchcomp.basementorspringcontext.Context;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import mentorcore.exceptions.ExceptionService;

class UtilGeracaoBaixaRenegociacaoTitulos {
    private final ServiceOpcoesContabeisBaixaTitulosImpl serviceOpcoesContabeisBaixaTitulosImpl = (ServiceOpcoesContabeisBaixaTitulosImpl)Context.get(ServiceOpcoesContabeisBaixaTitulosImpl.class);

    UtilGeracaoBaixaRenegociacaoTitulos() {
    }

    public GrupoDeBaixa criarBaixaRenegociacao(EmpresaContabilidade empresaContabil, List<Titulo> titulos, RenegociacaoTitulos renegTit, EmpresaFinanceiro empresaFinanceiro, Empresa empresa, OpcoesGerenciais opGer) throws ExceptionService, Exception {
        Short pagRec = titulos.get(0).getPagRec();
        GrupoDeBaixa vo = new GrupoDeBaixa();
        vo.setEmpresa(renegTit.getEmpresa());
        vo.setDataLiquidacao(renegTit.getDataBaixaTitulo());
        vo.setDataAtualizacao(renegTit.getDataAtualizacao());
        vo.setDataCadastro(renegTit.getDataCadastro());
        vo.setPagRec(pagRec);
        GrupoDeBaixaFormas gbf = new GrupoDeBaixaFormas();
        gbf.setGrupoDeBaixa(vo);
        vo.setGrupoDeBaixaFormas(Arrays.asList(gbf));
        gbf.setFormaPagamento(Short.valueOf((short)8));
        List<BaixaTitulo> baixaTitulos = this.processaTitulos(titulos, pagRec, empresaFinanceiro, empresa, opGer);
        gbf.setBaixaTitulo(this.getBaixasTitulo(gbf, true, baixaTitulos, empresaContabil));
        gbf.setIntegracaoBaixaTituloGrupoBaixaFormas(null);
        new HelperGrupoDeBaixa(vo).setLancamentoPisCofins();
        return vo;
    }

    private List getBaixasTitulo(GrupoDeBaixaFormas vo, boolean limparCheque, List<BaixaTitulo> baixaTitulos, EmpresaContabilidade empresaContabil) throws ExceptionService {
        ArrayList<BaixaTitulo> baixasTitulos = new ArrayList<BaixaTitulo>();
        Iterator<BaixaTitulo> iterator = baixaTitulos.iterator();
        while (iterator.hasNext()) {
            BaixaTitulo obj;
            BaixaTitulo baixa = obj = iterator.next();
            baixa.setGrupoDeBaixaFormas(vo);
            if (limparCheque) {
                baixa.setCheque(null);
            }
            if (baixa.getContasBaixa() != null) {
                ContasBaixa c = baixa.getContasBaixa();
                if (baixa.getVrJuros() == 0.0) {
                    c.setPlanoContaJuros(null);
                    c.setPlanoContaGerencialJuros(null);
                    c.setCentroCustoJuros(null);
                }
                if (baixa.getVrTaxaCartao() == 0.0) {
                    c.setPlanoContaTaxaCartao(null);
                    c.setPlanoContaGerencialTaxaCartao(null);
                    c.setCentroCustoTaxaCartao(null);
                }
                if (baixa.getVrAtualizacaoMonetariaRecebida() == 0.0 && baixa.getVrAtualizacaoMonetariaPaga() == 0.0) {
                    c.setCentroCustoAt(null);
                }
                if (baixa.getVrAtualizacaoMonetariaPaga() == 0.0) {
                    c.setPlanoContaAtualMonPaga(null);
                    c.setPlanoContaGerencialAtualMonPaga(null);
                }
                if (baixa.getVrAtualizacaoMonetariaRecebida() == 0.0) {
                    c.setPlanoContaAtualMonRecebida(null);
                    c.setPlanoContaGerencialAtualMonRecebida(null);
                }
                if (baixa.getVrConfins() == 0.0) {
                    c.setPlanoContaCofins(null);
                    c.setPlanoContaGerencialCofins(null);
                    c.setCentroCustoCofins(null);
                }
                if (baixa.getVrContribSocial() == 0.0) {
                    c.setPlanoContaContrSoc(null);
                    c.setPlanoContaGerencialContrSoc(null);
                    c.setCentroCustoContrSoc(null);
                }
                if (baixa.getVrMulta() == 0.0) {
                    c.setPlanoContaMulta(null);
                    c.setPlanoContaGerencialMulta(null);
                    c.setCentroCustoMulta(null);
                }
                if (baixa.getVrDespBancariaPaga() == 0.0) {
                    c.setPlanoContaDespBancPag(null);
                    c.setPlanoContaGerencialDespBancPag(null);
                }
                if (baixa.getVrDespBancariaRecebida() == 0.0) {
                    c.setPlanoContaDespBancRec(null);
                    c.setPlanoContaGerencialDespBancRec(null);
                }
                if (baixa.getVrDespBancariaRecebida() == 0.0 && baixa.getVrDespBancariaPaga() == 0.0) {
                    c.setCentroCustoDespBanc(null);
                }
                if (baixa.getVrDesconto() == 0.0) {
                    c.setPlanoContaDesc(null);
                    c.setPlanoContaGerencialDesc(null);
                    c.setCentroCustoDesc(null);
                }
                if (baixa.getVrAbatimento() == 0.0) {
                    c.setCentroCustoAbatimento(null);
                    c.setPlanoContaAbatimento(null);
                    c.setPlanoContaGerencialAbatimento(null);
                }
                if (baixa.getVrIOFPago() == null) {
                    c.setCentroCustoIof(null);
                    c.setPlanoContaIofPag(null);
                    c.setPlanoContaGerencialIofPag(null);
                }
                if (baixa.getVrIOFRecebido() == null) {
                    c.setCentroCustoIof(null);
                    c.setPlanoContaIofRec(null);
                    c.setPlanoContaGerencialIofRec(null);
                }
                if (baixa.getVrPis() == 0.0) {
                    c.setPlanoContaPis(null);
                    c.setPlanoContaGerencialPis(null);
                    c.setCentroCustoPis(null);
                }
                if (baixa.getVrDespesaCartorioPaga() == 0.0) {
                    c.setPlanoContaCartorioPag(null);
                    c.setPlanoContaGerencialCartorioPag(null);
                    c.setCentroCustoCartorio(null);
                }
                if (baixa.getVrDespesaCartorioRecebida() == 0.0) {
                    c.setPlanoContaCartorioRec(null);
                    c.setPlanoContaGerencialCartorioRec(null);
                    c.setCentroCustoCartorio(null);
                }
                if (baixa.getTitulo().getValorJurosEmbutido() == 0.0) {
                    c.setPlanoContaJurosEmb(null);
                }
                if (baixa.getTitulo().getValorMultaEmbutida() == 0.0) {
                    c.setPlanoContaMultaEmb(null);
                }
                if (baixa.getTitulo().getValorDescontosEmbutido() == 0.0) {
                    c.setPlanoContaDescontosEmb(null);
                }
                if (baixa.getVrPis() == null || baixa.getVrPis() == 0.0) {
                    baixa.setBaixaTituloSpedPis(new ArrayList());
                }
                if (baixa.getVrConfins() == null || baixa.getVrConfins() == 0.0) {
                    baixa.setBaixaTituloSpedCofins(new ArrayList());
                }
                c.setPlanoContaAntecipacao(null);
                baixa.setContasBaixa(c);
            }
            baixasTitulos.add(baixa);
        }
        return baixasTitulos;
    }

    private List<BaixaTitulo> processaTitulos(List<Titulo> titulos, Short pagRec, EmpresaFinanceiro empresaFinanceiro, Empresa empresa, OpcoesGerenciais opGer) throws ExceptionService, Exception {
        ArrayList<BaixaTitulo> baixasTitulos = new ArrayList();
        baixasTitulos = this.createBaixaTitulos(titulos, empresaFinanceiro, empresa, opGer);
        return baixasTitulos;
    }

    public List createBaixaTitulos(List<Titulo> obj, EmpresaFinanceiro empresaFinanceiro, Empresa empresa, OpcoesGerenciais opGer) throws ExceptionService, Exception {
        ArrayList<BaixaTitulo> aux = new ArrayList<BaixaTitulo>();
        HelperBaixaTitulos helper = (HelperBaixaTitulos)Context.get(HelperBaixaTitulos.class);
        Iterator<Titulo> iterator = obj.iterator();
        while (iterator.hasNext()) {
            Titulo o;
            Titulo t = o = iterator.next();
            OpcoesContabeisBaixaTitulos opcoesContabeisBaixaTitulos = this.serviceOpcoesContabeisBaixaTitulosImpl.findOpcaoContabilBaixaTituloComFormaPagCache(t.getPagRec(), t.getTipoDoc(), t.getClassificacaoPessoa(), Short.valueOf((short)1), empresa);
            BaixaTitulo baixa = helper.novaBaixaTitulos(t, EnumConstTipoBaixaTitulos.BAIXA_TITULOS_ORIG_PADRAO, t.getValorSaldo(), empresaFinanceiro, empresa, opGer);
            aux.add(baixa);
        }
        return aux;
    }
}

