/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.report;

import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.data.JRXmlDataSource;

public class CoreReportService
extends CoreService {
    private static final TLogger logger = TLogger.get(CoreReportService.class);
    public static final String GERAR_JASPER_PRINT_SQL = "getJasperPrintSQL";
    public static final String GERAR_JASPER_PRINT_HIBERNATE = "getJasperPrintHibernate";
    public static final String GERAR_JASPER_PRINT_DATA_SOURCE = "getJasperPrintDataSource";
    public static final String GERAR_JASPER_PRINT_XML_SOURCE = "getJasperPrintXMLSource";

    public JasperPrint getJasperPrintSQL(CoreRequestContext c) throws ExceptionService {
        String path = (String)c.getAttribute("path");
        HashMap params = (HashMap)c.getAttribute("parametros");
        try {
            if (params == null) {
                params = new HashMap();
            }
            for (Object key : params.keySet()) {
                Object value = params.get(key);
                if (!(value instanceof String) || !((String)value).isEmpty()) continue;
                params.put(key, null);
            }
            params.put("REPORT_LOCALE", Locale.getDefault());
            params.put("REPORT_RESOURCE_BUNDLE", MessagesBaseMentor.getResourceBundleMessages());
            System.out.println(path);
            JasperPrint jp = JasperFillManager.fillReport((String)path, params, (Connection)CoreBdUtil.getInstance().getConnection());
            return jp;
        }
        catch (JRException ex) {
            logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar o relatorio.");
        }
    }

    public JasperPrint getJasperPrintHibernate(CoreRequestContext c) throws ExceptionService {
        String path = (String)c.getAttribute("path");
        HashMap<String, Locale> params = (HashMap<String, Locale>)c.getAttribute("parametros");
        try {
            if (params == null) {
                params = new HashMap<String, Locale>();
            }
            params.put("REPORT_LOCALE", Locale.getDefault());
            params.put("REPORT_RESOURCE_BUNDLE", (Locale)((Object)MessagesBaseMentor.getResourceBundleMessages()));
            params.put("HIBERNATE_SESSION", (Locale)CoreBdUtil.getInstance().getSession());
            return JasperFillManager.fillReport((String)path, params);
        }
        catch (JRException ex) {
            logger.error(((Object)((Object)ex)).getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar o relatorio.");
        }
    }

    public JasperPrint getJasperPrintDataSource(CoreRequestContext c) throws JRException {
        Object pathOb = c.getAttribute("path");
        HashMap<String, Object> params = (HashMap<String, Object>)c.getAttribute("parametros");
        Collection ds = (Collection)c.getAttribute("dados");
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        String path = pathOb instanceof File ? ((File)pathOb).getAbsolutePath() : pathOb.toString();
        params.put("REPORT_LOCALE", Locale.getDefault());
        params.put("REPORT_LOCALE", Locale.getDefault());
        params.put("REPORT_RESOURCE_BUNDLE", MessagesBaseMentor.getResourceBundleMessages());
        System.out.println(path);
        return JasperFillManager.fillReport((String)path, params, (JRDataSource)new JRBeanCollectionDataSource(ds));
    }

    public JasperPrint getJasperPrintXMLSource(CoreRequestContext c) throws JRException {
        String start = (String)c.getAttribute("tagInicio");
        String path = (String)c.getAttribute("path");
        InputStream inputStream = (InputStream)c.getAttribute("inputStream");
        HashMap<String, Locale> params = (HashMap<String, Locale>)c.getAttribute("parametros");
        if (params == null) {
            params = new HashMap<String, Locale>();
        }
        params.put("REPORT_LOCALE", Locale.getDefault());
        params.put("REPORT_RESOURCE_BUNDLE", (Locale)((Object)MessagesBaseMentor.getResourceBundleMessages()));
        return JasperFillManager.fillReport((String)path, params, (JRDataSource)new JRXmlDataSource(inputStream, start));
    }
}

