/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh;

import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import org.apache.commons.lang3.StringUtils;

public class ImpressaoRequerimentoSeguroDesempregoUtilities {
    public Object gerarRequerimentoSeguro(Recisao r, HashMap hash) throws ExceptionService {
        String parametro = "";
        parametro = ImpressaoRequerimentoSeguroDesempregoUtilities.completarComBrancoDireita(r.getColaborador().getPessoa().getNome(), 38);
        hash.put("COLABORADOR", ToolString.insertSpacesBetween((String)parametro, (int)3));
        parametro = ImpressaoRequerimentoSeguroDesempregoUtilities.completarComBrancoDireita(r.getColaborador().getNomeMae(), 38);
        hash.put("NOMEMAE", ToolString.insertSpacesBetween((String)parametro, (int)3));
        parametro = ImpressaoRequerimentoSeguroDesempregoUtilities.completarComBrancoDireita(this.escreverEndereco(r.getColaborador().getPessoa()), 38);
        hash.put("ENDERECO", ToolString.insertSpacesBetween((String)parametro, (int)3));
        parametro = ImpressaoRequerimentoSeguroDesempregoUtilities.completarComBrancoDireita(r.getColaborador().getPessoa().getEndereco().getComplemento(), 14);
        hash.put("COMPLEMENTO", ToolString.insertSpacesBetween((String)parametro, (int)3));
        parametro = ImpressaoRequerimentoSeguroDesempregoUtilities.completarComZeroEsquerda(r.getColaborador().getPessoa().getEndereco().getCep(), 8);
        hash.put("CEP", ToolString.insertSpacesBetween((String)this.getCep(parametro), (int)4));
        hash.put("UF", ToolString.insertSpacesBetween((String)r.getColaborador().getPessoa().getEndereco().getCidade().getUf().getSigla(), (int)4));
        parametro = ImpressaoRequerimentoSeguroDesempregoUtilities.completarComBrancoDireita(r.getColaborador().getPessoa().getComplemento().getFone1(), 10);
        hash.put("TELEFONE", ToolString.insertSpacesBetween((String)parametro, (int)4));
        parametro = ImpressaoRequerimentoSeguroDesempregoUtilities.completarComZeroEsquerda(r.getColaborador().getNumeroPis(), 11);
        hash.put("PIS", ToolString.insertSpacesBetween((String)parametro, (int)4));
        parametro = ImpressaoRequerimentoSeguroDesempregoUtilities.completarComZeroEsquerda(r.getColaborador().getCarteiraProfissional(), 7);
        hash.put("CARTEIRA", ToolString.insertSpacesBetween((String)parametro, (int)4));
        parametro = ImpressaoRequerimentoSeguroDesempregoUtilities.completarComZeroEsquerda(r.getColaborador().getSerieCarteiraProfissional(), 3);
        hash.put("SERIECAR", ToolString.insertSpacesBetween((String)parametro, (int)4));
        hash.put("UFC", ToolString.insertSpacesBetween((String)r.getColaborador().getUfCarteiraProfissional().getSigla(), (int)3));
        parametro = ImpressaoRequerimentoSeguroDesempregoUtilities.completarComBrancoDireita(r.getColaborador().getPessoa().getComplemento().getCnpj(), 11);
        hash.put("CPF", ToolString.insertSpacesBetween((String)parametro, (int)4));
        hash.put("TP", "1");
        parametro = ToolString.refina((String)r.getColaborador().getFuncao().getCbo().getCodigo());
        parametro = ImpressaoRequerimentoSeguroDesempregoUtilities.completarComZeroEsquerda(parametro, 7);
        hash.put("CBO", ToolString.insertSpacesBetween((String)parametro, (int)4));
        hash.put("OCUPACAO", ToolString.insertSpacesBetween((String)r.getColaborador().getFuncao().getCbo().getDescricao(), (int)4));
        hash.put("DATAADMISSAO", ToolString.insertSpacesBetween((String)this.getDataFormatada(r.getColaborador().getDataAdmissao()), (int)4));
        hash.put("DATAAFASTAMENTO", ToolString.insertSpacesBetween((String)this.getDataFormatada(r.getDataAfastamento()), (int)4));
        hash.put("SEXO", this.getSexo(r.getColaborador().getSexo()));
        hash.put("GRAU", r.getColaborador().getGrauInstrucao().getCodigo());
        hash.put("DATANASCIMENTO", ToolString.insertSpacesBetween((String)this.getDataFormatada(r.getColaborador().getPessoa().getComplemento().getDataNascimento()), (int)4));
        hash.put("HORASSEMANAIS", ToolString.insertSpacesBetween((String)r.getColaborador().getJornadaSemanal().toString(), (int)4));
        hash.put("AVISO", this.getAviso(r.getAvisoIndenizado()));
        parametro = ImpressaoRequerimentoSeguroDesempregoUtilities.completarComZeroEsquerda((String)hash.get("CNAE"), 5);
        hash.put("CNAE", ToolString.insertSpacesBetween((String)parametro, (int)4));
        parametro = ImpressaoRequerimentoSeguroDesempregoUtilities.completarComZeroEsquerda(r.getColaborador().getEmpresa().getPessoa().getComplemento().getCnpj(), 14);
        hash.put("CNPJ", ToolString.insertSpacesBetween((String)parametro, (int)4));
        CoreRequestContext relatorio = new CoreRequestContext();
        Double valorUltimo = 0.0;
        Double valorPenultimo = 0.0;
        Double valorAntiPenultimo = 0.0;
        valorUltimo = (Double)hash.get("ultimaRemuneracao");
        hash.put("ultimaRemuneracao", ToolString.insertSpacesBetween((String)this.getFormatarValor(valorUltimo), (int)4));
        valorPenultimo = (Double)hash.get("penultimaRemuneracao");
        hash.put("penultimaRemuneracao", ToolString.insertSpacesBetween((String)this.getFormatarValor(valorPenultimo), (int)4));
        valorAntiPenultimo = (Double)hash.get("antiPenultimaRemuneraca");
        hash.put("antiPenultimaRemuneraca", ToolString.insertSpacesBetween((String)this.getFormatarValor(valorAntiPenultimo), (int)4));
        Integer mes = 0;
        mes = (Integer)hash.get("mesUltima");
        hash.put("mesUltimaS", ToolString.insertSpacesBetween((String)this.getFormatarMes(mes), (int)4));
        mes = (Integer)hash.get("mesPenultima");
        hash.put("mesPenultimaS", ToolString.insertSpacesBetween((String)this.getFormatarMes(mes), (int)4));
        mes = (Integer)hash.get("mesAntiPenultima");
        hash.put("mesAntiPenultimaS", ToolString.insertSpacesBetween((String)this.getFormatarMes(mes), (int)4));
        hash.put("difMes", ToolString.insertSpacesBetween((String)ImpressaoRequerimentoSeguroDesempregoUtilities.getDiferencaNumeroMes(r.getColaborador().getDataAdmissao(), r.getDataAfastamento()), (int)4));
        hash.put("somaTresUltimosSalarios", ToolString.insertSpacesBetween((String)this.getFormatarValor(ContatoFormatUtil.arrredondarNumero((Double)(valorUltimo + valorAntiPenultimo + valorPenultimo), (int)2)), (int)4));
        ArrayList<Recisao> aux = new ArrayList<Recisao>();
        aux.add(r);
        Object path = System.getProperty("user.dir");
        path = (String)path + File.separator + "reports" + File.separator + "rh" + File.separator + "folhapagamento" + File.separator + "recisao" + File.separator + "INDIVIDUAL_REQUERIMENTO_SEGURO_DESEMPREGO.jasper";
        relatorio.setAttribute("parametros", hash);
        relatorio.setAttribute("dados", aux);
        relatorio.setAttribute("path", path);
        Object jasperPrint = CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return jasperPrint;
    }

    private String escreverEndereco(Pessoa pessoa) {
        String logradouro = pessoa.getEndereco().getLogradouro();
        String numero = pessoa.getEndereco().getNumero();
        String complemento = pessoa.getEndereco().getComplemento();
        return ToolString.clearSpecialCharacXML((String)(logradouro.toUpperCase() + " " + numero + " " + complemento.toUpperCase()));
    }

    private String getDataFormatada(Date data) {
        SimpleDateFormat dataFormatada = new SimpleDateFormat("ddMMyy");
        String dataVenc = dataFormatada.format(data);
        return dataVenc;
    }

    private String getSexo(Short sexo) {
        if (sexo.equals((short)0)) {
            return "1";
        }
        return "2";
    }

    private Object getAviso(Short avisoIndenizado) {
        if (avisoIndenizado.equals((short)0)) {
            return "1";
        }
        return "2";
    }

    public static String completarComZeroEsquerda(String st, int tam) {
        if (st.length() > tam) {
            return st.substring(0, tam);
        }
        return StringUtils.leftPad((String)st, (int)tam, (String)"0");
    }

    public static String completarComBrancoDireita(String st, int tam) {
        if (st.length() > tam) {
            return st.substring(0, tam);
        }
        return StringUtils.rightPad((String)st, (int)tam, (String)" ");
    }

    private String getCep(String parametro) {
        return parametro.substring(0, 5) + " " + parametro.substring(5, 8);
    }

    private String getFormatarValor(Double valor) {
        valor = ContatoFormatUtil.arrredondarNumero((Double)valor, (int)2);
        String numero = "";
        Integer inteira = valor.intValue();
        Integer decimal = (int)Math.round((valor - (double)valor.intValue()) * 100.0);
        numero = decimal.toString().length() == 1 ? ImpressaoRequerimentoSeguroDesempregoUtilities.completarComZeroEsquerda(inteira.toString() + "0" + decimal.toString(), 10) : ImpressaoRequerimentoSeguroDesempregoUtilities.completarComZeroEsquerda(inteira.toString() + decimal.toString(), 10);
        return numero;
    }

    public String getFormatarMes(Integer mes) {
        String aux = mes.toString();
        if (aux.length() == 1) {
            return "0" + aux;
        }
        return aux;
    }

    public static String getDiferencaNumeroMes(Date date1, Date date2) {
        GregorianCalendar g = new GregorianCalendar();
        GregorianCalendar g1 = new GregorianCalendar();
        g.setTime(date1);
        g1.setTime(date2);
        int m1 = g.get(1) * 12 + g.get(2);
        int m2 = g1.get(1) * 12 + g1.get(2);
        Integer ret = m2 - m1 + 1;
        return ret.toString();
    }
}

