/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh;

import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.DiaHoraTrabalho;
import com.touchcomp.basementor.model.vo.ItemIntegPtEletronico;
import com.touchcomp.basementor.model.vo.PerfilIntegracaoPonto;
import contatocore.util.ContatoFormatUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionService;
import mentorcore.tools.DateUtil;

public class UtilIntegracaoPontoEletronico {
    public List readArquivoIntegracaoPonto(File arquivo, PerfilIntegracaoPonto perfil, Long idEmpresa) throws FileNotFoundException, IOException, ExceptionService, ParseException {
        ArrayList list = new ArrayList();
        Short colInicial = 0;
        Short colFinal = 0;
        Short datInicial = 0;
        Short datFinal = 0;
        Short horaInicial = 0;
        Short horaFinal = 0;
        Double tempoTolerancia = 0.0;
        Double horasDia = 0.0;
        String campoBusca = "";
        colInicial = perfil.getPosicaoInicialColaborador();
        colFinal = perfil.getPosicaoFinalColaborador();
        datInicial = perfil.getPosicaoInicialData();
        datFinal = perfil.getPosicaoFinalData();
        horaInicial = perfil.getPosicaoInicialHora();
        horaFinal = perfil.getPosicaoFinalHora();
        tempoTolerancia = perfil.getTempoTolerancia();
        horasDia = perfil.getHorasTrabalhadasDia();
        campoBusca = perfil.getCampoBuscaColaborador().trim();
        FileReader file = new FileReader(arquivo);
        BufferedReader buffer = new BufferedReader(file);
        while (buffer.ready()) {
            HashMap<String, String> h = new HashMap<String, String>();
            String linha = buffer.readLine();
            h.put(campoBusca, linha.substring(colInicial.shortValue(), colFinal.shortValue()));
            Colaborador colaborador = CoreDAOFactory.getInstance().getDAOIntegracaoPontoEletronico().findColaboradorPorCampoBusca(linha.substring(colInicial.shortValue(), colFinal.shortValue()), campoBusca, idEmpresa);
            h.put("colaborador", (String)colaborador);
            h.put("dataReferencia", linha.substring(datInicial.shortValue(), datFinal.shortValue()));
            h.put("hora", linha.substring(horaInicial.shortValue(), horaFinal.shortValue()));
            list.add(h);
        }
        ArrayList<ItemIntegPtEletronico> retorno = new ArrayList<ItemIntegPtEletronico>();
        for (Object e : list) {
            DiaHoraTrabalho dia;
            HashMap h = (HashMap)e;
            ItemIntegPtEletronico item = null;
            boolean achou = false;
            Colaborador c = (Colaborador)h.get("colaborador");
            String dataReferencia = (String)h.get("dataReferencia");
            String hora = (String)h.get("hora");
            for (ItemIntegPtEletronico itemLista : retorno) {
                if (!itemLista.getColaborador().equals((Object)c)) continue;
                achou = true;
                item = itemLista;
                break;
            }
            if (!achou) {
                item = new ItemIntegPtEletronico();
                item.setColaborador(c);
                dia = null;
                dia = this.getDiaHorarioTrabalho(dataReferencia, hora, item, horasDia, tempoTolerancia);
                if (dia != null) {
                    dia.setItemInteg(item);
                    item.getDiaHorarios().add(dia);
                }
                retorno.add(item);
                continue;
            }
            dia = null;
            dia = this.getDiaHorarioTrabalho(dataReferencia, hora, item, horasDia, tempoTolerancia);
            if (dia == null) continue;
            dia.setItemInteg(item);
            item.getDiaHorarios().add(dia);
        }
        return retorno;
    }

    private DiaHoraTrabalho getDiaHorarioTrabalho(String dataReferencia, String hora, ItemIntegPtEletronico item, Double horasDia, Double tempoTolerancia) throws ParseException {
        boolean achou = false;
        String horaInteiro = hora.substring(0, 2);
        String horaDecimal = hora.substring(2, 4);
        Double horaArquivo = this.formatarNumero(horaInteiro, horaDecimal, 1);
        String dia = dataReferencia.substring(0, 2);
        String mes = dataReferencia.substring(2, 4);
        String ano = dataReferencia.substring(4, 8);
        Date data = this.getData(dia, mes, ano);
        for (DiaHoraTrabalho diaHorario : item.getDiaHorarios()) {
            if (!this.verificarDatasIguals(diaHorario.getDataArquivo(), data)) continue;
            achou = true;
            diaHorario.setHoraFinal(horaArquivo);
            Double creditos = this.getCreditosHorasColaborador(diaHorario.getDataArquivo(), diaHorario.getHoraFinal(), diaHorario.getHoraInicial(), horasDia, tempoTolerancia);
            if (creditos >= 0.0) {
                diaHorario.setCreditos(creditos);
                diaHorario.setFaltas(Double.valueOf(0.0));
                break;
            }
            diaHorario.setCreditos(Double.valueOf(0.0));
            diaHorario.setFaltas(Double.valueOf(Math.abs(creditos)));
            break;
        }
        if (!achou) {
            DiaHoraTrabalho diaHorario = new DiaHoraTrabalho();
            diaHorario.setDataArquivo(data);
            diaHorario.setHoraInicial(horaArquivo);
            diaHorario.setDiaSemana(this.getDiaSemana(data));
            return diaHorario;
        }
        return null;
    }

    public Double formatarNumero(String valorInteiro, String valorDecimal, Integer mult) throws ParseException {
        String numeroCertoS = valorInteiro + "," + valorDecimal;
        DecimalFormat dff = (DecimalFormat)DecimalFormat.getInstance();
        Number numeroCerto = dff.parse(numeroCertoS);
        return ContatoFormatUtil.arrredondarNumero((Double)numeroCerto.doubleValue(), (int)2) * (double)mult.intValue();
    }

    private Date getData(String dia, String mes, String ano) {
        GregorianCalendar g = new GregorianCalendar();
        g.set(5, new Integer(dia));
        g.set(2, new Integer(mes) - 1);
        g.set(1, new Integer(ano));
        g.set(13, 0);
        return g.getTime();
    }

    private boolean verificarDatasIguals(Date dataArquivo1, Date data1) {
        GregorianCalendar dataArquivo = new GregorianCalendar();
        GregorianCalendar data = new GregorianCalendar();
        dataArquivo.setTime(dataArquivo1);
        data.setTime(data1);
        return data.get(5) == dataArquivo.get(5) && data.get(2) == dataArquivo.get(2) && data.get(1) == dataArquivo.get(1);
    }

    private Integer getDiaSemana(Date data) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(data);
        return g.get(7);
    }

    public Double getCreditosHorasColaborador(Date dataArquivo, Double horaFinal, Double horaInicial, Double horasDia, Double toleranciaDiaria) throws ParseException {
        GregorianCalendar entrada2 = this.getGregorianCalendar(dataArquivo, 13, 0, 0);
        horaFinal = ContatoFormatUtil.arrredondarNumero((Double)horaFinal, (int)2);
        Integer horas = horaFinal.intValue();
        Integer minutos = (int)Math.round((horaFinal - (double)horaFinal.intValue()) * 100.0);
        if (horas.equals(0) && minutos.equals(0)) {
            horas = 12;
            minutos = 0;
            entrada2 = this.getGregorianCalendar(dataArquivo, 17, 48, 0);
        }
        GregorianCalendar saida2 = this.getGregorianCalendar(dataArquivo, horas, minutos, 0);
        horas = horaInicial.intValue();
        minutos = (int)Math.round((horaInicial - (double)horaInicial.intValue()) * 100.0);
        GregorianCalendar entrada1 = this.getGregorianCalendar(dataArquivo, horas, minutos, 0);
        GregorianCalendar saida1 = this.getGregorianCalendar(dataArquivo, 12, 0, 0);
        Integer periodo1 = DateUtil.calcularDifMinutos(entrada1.getTime(), saida1.getTime());
        Integer periodo2 = DateUtil.calcularDifMinutos(entrada2.getTime(), saida2.getTime());
        Integer totalMinutos = periodo1 + periodo2;
        minutos = (int)Math.round((horasDia - (double)horasDia.intValue()) * 100.0);
        Integer minutosDia = horasDia.intValue() * 60 + minutos;
        Integer ret = totalMinutos - minutosDia;
        horas = ret / 60;
        minutos = ret % 60;
        Integer mult = 1;
        if (ret < 0) {
            mult = -1;
            horas = horas * mult;
            minutos = minutos * mult;
        }
        Double aux = this.formatarNumero(horas.toString(), (String)(minutos.toString().length() == 1 ? "0" + minutos.toString() : minutos.toString()), mult);
        return aux;
    }

    private GregorianCalendar getGregorianCalendar(Date data, Integer hora, Integer minutos, Integer segundos) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(data);
        g.set(11, hora);
        g.set(12, minutos);
        g.set(13, segundos);
        return g;
    }
}

