/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh;

import com.touchcomp.basementor.model.vo.ExamePeriodo;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilListagemImpressaoExamePeriodico {
    public Object impressaoControleExamePeriodico(HashMap parametros, ExamePeriodo ex, Date periodo, Integer ordenacao) throws ExceptionService {
        String hql = " SELECT  c.identificador    AS identificador,         c.numeroRegistro   AS Registro,         c.pessoa.nome      AS Colaborador,         c.dataAdmissao     AS Admissao,         c.funcao.descricao AS Cargo,         c.centroCusto.nome AS CentroCusto    FROM Colaborador c   WHERE c.dataDemissao is null   AND c.funcao IN (      SELECT item.funcao      FROM ItemControleExamesFuncao item      WHERE item.rotinaPeriodica = :exame) " + this.getOrdenacao(ordenacao);
        List ret = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("exame", (Object)ex).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        boolean retorna = false;
        ArrayList<HashMap> aux = new ArrayList<HashMap>();
        for (Object object : ret) {
            HashMap hash = (HashMap)object;
            Date dataAdmissao = (Date)hash.get("Admissao");
            retorna = this.mesExame(dataAdmissao, periodo, ex.getQtdadeDias());
            if (!retorna) continue;
            aux.add(hash);
        }
        Object path = System.getProperty("user.dir");
        path = (String)path + File.separator + "reports" + File.separator + "rh" + File.separator + "controleexameperiodico" + File.separator + "LISTAGEM_EXAME_PERIODICO.jasper";
        parametros.put("TITULO", "LISTAGEM EXAME " + ex.getDescricao().toUpperCase());
        parametros.put("ORDENACAO", ordenacao);
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", path);
        relatorio.setAttribute("parametros", parametros);
        relatorio.setAttribute("dados", aux);
        Object jasperPrint = CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return jasperPrint;
    }

    private boolean mesExame(Date dataAdmissao, Date periodo, Integer meses) {
        GregorianCalendar cFIm = new GregorianCalendar();
        GregorianCalendar cIni = new GregorianCalendar();
        cFIm.setTime(periodo);
        cIni.setTime(dataAdmissao);
        int difMes = cFIm.get(2) - cIni.get(2);
        int difAno = (cFIm.get(1) - cIni.get(1)) * 12;
        int total = difAno + difMes;
        int resto = meses == 0 ? total : total % meses;
        return resto == 0;
    }

    private String getOrdenacao(Integer ordenacao) {
        if (ordenacao.equals(1)) {
            return " order by c.numeroRegistro ";
        }
        if (ordenacao.equals(2)) {
            return " order by c.pessoa.nome ";
        }
        if (ordenacao.equals(3)) {
            return " order by c.funcao.descricao ";
        }
        if (ordenacao.equals(4)) {
            return " order by c.centroCusto.nome ";
        }
        return " order by c.dataAdmissao ";
    }
}

