/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh;

import com.touchcomp.basementor.model.vo.AberturaPeriodo;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.tools.DateUtil;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilListagemMovimentoFolha {
    public Object imprimirConferenciaFolha(List l, int op, HashMap parametros, Short filtro) throws ExceptionService {
        Object path = System.getProperty("user.dir");
        if (!filtro.equals((short)7) && !filtro.equals((short)8)) {
            path = "reports" + File.separator + "rh" + File.separator + "folhapagamento" + File.separator + "conferenciafolha" + File.separator + "LISTAGEM_CONFERENCIA_FOLHA.jasper";
            CoreRequestContext relatorio = new CoreRequestContext();
            relatorio.setAttribute("path", path);
            relatorio.setAttribute("parametros", parametros);
            relatorio.setAttribute("dados", l);
            Object jasperPrint = CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
            return jasperPrint;
        }
        if (filtro.equals((short)8)) {
            path = "reports" + File.separator + "rh" + File.separator + "folhapagamento" + File.separator + "conferenciafolha" + File.separator + "LISTAGEM_COLABORADORES_SEM_FOLHA.jasper";
            CoreRequestContext relatorio = new CoreRequestContext();
            relatorio.setAttribute("path", path);
            relatorio.setAttribute("parametros", parametros);
            relatorio.setAttribute("dados", l);
            Object jasperPrint = CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
            return jasperPrint;
        }
        path = "reports" + File.separator + "rh" + File.separator + "folhapagamento" + File.separator + "conferenciafolha" + File.separator + "LISTAGEM_FALTAS_ATESTADO.jasper";
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", path);
        relatorio.setAttribute("parametros", parametros);
        relatorio.setAttribute("dados", l);
        Object jasperPrint = CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return jasperPrint;
    }

    public JasperPrint findDuasOcorrencias(Date periodoInicial, Date periodoFinal, HashMap parametros, Short tipoRelatorio) throws ExceptionService {
        String hql = "";
        hql = tipoRelatorio.equals((short)13) ? "select  distinct (ferias.periodoAqFeriasColab.colaborador.pessoa.nome) as NOME,   (ferias.periodoAqFeriasColab.colaborador.numeroRegistro) as REGISTRO  from FeriasColaborador ferias  where  ferias.dataGozoInicial between :periodoInicial and :periodoFinal  and  ferias.dataGozoFinal between :periodoInicial and :periodoFinal  and  exists ( from FeriasColaborador f              where              f.identificador != ferias.identificador              and              f.periodoAqFeriasColab.colaborador = ferias.periodoAqFeriasColab.colaborador              and              f.dataGozoInicial between :periodoInicial and :periodoFinal             and             f.dataGozoFinal between :periodoInicial and :periodoFinal)  order by ferias.periodoAqFeriasColab.colaborador.pessoa.nome " : " select  distinct (af.colaborador.pessoa.nome) as NOME,  (af.colaborador.numeroRegistro)  as REGISTRO  from AfastamentoColaborador af  where  af.dataAfastamento != null  and  af.dataAfastamento between :periodoInicial and :periodoFinal  and  af.dataRetorno between :periodoInicial and :periodoFinal  and  exists (from AfastamentoColaborador a          where         a.dataAfastamento != null         and          a.identificador != af.identificador and af.colaborador = a.colaborador          and a.dataAfastamento between :periodoInicial and :periodoFinal and a.dataRetorno between :periodoInicial and :periodoFinal) order by af.colaborador.pessoa.nome ";
        List dados = CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("periodoInicial", periodoInicial).setDate("periodoFinal", periodoFinal).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        Object path = System.getProperty("user.dir");
        path = "reports" + File.separator + "rh" + File.separator + "folhapagamento" + File.separator + "conferenciafolha" + File.separator + "LISTAGEM_MULTIPLAS_OCORRENCIAS.jasper";
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", path);
        relatorio.setAttribute("parametros", parametros);
        relatorio.setAttribute("dados", dados);
        JasperPrint jasperPrint = (JasperPrint)CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return jasperPrint;
    }

    public JasperPrint diferencaLiquido(AberturaPeriodo abertura, HashMap parametros) throws ExceptionService {
        List dados = new ArrayList();
        parametros.put("PERIODO_ATUAL", abertura.getPeriodoApuracao());
        parametros.put("PERIODO_ANTERIOR", DateUtil.nextMonth(abertura.getPeriodoApuracao(), -1));
        for (MovimentoFolha movimentoFolha : abertura.getMovimentoFolha()) {
            HashMap<String, Object> hash = new HashMap<String, Object>();
            hash.put("NUMERO_REGISTRO", movimentoFolha.getColaborador().getNumeroRegistro());
            hash.put("COLABORADOR", movimentoFolha.getColaborador().getPessoa().getNome().toUpperCase());
            System.err.println(movimentoFolha.getColaborador().getPessoa().getNome().toUpperCase());
            hash.put("VALOR_LIQUIDO_ATUAL", movimentoFolha.getVrSalarioLiquido());
            hash.put("VALOR_LIQUIDO_ANTERIOR", this.getValorliquidoAnterior(movimentoFolha.getColaborador(), abertura.getTipoCalculo().getTipoFolha(), abertura.getDataInicio()));
            hash.put("DIFERENCA", ContatoFormatUtil.arrredondarNumero((Double)(movimentoFolha.getVrSalarioLiquido() - this.getValorliquidoAnterior(movimentoFolha.getColaborador(), abertura.getTipoCalculo().getTipoFolha(), abertura.getDataInicio())), (int)2));
            dados.add(hash);
        }
        dados = this.ordenarHash(dados);
        Object path = System.getProperty("user.dir");
        path = "reports" + File.separator + "rh" + File.separator + "folhapagamento" + File.separator + "conferenciafolha" + File.separator + "LISTAGEM_DIFERENCA_LIQUIDO.jasper";
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", path);
        relatorio.setAttribute("parametros", parametros);
        relatorio.setAttribute("dados", dados);
        JasperPrint jasperPrint = (JasperPrint)CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return jasperPrint;
    }

    private Double getValorliquidoAnterior(Colaborador colaborador, Short tipoFolha, Date dataInicio) {
        String hql = " select coalesce(mov.vrSalarioLiquido,0)  from MovimentoFolha mov  where  mov.colaborador = :colaborador  and  mov.aberturaPeriodo.dataInicio = :dataInicioAnterior  and  mov.aberturaPeriodo.tipoCalculo.tipoFolha = :tipoFolha ";
        Double ret = (Double)CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setDate("dataInicioAnterior", DateUtil.nextMonth(dataInicio, -1)).setShort("tipoFolha", tipoFolha.shortValue()).uniqueResult();
        if (ret == null) {
            return 0.0;
        }
        return ret;
    }

    public JasperPrint findValoresSalarioFamilia(AberturaPeriodo abertura, TipoCalculoEvento tpSalarioFamilia, HashMap parametros) throws ExceptionService {
        String hql = " select item.valor as VALOR,  item.movimentoFolha.nrQuota as QUOTA,  item.movimentoFolha.colaborador.pessoa.nome as COLABORADOR, item.movimentoFolha.colaborador.numeroRegistro as NUMERO_REGISTRO  from ItemMovimentoFolha item   where  item.movimentoFolha.aberturaPeriodo = :abertura  and  item.eventoColaborador.tipoCalculoEvento = :tpSalarioFamilia  order by item.movimentoFolha.colaborador.pessoa.nome ";
        List dados = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("abertura", (Object)abertura).setEntity("tpSalarioFamilia", (Object)tpSalarioFamilia).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        Object path = System.getProperty("user.dir");
        path = "reports" + File.separator + "rh" + File.separator + "folhapagamento" + File.separator + "conferenciafolha" + File.separator + "LISTAGEM_VALORES_SALARIO_FAMILIA.jasper";
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", path);
        relatorio.setAttribute("parametros", parametros);
        relatorio.setAttribute("dados", dados);
        JasperPrint jasperPrint = (JasperPrint)CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return jasperPrint;
    }

    private List ordenarHash(List lista) {
        if (lista != null) {
            Collections.sort(lista, new Comparator(this){

                public int compare(Object o1, Object o2) {
                    HashMap item1 = (HashMap)o1;
                    HashMap item2 = (HashMap)o2;
                    String nome1 = (String)item1.get("COLABORADOR");
                    String nome2 = (String)item2.get("COLABORADOR");
                    return nome1.compareTo(nome2);
                }
            });
            return lista;
        }
        return null;
    }
}

