/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.afastamentocolaborador;

import com.touchcomp.basementor.model.vo.AfastamentoColaborador;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.EsocMotivoAfastamento;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.MediaAfastamentoColaborador;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.PeriodoAqFeriasColab;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.rh.afastamentocolaborador.UtilAfastamentoColaborador;
import mentorcore.service.impl.rh.afastamentocolaborador.UtilityCalculoMediaAfastamentoColaborador;

public class ServiceAfastamentoColaborador
extends CoreService {
    public static final String FIND_DIAS_AFASTAMENTO_COLABORADOR = "findDiasAfastados";
    public static final String FIND_DIAS_AFASTAMENTO_MATERNIDADE = "findDiasAfastamentosMaternidade";
    public static final String FIND_DIAS_AFASTAMENTO_COM_RETORNO = "findDiasAfastamentoComRetorno";
    public static final String FIND_EVENTOS_FIXOS_PARA_MATERNIDADE = "findEventosFixosParaMaternidade";
    public static final String FIND_AFASTAMENTO_COM_RETORNO = "findAfasmentoComRetorno";
    public static final String FIND_AFASTAMENTO_SAIDA_MATERNIDADE_COM_RETORNO = "findAfasmentoMaternidadeComRetorno";
    public static final String VERIFICAR_AFASTAMENTO_PERIODO_AQUISITIVO = "verificarAfastamentoPeriodoAquisitivo";
    public static final String CALCULAR_MEDIAS_AFASTAMENTO_COLABORADOR = "calcularMediaAfastamentoColaborador";
    public static final String CALCULAR_MEDIAS_FIXAS_AFASTAMENTO = "calcularMediasFixasColaborador";
    public static final String EXCLUIR_AFASTAMENTO = "excluirAfastamento";
    public static final String CALCULAR_DIAS_ATESTADO = "calcularDiasAtestado";
    public static final String BUSCAR_DIAS_ATESTADO_2230 = "buscarDiasAtestado2230";
    public static final String FIND_VERIFICAR_AFASTAMENTO_INFORMADO = "verificarAfastamentoInformado";
    public static final String FIND_VERIFICAR_AFASTAMENTO_COLABORADOR_INFORMADO = "verificarAfastamentoColaboradorInformado";
    public static final String FIND_DIAS_AFASTAMENTO_COLABORADOR_ANTERIOR = "findDiasAfastadosAnterior";

    public void findDiasAfastados(CoreRequestContext r) throws ExceptionService {
        MovimentoFolha mov = (MovimentoFolha)r.getAttribute("MOVIMENTO_FOLHA");
        Date dataInicio = (Date)r.getAttribute("DATA_INICIO");
        Date dataFinal = (Date)r.getAttribute("DATA_FINAL");
        Short tipoFolha = (Short)r.getAttribute("TIPO_FOLHA");
        CoreDAOFactory.getInstance().getDAOAfastamentoColaborador().findAfastamento(mov, dataInicio, dataFinal, tipoFolha);
    }

    public void findDiasAfastamentosMaternidade(CoreRequestContext r) throws ExceptionService {
        MovimentoFolha mov = (MovimentoFolha)r.getAttribute("MOVIMENTO_FOLHA");
        EmpresaRh empRh = (EmpresaRh)r.getAttribute("EMPRESA_RH");
        Date dataInicio = (Date)r.getAttribute("DATA_INICIO");
        Date dataFinal = (Date)r.getAttribute("DATA_FINAL");
        CoreDAOFactory.getInstance().getDAOAfastamentoColaborador().findDiasAfastamentosMaternidade(mov, dataInicio, dataFinal, empRh);
    }

    public void findDiasAfastamentoComRetorno(CoreRequestContext r) throws ExceptionService {
        MovimentoFolha mov = (MovimentoFolha)r.getAttribute("movFolha");
        CoreDAOFactory.getInstance().getDAOAfastamentoColaborador().findInicioAfastamentoComRetorno(mov);
    }

    public List findEventosFixosParaMaternidade(CoreRequestContext r) {
        Colaborador colaborador = (Colaborador)r.getAttribute("colaborador");
        Date dataFinal = (Date)r.getAttribute("dataFinal");
        return CoreDAOFactory.getInstance().getDAOAfastamentoColaborador().findEventosFixosColaboradores(colaborador, dataFinal);
    }

    public AfastamentoColaborador findAfasmentoComRetorno(CoreRequestContext r) {
        MovimentoFolha vo = (MovimentoFolha)r.getAttribute("movFolha");
        return CoreDAOFactory.getInstance().getDAOAfastamentoColaborador().getAfastamentoColaboradorComRetornoNormal(vo);
    }

    public AfastamentoColaborador findAfasmentoMaternidadeComRetorno(CoreRequestContext r) {
        MovimentoFolha vo = (MovimentoFolha)r.getAttribute("movFolha");
        return CoreDAOFactory.getInstance().getDAOAfastamentoColaborador().getAfastamentoColaboradorComRetornoMaternidade(vo);
    }

    public PeriodoAqFeriasColab verificarAfastamentoPeriodoAquisitivo(CoreRequestContext request) {
        PeriodoAqFeriasColab periodoAquisitivo = (PeriodoAqFeriasColab)request.getAttribute("periodoAquisitivo");
        return new UtilAfastamentoColaborador().verificarExistenciaAfastamentoColaborador(periodoAquisitivo);
    }

    public List<MediaAfastamentoColaborador> calcularMediaAfastamentoColaborador(CoreRequestContext request) {
        Colaborador colaborador = (Colaborador)request.getAttribute("colaborador");
        Date dataInicio = (Date)request.getAttribute("dataInicio");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        return new UtilityCalculoMediaAfastamentoColaborador().calcularMediasVariaveisAfastamento(colaborador, dataInicio, dataFinal);
    }

    public List<MediaAfastamentoColaborador> calcularMediasFixasColaborador(CoreRequestContext request) {
        Colaborador colaborador = (Colaborador)request.getAttribute("colaborador");
        return new UtilityCalculoMediaAfastamentoColaborador().calcularMediasFixasAfastamento(colaborador);
    }

    public void excluirAfastamento(CoreRequestContext r) throws ExceptionDatabase {
        AfastamentoColaborador vo = (AfastamentoColaborador)r.getAttribute("afastamento");
        if (!vo.getPreEventosEsocial().isEmpty()) {
            List eventos = vo.getPreEventosEsocial();
            vo.setPreEventosEsocial(new ArrayList());
            for (EsocPreEvento e : eventos) {
                e.setAfastamentoColaborador(null);
                CoreDAOFactory.getInstance().getDAOEsocPreEvento().delete(e);
            }
        }
        CoreDAOFactory.getInstance().getDAOAfastamentoColaborador().delete(vo);
    }

    public Date calcularDiasAtestado(CoreRequestContext r) {
        Date dataInicio = (Date)r.getAttribute("dataInicio");
        Date dataRetorno = (Date)r.getAttribute("dataRetorno");
        String codigoCid = (String)r.getAttribute("codigoCid");
        Colaborador colaborador = (Colaborador)r.getAttribute("colaborador");
        EsocMotivoAfastamento esocMotivo = (EsocMotivoAfastamento)r.getAttribute("afastamentoESocial");
        return new UtilAfastamentoColaborador().getDataAfastamento16Dia(colaborador, dataInicio, esocMotivo, dataRetorno, codigoCid);
    }

    public List buscarDiasAtestado2230(CoreRequestContext request) {
        Colaborador colaborador = (Colaborador)request.getAttribute("colaborador");
        Date dataInicio = (Date)request.getAttribute("dataInicio");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        return new UtilAfastamentoColaborador().getDiasAtestado2230(colaborador, dataInicio, dataFinal);
    }

    public Integer verificarAfastamentoInformado(CoreRequestContext r) {
        Colaborador colaborador = (Colaborador)r.getAttribute("colaborador");
        Date dataAfastamento = (Date)r.getAttribute("dataAfastamento");
        return new UtilAfastamentoColaborador().verificarAfastamento(colaborador, dataAfastamento);
    }

    public List<AfastamentoColaborador> verificarAfastamentoColaboradorInformado(CoreRequestContext r) {
        Colaborador colaborador = (Colaborador)r.getAttribute("colaborador");
        Date dataAfastamento = (Date)r.getAttribute("dataAfastamento");
        return new UtilAfastamentoColaborador().verificarAfastamentoColaborador(colaborador, dataAfastamento);
    }

    public void findDiasAfastadosAnterior(CoreRequestContext r) throws ExceptionService {
        MovimentoFolha mov = (MovimentoFolha)r.getAttribute("MOVIMENTO_FOLHA");
        Date dataInicio = (Date)r.getAttribute("DATA_INICIO");
        Date dataFinal = (Date)r.getAttribute("DATA_FINAL");
        Short tipoFolha = (Short)r.getAttribute("TIPO_FOLHA");
        CoreDAOFactory.getInstance().getDAOAfastamentoColaborador().findAfastamentoAnterior(mov, dataInicio, dataFinal, tipoFolha);
    }
}

