/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.afastamentocolaborador;

import com.touchcomp.basementor.model.vo.AfastamentoColaborador;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.EsocMotivoAfastamento;
import com.touchcomp.basementor.model.vo.PeriodoAqFeriasColab;
import java.util.Date;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.tools.DateUtil;

public class UtilAfastamentoColaborador {
    public PeriodoAqFeriasColab verificarExistenciaAfastamentoColaborador(PeriodoAqFeriasColab periodo) {
        Date dataInicioPeriodo = periodo.getDataInicial();
        Date dataFinalPeriodo = periodo.getDataFinal();
        String hql = " select distinct(af)  from AfastamentoColaborador af  where  af.dataAfastamento != null  and  af.afastamentoSefip.codigo != :maternidade and af.afastamentoSefip.codigo != :aposentadoria  and ( af.dataAfastamento between :dataInicio and :dataFinal  or  af.dataRetorno between :dataInicio and :dataFinal or (af.dataAfastamento < :dataInicio and af.dataRetorno > :dataFinal))  and  af.colaborador = :colaborador  order by af.dataAfastamento ";
        List ret = CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("dataInicio", dataInicioPeriodo).setDate("dataFinal", dataFinalPeriodo).setEntity("colaborador", (Object)periodo.getColaborador()).setString("aposentadoria", "U1").setString("maternidade", "Q1").list();
        if (ret == null || ret.isEmpty()) {
            return periodo;
        }
        Integer dias = 0;
        Date inicio = null;
        Date fim = null;
        for (Object obj : ret) {
            AfastamentoColaborador afastamento = (AfastamentoColaborador)obj;
            inicio = afastamento.getDataAfastamento().before(dataInicioPeriodo) ? dataInicioPeriodo : afastamento.getDataAfastamento();
            fim = afastamento.getDataRetorno() == null || afastamento.getDataRetorno().after(dataFinalPeriodo) ? dataFinalPeriodo : afastamento.getDataRetorno();
            dias = dias + (DateUtil.diferenceDayBetweenDates(inicio, fim) + 1);
        }
        if (dias <= 180) {
            return periodo;
        }
        AfastamentoColaborador afastamento = (AfastamentoColaborador)ret.get(ret.size() - 1);
        periodo.setDataInicial(afastamento.getDataRetorno());
        dataFinalPeriodo = DateUtil.nextYear(afastamento.getDataRetorno(), 1);
        dataFinalPeriodo = DateUtil.nextDays(dataFinalPeriodo, -1);
        periodo.setDataFinal(dataFinalPeriodo);
        return periodo;
    }

    public Date getDataAfastamento16Dia(Colaborador colaborador, Date dataInicio, EsocMotivoAfastamento esocAfastamento, Date dataRetorno, String codigoCid) {
        Date dataCorte = DateUtil.nextDays(dataInicio, -60);
        Integer diasAfastamento = DateUtil.diferenceDayBetweenDates(dataInicio, dataRetorno) + 1;
        String hql = " from AfastamentoColaborador af  where  af.colaborador = :colaborador  and  lower(af.codigoCid) = :cid  and  af.esocMotivoAfastamento = :afastamento  and  af.dataRetorno between :dataCorte and :dataInicio ";
        List afastamentos = CoreBdUtil.getInstance().getSession().createQuery(hql).setParameter("colaborador", (Object)colaborador).setParameter("dataCorte", (Object)dataCorte).setParameter("dataInicio", (Object)dataInicio).setParameter("cid", (Object)codigoCid.toLowerCase()).setParameter("afastamento", (Object)esocAfastamento).list();
        if (diasAfastamento <= 15 && (afastamentos == null || afastamentos.isEmpty())) {
            return null;
        }
        Integer dias = 0;
        for (Object obj : afastamentos) {
            Integer diffDias;
            AfastamentoColaborador af = (AfastamentoColaborador)obj;
            if (af.getDataAfastamento() != null) {
                if (af.getDataAfastamento().before(dataCorte)) {
                    diffDias = DateUtil.diferenceDayBetweenDates(dataCorte, af.getDataRetorno()) + 1;
                    dias = dias + diffDias;
                    continue;
                }
                diffDias = DateUtil.diferenceDayBetweenDates(af.getDataAfastamento(), af.getDataRetorno()) + 1;
                dias = dias + diffDias;
                continue;
            }
            if (af.getDataInicio() == null) continue;
            if (af.getDataInicio().before(dataCorte)) {
                diffDias = DateUtil.diferenceDayBetweenDates(dataCorte, af.getDataRetorno()) + 1;
                dias = dias + diffDias;
                continue;
            }
            diffDias = DateUtil.diferenceDayBetweenDates(af.getDataInicio(), af.getDataRetorno()) + 1;
            dias = dias + diffDias;
        }
        if (dias > 15) {
            return dataInicio;
        }
        if (dias == 0 && diasAfastamento > 15) {
            return DateUtil.nextDays(dataInicio, 15);
        }
        Integer diasTotal = dias + diasAfastamento;
        if (diasTotal <= 15) {
            return null;
        }
        diasAfastamento = 15 - dias;
        return DateUtil.nextDays(dataInicio, diasAfastamento);
    }

    public List getDiasAtestado2230(Colaborador colaborador, Date dataInicio, Date dataFinal) {
        String hql = " select af  from AfastamentoColaborador af  where  af.esocMotivoAfastamento.codigo != :codigoAposentadoria  and  af.colaborador = :colaborador  and  (af.dataInicio between :dataInicio and :dataFinal  or  af.dataFinal between :dataInicio and :dataFinal  or  ((af.dataAfastamento - 1) between :dataInicio and :dataFinal ))";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setString("codigoAposentadoria", "06").setDate("dataInicio", dataInicio).setDate("dataFinal", dataFinal).list();
    }

    public Integer verificarAfastamento(Colaborador colaborador, Date dataAfastamento) {
        String hql = " select coalesce (count(af.identificador),0)  from AfastamentoColaborador af  where  af.colaborador = :colaborador  and  af.dataInicio <= :dataAfastamento  and  (af.dataRetorno is null or af.dataRetorno > :dataAfastamento)";
        Long retorno = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setDate("dataAfastamento", dataAfastamento).uniqueResult();
        if (retorno == null || retorno == 0L) {
            return 0;
        }
        return 1;
    }

    public List<AfastamentoColaborador> verificarAfastamentoColaborador(Colaborador colaborador, Date dataAfastamento) {
        String hql = " select af  from AfastamentoColaborador af  where  af.colaborador = :colaborador  and  af.dataInicio <= :dataAfastamento  and  (af.dataRetorno is null or af.dataRetorno > :dataAfastamento)";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setDate("dataAfastamento", dataAfastamento).list();
    }
}

