/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.afastamentocolaborador;

import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoMedias;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ItemMovimentoFolha;
import com.touchcomp.basementor.model.vo.MediaAfastamentoColaborador;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilityCalculoMediaAfastamentoColaborador {
    public List<MediaAfastamentoColaborador> calcularMediasVariaveisAfastamento(Colaborador colaborador, Date dataInicio, Date dataFinal) {
        String hql = " select mov  from MovimentoFolha mov  where  mov.colaborador = :colaborador  and  mov.finalizado = :sim  and  mov.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaDePagamento  and  mov.statusFolha.codigo = :folhaNormal  and  mov.aberturaPeriodo.dataInicio between :dataInicio and :dataFinal  order by mov.aberturaPeriodo.dataFinal  DESC ";
        List movs = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setShort("folhaDePagamento", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue()).setShort("sim", (short)1).setShort("folhaNormal", (short)1).setDate("dataInicio", dataInicio).setDate("dataFinal", dataFinal).list();
        if (movs != null && !movs.isEmpty()) {
            return this.ratearValores(movs);
        }
        return new ArrayList<MediaAfastamentoColaborador>();
    }

    private List<MediaAfastamentoColaborador> ratearValores(List<MovimentoFolha> movs) {
        ArrayList<MediaAfastamentoColaborador> retornoMedias = new ArrayList<MediaAfastamentoColaborador>();
        for (MovimentoFolha mov : movs) {
            for (ItemMovimentoFolha item : mov.getItensMovimentoFolha()) {
                if (!item.getEventoColaborador().getEventoFixo().equals((short)0) || item.getEventoColaborador().getTipoCalculoEvento().getMediaAfastamentos().equals(EnumConstEventoMedias.SEM_MEDIA.getValue())) continue;
                TipoCalculoEvento newTp = item.getEventoColaborador().getTipoCalculoEvento();
                Short tipoMedia = item.getEventoColaborador().getTipoCalculoEvento().getMediaAfastamentos();
                System.err.println(newTp.getEvento().getDescricao());
                boolean achou = false;
                for (MediaAfastamentoColaborador mediaAfastamento : retornoMedias) {
                    if (!mediaAfastamento.getTipoCalculoEvento().equals((Object)newTp)) continue;
                    if (tipoMedia.equals(EnumConstEventoMedias.MEDIA_REFERENCIA.getValue())) {
                        mediaAfastamento.setReferencia(Double.valueOf(mediaAfastamento.getReferencia() + item.getReferencia()));
                    } else {
                        mediaAfastamento.setValor(Double.valueOf(mediaAfastamento.getValor() + item.getValor()));
                    }
                    achou = true;
                    break;
                }
                if (achou) continue;
                MediaAfastamentoColaborador newMedia = new MediaAfastamentoColaborador();
                newMedia.setTipoCalculoEvento(newTp);
                newMedia.setTipoMedia(tipoMedia);
                if (newMedia.getTipoMedia().equals(EnumConstEventoMedias.MEDIA_REFERENCIA.getValue())) {
                    newMedia.setReferencia(item.getReferencia());
                } else {
                    newMedia.setValor(item.getValor());
                    newMedia.setInformarValor(Short.valueOf((short)1));
                }
                retornoMedias.add(newMedia);
            }
        }
        return retornoMedias;
    }

    public List<MediaAfastamentoColaborador> calcularMediasFixasAfastamento(Colaborador colaborador) {
        String hql = " select  evt.tipoCalculoEvento.identificador as ID_EVENTO,  evt.tipoCalculoEvento.mediaFerias as TIPO_MEDIA  from EventoColaborador evt  where  evt.dataFinal is null  and  evt.eventoFixo = :sim  and  evt.tipoCalculoEvento.mediaAfastamentos <> :nao  and  evt.colaborador = :colaborador ";
        List ret = CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("sim", (short)1).setShort("nao", (short)0).setEntity("colaborador", (Object)colaborador).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        for (Object obj : ret) {
            HashMap hash = (HashMap)obj;
            hash.put("VALOR", 0.0);
            hash.put("REFERENCIA", 0.0);
        }
        ArrayList<HashMap> retorno = new ArrayList<HashMap>();
        for (Object obj : ret) {
            HashMap h = (HashMap)obj;
            Long id = (Long)h.get("ID_EVENTO");
            TipoCalculoEvento tipo = this.findTipoCalculoEvento(id);
            h.put("TIPO_CALCULO", tipo);
            retorno.add(h);
        }
        return this.createMedia(retorno);
    }

    private TipoCalculoEvento findTipoCalculoEvento(Long id) {
        String hql = " from TipoCalculoEvento t  where t.identificador = :id ";
        return (TipoCalculoEvento)CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("id", id.longValue()).uniqueResult();
    }

    private List<MediaAfastamentoColaborador> createMedia(List retorno) {
        ArrayList<MediaAfastamentoColaborador> medias = new ArrayList<MediaAfastamentoColaborador>();
        for (Object obj : retorno) {
            HashMap hash = (HashMap)obj;
            Short tipoMedia = (Short)hash.get("TIPO_MEDIA");
            TipoCalculoEvento tp = (TipoCalculoEvento)hash.get("TIPO_CALCULO");
            MediaAfastamentoColaborador media = new MediaAfastamentoColaborador(tp, tipoMedia);
            medias.add(media);
        }
        return medias;
    }
}

