/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.apuracaocustomensal;

import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoParamFolha;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.ApuracaoCustoProvisao;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.ItemCustoMensalColaborador;
import com.touchcomp.basementor.model.vo.ItemMovimentoFolha;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilApuracaoCustoMensal {
    public Double percentualDesoneracaoInssEmpresa(Date dataInicio, Date dataFinal, Empresa empresa) throws ExceptionService {
        String hql = " select  coalesce(inss.percDesoneracao,0)  from CalculoInssEmpresa inss  inner join inss.aberturasPeriodo abr  where  abr.aberturaPeriodo.dataInicio = :dataInicio  and  abr.aberturaPeriodo.dataFinal = :dataFinal  and  abr.aberturaPeriodo.empresa = :empresa  and  abr.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento ";
        Double perc = (Double)CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("dataInicio", dataInicio).setDate("dataFinal", dataFinal).setEntity("empresa", (Object)empresa).setShort("folhaPagamento", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue()).setMaxResults(1).uniqueResult();
        if (perc == null) {
            throw new ExceptionService("N\u00e3o existe uma apura\u00e7\u00e3o de INSS para este periodo.");
        }
        return perc;
    }

    public List findFolhaCustoMensal(Date dataInicio, Date dataFinal, Empresa empresa) throws ExceptionService {
        String hql = " select   (movimentoFolha.bcInssSalario + movimentoFolha.bcInssFerias) as BC_INSS,   movimentoFolha.vrFgtsSalario as VR_FGTS,  movimentoFolha.colaborador.identificador as COLABORADOR,  movimentoFolha.identificador as ID_FOLHA  from MovimentoFolha movimentoFolha   where   movimentoFolha.aberturaPeriodo.dataInicio >= :dataInicial and   movimentoFolha.aberturaPeriodo.dataFinal  <= :dataFinal  and   movimentoFolha.empresa = :empresa  and  (movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento  or  movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :recisaoComplementar or  movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaComplementar) group by   movimentoFolha.colaborador.identificador,   movimentoFolha.bcInssSalario , movimentoFolha.bcInssFerias  , movimentoFolha.bcInss13Sal,  movimentoFolha.vrFgtsSalario ,  movimentoFolha.vrFgtsFerias , movimentoFolha.vrFgts13Sal,  movimentoFolha.identificador ";
        List hashs = CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("dataInicial", dataInicio).setDate("dataFinal", dataFinal).setEntity("empresa", (Object)empresa).setShort("folhaPagamento", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue()).setShort("recisaoComplementar", EnumConstTipoCalculoEvento.CALCULO_RECISAO_COMPLEMENTAR.getValue().shortValue()).setShort("folhaComplementar", EnumConstTipoCalculoEvento.CALCULO_FOLHA_COMPLEMENTAR.getValue().shortValue()).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        for (HashMap hash : hashs) {
            Long idMov = (Long)hash.get("ID_FOLHA");
            MovimentoFolha mov = (MovimentoFolha)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOMovimentoFolha(), "identificador", idMov, 0);
            hash.put("MOV_FOLHA", mov);
        }
        return hashs;
    }

    public List calcularCustoMensalPorColaborador(List movsFolha, EmpresaRh empresaRh, Double percentualDesoneracao, Date periodoFinal) throws ExceptionService {
        ArrayList<ItemCustoMensalColaborador> itens = new ArrayList<ItemCustoMensalColaborador>();
        for (Object obj : movsFolha) {
            HashMap hash = (HashMap)obj;
            MovimentoFolha mov = (MovimentoFolha)hash.get("MOV_FOLHA");
            Long identificador = (Long)hash.get("COLABORADOR");
            Colaborador colaborador = (Colaborador)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOColaborador(), "identificador", identificador, 0);
            Double vlrFgts = (Double)hash.get("VR_FGTS");
            Double bcInss = (Double)hash.get("BC_INSS");
            Double vlrCusto = this.getValorCustoIndividual(mov);
            Double vlrInssEmpresa = this.vlrInssEmpresa(bcInss, percentualDesoneracao, empresaRh);
            Double vlrInssTerceiros = this.vlrInssTerceiros(bcInss, empresaRh, mov.getColaborador());
            Double vlrMultaRecisao = this.vlrMultaFgts(vlrFgts);
            Double vlrAvisoIndenizado = this.vlrAvisoIndenizado(bcInss, empresaRh);
            Double provisaoDec = 0.0;
            Double provisaoFerias = 0.0;
            if (mov.getAberturaPeriodo().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue())) {
                provisaoDec = ContatoFormatUtil.arrredondarNumero((Double)this.vlrProvisaoDec(colaborador, periodoFinal), (int)2);
                provisaoFerias = ContatoFormatUtil.arrredondarNumero((Double)this.vlrProvisaoFerias(colaborador, periodoFinal), (int)2);
            }
            Double totalCustoColaborador = vlrCusto + vlrFgts + vlrInssEmpresa + vlrInssTerceiros + vlrMultaRecisao + vlrAvisoIndenizado + provisaoDec + provisaoFerias;
            totalCustoColaborador = ContatoFormatUtil.arrredondarNumero((Double)totalCustoColaborador, (int)2);
            ItemCustoMensalColaborador item = new ItemCustoMensalColaborador(vlrCusto, vlrFgts, vlrMultaRecisao, vlrAvisoIndenizado, vlrInssTerceiros, provisaoDec, provisaoFerias, vlrInssEmpresa, colaborador, totalCustoColaborador, colaborador.getCentroCusto());
            itens.add(item);
        }
        return itens;
    }

    private Double vlrProvisaoFerias(Colaborador colaborador, Date dataFinal) {
        String hql = " select coalesce(item.valorMensal,0)  from ItemProvisaoFerias item  where  item.colaborador = :colaborador  and  item.provisao.periodo = :periodo ";
        return (Double)CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setDate("periodo", dataFinal).uniqueResult();
    }

    private Double vlrProvisaoDec(Colaborador colaborador, Date dataFinal) {
        String hql = " select coalesce(item.valorMensal,0)  from ItemProvisaoDec item  where  item.colaborador = :colaborador  and  item.provisao.periodo = :periodo ";
        return (Double)CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setDate("periodo", dataFinal).uniqueResult();
    }

    private Double vlrInssEmpresa(Double bcInss, Double percDesoneracao, EmpresaRh empresaRh) {
        if (percDesoneracao == 100.0) {
            return 0.0;
        }
        Double inss = bcInss * (empresaRh.getPercEmpresa() / 100.0);
        inss = inss * ((100.0 - percDesoneracao) / 100.0);
        return inss;
    }

    private Double vlrInssTerceiros(Double bcInss, EmpresaRh empresaRh, Colaborador colaborador) {
        if (colaborador.getTipoColaborador().getIdentificador().equals(EnumConstTipoColaborador.EMPREGADO.getValue()) || colaborador.getTipoColaborador().getIdentificador().equals(EnumConstTipoColaborador.MENOR_APRENDIZ.getValue())) {
            Double indiceFat = empresaRh.getIndiceFAP();
            Double percRat = empresaRh.getPercRat();
            Double rat = ContatoFormatUtil.arrredondarNumero((Double)(bcInss * indiceFat * (percRat / 100.0)), (int)2);
            Double parteTerceiro = ContatoFormatUtil.arrredondarNumero((Double)(bcInss * empresaRh.getPercTerceiros() / 100.0), (int)2);
            return ContatoFormatUtil.arrredondarNumero((Double)(rat + parteTerceiro), (int)2);
        }
        return 0.0;
    }

    private Double vlrMultaFgts(Double vlrFgts) {
        return ContatoFormatUtil.arrredondarNumero((Double)(vlrFgts * 0.4), (int)2);
    }

    private Double vlrAvisoIndenizado(Double vlrCusteio, EmpresaRh empresaRh) {
        Double percAvisoIndenizado = empresaRh.getPercDescontoAvisoIndenizadoCusteio();
        return ContatoFormatUtil.arrredondarNumero((Double)(vlrCusteio * (percAvisoIndenizado / 100.0)), (int)2);
    }

    private Double getValorCustoIndividual(MovimentoFolha mov) {
        Double valorCusto = 0.0;
        for (ItemMovimentoFolha item : mov.getItensMovimentoFolha()) {
            if (item.getEventoColaborador().getTipoCalculoEvento().getCompoeCustoColaborador().equals((short)1) && item.getEventoColaborador().getTipoCalculoEvento().getEvento().getTipoEvento().equals(EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue())) {
                valorCusto = valorCusto + item.getValor();
                continue;
            }
            if (!item.getEventoColaborador().getTipoCalculoEvento().getCompoeCustoColaborador().equals((short)1)) continue;
            valorCusto = valorCusto - item.getValor();
        }
        return ContatoFormatUtil.arrredondarNumero((Double)valorCusto, (int)2);
    }

    public JasperPrint imprimirCustosMensais(ApuracaoCustoProvisao custo, HashMap parametros) throws ExceptionService {
        String hql = " select  item.colaborador.pessoa.nome as NOME , item.colaborador.dataAdmissao as ADMISSAO, item.apuracaoCusto.periodo as PERIODO,  item.colaborador.numeroRegistro as NR_REGISTRO,  item.vlrCustoMensal as CUSTO_MENSAL,  item.vlrFgts as FGTS,  item.inssEmpresa as INSS_EMPRESA,  item.vlrMultaRecisao as MULTA,  item.vlrInssTerceiros as INSS_TERCEIROS,  item.provisaoFerias as PROVISAO_FERIAS,  item.provisaoDec as PROVISAO_DEC ,  item.totalCustoColaborador as TOTAL, item.centroCusto.nome as CENTRO_C, item.centroCusto.codigo as CODIGO  from ItemCustoMensalColaborador item  where  item.apuracaoCusto = :custo  order by item.colaborador.centroCusto.nome, item.colaborador.pessoa.nome";
        List dados = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("custo", (Object)custo).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "rh" + File.separator + "relatorios" + File.separator + "customensal" + File.separator + "LISTAGEM_CUSTO_MENSAL.jasper";
        CoreRequestContext r = new CoreRequestContext();
        r.setAttribute("path", path);
        r.setAttribute("parametros", parametros);
        r.setAttribute("dados", dados);
        return (JasperPrint)CoreServiceFactory.getCoreReportService().execute(r, "getJasperPrintDataSource");
    }
}

