/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.apuracaoponto;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementor.model.vo.AfastamentoColaborador;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.Feriado;
import com.touchcomp.basementor.model.vo.FeriasColaborador;
import com.touchcomp.basementor.model.vo.InfoHorarioTrabalho;
import com.touchcomp.basementor.model.vo.ItemLeituraArquivoPonto;
import com.touchcomp.basementor.model.vo.LeituraArquivoPonto;
import com.touchcomp.basementor.model.vo.OpcoesIntegracaoPonto;
import com.touchcomp.basementor.model.vo.PontoColaborador;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.VOProcessResult;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.CoreServiceFactory;

public class UtiltityAberturaFolhaPonto {
    public List efetuarAberturaPonto(Date dataInicio, Date dataFinal, Empresa empresa, EmpresaRh empresaRh, OpcoesIntegracaoPonto opcoesIntegracaoPonto) throws ExceptionService {
        ArrayList<PontoColaborador> pontos = new ArrayList<PontoColaborador>();
        String hql = " from Colaborador c  where  c.ativo = :sim  and  (c.dataDemissao is null or c.dataDemissao > :dataFinal )  and  c.dataAdmissao <= :dataFinal   and  (c.tipoColaborador.identificador = :empregado or c.tipoColaborador.identificador = :menorAprendiz )  and  c.horarioTrabalho.descartarApuracaoPonto = :nao  and  c.empresa = :grupoEmpresa   order by c.pessoa.nome ";
        List colaboradores = CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("sim", (short)1).setShort("nao", (short)0).setDate("dataFinal", dataFinal).setLong("empregado", EnumConstTipoColaborador.EMPREGADO.getValue()).setLong("menorAprendiz", EnumConstTipoColaborador.MENOR_APRENDIZ.getValue()).setEntity("grupoEmpresa", (Object)empresa).list();
        if (colaboradores.isEmpty()) {
            throw new ExceptionService("Nenhum colaborador Encontrado com os Parametros informados");
        }
        Integer cont = 0;
        for (Colaborador c : colaboradores) {
            cont = cont + 1;
            System.out.println(c.toString());
            System.out.println("Total: " + colaboradores.size() + " - " + cont);
            PontoColaborador ponto = new PontoColaborador();
            ponto.setColaborador(c);
            this.getItensLeituraPonto(dataInicio, dataFinal, ponto, c, opcoesIntegracaoPonto);
            pontos.add(ponto);
        }
        this.getPontosColaboradores(pontos, empresaRh, opcoesIntegracaoPonto, dataInicio, dataFinal);
        return pontos;
    }

    private List<PontoColaborador> getPontosColaboradores(List<PontoColaborador> pontos, EmpresaRh empresaRh, OpcoesIntegracaoPonto opcoesIntegracaoPonto, Date dataInicio, Date dataFinal) throws ExceptionService {
        Integer cont = 0;
        List<FeriasColaborador> feriasPeriodo = this.getFeriasPeriodo(dataInicio, dataFinal);
        List<AfastamentoColaborador> afastamentosPeriodo = this.getAfastamentoPeriodo(dataInicio, dataFinal);
        List<Feriado> feriados = this.getFeriados(dataInicio, dataFinal, empresaRh.getEmpresa().getIdentificador());
        for (PontoColaborador pt : pontos) {
            cont = cont + 1;
            System.err.println(pt.getColaborador().toString());
            System.out.println("Total: " + pontos.size() + " - " + cont);
            for (ItemLeituraArquivoPonto item : pt.getItensLeitura()) {
                if (ToolMethods.isAffirmative((Number)item.getInformarManual())) continue;
                if (this.getAfastamento(item.getDataResumo(), pt.getColaborador(), afastamentosPeriodo).equals((short)1)) {
                    item.setTipoOcorrenciaPonto(opcoesIntegracaoPonto.getTipoOcorrenciaAfastamento());
                    continue;
                }
                if (this.getFerias(item.getDataResumo(), pt.getColaborador(), feriasPeriodo).equals((short)1)) {
                    item.setTipoOcorrenciaPonto(opcoesIntegracaoPonto.getTipoOcorrenciaFerias());
                    continue;
                }
                if (this.diaFeriado(item.getDataResumo(), empresaRh.getEmpresa().getIdentificador(), feriados).equals((short)1)) {
                    item.setTipoOcorrenciaPonto(opcoesIntegracaoPonto.getTipoOcorrenciaFeriado());
                    continue;
                }
                if (item.getDiaFolga().equals((short)1)) {
                    item.setTotalHorasTrabalhadas(Double.valueOf(0.0));
                    continue;
                }
                item.setTotalHorasATrabalhar(item.getInfoHorario().getTotalHoras());
            }
        }
        return pontos;
    }

    private Short diaFeriado(Date inicioParametro, Long idEmpresa, List<Feriado> feriados) throws ExceptionService {
        for (Feriado feriado : feriados) {
            if (!feriado.getDia().equals(ToolDate.dayFromDate((Date)inicioParametro)) || !feriado.getMes().equals(ToolDate.monthFromDate((Date)inicioParametro))) continue;
            return (short)1;
        }
        return (short)0;
    }

    private Short getAfastamento(Date dataParametro, Colaborador colaborador, List<AfastamentoColaborador> afastamentosPeriodo) {
        for (AfastamentoColaborador af : afastamentosPeriodo) {
            if (!colaborador.equals((Object)af.getColaborador()) || !dataParametro.equals(af.getDataInicio()) && !dataParametro.after(af.getDataInicio()) || (af.getDataAfastamento() != null || !af.getDataFinal().equals(dataParametro) && !af.getDataFinal().after(dataParametro)) && (af.getDataAfastamento() == null || af.getDataRetorno() != null && !af.getDataRetorno().after(dataParametro))) continue;
            return (short)1;
        }
        return (short)0;
    }

    private Short getFerias(Date dataParametro, Colaborador colaborador, List<FeriasColaborador> feriasPeriodo) {
        for (FeriasColaborador f : feriasPeriodo) {
            if (!f.getPeriodoAqFeriasColab().getColaborador().equals((Object)colaborador) || !f.getDataGozoInicial().equals(dataParametro) && (!f.getDataGozoInicial().before(dataParametro) || !f.getDataGozoFinal().equals(dataParametro) && !f.getDataGozoFinal().after(dataParametro))) continue;
            return (short)1;
        }
        return (short)0;
    }

    private void getItensLeituraPonto(Date dataInicio, Date dataFinal, PontoColaborador ponto, Colaborador colaborador, OpcoesIntegracaoPonto opcoesIntegracaoPonto) throws ExceptionService {
        do {
            if (dataInicio.before(colaborador.getDataAdmissao())) continue;
            ItemLeituraArquivoPonto item = new ItemLeituraArquivoPonto(dataInicio);
            item.setPontoColaborador(ponto);
            item.setDataResumo(dataInicio);
            item.setHorario(colaborador.getHorarioTrabalho());
            Integer diaParametro = this.getDiaSemanal(dataInicio);
            this.getInfoHorario(colaborador, diaParametro, ponto, item, dataInicio, opcoesIntegracaoPonto);
            ponto.getItensLeitura().add(item);
        } while ((dataInicio = ToolDate.nextDays((Date)dataInicio, (int)1)).before(dataFinal) || dataInicio.equals(dataFinal));
    }

    private void getInfoHorario(Colaborador colaborador, Integer diaParametro, PontoColaborador ponto, ItemLeituraArquivoPonto itemPonto, Date dataResumo, OpcoesIntegracaoPonto opcoesIntegracaoPonto) throws ExceptionService {
        if (colaborador.getHorarioTrabalho().getEsocCadastroHorario() == null) {
            return;
        }
        if (ToolMethods.isAffirmative((Number)itemPonto.getInformarManual())) {
            return;
        }
        if (colaborador.getHorarioTrabalho().getEsocCadastroHorario().getTipoJornada().getCodigo().equals("4") || colaborador.getHorarioTrabalho().getEsocCadastroHorario().getTipoJornada().getCodigo().equals("5") || colaborador.getHorarioTrabalho().getEsocCadastroHorario().getTipoJornada().getCodigo().equals("6")) {
            if (colaborador.getHorarioTrabalho().getEsocCadastroHorario() != null && !colaborador.getHorarioTrabalho().getEsocCadastroHorario().getListaHorario().isEmpty()) {
                for (InfoHorarioTrabalho dia : colaborador.getHorarioTrabalho().getEsocCadastroHorario().getListaHorario()) {
                    if (!dia.getDiaSemana().getDia().equals(diaParametro.shortValue())) continue;
                    itemPonto.setInfoHorario(dia);
                    if (dia.getDiaCompensado().equals((short)1)) {
                        itemPonto.setAbonarDia(Short.valueOf((short)1));
                    }
                    if (dia.getFolga().equals((short)1)) {
                        itemPonto.setDiaFolga(Short.valueOf((short)1));
                        itemPonto.setTipoOcorrenciaPonto(opcoesIntegracaoPonto.getTipoOcorrenciaFaltaLegal());
                        continue;
                    }
                    itemPonto.setTipoOcorrenciaPonto(opcoesIntegracaoPonto.getTipoOcorrenciaNormal());
                }
            }
        } else if (colaborador.getHorarioTrabalho().getEsocCadastroHorario().getTipoJornada().getCodigo().equals("2")) {
            if (colaborador.getHorarioTrabalho().getEsocCadastroHorario() != null && colaborador.getHorarioTrabalho().getEsocCadastroHorario().getInfoHorario() != null) {
                InfoHorarioTrabalho dia = colaborador.getHorarioTrabalho().getEsocCadastroHorario().getInfoHorario();
                if (ponto.getItensLeitura().isEmpty()) {
                    if (colaborador.getDataInicioIndice() == null || colaborador.getHorarioAdmissao() == null) {
                        throw new ExceptionService("Colaborador: " + colaborador.toString() + " sem informa\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdo de indice de inicio");
                    }
                    if (diaParametro.equals(this.getDiaSemanal(colaborador.getDataInicioIndice()))) {
                        itemPonto.setInfoHorario(colaborador.getHorarioAdmissao());
                        itemPonto.setTipoOcorrenciaPonto(opcoesIntegracaoPonto.getTipoOcorrenciaNormal());
                    } else {
                        itemPonto.setDiaFolga(Short.valueOf((short)1));
                        itemPonto.setTipoOcorrenciaPonto(opcoesIntegracaoPonto.getTipoOcorrenciaFaltaLegal());
                    }
                } else {
                    boolean achou = false;
                    for (ItemLeituraArquivoPonto itemLeitura : ponto.getItensLeitura()) {
                        if (!itemLeitura.getDataResumo().equals(ToolDate.nextDays((Date)dataResumo, (int)-1))) continue;
                        if (itemLeitura.getDiaFolga().equals((short)1)) {
                            itemPonto.setInfoHorario(colaborador.getHorarioAdmissao());
                            itemPonto.setTipoOcorrenciaPonto(opcoesIntegracaoPonto.getTipoOcorrenciaNormal());
                        } else {
                            itemPonto.setDiaFolga(Short.valueOf((short)1));
                            itemPonto.setTipoOcorrenciaPonto(opcoesIntegracaoPonto.getTipoOcorrenciaFaltaLegal());
                        }
                        achou = true;
                    }
                }
            }
        } else if (colaborador.getHorarioTrabalho().getEsocCadastroHorario().getTipoJornada().getCodigo().equals("3")) {
            if (ponto.getItensLeitura().isEmpty()) {
                if (colaborador.getDataInicioIndice() == null || colaborador.getHorarioAdmissao() == null) {
                    throw new ExceptionService("Colaborador: " + colaborador.toString() + " sem informa\u00ef\u00bf\u00bd\u00ef\u00bf\u00bdo de indice de inicio");
                }
                for (InfoHorarioTrabalho dia : colaborador.getHorarioTrabalho().getEsocCadastroHorario().getListaHorario()) {
                    if (!dia.equals((Object)colaborador.getHorarioAdmissao())) continue;
                    itemPonto.setInfoHorario(dia);
                    if (dia.getFolga().equals((short)1)) {
                        itemPonto.setDiaFolga(Short.valueOf((short)1));
                        itemPonto.setTipoOcorrenciaPonto(opcoesIntegracaoPonto.getTipoOcorrenciaFaltaLegal());
                    } else {
                        itemPonto.setTipoOcorrenciaPonto(opcoesIntegracaoPonto.getTipoOcorrenciaNormal());
                    }
                    break;
                }
            } else {
                boolean achou = false;
                Integer indice = 0;
                for (ItemLeituraArquivoPonto itemLeitura : ponto.getItensLeitura()) {
                    if (!itemLeitura.getDataResumo().equals(ToolDate.nextDays((Date)dataResumo, (int)-1))) continue;
                    indice = itemLeitura.getInfoHorario().getIndice().intValue();
                    achou = true;
                    break;
                }
                indice = indice + 1;
                achou = false;
                for (InfoHorarioTrabalho dia : colaborador.getHorarioTrabalho().getEsocCadastroHorario().getListaHorario()) {
                    if (!dia.getIndice().equals(indice.shortValue())) continue;
                    itemPonto.setInfoHorario(dia);
                    if (dia.getFolga().equals((short)1)) {
                        itemPonto.setDiaFolga(Short.valueOf((short)1));
                        itemPonto.setTipoOcorrenciaPonto(opcoesIntegracaoPonto.getTipoOcorrenciaFaltaLegal());
                    } else {
                        itemPonto.setTipoOcorrenciaPonto(opcoesIntegracaoPonto.getTipoOcorrenciaNormal());
                    }
                    achou = true;
                    break;
                }
                if (!achou) {
                    itemPonto.setInfoHorario((InfoHorarioTrabalho)colaborador.getHorarioTrabalho().getEsocCadastroHorario().getListaHorario().get(0));
                    itemPonto.setTipoOcorrenciaPonto(opcoesIntegracaoPonto.getTipoOcorrenciaNormal());
                }
            }
        } else {
            throw new ExceptionService("Colaborador: " + colaborador.toString() + " Horario Invalido: " + colaborador.getHorarioTrabalho().getEsocCadastroHorario().getTipoJornada().getDescricao());
        }
    }

    private Integer getDiaSemanal(Date inicioParametro) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(inicioParametro);
        return g.get(7);
    }

    private List<FeriasColaborador> getFeriasPeriodo(Date dataInicio, Date dataFinal) throws ExceptionService {
        return (List)CoreService.simpleFindAll(CoreDAOFactory.getInstance().getDAOFeriasColaborador());
    }

    private List<AfastamentoColaborador> getAfastamentoPeriodo(Date dataInicio, Date dataFinal) {
        String hql = " from AfastamentoColaborador af  where  af.dataInicio  <= :dataFinal ";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setParameter("dataFinal", (Object)dataFinal).list();
    }

    private List<Feriado> getFeriados(Date dataInicio, Date dataFinal, Long idEmpresa) throws ExceptionService {
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("periodoInicial", dataInicio);
        request.setAttribute("periodoFinal", dataFinal);
        request.setAttribute("idEmpresa", idEmpresa);
        List retorno = (List)CoreServiceFactory.getServiceFeriado().execute(request, "findFeriadoPorPeriodo");
        if (retorno == null || retorno.isEmpty()) {
            return new ArrayList<Feriado>();
        }
        return retorno;
    }

    public VOProcessResult reprocessarPonto(LeituraArquivoPonto vo, OpcoesIntegracaoPonto opcoesIntegracaoPonto, VOProcessResult res) throws ExceptionService, ExceptionDatabase {
        Integer cont = 0;
        List<FeriasColaborador> feriasPeriodo = this.getFeriasPeriodo(vo.getPeriodo().getDataInicialApPonto(), vo.getPeriodo().getDataFinalApPonto());
        List<AfastamentoColaborador> afastamentosPeriodo = this.getAfastamentoPeriodo(vo.getPeriodo().getDataInicialApPonto(), vo.getPeriodo().getDataFinalApPonto());
        List<Colaborador> colaboradoresAdmitidos = this.getColaboradoresAdmissao(vo);
        for (Colaborador c : colaboradoresAdmitidos) {
            System.out.println(c.toString());
            System.out.println("Total: " + colaboradoresAdmitidos.size() + " - " + cont);
            VOProcessResult.VOPRocessSuccess success = new VOProcessResult.VOPRocessSuccess();
            success.setDescricao("Colaborador Adicionado: " + c.toString());
            res.addSuccess(success);
            PontoColaborador ponto = new PontoColaborador();
            ponto.setColaborador(c);
            ponto.setLeituraArquivoPonto(vo);
            this.getItensLeituraPonto(vo.getPeriodo().getDataInicialApPonto(), vo.getPeriodo().getDataFinalApPonto(), ponto, c, opcoesIntegracaoPonto);
            vo.getPontoColaborador().add(ponto);
        }
        for (PontoColaborador pt : vo.getPontoColaborador()) {
            cont = cont + 1;
            System.err.println(pt.getColaborador().toString());
            System.out.println("Total: " + vo.getPontoColaborador().size() + " - " + cont);
            if (pt.getColaborador().getIdentificador() == 2438L) {
                System.out.println("testes");
            }
            for (ItemLeituraArquivoPonto item : pt.getItensLeitura()) {
                Integer diaParametro = this.getDiaSemanal(item.getDataResumo());
                if (this.getAfastamento(item.getDataResumo(), pt.getColaborador(), afastamentosPeriodo).equals((short)1)) {
                    item.setTipoOcorrenciaPonto(opcoesIntegracaoPonto.getTipoOcorrenciaAfastamento());
                    continue;
                }
                if (this.getFerias(item.getDataResumo(), pt.getColaborador(), feriasPeriodo).equals((short)1)) {
                    item.setTipoOcorrenciaPonto(opcoesIntegracaoPonto.getTipoOcorrenciaFerias());
                    continue;
                }
                if (ToolMethods.isEquals((Object)item.getDiaFolga(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) && ToolMethods.isEquals((Object)item.getAbonarDia(), (Object)EnumConstantsMentorSimNao.NAO.getValue())) {
                    item.setTipoOcorrenciaPonto(opcoesIntegracaoPonto.getTipoOcorrenciaFaltaLegal());
                    continue;
                }
                if (!ToolMethods.isEquals((Object)item.getTipoOcorrenciaPonto().getReprocessar(), (Object)1) || !ToolMethods.isEquals((Object)item.getAbonarDia(), (Object)EnumConstantsMentorSimNao.NAO.getValue()) || this.getHora(item.getSaida1()) != 0 || this.getHora(item.getEntrada1()) != 0) continue;
                item.setTipoOcorrenciaPonto(opcoesIntegracaoPonto.getTipoOcorrenciaNormal());
            }
        }
        CoreDAOFactory.getInstance().getDAOLeituraArquivoPonto().saveOrUpdate(vo);
        return res;
    }

    private List<Colaborador> getColaboradoresAdmissao(LeituraArquivoPonto vo) {
        String hql = " from Colaborador c  where  c.ativo = :sim  and  (c.dataDemissao is null or c.dataDemissao > :dataFinal )  and  c.dataAdmissao <= :dataFinal   and  (c.tipoColaborador.identificador = :empregado or c.tipoColaborador.identificador = :menorAprendiz )  and  c.horarioTrabalho.descartarApuracaoPonto = :nao  and  c.empresa = :grupoEmpresa  and  not exists(from PontoColaborador p where p.colaborador = c and p.leituraArquivoPonto = :leitura) order by c.pessoa.nome ";
        List colaboradores = CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("sim", (short)1).setShort("nao", (short)0).setDate("dataFinal", vo.getPeriodo().getDataFinalApPonto()).setParameter("leitura", (Object)vo).setLong("empregado", EnumConstTipoColaborador.EMPREGADO.getValue()).setLong("menorAprendiz", EnumConstTipoColaborador.MENOR_APRENDIZ.getValue()).setEntity("grupoEmpresa", (Object)vo.getEmpresa()).list();
        return colaboradores;
    }

    private Integer getHora(Date horarioInicial) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(horarioInicial);
        Integer hora = g.get(11);
        Integer minuto = g.get(12);
        if (hora == 0 && minuto == 0) {
            return 0;
        }
        return 1;
    }
}

