/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.apuracaoponto.apuracaopontoportxt;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.PeriodoFolhaPagamento;
import com.touchcomp.basementor.model.vo.PontoColaborador;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.rh.apuracaoponto.apuracaopontoportxt.LeituraPontoTxt;
import mentorcore.tools.DateUtil;

public class UtilityApuracaoPontoTxt {
    private String COLABORADOR = "3";

    public HashMap apuracaoPontoArquivoTexto(File arquivo, Empresa empresa, PeriodoFolhaPagamento periodo, EmpresaRh empresaRh) throws FileNotFoundException, IOException, ExceptionService {
        HashMap<String, List<Object>> hashRetorno = new HashMap<String, List<Object>>();
        List<PontoColaborador> pontosColaboradores = this.getPontosColaboradores(periodo, empresaRh, empresa);
        FileReader file = new FileReader(arquivo);
        BufferedReader buffer = new BufferedReader(file);
        ArrayList<LeituraPontoTxt> newPontos = new ArrayList<LeituraPontoTxt>();
        Integer cont = 0;
        while (buffer.ready()) {
            cont = cont + 1;
            String linha = buffer.readLine();
            System.err.println(linha);
            System.err.println(cont);
            String tipoRegistro = linha.substring(9, 10);
            Integer tamLinha = linha.length();
            if (!tipoRegistro.equals(this.COLABORADOR)) continue;
            String registro = linha.substring(23, 34);
            String dataTexto = linha.substring(10, 18);
            String horarioTexto = linha.substring(18, 22);
            PontoColaborador p = this.getColaborador(registro, empresa, pontosColaboradores);
            if (p == null) continue;
            if (p.getColaborador().getIdentificador().equals(1717L)) {
                System.out.println("");
            }
            Date dataMarcacao = DateUtil.strToDate(dataTexto, "ddMMyy");
            Date horaMarcacao = this.getHoraMarcacao(horarioTexto, dataMarcacao);
            boolean achou = false;
            if (achou || !ToolDate.dateBetween((Date)dataMarcacao, (Date)p.getLeituraArquivoPonto().getPeriodo().getDataInicialApPonto(), (Date)ToolDate.nextDays((Date)p.getLeituraArquivoPonto().getPeriodo().getDataFinalApPonto(), (int)1)).booleanValue()) continue;
            LeituraPontoTxt newPonto = new LeituraPontoTxt();
            if (p.getColaborador().getHorarioTrabalho().getEsocCadastroHorario().getPossuiHoraNoturna().equals((short)1)) {
                Integer hora = this.getHora(horaMarcacao);
                if (hora >= 0 && hora < 9) {
                    newPonto.setDataMarcacao(dataMarcacao);
                    newPonto.setDataApuracao(ToolDate.nextDays((Date)dataMarcacao, (int)-1));
                } else {
                    newPonto.setDataMarcacao(dataMarcacao);
                    newPonto.setDataApuracao(dataMarcacao);
                }
            } else {
                newPonto.setDataMarcacao(dataMarcacao);
                newPonto.setDataApuracao(dataMarcacao);
            }
            newPonto.setColaborador(p.getColaborador());
            newPonto.setHora(horaMarcacao);
            newPontos.add(newPonto);
        }
        hashRetorno.put("PONTOS", pontosColaboradores);
        hashRetorno.put("PONTOS_LIDOS", newPontos);
        return hashRetorno;
    }

    private Integer getHora(Date horarioInicial) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(horarioInicial);
        return g.get(11);
    }

    private PontoColaborador getColaborador(String registro, Empresa empresa, List<PontoColaborador> pontosColaboradores) throws ExceptionService {
        for (PontoColaborador pontosColaboradore : pontosColaboradores) {
            if (!pontosColaboradore.getColaborador().getNumeroPis().equals(registro)) continue;
            return pontosColaboradore;
        }
        return null;
    }

    private Date getHoraMarcacao(String horarioTexto, Date dataMarcacao) {
        GregorianCalendar g = new GregorianCalendar();
        Date data = ToolDate.dataSemHora((Date)dataMarcacao);
        g.setTime(data);
        String hora = horarioTexto.substring(0, 2);
        String minutos = horarioTexto.substring(2, 4);
        g.set(11, new Integer(hora));
        g.set(12, new Integer(minutos));
        g.set(13, 0);
        return g.getTime();
    }

    private List<PontoColaborador> getPontosColaboradores(PeriodoFolhaPagamento periodo, EmpresaRh empresaRh, Empresa empresa) throws ExceptionService {
        List<PontoColaborador> pontos = this.getPontosColaboradoresPeriodo(periodo);
        return pontos;
    }

    public List<PontoColaborador> getPontosColaboradoresPeriodo(PeriodoFolhaPagamento periodo) {
        String hql = " from PontoColaborador p  where  p.leituraArquivoPonto.periodo = :periodo";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("periodo", (Object)periodo).list();
    }
}

