/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.apuracaoponto.apuracaoporocorrencia;

import com.touchcomp.basementor.model.vo.AberturaPeriodo;
import com.touchcomp.basementor.model.vo.AfastamentoColaborador;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ColaboradorApuracaoPontoFolha;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.FeriasColaborador;
import com.touchcomp.basementor.model.vo.HorarioTrabalho;
import com.touchcomp.basementor.model.vo.InfoHorarioTrabalho;
import com.touchcomp.basementor.model.vo.MovPtoColaborador;
import com.touchcomp.basementor.model.vo.ResumoCompetenciaPontoColaborador;
import com.touchcomp.basementor.model.vo.ResumoDiarioApuracaoPontoColaborador;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementor.model.vo.TipoOcorrenciaPonto;
import contatocore.util.ContatoFormatUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.CoreServiceFactory;
import mentorcore.tools.DateUtil;

public class UtilityApuracaoPontoPorOcorrencia {
    public List apuracaoPontoPorOcorrenciaDesligamento(Date dataInicio, Date dataFinal, Empresa empresa, Colaborador colaborador) {
        String hql = " from MovPtoColaborador movPonto  where  movPonto.colaborador = :colaborador  and  movPonto.dataOcorrencia between :dataInicio and :dataFinal  and  (movPonto.tipoOcorrencia.statusPonto.status = :faltas or movPonto.tipoOcorrencia.statusPonto.status = :faltasHoras)";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setDate("dataInicio", dataInicio).setDate("dataFinal", dataFinal).setInteger("faltas", 4).setInteger("faltasHoras", 10).list();
    }

    public List apuracaoPontoPorOcorrencia(Date dataInicio, Date dataFinal, EmpresaRh empresaRh, AberturaPeriodo abertura) throws ExceptionService {
        String hql = " from MovPtoColaborador movPonto  where  movPonto.colaborador.empresa = :empresa  and  movPonto.dataOcorrencia between :dataInicio and :dataFinal  and  movPonto.colaborador.ativo = :sim  and  movPonto.tipoOcorrencia.tipoCalculoEvento is not null  and  (movPonto.colaborador.dataDemissao is null or  movPonto.colaborador.dataDemissao > :dataFinal) and  exists (from MovimentoFolha m where m.aberturaPeriodo = :abertura and m.colaborador = movPonto.colaborador )";
        List retorno = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("empresa", (Object)empresaRh.getEmpresa()).setDate("dataInicio", dataInicio).setEntity("abertura", (Object)abertura).setShort("sim", (short)1).setDate("dataFinal", dataFinal).list();
        if (retorno == null || retorno.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<ColaboradorApuracaoPontoFolha> colaboradores = new ArrayList<ColaboradorApuracaoPontoFolha>();
        for (Object obj : retorno) {
            MovPtoColaborador movPonto = (MovPtoColaborador)obj;
            boolean achou = false;
            for (Object e : colaboradores) {
                ColaboradorApuracaoPontoFolha colaboradorApuracao = (ColaboradorApuracaoPontoFolha)e;
                if (!colaboradorApuracao.getColaborador().equals((Object)movPonto.getColaborador())) continue;
                achou = true;
                ResumoDiarioApuracaoPontoColaborador resumoDiarioApuracaoPontoColaborador = new ResumoDiarioApuracaoPontoColaborador();
                resumoDiarioApuracaoPontoColaborador.setColaboradorApuracaoPonto(colaboradorApuracao);
                resumoDiarioApuracaoPontoColaborador.setDataResumo(movPonto.getDataOcorrencia());
                resumoDiarioApuracaoPontoColaborador.setTipoOcorrenciaPonto(movPonto.getTipoOcorrencia());
                resumoDiarioApuracaoPontoColaborador.setTotalHoras(movPonto.getReferencia());
                colaboradorApuracao.getResumoDiario().add(resumoDiarioApuracaoPontoColaborador);
                break;
            }
            if (achou) continue;
            ColaboradorApuracaoPontoFolha newApuracao = new ColaboradorApuracaoPontoFolha();
            newApuracao.setColaborador(movPonto.getColaborador());
            newApuracao.setDiasUteis(this.getDiasUteis(movPonto.getColaborador()));
            ResumoDiarioApuracaoPontoColaborador resumoDiarioApuracaoPontoColaborador = new ResumoDiarioApuracaoPontoColaborador();
            resumoDiarioApuracaoPontoColaborador.setColaboradorApuracaoPonto(newApuracao);
            resumoDiarioApuracaoPontoColaborador.setDataResumo(movPonto.getDataOcorrencia());
            resumoDiarioApuracaoPontoColaborador.setTipoOcorrenciaPonto(movPonto.getTipoOcorrencia());
            resumoDiarioApuracaoPontoColaborador.setTotalHoras(movPonto.getReferencia());
            newApuracao.getResumoDiario().add(resumoDiarioApuracaoPontoColaborador);
            colaboradores.add(newApuracao);
        }
        if (empresaRh.getTpPagamentoAddNoturno() == null) {
            this.criarResumoCompetencia(colaboradores);
            return colaboradores;
        }
        TipoCalculoEvento tp = empresaRh.getTpPagamentoAddNoturno();
        hql = " select distinct evt.colaborador  from EventoColaborador evt  where  evt.colaborador.ativo = :sim  and  (evt.colaborador.dataDemissao is null or evt.colaborador.dataDemissao > :dataFinal) and  evt.colaborador.empresa = :empresa  and  evt.tipoCalculoEvento = :addNoturno  and  evt.dataInicial is not null  and  evt.colaborador.dataAdmissao <= :dataFinal  and  (evt.dataFinal is null or evt.dataFinal > :dataFinal)  and  exists (from MovimentoFolha m where m.aberturaPeriodo = :abertura and m.colaborador = evt.colaborador ) order by evt.colaborador.pessoa.nome ";
        List retornoAddNoturno = CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("sim", (short)1).setEntity("addNoturno", (Object)tp).setEntity("empresa", (Object)empresaRh.getEmpresa()).setEntity("abertura", (Object)abertura).setDate("dataFinal", dataFinal).list();
        if (retornoAddNoturno == null || retornoAddNoturno.isEmpty()) {
            this.criarResumoCompetencia(colaboradores);
            return colaboradores;
        }
        for (Object obj : retornoAddNoturno) {
            Colaborador colaborador = (Colaborador)obj;
            if (colaborador.getNumeroRegistro().equals("7419")) {
                System.out.println("");
            }
            boolean bl = false;
            for (Object e : colaboradores) {
                ColaboradorApuracaoPontoFolha apuracao = (ColaboradorApuracaoPontoFolha)e;
                if (!apuracao.getColaborador().equals((Object)colaborador)) continue;
                bl = true;
                apuracao.setColaborador(colaborador);
                apuracao.setDiasUteis(this.getDiasUteis(colaborador));
                ResumoDiarioApuracaoPontoColaborador resumoDiario3 = new ResumoDiarioApuracaoPontoColaborador();
                resumoDiario3.setColaboradorApuracaoPonto(apuracao);
                resumoDiario3.setDataResumo(dataFinal);
                resumoDiario3.setTipoOcorrenciaPonto(this.getOcorrenciaPontoAddNoturno(tp));
                resumoDiario3.setTotalHoras(this.getReferenciaAddNoturno(colaborador, dataInicio, dataFinal));
                apuracao.getResumoDiario().add(resumoDiario3);
                break;
            }
            if (bl) continue;
            ColaboradorApuracaoPontoFolha newApuracao = new ColaboradorApuracaoPontoFolha();
            newApuracao.setColaborador(colaborador);
            newApuracao.setDiasUteis(this.getDiasUteis(colaborador));
            ResumoDiarioApuracaoPontoColaborador resumoDiarioApuracaoPontoColaborador = new ResumoDiarioApuracaoPontoColaborador();
            resumoDiarioApuracaoPontoColaborador.setColaboradorApuracaoPonto(newApuracao);
            resumoDiarioApuracaoPontoColaborador.setDataResumo(dataFinal);
            resumoDiarioApuracaoPontoColaborador.setTipoOcorrenciaPonto(this.getOcorrenciaPontoAddNoturno(tp));
            resumoDiarioApuracaoPontoColaborador.setTotalHoras(this.getReferenciaAddNoturno(colaborador, dataInicio, dataFinal));
            newApuracao.getResumoDiario().add(resumoDiarioApuracaoPontoColaborador);
            colaboradores.add(newApuracao);
        }
        this.criarResumoCompetencia(colaboradores);
        this.calcularReferenciaAddNoturno(colaboradores, empresaRh);
        return colaboradores;
    }

    private Double getDiasUteis(Colaborador colaborador) {
        return 0.0;
    }

    private TipoOcorrenciaPonto getOcorrenciaPontoAddNoturno(TipoCalculoEvento tp) throws ExceptionService {
        return (TipoOcorrenciaPonto)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOTipoOcorrenciaPonto(), "tipoCalculoEvento", tp, 0);
    }

    private Double getReferenciaAddNoturno(Colaborador colaborador, Date inicioApuracao, Date finalApuracao) throws ExceptionService {
        Double referenciaGeral = 0.0;
        Double diasFerias = 0.0;
        Double diasAfastados = 0.0;
        if (colaborador.getIdentificador() == 482L) {
            System.out.println("");
        }
        if (colaborador.getHorarioTrabalho() == null) {
            return 0.0;
        }
        if (colaborador.getHorarioTrabalho().getEsocCadastroHorario() == null) {
            throw new ExceptionService("Verifique o cadastro do Horario: " + colaborador.getHorarioTrabalho().getIdentificador() + " do colaborador: " + colaborador.toString());
        }
        if (colaborador == null || colaborador.getHorarioTrabalho() == null || colaborador.getHorarioTrabalho().getTurnoDeTrabalho() == null) {
            return 0.0;
        }
        System.err.println(colaborador);
        if (colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)0)) {
            referenciaGeral = this.calcularReferenciaJornadaSemanal(colaborador, inicioApuracao, finalApuracao);
            diasFerias = this.getDiasFerias(colaborador, inicioApuracao, finalApuracao);
            diasAfastados = this.getDiasAfastamentos(colaborador, inicioApuracao, finalApuracao);
        }
        if (colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)1)) {
            referenciaGeral = this.calcularReferenciaJornadaRevezamento(colaborador, inicioApuracao, finalApuracao);
            diasFerias = this.getDiasFerias(colaborador, inicioApuracao, finalApuracao);
            diasAfastados = this.getDiasAfastamentos(colaborador, inicioApuracao, finalApuracao);
        }
        if (colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)2)) {
            referenciaGeral = this.calcularReferenciaJornada1236(colaborador, inicioApuracao, finalApuracao);
            diasFerias = this.getDiasFerias(colaborador, inicioApuracao, finalApuracao);
            diasAfastados = this.getDiasAfastamentos(colaborador, inicioApuracao, finalApuracao);
        }
        return referenciaGeral - diasFerias - diasAfastados;
    }

    private void criarResumoCompetencia(List colaboradores) {
        for (Object obj : colaboradores) {
            ColaboradorApuracaoPontoFolha ap = (ColaboradorApuracaoPontoFolha)obj;
            for (ResumoDiarioApuracaoPontoColaborador resumoDiario : ap.getResumoDiario()) {
                boolean achou = false;
                for (ResumoCompetenciaPontoColaborador resumoComp : ap.getResumoCompetencia()) {
                    if (!resumoDiario.getTipoOcorrenciaPonto().getTipoCalculoEvento().equals((Object)resumoComp.getTipoCalculoEvento())) continue;
                    Double quantidade = resumoDiario.getTotalHoras() + resumoComp.getQuantidade();
                    resumoComp.setQuantidade(quantidade);
                    achou = true;
                    break;
                }
                if (achou) continue;
                ResumoCompetenciaPontoColaborador resumoComp = new ResumoCompetenciaPontoColaborador();
                resumoComp.setColaborador(ap.getColaborador());
                resumoComp.setColaboradorApuracaoPonto(ap);
                resumoComp.setQuantidade(resumoDiario.getTotalHoras());
                resumoComp.setTipoCalculoEvento(resumoDiario.getTipoOcorrenciaPonto().getTipoCalculoEvento());
                ap.getResumoCompetencia().add(resumoComp);
            }
        }
    }

    private Double calcularReferenciaJornadaSemanal(Colaborador colaborador, Date inicioApuracao, Date finalApuracao) throws ExceptionService {
        return this.calculoSemanalSemDiaDiferente(colaborador, inicioApuracao, finalApuracao);
    }

    private Integer getDiaSemanal(Date inicioParametro) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(inicioParametro);
        return g.get(7);
    }

    private Double calcularReferenciaJornada1236(Colaborador colaborador, Date inicioApuracao, Date finalApuracao) {
        Date dataAdmissao;
        Date inicioParametro;
        HorarioTrabalho horario = colaborador.getHorarioTrabalho();
        Date dataProjecao = inicioParametro = (dataAdmissao = colaborador.getDataAdmissao());
        Integer contador = 0;
        boolean menor = true;
        Double referenciaPonto = 0.0;
        referenciaPonto = colaborador.getSindicato() != null && colaborador.getSindicato().getPossuiAdiantamentoSalario().equals((short)1) ? Double.valueOf(1.142) : Double.valueOf(1.0);
        Double horasNoturnas = this.getQuantidadeHorasNoturnasSemanalFixo(colaborador, horario.getEsocCadastroHorario().getInfoHorario().getHorarioInicial(), horario.getEsocCadastroHorario().getInfoHorario().getHorarioFinal()) * referenciaPonto;
        Double intervalo = this.getQuantidadeHorasNoturnasSemanalFixo(colaborador, horario.getEsocCadastroHorario().getInfoHorario().getInicioIntervalo(), horario.getEsocCadastroHorario().getInfoHorario().getFinalIntervalo()) * referenciaPonto;
        horasNoturnas = horasNoturnas - intervalo;
        if (dataAdmissao.before(inicioApuracao)) {
            while (menor = (dataProjecao = DateUtil.nextDays(DateUtil.dataSemHora(dataProjecao), 2)).before(inicioApuracao)) {
            }
        }
        menor = true;
        contador = contador + 1;
        do {
            if ((dataProjecao = DateUtil.nextDays(dataProjecao, 2)).before(finalApuracao)) {
                contador = contador + 1;
                menor = true;
                continue;
            }
            if (dataProjecao.equals(finalApuracao)) {
                contador = contador + 1;
                menor = false;
                continue;
            }
            menor = false;
        } while (menor);
        return ContatoFormatUtil.arrredondarNumero((Double)(contador.doubleValue() * horasNoturnas), (int)2);
    }

    private Double calcularReferenciaJornadaRevezamento(Colaborador colaborador, Date inicioApuracao, Date finalApuracao) {
        Date dataAdmissao;
        HorarioTrabalho horario = colaborador.getHorarioTrabalho();
        Date inicioParametro = dataAdmissao = colaborador.getDataAdmissao();
        Integer contador = 0;
        Integer diasTrabalho = horario.getHorasTrabalhadasRevezamento().intValue();
        Integer diasFolga = horario.getHorasFolgasRevezamento().intValue();
        Integer diasAContar = diasTrabalho + diasFolga;
        boolean menor = true;
        Date dataProjecao = inicioParametro;
        if (dataAdmissao.before(inicioApuracao)) {
            while (menor = (dataProjecao = DateUtil.nextDays(dataProjecao, diasAContar)).before(inicioApuracao)) {
            }
            menor = true;
            if (dataProjecao.equals(inicioApuracao)) {
                contador = contador + 0;
                do {
                    Date dataUltimaProjecao = dataProjecao;
                    if ((dataProjecao = DateUtil.nextDays(dataProjecao, diasAContar)).before(finalApuracao)) {
                        contador = contador + horario.getHorasTrabalhadasRevezamento().intValue();
                        menor = true;
                        continue;
                    }
                    if (dataProjecao.equals(finalApuracao)) {
                        contador = contador + 1;
                        menor = false;
                        continue;
                    }
                    Integer difDias = DateUtil.diferenceDayBetweenDates(dataUltimaProjecao, finalApuracao);
                    if (difDias == diasAContar) {
                        difDias = difDias - 1;
                    }
                    contador = contador + difDias;
                    menor = false;
                } while (menor);
                Double referenciaPonto = 0.0;
                referenciaPonto = colaborador.getSindicato() != null && colaborador.getSindicato().getPossuiAdiantamentoSalario().equals((short)1) ? Double.valueOf(1.142) : Double.valueOf(1.0);
                Double horasNoturnas = this.getQuantidadeHorasNoturnasSemanalFixo(colaborador, horario.getEsocCadastroHorario().getInfoHorario().getHorarioInicial(), horario.getEsocCadastroHorario().getInfoHorario().getHorarioFinal()) * referenciaPonto;
                return ContatoFormatUtil.arrredondarNumero((Double)(horasNoturnas * contador.doubleValue()), (int)2);
            }
            if (dataProjecao.after(inicioApuracao)) {
                contador = 0;
                menor = true;
                Date dataUltimaProjecao = DateUtil.nextDays(dataProjecao, -diasAContar.intValue());
                Integer difDias = DateUtil.diferenceDayBetweenDates(dataUltimaProjecao, inicioApuracao) + 1;
                Integer aux = 0;
                if (difDias == diasAContar) {
                    contador = contador + 0;
                } else {
                    aux = diasAContar - difDias;
                    contador = contador + aux;
                }
                dataProjecao = inicioApuracao;
                dataProjecao = DateUtil.nextDays(dataProjecao, aux - 1);
                do {
                    dataUltimaProjecao = dataProjecao;
                    if ((dataProjecao = DateUtil.nextDays(dataProjecao, diasAContar)).before(finalApuracao)) {
                        contador = contador + diasTrabalho;
                        menor = true;
                        continue;
                    }
                    if (dataProjecao.equals(finalApuracao)) {
                        menor = false;
                        continue;
                    }
                    difDias = DateUtil.diferenceDayBetweenDates(dataUltimaProjecao, finalApuracao);
                    difDias = difDias - diasFolga;
                    contador = contador + difDias;
                    menor = false;
                } while (menor);
                Double referenciaPonto = 0.0;
                referenciaPonto = colaborador.getSindicato() != null && colaborador.getSindicato().getPossuiAdiantamentoSalario().equals((short)1) ? Double.valueOf(1.142) : Double.valueOf(1.0);
                Double horasNoturnas = this.getQuantidadeHorasNoturnasSemanalFixo(colaborador, horario.getEsocCadastroHorario().getInfoHorario().getHorarioInicial(), horario.getEsocCadastroHorario().getInfoHorario().getHorarioFinal()) * referenciaPonto;
                return ContatoFormatUtil.arrredondarNumero((Double)(horasNoturnas * contador.doubleValue()), (int)2);
            }
        } else {
            contador = 0;
            menor = true;
            dataProjecao = dataAdmissao;
            do {
                Date dataUltimaProjecao = dataProjecao;
                if ((dataProjecao = DateUtil.nextDays(dataProjecao, diasAContar)).before(finalApuracao)) {
                    contador = contador + diasTrabalho;
                    menor = true;
                    continue;
                }
                if (dataProjecao.equals(finalApuracao)) {
                    menor = false;
                    continue;
                }
                Integer difDias = DateUtil.diferenceDayBetweenDates(dataUltimaProjecao, finalApuracao) + 1;
                if (difDias == diasAContar) {
                    difDias = difDias - diasFolga;
                    contador = contador + difDias;
                    menor = false;
                    continue;
                }
                contador = contador + difDias;
                menor = false;
            } while (menor);
            Double referenciaPonto = 0.0;
            referenciaPonto = colaborador.getSindicato() != null && colaborador.getSindicato().getPossuiAdiantamentoSalario().equals((short)1) ? Double.valueOf(1.142) : Double.valueOf(1.0);
            Double horasNoturnas = this.getQuantidadeHorasNoturnasSemanalFixo(colaborador, horario.getEsocCadastroHorario().getInfoHorario().getHorarioInicial(), horario.getEsocCadastroHorario().getInfoHorario().getHorarioFinal()) * referenciaPonto;
            return ContatoFormatUtil.arrredondarNumero((Double)(horasNoturnas * contador.doubleValue()), (int)2);
        }
        return 0.0;
    }

    private Double getDiasFerias(Colaborador colaborador, Date inicioApuracao, Date finalApuracao) throws ExceptionService {
        Double diasFerias = 0.0;
        String hql = " from FeriasColaborador ferias  where  ferias.periodoAqFeriasColab.colaborador = :colaborador  and  (ferias.dataGozoInicial between :inicioApuracao and :finalApuracao  or  ferias.dataGozoFinal between :inicioApuracao and :finalApuracao)";
        List aux = new ArrayList();
        aux = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setDate("inicioApuracao", inicioApuracao).setDate("finalApuracao", finalApuracao).list();
        if (aux == null || aux.isEmpty()) {
            return diasFerias;
        }
        for (Object object : aux) {
            FeriasColaborador ferias = (FeriasColaborador)object;
            Date parametroInicial = null;
            Date parametroFinal = null;
            parametroInicial = ferias.getDataGozoInicial().after(inicioApuracao) ? ferias.getDataGozoInicial() : inicioApuracao;
            parametroFinal = ferias.getDataGozoFinal().after(finalApuracao) ? finalApuracao : ferias.getDataGozoFinal();
            System.err.println(colaborador.toString());
            if (colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)0)) {
                diasFerias = this.calcularReferenciaJornadaSemanal(colaborador, parametroInicial, parametroFinal);
            }
            if (colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)1)) {
                diasFerias = this.calcularReferenciaJornadaRevezamento(colaborador, parametroInicial, parametroFinal);
            }
            if (!colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)2)) continue;
            diasFerias = this.calcularReferenciaJornada1236(colaborador, parametroInicial, parametroFinal);
        }
        return diasFerias;
    }

    private Double getDiasAfastamentos(Colaborador colaborador, Date inicioApuracao, Date finalApuracao) throws ExceptionService {
        Double diasAfastamento = 0.0;
        List aux = new ArrayList();
        String hql = " from AfastamentoColaborador af  where  af.dataAfastamento != null  and  af.colaborador = :colaborador  and  (af.dataAfastamento between :inicioApuracao and :finalApuracao  or  (af.dataRetorno is not null   and   af.dataRetorno between :inicioApuracao and :finalApuracao)) ";
        aux = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setDate("inicioApuracao", inicioApuracao).setDate("finalApuracao", finalApuracao).list();
        if (aux == null || aux.isEmpty()) {
            return diasAfastamento;
        }
        for (Object obj : aux) {
            AfastamentoColaborador af = (AfastamentoColaborador)obj;
            Date parametroInicial = null;
            Date parametroFinal = null;
            parametroInicial = af.getDataAfastamento().after(inicioApuracao) ? af.getDataAfastamento() : inicioApuracao;
            parametroFinal = af.getDataRetorno() == null ? finalApuracao : (af.getDataRetorno().after(finalApuracao) ? finalApuracao : DateUtil.nextDays(af.getDataRetorno(), -1));
            System.err.println(colaborador.toString());
            if (colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)0)) {
                diasAfastamento = this.calcularReferenciaJornadaSemanal(colaborador, parametroInicial, parametroFinal);
            }
            if (colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)1)) {
                diasAfastamento = this.calcularReferenciaJornadaRevezamento(colaborador, parametroInicial, parametroFinal);
            }
            if (!colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)2)) continue;
            diasAfastamento = this.calcularReferenciaJornada1236(colaborador, parametroInicial, parametroFinal);
        }
        return diasAfastamento;
    }

    private void calcularReferenciaAddNoturno(List colaboradores, EmpresaRh empresaRh) throws ExceptionService {
        Double referenciaFaltas = 0.0;
        Double referenciaAtestado = 0.0;
        for (Object obj : colaboradores) {
            ColaboradorApuracaoPontoFolha ap = (ColaboradorApuracaoPontoFolha)obj;
            referenciaFaltas = 0.0;
            referenciaAtestado = 0.0;
            System.out.println(ap.getColaborador());
            for (ResumoDiarioApuracaoPontoColaborador resumoDiario : ap.getResumoDiario()) {
                if (resumoDiario.getTipoOcorrenciaPonto().getTipoCalculoEvento().equals((Object)empresaRh.getTpFaltas())) {
                    referenciaFaltas = referenciaFaltas + this.getReferenciaAddNoturno(ap.getColaborador(), resumoDiario.getDataResumo(), resumoDiario.getDataResumo());
                    continue;
                }
                if (!resumoDiario.getTipoOcorrenciaPonto().getTipoCalculoEvento().equals((Object)empresaRh.getTipoCalculoAtestado())) continue;
                referenciaAtestado = referenciaAtestado + this.getReferenciaAddNoturno(ap.getColaborador(), resumoDiario.getDataResumo(), resumoDiario.getDataResumo());
            }
            ap.getColaborador();
            for (ResumoCompetenciaPontoColaborador resumoComp : ap.getResumoCompetencia()) {
                if (!resumoComp.getTipoCalculoEvento().equals((Object)empresaRh.getTpPagamentoAddNoturno())) continue;
                resumoComp.setQuantidade(Double.valueOf(resumoComp.getQuantidade() - referenciaFaltas - referenciaAtestado));
            }
        }
    }

    private boolean diaNaoFeriado(Date inicioParametro, Long idEmpresa) throws ExceptionService {
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("periodoInicial", inicioParametro);
        request.setAttribute("periodoFinal", inicioParametro);
        request.setAttribute("idEmpresa", idEmpresa);
        List retorno = (List)CoreServiceFactory.getServiceFeriado().execute(request, "findFeriadoPorPeriodo");
        return retorno == null || retorno.isEmpty();
    }

    private Double getQuantidadeHorasNoturnasSemanalFixo(Colaborador colaborador, Date horaInicioInf, Date horaFinalInf) {
        GregorianCalendar inicioHorario = new GregorianCalendar();
        inicioHorario.setTime(horaInicioInf);
        GregorianCalendar finalHorario = new GregorianCalendar();
        finalHorario.setTime(horaFinalInf);
        GregorianCalendar inicioNoturno = new GregorianCalendar();
        inicioNoturno.set(11, 22);
        GregorianCalendar finalNoturno = new GregorianCalendar();
        finalNoturno.set(11, 5);
        Integer horaInicio = inicioHorario.get(11);
        Integer horaFinal = finalHorario.get(11);
        Integer inicioContagem = 22;
        Integer finalContagem = 5;
        if (horaFinal == 0 || horaFinal < horaInicio) {
            finalNoturno.add(6, 1);
            if (horaInicio > inicioContagem) {
                inicioNoturno.set(11, horaInicio);
            }
            if (horaFinal < finalContagem) {
                finalNoturno.set(11, horaFinal);
            }
            return DateUtil.calcularDifHoras(inicioNoturno.getTime(), finalNoturno.getTime());
        }
        if (horaFinal <= 22) {
            if (horaInicio >= 5 && horaFinal < 22) {
                return 0.0;
            }
            if (horaFinal == 22) {
                inicioNoturno.set(12, 0);
                finalNoturno.set(11, finalHorario.get(11));
                finalNoturno.set(12, finalHorario.get(12));
                return DateUtil.calcularDifHoras(inicioNoturno.getTime(), finalNoturno.getTime());
            }
            inicioNoturno.set(11, horaInicio);
            if (horaFinal < 5) {
                finalNoturno.set(11, horaFinal);
            }
            return DateUtil.calcularDifHoras(inicioNoturno.getTime(), finalNoturno.getTime());
        }
        if (horaInicio > inicioContagem) {
            inicioNoturno.set(11, horaInicio);
        }
        if (horaFinal < finalContagem || horaFinal == 23) {
            finalNoturno.set(11, horaFinal);
        }
        return DateUtil.calcularDifHoras(inicioNoturno.getTime(), finalNoturno.getTime());
    }

    private Double calculoSemanalSemDiaDiferente(Colaborador colaborador, Date inicioApuracao, Date finalApuracao) throws ExceptionService {
        HorarioTrabalho horario = colaborador.getHorarioTrabalho();
        Double quantidadeHorasNoturnas = 0.0;
        Date inicioParametro = null;
        inicioParametro = colaborador.getDataAdmissao().after(inicioApuracao) ? colaborador.getDataAdmissao() : inicioApuracao;
        do {
            Integer diaParametro = this.getDiaSemanal(inicioParametro);
            if (!this.diaNaoFeriado(inicioParametro, colaborador.getEmpresa().getIdentificador())) continue;
            for (InfoHorarioTrabalho dia : horario.getEsocCadastroHorario().getListaHorario()) {
                if (!dia.getDiaSemana().getDia().equals(diaParametro.shortValue()) || !dia.getFolga().equals((short)0)) continue;
                Double referenciaPonto = 0.0;
                referenciaPonto = colaborador.getSindicato() != null && colaborador.getSindicato().getPossuiAdiantamentoSalario().equals((short)1) ? Double.valueOf(1.142) : Double.valueOf(1.0);
                quantidadeHorasNoturnas = quantidadeHorasNoturnas + this.getQuantidadeHorasNoturnasSemanalFixo(colaborador, dia.getHorarioInicial(), dia.getHorarioFinal()) * referenciaPonto;
            }
        } while (finalApuracao.after(inicioParametro = DateUtil.nextDays(inicioParametro, 1)) || finalApuracao.equals(inicioParametro));
        return ContatoFormatUtil.arrredondarNumero((Double)quantidadeHorasNoturnas, (int)2);
    }
}

