/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.apuracaoponto.fechamentoponto;

import com.touchcomp.basementor.model.vo.AberturaPeriodo;
import com.touchcomp.basementor.model.vo.ApuracaoPontoFolhaPagamento;
import com.touchcomp.basementor.model.vo.CalculoInssAberturaPeriodo;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.FechamentoPontoFolha;
import com.touchcomp.basementor.model.vo.ItemFechamentoPontoFolha;
import com.touchcomp.basementor.model.vo.ItemMovimentoFolha;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import java.util.ArrayList;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.rh.apuracaoponto.fechamentoponto.UtilityRateioPontoComIntegracao;
import mentorcore.service.impl.rh.apuracaoponto.fechamentoponto.UtilityRateioPontoSemIntegracao;
import mentorcore.service.impl.rh.apuracaoponto.fechamentoponto.UtilityRateioValoresImpostoFolha;
import mentorcore.service.impl.rh.apuracaoponto.rateiofolha.UtilityValidacaoRateioImpostoFolha;

public class UtilityFechamentoPonto {
    public List<ItemFechamentoPontoFolha> getItensFechamentoPonto(EmpresaRh empresaRh, FechamentoPontoFolha fechamento) throws ExceptionService {
        if (empresaRh.getValidarAlocacaoTomador().equals((short)0) && empresaRh.getCentroCustoPadrao() == null) {
            throw new ExceptionService("Primeiro, cadastre um Centro de Custo na Empresa RH");
        }
        ArrayList<ItemFechamentoPontoFolha> retorno = new ArrayList<ItemFechamentoPontoFolha>();
        for (CalculoInssAberturaPeriodo ab : fechamento.getFechamentoPeriodo().getCalculoInss().getAberturasPeriodo()) {
            for (MovimentoFolha mov : ab.getAberturaPeriodo().getMovimentoFolha()) {
                if (empresaRh.getValidarAlocacaoTomador().equals((short)1)) {
                    new UtilityValidacaoRateioImpostoFolha().validarAlocacaoColaboradores(fechamento);
                }
                List<ApuracaoPontoFolhaPagamento> apuracoes = this.getIntegracoesPorColaborador(mov.getColaborador(), mov.getAberturaPeriodo());
                for (ItemMovimentoFolha itemFolha : mov.getItensMovimentoFolha()) {
                    if (itemFolha.getItensPontoFolha().isEmpty()) {
                        new UtilityRateioPontoSemIntegracao().rateioPontoSemIntegracao(apuracoes, retorno, itemFolha, empresaRh.getCentroCustoPadrao(), fechamento);
                        continue;
                    }
                    if (itemFolha.getItensPontoFolha().isEmpty()) continue;
                    new UtilityRateioPontoComIntegracao().rateioPontoComIntegracao(apuracoes, retorno, itemFolha, empresaRh.getCentroCustoPadrao(), fechamento);
                }
                new UtilityRateioValoresImpostoFolha().ratearImpostoFolhaPagamento(retorno, fechamento, mov, empresaRh, apuracoes);
            }
        }
        return retorno;
    }

    private List<ApuracaoPontoFolhaPagamento> getIntegracoesPorColaborador(Colaborador colaborador, AberturaPeriodo abertura) {
        ArrayList<ApuracaoPontoFolhaPagamento> integracoes = new ArrayList();
        String hql = " select distinct apuracao  from ApuracaoPontoFolhaPagamento apuracao  inner join apuracao.apuracaoPontoColaborador ap  where  apuracao.aberturaPeriodo = :abertura  and  ap.colaborador = :colaborador ";
        integracoes = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setEntity("abertura", (Object)abertura).list();
        return integracoes;
    }
}

