/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.apuracaoponto.fechamentoponto;

import com.touchcomp.basementor.model.vo.ApuracaoPontoFolhaPagamento;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.FechamentoPontoFolha;
import com.touchcomp.basementor.model.vo.ItemFechamentoPontoFolha;
import com.touchcomp.basementor.model.vo.ItemIntegracaoPontoFolha;
import com.touchcomp.basementor.model.vo.ItemMovimentoFolha;
import contatocore.util.ContatoFormatUtil;
import java.util.List;

public class UtilityRateioPontoComIntegracao {
    public void rateioPontoComIntegracao(List<ApuracaoPontoFolhaPagamento> apuracoes, List<ItemFechamentoPontoFolha> retorno, ItemMovimentoFolha itemFolha, CentroCusto centroCusto, FechamentoPontoFolha fechamento) {
        Double totalReferencia = 0.0;
        Double totalValor = 0.0;
        for (ItemIntegracaoPontoFolha itemIntegracao : itemFolha.getItensPontoFolha()) {
            totalReferencia = totalReferencia + itemIntegracao.getReferenciaRateio();
            totalValor = totalValor + itemIntegracao.getValorRateio();
            ItemFechamentoPontoFolha itemFech = new ItemFechamentoPontoFolha();
            itemFech.setCentroCusto(itemIntegracao.getCentroCusto());
            itemFech.setColaborador(itemFolha.getMovimentoFolha().getColaborador());
            itemFech.setReferencia(itemIntegracao.getReferenciaRateio());
            itemFech.setValor(itemIntegracao.getValorRateio());
            itemFech.setTpCalculoEvento(itemFolha.getEventoColaborador().getTipoCalculoEvento());
            retorno.add(itemFech);
        }
        totalReferencia = ContatoFormatUtil.arrredondarNumero((Double)totalReferencia, (int)2);
        if ((totalValor = ContatoFormatUtil.arrredondarNumero((Double)totalValor, (int)2)) < itemFolha.getValor()) {
            totalReferencia = itemFolha.getReferencia() - totalReferencia;
            totalValor = itemFolha.getValor() - totalValor;
            ItemFechamentoPontoFolha itemFech = new ItemFechamentoPontoFolha();
            itemFech.setCentroCusto(centroCusto);
            itemFech.setColaborador(itemFolha.getMovimentoFolha().getColaborador());
            itemFech.setReferencia(totalReferencia);
            itemFech.setValor(totalValor);
            if (itemFech.getValor() > 0.0) {
                retorno.add(itemFech);
            }
        }
    }
}

