/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.apuracaoponto.fechamentoponto;

import com.touchcomp.basementor.model.vo.ApuracaoPontoFolhaPagamento;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.FechamentoPontoFolha;
import com.touchcomp.basementor.model.vo.ItemFechamentoPontoFolha;
import com.touchcomp.basementor.model.vo.ItemMovimentoFolha;
import contatocore.util.ContatoFormatUtil;
import java.util.List;
import mentorcore.tools.DateUtil;

public class UtilityRateioPontoSemIntegracao {
    public void rateioPontoSemIntegracao(List<ApuracaoPontoFolhaPagamento> apuracoes, List<ItemFechamentoPontoFolha> retorno, ItemMovimentoFolha itemFolha, CentroCusto centroCusto, FechamentoPontoFolha fechamento) {
        Integer diaFinalAbertura = DateUtil.diferenceDayBetweenDates(fechamento.getDataInicial(), fechamento.getDataFinal()) + 1;
        Integer totalDias = 0;
        for (ApuracaoPontoFolhaPagamento apuracao : apuracoes) {
            Integer diasApuracao = DateUtil.diferenceDayBetweenDates(apuracao.getDataInicio(), apuracao.getDataFinal()) + 1;
            totalDias = totalDias + diasApuracao;
            ItemFechamentoPontoFolha itemFech = new ItemFechamentoPontoFolha();
            itemFech.setCentroCusto(apuracao.getCentroCusto());
            itemFech.setColaborador(itemFolha.getMovimentoFolha().getColaborador());
            itemFech.setTpCalculoEvento(itemFolha.getEventoColaborador().getTipoCalculoEvento());
            itemFech.setReferencia(ContatoFormatUtil.arrredondarNumero((Double)(itemFolha.getReferencia() * new Double(diasApuracao.intValue()) / new Double(diaFinalAbertura.intValue())), (int)2));
            itemFech.setValor(ContatoFormatUtil.arrredondarNumero((Double)(itemFolha.getValor() * new Double(diasApuracao.intValue()) / new Double(diaFinalAbertura.intValue())), (int)2));
            retorno.add(itemFech);
        }
        if (totalDias <= diaFinalAbertura) {
            totalDias = diaFinalAbertura - totalDias;
            ItemFechamentoPontoFolha itemFech = new ItemFechamentoPontoFolha();
            itemFech.setCentroCusto(centroCusto);
            itemFech.setColaborador(itemFolha.getMovimentoFolha().getColaborador());
            itemFech.setTpCalculoEvento(itemFolha.getEventoColaborador().getTipoCalculoEvento());
            itemFech.setReferencia(ContatoFormatUtil.arrredondarNumero((Double)(itemFolha.getReferencia() / diaFinalAbertura.doubleValue() * totalDias.doubleValue()), (int)2));
            itemFech.setValor(ContatoFormatUtil.arrredondarNumero((Double)(itemFolha.getValor() / diaFinalAbertura.doubleValue() * totalDias.doubleValue()), (int)2));
            if (itemFech.getValor() > 0.0) {
                retorno.add(itemFech);
            }
        }
    }
}

