/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.apuracaoponto.fechamentoponto;

import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.ApuracaoPontoFolhaPagamento;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.FechamentoPontoFolha;
import com.touchcomp.basementor.model.vo.ItemFechamentoPontoFolha;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import contatocore.util.ContatoFormatUtil;
import java.util.Date;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.tools.DateUtil;

public class UtilityRateioValoresImpostoFolha {
    public void ratearImpostoFolhaPagamento(List<ItemFechamentoPontoFolha> retorno, FechamentoPontoFolha fechamento, MovimentoFolha movFolha, EmpresaRh empresaRh, List<ApuracaoPontoFolhaPagamento> apuracoes) throws ExceptionService {
        ItemFechamentoPontoFolha itemFech;
        Object diasApuracao;
        ItemFechamentoPontoFolha itemFech2;
        Integer diasApuracao2;
        Double valor;
        Integer diaFinalAbertura = DateUtil.diferenceDayBetweenDates(fechamento.getDataInicial(), fechamento.getDataFinal()) + 1;
        Integer totalDias = 0;
        if (movFolha.getVrFgts13Sal() + movFolha.getVrFgtsFerias() + movFolha.getVrFgtsSalario() > 0.0) {
            if (empresaRh.getTpFgts() == null) {
                throw new ExceptionService("Primeiro, informe o Evento de FGTS na Empresa RH");
            }
            valor = movFolha.getVrFgts13Sal() + movFolha.getVrFgtsFerias() + movFolha.getVrFgtsSalario();
            for (ApuracaoPontoFolhaPagamento apuracao : apuracoes) {
                diasApuracao2 = DateUtil.diferenceDayBetweenDates(apuracao.getDataInicio(), apuracao.getDataFinal()) + 1;
                totalDias = totalDias + diasApuracao2;
                itemFech2 = new ItemFechamentoPontoFolha();
                itemFech2.setCentroCusto(apuracao.getCentroCusto());
                itemFech2.setColaborador(movFolha.getColaborador());
                itemFech2.setTpCalculoEvento(empresaRh.getTpFgts());
                itemFech2.setReferencia(Double.valueOf(1.0));
                itemFech2.setValor(ContatoFormatUtil.arrredondarNumero((Double)(valor * new Double(diasApuracao2.intValue()) / new Double(diaFinalAbertura.intValue())), (int)2));
                retorno.add(itemFech2);
            }
            if (totalDias < diaFinalAbertura) {
                diasApuracao = diaFinalAbertura - totalDias;
                itemFech = new ItemFechamentoPontoFolha();
                itemFech.setCentroCusto(empresaRh.getCentroCustoPadrao());
                itemFech.setColaborador(movFolha.getColaborador());
                itemFech.setTpCalculoEvento(empresaRh.getTpFgts());
                itemFech.setReferencia(Double.valueOf(1.0));
                itemFech.setValor(ContatoFormatUtil.arrredondarNumero((Double)(valor * new Double(((Integer)diasApuracao).intValue()) / new Double(diaFinalAbertura.intValue())), (int)2));
                retorno.add(itemFech);
            }
        }
        if (movFolha.getVrInss13Sal() + movFolha.getVrInssFerias() + movFolha.getVrInssSalario() > 0.0) {
            if (empresaRh.getTpInss() == null) {
                throw new ExceptionService("Primeiro, informe o Evento de INSS na Empresa RH");
            }
            valor = movFolha.getVrInss13Sal() + movFolha.getVrInssFerias() + movFolha.getVrInssSalario();
            for (ApuracaoPontoFolhaPagamento apuracao : apuracoes) {
                diasApuracao2 = DateUtil.diferenceDayBetweenDates(apuracao.getDataInicio(), apuracao.getDataFinal()) + 1;
                totalDias = totalDias + diasApuracao2;
                itemFech2 = new ItemFechamentoPontoFolha();
                itemFech2.setCentroCusto(apuracao.getCentroCusto());
                itemFech2.setColaborador(movFolha.getColaborador());
                itemFech2.setTpCalculoEvento(empresaRh.getTpInss());
                itemFech2.setReferencia(Double.valueOf(1.0));
                itemFech2.setValor(ContatoFormatUtil.arrredondarNumero((Double)(valor * new Double(diasApuracao2.intValue()) / new Double(diaFinalAbertura.intValue())), (int)2));
                retorno.add(itemFech2);
            }
            if (totalDias < diaFinalAbertura) {
                diasApuracao = diaFinalAbertura - totalDias;
                itemFech = new ItemFechamentoPontoFolha();
                itemFech.setCentroCusto(empresaRh.getCentroCustoPadrao());
                itemFech.setColaborador(movFolha.getColaborador());
                itemFech.setTpCalculoEvento(empresaRh.getTpInss());
                itemFech.setReferencia(Double.valueOf(1.0));
                itemFech.setValor(ContatoFormatUtil.arrredondarNumero((Double)(valor * new Double(((Integer)diasApuracao).intValue()) / new Double(diaFinalAbertura.intValue())), (int)2));
                retorno.add(itemFech);
            }
        }
        if (movFolha.getVrIrrf13Sal() + movFolha.getVrIrrfFerias() + movFolha.getVrIrrfSalario() > 0.0) {
            if (empresaRh.getTpIrrf() == null) {
                throw new ExceptionService("Primeiro, informe o Evento de IRRF na Empresa RH");
            }
            valor = movFolha.getVrIrrf13Sal() + movFolha.getVrIrrfFerias() + movFolha.getVrIrrfSalario();
            for (ApuracaoPontoFolhaPagamento apuracao : apuracoes) {
                diasApuracao2 = DateUtil.diferenceDayBetweenDates(apuracao.getDataInicio(), apuracao.getDataFinal()) + 1;
                totalDias = totalDias + diasApuracao2;
                itemFech2 = new ItemFechamentoPontoFolha();
                itemFech2.setCentroCusto(apuracao.getCentroCusto());
                itemFech2.setColaborador(movFolha.getColaborador());
                itemFech2.setTpCalculoEvento(empresaRh.getTpIrrf());
                itemFech2.setReferencia(Double.valueOf(1.0));
                itemFech2.setValor(ContatoFormatUtil.arrredondarNumero((Double)(valor * new Double(diasApuracao2.intValue()) / new Double(diaFinalAbertura.intValue())), (int)2));
                retorno.add(itemFech2);
            }
            if (totalDias < diaFinalAbertura) {
                diasApuracao = diaFinalAbertura - totalDias;
                itemFech = new ItemFechamentoPontoFolha();
                itemFech.setCentroCusto(empresaRh.getCentroCustoPadrao());
                itemFech.setColaborador(movFolha.getColaborador());
                itemFech.setTpCalculoEvento(empresaRh.getTpIrrf());
                itemFech.setReferencia(Double.valueOf(1.0));
                itemFech.setValor(ContatoFormatUtil.arrredondarNumero((Double)(valor * new Double(((Integer)diasApuracao).intValue()) / new Double(diaFinalAbertura.intValue())), (int)2));
                retorno.add(itemFech);
            }
        }
        if (!movFolha.getStatusFolha().getCodigo().equals(EnumConstTipoCalculoEvento.CALCULO_RESCISAO.getValue())) {
            if (this.existeProvisaoFerias(movFolha.getColaborador(), movFolha.getAberturaPeriodo().getDataFinal())) {
                if (empresaRh.getTpProvisaoFerias() == null) {
                    throw new ExceptionService("Primeiro, informe o Evento de Provis\u00e3o de Ferias na Empresa RH");
                }
                valor = this.findValorProvisaoFerias(movFolha.getColaborador(), movFolha.getAberturaPeriodo().getDataFinal());
                for (ApuracaoPontoFolhaPagamento apuracao : apuracoes) {
                    diasApuracao2 = DateUtil.diferenceDayBetweenDates(apuracao.getDataInicio(), apuracao.getDataFinal()) + 1;
                    totalDias = totalDias + diasApuracao2;
                    itemFech2 = new ItemFechamentoPontoFolha();
                    itemFech2.setCentroCusto(apuracao.getCentroCusto());
                    itemFech2.setColaborador(movFolha.getColaborador());
                    itemFech2.setTpCalculoEvento(empresaRh.getTpProvisaoFerias());
                    itemFech2.setReferencia(Double.valueOf(1.0));
                    itemFech2.setValor(ContatoFormatUtil.arrredondarNumero((Double)(valor * new Double(diasApuracao2.intValue()) / new Double(diaFinalAbertura.intValue())), (int)2));
                    retorno.add(itemFech2);
                }
                if (totalDias < diaFinalAbertura) {
                    diasApuracao = diaFinalAbertura - totalDias;
                    itemFech = new ItemFechamentoPontoFolha();
                    itemFech.setCentroCusto(empresaRh.getCentroCustoPadrao());
                    itemFech.setColaborador(movFolha.getColaborador());
                    itemFech.setTpCalculoEvento(empresaRh.getTpProvisaoFerias());
                    itemFech.setReferencia(Double.valueOf(1.0));
                    itemFech.setValor(ContatoFormatUtil.arrredondarNumero((Double)(valor * new Double(((Integer)diasApuracao).intValue()) / new Double(diaFinalAbertura.intValue())), (int)2));
                    retorno.add(itemFech);
                }
            }
            if (this.existeProvisaoDec(movFolha.getColaborador(), movFolha.getAberturaPeriodo().getDataFinal())) {
                if (empresaRh.getTpProvisaoDec() == null) {
                    throw new ExceptionService("Primeiro, informe o Evento de Provis\u00e3o de Decimo Terceiro na Empresa RH");
                }
                valor = this.findValorProvisaoDec(movFolha.getColaborador(), movFolha.getAberturaPeriodo().getDataFinal());
                for (ApuracaoPontoFolhaPagamento apuracao : apuracoes) {
                    diasApuracao2 = DateUtil.diferenceDayBetweenDates(apuracao.getDataInicio(), apuracao.getDataFinal()) + 1;
                    totalDias = totalDias + diasApuracao2;
                    itemFech2 = new ItemFechamentoPontoFolha();
                    itemFech2.setCentroCusto(apuracao.getCentroCusto());
                    itemFech2.setColaborador(movFolha.getColaborador());
                    itemFech2.setTpCalculoEvento(empresaRh.getTpProvisaoDec());
                    itemFech2.setReferencia(Double.valueOf(1.0));
                    itemFech2.setValor(ContatoFormatUtil.arrredondarNumero((Double)(valor * new Double(diasApuracao2.intValue()) / new Double(diaFinalAbertura.intValue())), (int)2));
                    retorno.add(itemFech2);
                }
                if (totalDias < diaFinalAbertura) {
                    diasApuracao = diaFinalAbertura - totalDias;
                    itemFech = new ItemFechamentoPontoFolha();
                    itemFech.setCentroCusto(empresaRh.getCentroCustoPadrao());
                    itemFech.setColaborador(movFolha.getColaborador());
                    itemFech.setTpCalculoEvento(empresaRh.getTpProvisaoDec());
                    itemFech.setReferencia(Double.valueOf(1.0));
                    itemFech.setValor(ContatoFormatUtil.arrredondarNumero((Double)(valor * new Double(((Integer)diasApuracao).intValue()) / new Double(diaFinalAbertura.intValue())), (int)2));
                    retorno.add(itemFech);
                }
            }
        }
    }

    private boolean existeProvisaoFerias(Colaborador colaborador, Date dataFinal) throws ExceptionService {
        String hql = " select coalesce(count(i.identificador),0)  from ProvisaoFerias i  where  i.periodo = :periodo ";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("periodo", dataFinal).uniqueResult();
        if (ret != null && ret > 0L) {
            return true;
        }
        throw new ExceptionService("Primeiro, calcule a Provis\u00e3o de Ferias: " + colaborador.toString());
    }

    private Double findValorProvisaoFerias(Colaborador colaborador, Date periodo) {
        String hql = " select coalesce(sum(i.valorMensal),0)  from ItemProvisaoFerias i  where  i.colaborador = :colaborador  and  i.provisao.periodo = :periodo ";
        return (Double)CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setDate("periodo", periodo).uniqueResult();
    }

    private boolean existeProvisaoDec(Colaborador colaborador, Date dataFinal) throws ExceptionService {
        String hql = " select coalesce(count(i.identificador),0)  from ProvisaoDec i  where  i.periodo = :periodo ";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("periodo", dataFinal).uniqueResult();
        if (ret != null && ret > 0L) {
            return true;
        }
        throw new ExceptionService("Primeiro, calcule a Provis\u00e3o de Decimo Terceiro: " + colaborador.toString());
    }

    private Double findValorProvisaoDec(Colaborador colaborador, Date periodo) {
        String hql = " select coalesce(sum(i.valorMensal),0)  from ItemProvisaoDec i  where  i.colaborador = :colaborador  and  i.provisao.periodo = :periodo ";
        return (Double)CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setDate("periodo", periodo).uniqueResult();
    }
}

