/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.apuracaoponto.leituraplanilha;

import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoMedias;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.EventoColaborador;
import com.touchcomp.basementor.model.vo.ItemIntegracaoPontoFolha;
import com.touchcomp.basementor.model.vo.ItemMovimentoFolha;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.ResumoCompetenciaPontoColaborador;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import java.util.HashMap;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;

public class UtilityGeracaoLancamentos {
    public void criarLancamentosImportados(MovimentoFolha mov, HashMap hashMap, EmpresaRh empresaRh) throws ExceptionService {
        boolean achou = false;
        HashMap hh = hashMap;
        Long codigoEvento = (Long)hh.get("CODIGO_EVENTO");
        Short tipo = (Short)hh.get("TIPO");
        Double valorReferencia = (Double)hh.get("VALOR_REFERENCIA");
        CentroCusto centroCusto = (CentroCusto)hh.get("CENTRO_CUSTO");
        ResumoCompetenciaPontoColaborador resumoCompetencia = (ResumoCompetenciaPontoColaborador)hh.get("RESUMO_COMPETENCIA");
        if (valorReferencia > 0.0) {
            for (ItemMovimentoFolha item : mov.getItensMovimentoFolha()) {
                if (!item.getEventoColaborador().getTipoCalculoEvento().getEvento().getCodigo().equals(codigoEvento)) continue;
                achou = true;
                if (tipo.equals(EnumConstEventoMedias.MEDIA_REFERENCIA.getValue())) {
                    item.setInformarReferencia(Short.valueOf((short)1));
                    item.setReferencia(valorReferencia);
                    this.verificarEventosFaltasAtestado(mov, item.getEventoColaborador().getTipoCalculoEvento(), empresaRh, item.getReferencia());
                } else {
                    item.setInformarValor(Short.valueOf((short)1));
                    item.setValor(valorReferencia);
                }
                this.getItensIntegrao(item, mov.getCentroCusto(), resumoCompetencia);
            }
            if (!achou) {
                ItemMovimentoFolha item;
                EventoColaborador evt = this.createEventoColaborador(codigoEvento, mov);
                item = this.createItemMovimentoFolha(mov, evt, tipo, valorReferencia);
                this.verificarEventosFaltasAtestado(mov, item.getEventoColaborador().getTipoCalculoEvento(), empresaRh, item.getReferencia());
                this.getItensIntegrao(item, mov.getCentroCusto(), resumoCompetencia);
                mov.getItensMovimentoFolha().add(item);
            }
            achou = false;
        }
    }

    private EventoColaborador createEventoColaborador(Long codigoEvento, MovimentoFolha mov) {
        EventoColaborador evento = new EventoColaborador();
        TipoCalculoEvento tipoCalculoEvento = this.getTipoCalculoEvento(codigoEvento);
        evento.setTipoCalculoEvento(tipoCalculoEvento);
        evento.setColaborador(mov.getColaborador());
        evento.setDataInicial(mov.getAberturaPeriodo().getDataInicio());
        evento.setDataFinal(mov.getAberturaPeriodo().getDataFinal());
        evento.setTipoOcorrencia(Short.valueOf((short)2));
        evento.setEventoFixo(Short.valueOf((short)0));
        evento.setValor(Double.valueOf(0.0));
        return evento;
    }

    private TipoCalculoEvento getTipoCalculoEvento(Long codigoEvento) {
        String hql = " select t  from TipoCalculoEvento t  where  t.evento.codigo = :codEvento ";
        return (TipoCalculoEvento)CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("codEvento", codigoEvento.longValue()).uniqueResult();
    }

    private ItemMovimentoFolha createItemMovimentoFolha(MovimentoFolha vo, EventoColaborador ev, Short tipo, Double valorReferencia) {
        ItemMovimentoFolha i = new ItemMovimentoFolha();
        i.setMovimentoFolha(vo);
        i.setValor(Double.valueOf(0.0));
        i.setReferencia(Double.valueOf(0.0));
        i.setEventoColaborador(ev);
        i.setGeraFeriDecRec(EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue());
        if (tipo.equals(EnumConstEventoMedias.MEDIA_REFERENCIA.getValue())) {
            i.setInformarReferencia(Short.valueOf((short)1));
            i.setReferencia(valorReferencia);
        } else {
            i.setInformarValor(Short.valueOf((short)1));
            i.setValor(valorReferencia);
        }
        return i;
    }

    private void verificarEventosFaltasAtestado(MovimentoFolha mov, TipoCalculoEvento tipoCalculoEvento, EmpresaRh empresaRh, Double valor) {
        if (empresaRh.getTipoCalculoAtestado() != null && empresaRh.getTipoCalculoAtestado().equals((Object)tipoCalculoEvento)) {
            mov.setInformarAtestadoManual(Short.valueOf((short)1));
            mov.setDiasAtestado(valor);
        }
        if (empresaRh.getTpAtestadoHoras() != null && empresaRh.getTpAtestadoHoras().equals((Object)tipoCalculoEvento)) {
            mov.setInformarAtestadoManual(Short.valueOf((short)1));
            mov.setHorasAtestado(valor);
        }
        if (empresaRh.getTpFaltaHoras() != null && empresaRh.getTpFaltaHoras().equals((Object)tipoCalculoEvento)) {
            mov.setHorasFaltas(valor);
        }
        if (empresaRh.getTpFaltas() != null && empresaRh.getTpFaltas().equals((Object)tipoCalculoEvento)) {
            mov.setDiasFaltosos(valor);
        }
    }

    private void getItensIntegrao(ItemMovimentoFolha item, CentroCusto centroCusto, ResumoCompetenciaPontoColaborador resumoCompetencia) {
        if (centroCusto != null) {
            boolean achou = false;
            for (ItemIntegracaoPontoFolha itemIntegracao : item.getItensPontoFolha()) {
                if (!itemIntegracao.getCentroCusto().equals((Object)centroCusto) || !item.getEventoColaborador().getTipoCalculoEvento().equals((Object)resumoCompetencia.getTipoCalculoEvento())) continue;
                achou = true;
                itemIntegracao.setReferenciaRateio(Double.valueOf(itemIntegracao.getValorRateio() + item.getReferencia()));
                break;
            }
            if (!achou) {
                ItemIntegracaoPontoFolha i = new ItemIntegracaoPontoFolha();
                i.setCentroCusto(centroCusto);
                i.setResumoCompetencia(resumoCompetencia);
                i.setReferenciaRateio(resumoCompetencia.getQuantidade());
                i.setItemFolha(item);
                item.getItensPontoFolha().add(i);
            }
        }
    }

    public void importarEventosConvencao(MovimentoFolha movimentoFolha, TipoCalculoEvento tpEvento, Double valor) {
        boolean achou = false;
        for (ItemMovimentoFolha item : movimentoFolha.getItensMovimentoFolha()) {
            if (!item.getEventoColaborador().getTipoCalculoEvento().equals((Object)tpEvento)) continue;
            achou = true;
            item.setInformarValor(Short.valueOf((short)1));
            item.setValor(valor);
            break;
        }
        if (!achou) {
            ItemMovimentoFolha item;
            EventoColaborador evt = this.createEventoColaborador(tpEvento.getEvento().getCodigo(), movimentoFolha);
            item = this.createItemMovimentoFolha(movimentoFolha, evt, EnumConstEventoMedias.MEDIA_VALOR.getValue(), valor);
            movimentoFolha.getItensMovimentoFolha().add(item);
        }
    }
}

