/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.apuracaoponto.leituraplanilha;

import com.touchcomp.basementor.model.vo.ColaboradorApuracaoPontoFolha;
import com.touchcomp.basementor.model.vo.DiaHorarioTrabalho;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.ResumoDiarioApuracaoPontoColaborador;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import contatocore.util.ContatoFormatUtil;
import java.util.HashMap;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;

public class UtilityStatusHoraViagem {
    public void getAtestadoHoras(ResumoDiarioApuracaoPontoColaborador resumoDiario, ColaboradorApuracaoPontoFolha apuracaoPonto, List<HashMap> listaHoras, EmpresaRh empresaRh) throws ExceptionService {
        TipoCalculoEvento tp = empresaRh.getTpCalculoHoraViagem();
        if (tp == null) {
            throw new ExceptionService("Primeiro, informe o Evento de Hora de Viagem");
        }
        Double totalHorasTrabalhadas = 0.0;
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("dataResumo", resumoDiario.getDataResumo());
        request.setAttribute("colaborador", apuracaoPonto.getColaborador());
        DiaHorarioTrabalho diaHorario = (DiaHorarioTrabalho)CoreServiceFactory.getCoreServiceApuracaoEventosPontoFolha().execute(request, "verificarConfiguracoesDia");
        Double horasViagem = ContatoFormatUtil.arrredondarNumero((Double)(diaHorario.getTotalHorasDia() - totalHorasTrabalhadas), (int)2);
        resumoDiario.setTotalHoras(horasViagem);
        boolean achou = false;
        for (HashMap listaHora : listaHoras) {
            TipoCalculoEvento tpAtestado = (TipoCalculoEvento)listaHora.get("EVENTO");
            if (!tpAtestado.equals((Object)tp)) continue;
            Double referencia = (Double)listaHora.get("REFERENCIA");
            referencia = referencia + horasViagem;
            listaHora.put("REFERENCIA", referencia);
            break;
        }
        if (!achou) {
            HashMap<String, Object> hash = new HashMap<String, Object>();
            hash.put("EVENTO", tp);
            hash.put("REFERENCIA", horasViagem);
            listaHoras.add(hash);
        }
    }
}

