/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.apuracaoponto.rateiofolha;

import com.touchcomp.basementor.model.vo.CalculoInssAberturaPeriodo;
import com.touchcomp.basementor.model.vo.CalculoInssEmpresa;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.FechamentoPontoFolha;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.tools.DateUtil;

public class UtilityValidacaoRateioImpostoFolha {
    public void validarAlocacaoColaboradores(FechamentoPontoFolha fechamentoPonto) throws ExceptionService {
        CalculoInssEmpresa calculoInss = fechamentoPonto.getFechamentoPeriodo().getCalculoInss();
        for (CalculoInssAberturaPeriodo ab : calculoInss.getAberturasPeriodo()) {
            for (MovimentoFolha movimentoFolha : ab.getAberturaPeriodo().getMovimentoFolha()) {
                Colaborador colaborador = movimentoFolha.getColaborador();
                Integer diaFinal = DateUtil.diferenceDayBetweenDates(fechamentoPonto.getDataInicial(), fechamentoPonto.getDataFinal()) + 1;
                String hql = " select coalesce(count(resumo.identificador),0) from ResumoDiarioApuracaoPontoColaborador resumo  where  resumo.colaboradorApuracaoPonto.colaborador = :colaborador  and  resumo.dataResumo between :dataInicio and :dataFinal ";
                Long contResumo = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setParameter("colaborador", (Object)colaborador).setParameter("dataInicio", (Object)fechamentoPonto.getDataInicial()).setParameter("dataFinal", (Object)fechamentoPonto.getDataFinal()).uniqueResult();
                if (movimentoFolha.getStatusFolha().getCodigo().equals((short)3)) continue;
                if (contResumo == null) {
                    throw new ExceptionService("Dias Invalidos de aloca\u00e7\u00e3o para o colaborador: " + colaborador.getNumeroRegistro() + " - " + colaborador.toString());
                }
                Integer diasAlocados = contResumo.intValue();
                if (diasAlocados.equals(diaFinal)) continue;
                throw new ExceptionService("Dias Invalidos de aloca\u00e7\u00e3o para o colaborador: " + colaborador.getNumeroRegistro() + " - " + colaborador.toString() + "\nDias Alocados: " + diasAlocados);
            }
        }
    }
}

