/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.apuracaovalordecimoterceiro;

import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoParamFolha;
import com.touchcomp.basementor.model.vo.Ano13oSalario;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.EventoColaborador;
import com.touchcomp.basementor.model.vo.ItemMovimentoFolhaDec;
import com.touchcomp.basementor.model.vo.Media13oSalarioColaborador;
import com.touchcomp.basementor.model.vo.Salario13oColaborador;
import com.touchcomp.basementor.model.vo.Sindicato;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import contatocore.util.ContatoFormatUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.rh.apuracaovalordecimoterceiro.UtilApuracaoValoreDecimoTerceiro;
import mentorcore.service.impl.rh.apuracaovalordecimoterceiro.UtilCalculoPagamentoDecimoTerceiro;

public class ServiceApuracaoValorDecimoTerceiro
extends CoreService {
    public static final String FIND_COLABORADORES_ADD_DEC = "findColaboradoresAddDec";
    public static final String FIND_PAGAMENTOS_13_EFETUADOS = "findPagamentosDecEfetuados";
    public static final String COLABORADORES_ATIVOS_SEM_DIREITO_REC_ADD_DEC = "colaboradoresAtivosSemDireitoAddDec";
    public static final String CREATE_DECIMO_TERCEIRO_SALARIO = "createDecimoTerceiroSalario";
    public static final String FIND_MEDIA_VARIAVEL_AP_DEC = "findMediaVariavelApDc";
    public static final String FIND_MEDIA_FIXA_AP_DEC = "findMediaFixaApDec";
    public static final String CALCULAR_MEDIA_DECIMO_TERCEIRO_VARIAVEL = "calcularMediaDecimoTerceiro";
    public static final String CALCULAR_MEDIA_DECIMO_TERCEIRO_FIXA = "calcularMediaDecimoTerceiroFixa";
    public static final String CALCULAR_LANCAMENTOS_ADD_DEC = "calcularLancamentosAddDec";
    public static final String CALCULAR_LANCAMENTO_PAG_DEC = "calcularLancamentoPagDec";
    public static final String CALCULAR_NOVO_VALOR_MEDIA = "calcularNovoValorMedia";
    public static final String FIND_COLABORADORES_PAGAMENTO_DECIMO_TERCEIRO = "findColaboradoresPagamentoDecimoTerceiro";
    public static final String SALVAR_FOLHA_DECIMO_TERCEIRO = "salvarFolhaDecimoTerceiro";
    public static final String FIND_VALOR_DESCONTO_ADD_DEC = "findValorDescontoAddDec";

    public List findColaboradoresAddDec(CoreRequestContext request) {
        Integer ano = (Integer)request.getAttribute("ano");
        Long idEmpresa = (Long)request.getAttribute("idEmpresa");
        Long eventoAddDec = (Long)request.getAttribute("eventoAddDec");
        Date dataPagamento = (Date)request.getAttribute("dataPagamento");
        Sindicato sindicato = (Sindicato)request.getAttribute("sindicato");
        return new UtilApuracaoValoreDecimoTerceiro().findColaboradoresAdiantamentoDecimoTerceiro(ano, idEmpresa, eventoAddDec, dataPagamento, sindicato);
    }

    public List findPagamentosDecEfetuados(CoreRequestContext request) {
        Long idEmpresa = (Long)request.getAttribute("idEmpresa");
        Long eventoAddDec = (Long)request.getAttribute("eventoAddDec");
        Integer ano = (Integer)request.getAttribute("ano");
        return new UtilApuracaoValoreDecimoTerceiro().findPagamentoEfetuadoAdiantamentoDecimoTerceiro(ano, idEmpresa, eventoAddDec);
    }

    public List colaboradoresAtivosSemDireitoAddDec(CoreRequestContext request) {
        Long idEmpresa = (Long)request.getAttribute("idEmpresa");
        Date dataPagamento = (Date)request.getAttribute("dataPagamento");
        Integer ano = (Integer)request.getAttribute("ano");
        return new UtilApuracaoValoreDecimoTerceiro().colaboradoresSemDireitoAddDec(ano, idEmpresa, dataPagamento);
    }

    public List createDecimoTerceiroSalario(CoreRequestContext request) throws ExceptionService {
        Date dataPrevisaoPagamento = (Date)request.getAttribute("dataPrevisaoPagamento");
        List colaboradores = (List)request.getAttribute("colaboradores");
        return new UtilApuracaoValoreDecimoTerceiro().createSalario13Colaborador(colaboradores, dataPrevisaoPagamento);
    }

    public List findMediaVariavelApDc(CoreRequestContext request) throws ExceptionService {
        Colaborador colaborador = (Colaborador)request.getAttribute("colaborador");
        Integer ano = (Integer)request.getAttribute("ano");
        return new UtilApuracaoValoreDecimoTerceiro().findMediaDecFerias(colaborador, ano);
    }

    public List findMediaFixaApDec(CoreRequestContext request) {
        Colaborador colaborador = (Colaborador)request.getAttribute("colaborador");
        Date periodoFinal = (Date)request.getAttribute("periodoFinal");
        return new UtilApuracaoValoreDecimoTerceiro().findMediaFixaDecFerias(colaborador, periodoFinal);
    }

    public Media13oSalarioColaborador calcularMediaDecimoTerceiro(CoreRequestContext request) throws ExceptionService {
        HashMap hash = (HashMap)request.getAttribute("hash");
        List media13 = (List)request.getAttribute("media13");
        return new UtilCalculoPagamentoDecimoTerceiro().calcularMediaDecimoTerceiro(hash, media13);
    }

    public Media13oSalarioColaborador calcularMediaDecimoTerceiroFixa(CoreRequestContext request) throws ExceptionService {
        Salario13oColaborador vo = (Salario13oColaborador)request.getAttribute("vo");
        EventoColaborador eventoColaborador = (EventoColaborador)request.getAttribute("eventoColaborador");
        List medias = (List)request.getAttribute("medias");
        return new UtilCalculoPagamentoDecimoTerceiro().createMedia13oSalarioColaborador(eventoColaborador, vo, medias);
    }

    public void calcularLancamentosAddDec(CoreRequestContext request) throws ExceptionService {
        Salario13oColaborador vo = (Salario13oColaborador)request.getAttribute("vo");
        Double percCalculo = (Double)request.getAttribute("percCalculo");
        new UtilCalculoPagamentoDecimoTerceiro().itensLancamentosAdiantamentoDecimoTerceiro(vo, percCalculo);
    }

    public void calcularLancamentoPagDec(CoreRequestContext request) throws ExceptionService {
        Salario13oColaborador vo = (Salario13oColaborador)request.getAttribute("vo");
        Double percCalculo = (Double)request.getAttribute("percCalculo");
        TipoCalculoEvento eventoPagDecimoTerceiro = (TipoCalculoEvento)request.getAttribute("eventoPagDecimoTerceiro");
        TipoCalculoEvento maternidade = (TipoCalculoEvento)request.getAttribute("maternidade");
        new UtilCalculoPagamentoDecimoTerceiro().itensLancamentosPagamentoDecimoTerceiro(vo, percCalculo, eventoPagDecimoTerceiro, maternidade);
    }

    public Double calcularNovoValorMedia(CoreRequestContext request) throws ExceptionService {
        Media13oSalarioColaborador media = (Media13oSalarioColaborador)request.getAttribute("media");
        return new UtilCalculoPagamentoDecimoTerceiro().calcularEventoDecimoTerceiro(media.getSalario13Colaborador(), media.getTpCalculo().getEvento(), media.getReferencia(), media.getSalario13Colaborador().getDataPagamento(), media.getSalario13Colaborador().getDataPagamento());
    }

    public List findColaboradoresPagamentoDecimoTerceiro(CoreRequestContext request) {
        Date dataPagamento = (Date)request.getAttribute("dataPagamento");
        Integer ano = (Integer)request.getAttribute("ano");
        Long idEmpresa = (Long)request.getAttribute("idEmpresa");
        return new UtilApuracaoValoreDecimoTerceiro().findColaboradoresPagamentoDecimoTerceiro(dataPagamento, ano, idEmpresa);
    }

    public Object salvarFolhaDecimoTerceiro(CoreRequestContext request) throws ExceptionService {
        Ano13oSalario vo = (Ano13oSalario)request.getAttribute("vo");
        for (Salario13oColaborador salario : vo.getSalario13oColaborador()) {
            Double vlrProvento = 0.0;
            Double vlrDesconto = 0.0;
            Double vlrLiquido = 0.0;
            for (ItemMovimentoFolhaDec item : salario.getItemMovimentoFolha()) {
                if (item.getEventoColaborador().getTipoCalculoEvento().getEvento().getTipoEvento().equals(EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue())) {
                    vlrProvento = vlrProvento + item.getValor();
                    continue;
                }
                vlrDesconto = vlrDesconto + item.getValor();
            }
            vlrLiquido = ContatoFormatUtil.arrredondarNumero((Double)(vlrProvento - vlrDesconto), (int)2);
            salario.setVrLiquido(vlrLiquido);
        }
        return ServiceApuracaoValorDecimoTerceiro.simpleSave(CoreDAOFactory.getInstance().getDAOAno13oSalario(), vo);
    }

    public void findValorDescontoAddDec(CoreRequestContext request) throws ExceptionService {
        Integer ano = (Integer)request.getAttribute("ano");
        Salario13oColaborador vo = (Salario13oColaborador)request.getAttribute("vo");
        Long arredAnt = (Long)request.getAttribute("arredAnt");
        Long arredProx = (Long)request.getAttribute("arredProx");
        new UtilCalculoPagamentoDecimoTerceiro().lancamentoAdiantamentoDecimoTerceiro(vo, ano, arredAnt, arredProx);
    }
}

