/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.apuracaovalordecimoterceiro;

import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoMedias;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Salario13oColaborador;
import com.touchcomp.basementor.model.vo.Sindicato;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import contatocore.util.ContatoFormatUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;
import mentorcore.tools.DateUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilApuracaoValoreDecimoTerceiro {
    public List findColaboradoresAdiantamentoDecimoTerceiro(Integer ano, Long idEmpresa, Long codigoAddDec, Date dataPagamento, Sindicato sindicato) {
        Long idSindicato = sindicato != null ? sindicato.getIdentificador() : 0L;
        String hql = " from Colaborador c  where  c.ativo = :sim  and (:idSindicato = 0 or c.sindicato.identificador = :idSindicato)  and  (c.dataDemissao is null or c.dataDemissao > :dataPagamento )  and  c.dataAdmissao <= :dataPagamento  and  c.empresa.identificador = :idEmpresa  and  c.tipoColaborador.identificador != :autonomo  and  c.tipoColaborador.identificador != :autonomoFrete and  c.tipoColaborador.identificador != :socioDiretor  and  c.esocCategoriaTrabalhador.codigo != :intermitente  and  c.tipoColaborador.identificador != :estagiario  and  (not exists (select s.identificador              from Salario13oColaborador s              where              s.colaborador = c              and              s.ano13Salario.ano = :ano              and              s.ano13Salario.tipoCalculo = :addDec)  and  not exists (select item.identificador              from ItemMovimentoFolha item              where              item.movimentoFolha.colaborador = c              and              extract(year from item.movimentoFolha.aberturaPeriodo.periodoApuracao) = :ano              and              item.eventoColaborador.tipoCalculoEvento.evento.codigo = :eventoAddDec))  and   not exists (select af.colaborador              from AfastamentoColaborador af              where  af.dataAfastamento != null  and               ( af.dataAfastamento < :primeiroJaneiro and (af.dataRetorno is null or af.dataRetorno > :dataPagamento ))              and               af.colaborador = c               and               af.afastamentoSefip.codigo != :cod1              and               af.afastamentoSefip.codigo != :cod2              and               af.afastamentoSefip.codigo != :cod3) ";
        List retorno = CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("sim", (short)1).setShort("addDec", (short)1).setInteger("ano", ano.intValue()).setLong("idSindicato", idSindicato.longValue()).setLong("idEmpresa", idEmpresa.longValue()).setLong("eventoAddDec", codigoAddDec.longValue()).setLong("autonomo", EnumConstTipoColaborador.AUTONOMO.getValue()).setLong("autonomoFrete", EnumConstTipoColaborador.AUTONOMO_FRETE.getValue()).setLong("estagiario", EnumConstTipoColaborador.ESTAGIARIO.getValue()).setLong("socioDiretor", EnumConstTipoColaborador.SOCIO_DIRETOR.getValue()).setString("intermitente", "111").setDate("dataPagamento", dataPagamento).setDate("primeiroJaneiro", DateUtil.intToDate(ano, 1, 1)).setString("cod1", "Z1").setString("cod2", "Q1").setString("cod3", "U1").list();
        return retorno;
    }

    public List colaboradoresSemDireitoAddDec(Integer ano, Long idEmpresa, Date dataPagamento) {
        String hql = " select af.colaborador     from AfastamentoColaborador af     where  af.dataAfastamento != null  and     ( af.dataAfastamento < :primeiroJaneiro     and     (af.dataRetorno is null or af.dataRetorno > :dataPagamento ))    and     af.afastamentoSefip.codigo != :cod1    and     af.afastamentoSefip.codigo != :cod2    and     af.afastamentoSefip.codigo != :cod3     and     af.colaborador.empresa.identificador = :idEmpresa ";
        List retorno = CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("idEmpresa", idEmpresa.longValue()).setDate("dataPagamento", dataPagamento).setDate("primeiroJaneiro", DateUtil.intToDate(ano, 1, 1)).setString("cod1", "Z1").setString("cod2", "Q1").setString("cod3", "U1").list();
        return retorno;
    }

    public List findPagamentoEfetuadoAdiantamentoDecimoTerceiro(Integer ano, Long idEmpresa, Long codigoAddDec) {
        String hql = " from Colaborador c  where  c.ativo = :sim  and  c.dataDemissao is null  and  c.empresa.identificador = :idEmpresa  and  c.tipoColaborador.identificador != :autonomo  and  c.tipoColaborador.identificador != :autonomoFrete and  c.tipoColaborador.identificador != :socioDiretor  and  (exists (select s.identificador              from Salario13oColaborador s              where              s.colaborador = c              and              s.ano13Salario.ano = :ano              and              s.ano13Salario.tipoCalculo = :addDec)  or   exists (select item.identificador              from ItemMovimentoFolha item              where              item.movimentoFolha.colaborador = c              and              extract(year from item.movimentoFolha.aberturaPeriodo.periodoApuracao) = :ano              and              item.eventoColaborador.tipoCalculoEvento.evento.codigo = :eventoAddDec)) ";
        List retorno = CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("sim", (short)1).setShort("addDec", (short)1).setInteger("ano", ano.intValue()).setLong("idEmpresa", idEmpresa.longValue()).setLong("eventoAddDec", codigoAddDec.longValue()).setLong("autonomo", EnumConstTipoColaborador.AUTONOMO.getValue()).setLong("autonomoFrete", EnumConstTipoColaborador.AUTONOMO_FRETE.getValue()).setLong("socioDiretor", EnumConstTipoColaborador.SOCIO_DIRETOR.getValue()).list();
        return retorno;
    }

    public List createSalario13Colaborador(List colaboradores, Date dataPrevisaoPagamento) throws ExceptionService {
        ArrayList<Salario13oColaborador> listasalario13 = new ArrayList<Salario13oColaborador>();
        for (Object o : colaboradores) {
            Colaborador c = (Colaborador)o;
            Salario13oColaborador salario13 = new Salario13oColaborador();
            salario13.setColaborador(c);
            salario13.setDataPagamento(dataPrevisaoPagamento);
            salario13.setSalarioNominal(this.getSalarioNominal(c, dataPrevisaoPagamento));
            listasalario13.add(salario13);
        }
        return listasalario13;
    }

    public Double getSalarioNominal(Colaborador colaborador, Date periodoInicial) throws ExceptionService {
        String cod = colaborador.getTipoSalario().getCodigo();
        System.err.println(colaborador.toString() + "Decimo Terceiro");
        Integer codigo = new Integer(cod);
        Double valor = 0.0;
        switch (codigo) {
            case 1: {
                valor = this.findVrSalarioMaiorColaboradorSalarioNoPeriodo(colaborador, periodoInicial);
                return valor;
            }
            case 2: {
                valor = this.findVrSalarioMaiorColaboradorSalarioNoPeriodo(colaborador, periodoInicial);
                return valor;
            }
            case 3: {
                valor = this.findVrSalarioMaiorColaboradorSalarioNoPeriodo(colaborador, periodoInicial);
                return valor;
            }
            case 4: {
                valor = this.findVrSalarioMaiorColaboradorSalarioNoPeriodo(colaborador, periodoInicial);
                valor = valor * colaborador.getDiasJornada();
                return valor;
            }
            case 5: {
                valor = this.findVrSalarioMaiorColaboradorSalarioNoPeriodo(colaborador, periodoInicial);
                valor = valor * colaborador.getDiasJornada() * colaborador.getHorasTrabDia();
                valor = ContatoFormatUtil.arrredondarNumero((Double)valor, (int)2);
                return valor;
            }
            case 6: {
                return valor;
            }
            case 7: {
                return valor;
            }
        }
        return valor;
    }

    public Double findVrSalarioMaiorColaboradorSalarioNoPeriodo(Colaborador c, Date periodoAbertura) throws ExceptionService {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select distinct c.valorSalario  from ColaboradorSalario c where c.periodo = (select max(cc.periodo)  from ColaboradorSalario cc                    where (cc.periodo <= :periodo) and cc.colaborador.identificador = :colaborador) and c.colaborador.identificador = :colaborador");
        q.setLong("colaborador", c.getIdentificador().longValue());
        q.setDate("periodo", periodoAbertura);
        if (q.list().size() > 1 || q.uniqueResult() == null) {
            throw new ExceptionService("Verifique as informa\u00e7\u00f5es referentes ao Salario do colaborador: " + c.getPessoa().getNome());
        }
        return (Double)q.uniqueResult();
    }

    public List findMediaDecFerias(Colaborador colaborador, Integer ano) throws ExceptionService {
        String hql = " select  item.eventoColaborador.tipoCalculoEvento.identificador as ID_EVENTO,  sum(item.referencia) as REFERENCIA , sum(item.valor) as VALOR , item.eventoColaborador.tipoCalculoEvento.mediaFerias as TIPO_MEDIA,  item.eventoColaborador.identificador as ID_EVENTO_COLABORADOR  from ItemMovimentoFolha item  where  (item.eventoColaborador.tipoCalculoEvento.media13Salario = :referencia  or  (item.eventoColaborador.tipoCalculoEvento.media13Salario = :valor)) and  item.movimentoFolha.colaborador = :colaborador  and  item.eventoColaborador.eventoFixo = :nao  and  (extract(year from item.movimentoFolha.aberturaPeriodo.dataInicio) = :ano)  and  item.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento  group by item.eventoColaborador.tipoCalculoEvento.identificador, item.eventoColaborador.tipoCalculoEvento.mediaFerias,item.eventoColaborador.identificador ";
        List l = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setShort("referencia", EnumConstEventoMedias.MEDIA_REFERENCIA.getValue()).setShort("valor", EnumConstEventoMedias.MEDIA_VALOR.getValue()).setInteger("ano", ano.intValue()).setShort("nao", (short)0).setShort("folhaPagamento", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue()).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        ArrayList<HashMap> retorno = new ArrayList<HashMap>();
        for (Object obj : l) {
            HashMap h = (HashMap)obj;
            Long id = (Long)h.get("ID_EVENTO");
            TipoCalculoEvento tipo = (TipoCalculoEvento)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOTipoCalculoEvento(), "identificador", id, 0);
            h.put("tipoCalculo", tipo);
            retorno.add(h);
        }
        return retorno;
    }

    public List findMediaFixaDecFerias(Colaborador colaborador, Date periodoFinal) {
        String hql = " select event  from EventoColaborador event  where  event.colaborador = :colaborador  and  (event.dataFinal is null or event.dataFinal >= :periodoFinal) and  event.eventoFixo = :sim  and  event.tipoCalculoEvento.mediaFerias <> :nao ";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setDate("periodoFinal", periodoFinal).setShort("sim", (short)1).setShort("nao", (short)0).list();
    }

    public List findColaboradoresPagamentoDecimoTerceiro(Date dataPagamento, Integer ano, Long idEmpresa) {
        String hql = " from Colaborador c  where  (c.tipoColaborador.identificador != :autonomoFrete  and  c.tipoColaborador.identificador  != :autonomo and  c.tipoColaborador.identificador != :socioDiretor and  c.tipoColaborador.identificador != :estagiario)  and  c.esocCategoriaTrabalhador.codigo != :intermitente  and  extract(year from c.dataAdmissao) <= :ano  and  c.dataAdmissao <= :dataPagamento  and  c.ativo = 1  and  (c.dataDemissao is null or c.dataDemissao > :dataPagamento )  and   not exists (select af.colaborador              from AfastamentoColaborador af              where  af.dataAfastamento != null  and               ( af.dataAfastamento < :primeiroJaneiro and (af.dataRetorno is null or af.dataRetorno > :dataPagamento ))              and               af.colaborador = c               and               af.afastamentoSefip.codigo != :cod1              and               af.afastamentoSefip.codigo != :cod2              and af.afastamentoSefip.codigo != :cod3)  and  c.empresa.identificador = :idEmpresa  and  not exists (select salario13.colaborador             from Salario13oColaborador salario13             where             salario13.ano13Salario.ano = :ano             and             salario13.ano13Salario.tipoCalculo = :pagDec            and             salario13.colaborador = c)";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("autonomo", EnumConstTipoColaborador.AUTONOMO.getValue()).setLong("autonomoFrete", EnumConstTipoColaborador.AUTONOMO_FRETE.getValue()).setLong("socioDiretor", EnumConstTipoColaborador.SOCIO_DIRETOR.getValue()).setLong("estagiario", EnumConstTipoColaborador.ESTAGIARIO.getValue()).setShort("pagDec", (short)2).setInteger("ano", ano.intValue()).setString("intermitente", "111").setDate("dataPagamento", dataPagamento).setDate("primeiroJaneiro", DateUtil.intToDate(ano, 1, 1)).setString("cod1", "Z1").setString("cod2", "Q1").setString("cod3", "U1").setLong("idEmpresa", idEmpresa.longValue()).list();
    }
}

