/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.apuracaovalordecimoterceiro;

import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoOcorrenciaEvtColaborador;
import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoMedias;
import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoParamFolha;
import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoTipoReferenciaPadrao;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Evento;
import com.touchcomp.basementor.model.vo.EventoColaborador;
import com.touchcomp.basementor.model.vo.ItemMovimentoFolhaDec;
import com.touchcomp.basementor.model.vo.Media13oSalarioColaborador;
import com.touchcomp.basementor.model.vo.Salario13oColaborador;
import com.touchcomp.basementor.model.vo.TabelaINSS;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.rh.apuracaovalordecimoterceiro.UtilApuracaoValoreDecimoTerceiro;
import mentorcore.tools.DateUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.nfunk.jep.JEP;

public class UtilCalculoPagamentoDecimoTerceiro {
    public Media13oSalarioColaborador calcularMediaDecimoTerceiro(HashMap h, List media13) throws ExceptionService {
        Salario13oColaborador vo = (Salario13oColaborador)h.get("vo");
        boolean achou = false;
        Date primeiroJaneiro = DateUtil.intToDate(DateUtil.yearFromDate(vo.getDataPagamento()), 1, 1);
        Date trintaUmDezembro = DateUtil.intToDate(DateUtil.yearFromDate(vo.getDataPagamento()), 12, 31);
        TipoCalculoEvento tipoCalculo = (TipoCalculoEvento)h.get("tipoCalculo");
        Double valor = (Double)h.get("VALOR");
        Double referencia = (Double)h.get("REFERENCIA");
        Short tipoMedia = (Short)h.get("TIPO_MEDIA");
        Long idEventoColaborador = (Long)h.get("ID_EVENTO_COLABORADOR");
        HashMap hash = this.tipoComposicaoRemuneracao(idEventoColaborador, trintaUmDezembro, primeiroJaneiro);
        for (Object object : media13) {
            Media13oSalarioColaborador mediaEncontrada = (Media13oSalarioColaborador)object;
            if (!mediaEncontrada.getTpCalculo().getEvento().equals((Object)tipoCalculo.getEvento())) continue;
            achou = true;
            this.atualizarMedia13Ferias(mediaEncontrada, referencia, valor, primeiroJaneiro, trintaUmDezembro);
            break;
        }
        if (!achou) {
            Media13oSalarioColaborador media = this.createMediaFerias13(hash, tipoCalculo, vo, tipoMedia, referencia, valor, primeiroJaneiro, trintaUmDezembro);
            return media;
        }
        return null;
    }

    public HashMap tipoComposicaoRemuneracao(Long idEventoColaborador, Date periodoInicial, Date periodoFinal) throws ExceptionService {
        HashMap<String, Object> retorno = new HashMap<String, Object>();
        String hql = " select evt  from EventoColaborador evt  where  evt.identificador = :idEvento  and  evt.eventoFixo = :nao ";
        EventoColaborador eventoColaborador = (EventoColaborador)CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("idEvento", idEventoColaborador.longValue()).setShort("nao", (short)0).uniqueResult();
        if (eventoColaborador != null) {
            retorno.put("eventoColaborador", eventoColaborador);
            retorno.put("tipoRemuneracao", (short)2);
            return retorno;
        }
        hql = " select evt  from EventoColaborador evt  where  evt.identificador = :idEvento  and  evt.eventoFixo = :sim   and  (evt.dataFinal is null or evt.dataFinal >= :periodoFinal)";
        eventoColaborador = (EventoColaborador)CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("sim", (short)1).setLong("idEvento", idEventoColaborador.longValue()).setDate("periodoFinal", periodoFinal).uniqueResult();
        if (eventoColaborador != null) {
            retorno.put("eventoColaborador", eventoColaborador);
            retorno.put("tipoRemuneracao", (short)0);
            return retorno;
        }
        hql = " select evt  from EventoColaborador evt  where  evt.identificador = :idEvento  and  evt.eventoFixo = :sim  and  evt.dataFinal <= :periodoFinal ";
        eventoColaborador = (EventoColaborador)CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("idEvento", idEventoColaborador.longValue()).setShort("sim", (short)1).setDate("periodoFinal", periodoFinal).uniqueResult();
        if (eventoColaborador != null) {
            retorno.put("eventoColaborador", eventoColaborador);
            retorno.put("tipoRemuneracao", (short)1);
            return retorno;
        }
        throw new ExceptionService("Erro com as configura\u00e7\u00f5es do Evento Colaborador id: " + idEventoColaborador.toString());
    }

    private Media13oSalarioColaborador createMediaFerias13(HashMap hash, TipoCalculoEvento tipoCalculo, Salario13oColaborador vo, Short tipoMedia, Double referencia, Double valor, Date primeiroJaneiro, Date trintaUmDezembro) throws ExceptionService {
        Media13oSalarioColaborador media = new Media13oSalarioColaborador();
        Colaborador colaborador = vo.getColaborador();
        EventoColaborador evt = (EventoColaborador)hash.get("eventoColaborador");
        Short tipoRemuneracao = (Short)hash.get("tipoRemuneracao");
        Double referenciaPadrao = this.getTipoReferencia(tipoCalculo.getEvento(), colaborador);
        Double avosParciais = 0.0;
        if (tipoRemuneracao.equals((short)2)) {
            media.setTpCalculo(tipoCalculo);
            media.setTipoEvento(tipoMedia);
            media.setSalario13Colaborador(vo);
            media.setTipoRemuneracao(Short.valueOf((short)2));
            if (referencia > 0.0) {
                media.setReferencia(referencia);
                valor = this.calcularEventoDecimoTerceiro(vo, tipoCalculo.getEvento(), referencia, primeiroJaneiro, trintaUmDezembro);
                media.setValor(valor);
                media.setInformarValor(Short.valueOf((short)0));
                return media;
            }
            media.setReferencia(Double.valueOf(0.0));
            media.setValor(valor);
            media.setInformarValor(Short.valueOf((short)1));
            return media;
        }
        if (tipoRemuneracao.equals((short)0)) {
            media.setTpCalculo(tipoCalculo);
            media.setTipoEvento(tipoMedia);
            media.setSalario13Colaborador(vo);
            media.setTipoRemuneracao(Short.valueOf((short)0));
            if (evt.getDataInicial().before(primeiroJaneiro) || evt.getDataInicial().equals(primeiroJaneiro)) {
                if (referencia > 0.0) {
                    referenciaPadrao = ContatoFormatUtil.arrredondarNumero((Double)(referenciaPadrao * (double)vo.getNrAvos().intValue()), (int)2);
                    media.setReferencia(referenciaPadrao);
                    valor = this.calcularEventoDecimoTerceiro(vo, tipoCalculo.getEvento(), referenciaPadrao, primeiroJaneiro, trintaUmDezembro);
                    media.setValor(valor);
                    media.setInformarValor(Short.valueOf((short)0));
                    return media;
                }
                if (evt.getValor() > 0.0) {
                    valor = evt.getValor() * (double)vo.getNrAvos().intValue();
                }
                media.setReferencia(Double.valueOf(0.0));
                media.setValor(ContatoFormatUtil.arrredondarNumero((Double)valor, (int)2));
                media.setInformarValor(Short.valueOf((short)1));
                return media;
            }
            if (evt.getDataInicial().after(primeiroJaneiro)) {
                avosParciais = UtilCalculoPagamentoDecimoTerceiro.getAvosFerias(evt.getDataInicial(), trintaUmDezembro);
                if (referencia > 0.0) {
                    referenciaPadrao = ContatoFormatUtil.arrredondarNumero((Double)(referenciaPadrao * avosParciais), (int)2);
                    media.setReferencia(referenciaPadrao);
                    valor = this.calcularEventoDecimoTerceiro(vo, tipoCalculo.getEvento(), referenciaPadrao, primeiroJaneiro, trintaUmDezembro);
                    media.setValor(valor);
                    media.setInformarValor(Short.valueOf((short)0));
                    return media;
                }
                if (evt.getValor() > 0.0) {
                    valor = ContatoFormatUtil.arrredondarNumero((Double)(evt.getValor() * avosParciais), (int)2);
                }
                media.setReferencia(Double.valueOf(0.0));
                media.setValor(ContatoFormatUtil.arrredondarNumero((Double)valor, (int)2));
                media.setInformarValor(Short.valueOf((short)1));
                return media;
            }
        } else if (tipoRemuneracao.equals((short)1)) {
            media.setTpCalculo(tipoCalculo);
            media.setTipoEvento(tipoMedia);
            media.setSalario13Colaborador(vo);
            media.setTipoRemuneracao(Short.valueOf((short)1));
            avosParciais = evt.getDataInicial().after(primeiroJaneiro) && (evt.getDataFinal() == null || evt.getDataFinal().after(trintaUmDezembro)) ? UtilCalculoPagamentoDecimoTerceiro.getAvosFerias(evt.getDataInicial(), trintaUmDezembro) : (!(!evt.getDataInicial().before(primeiroJaneiro) && !evt.getDataInicial().equals(primeiroJaneiro) || evt.getDataFinal() != null && !evt.getDataFinal().after(trintaUmDezembro)) ? UtilCalculoPagamentoDecimoTerceiro.getAvosFerias(primeiroJaneiro, trintaUmDezembro) : ((evt.getDataInicial().before(primeiroJaneiro) || evt.getDataInicial().equals(primeiroJaneiro)) && evt.getDataFinal().before(trintaUmDezembro) ? UtilCalculoPagamentoDecimoTerceiro.getAvosFerias(primeiroJaneiro, evt.getDataFinal()) : UtilCalculoPagamentoDecimoTerceiro.getAvosFerias(evt.getDataInicial(), evt.getDataFinal())));
            if (referencia > 0.0) {
                referenciaPadrao = ContatoFormatUtil.arrredondarNumero((Double)(referenciaPadrao * avosParciais), (int)2);
                media.setReferencia(referenciaPadrao);
                valor = this.calcularEventoDecimoTerceiro(vo, tipoCalculo.getEvento(), referenciaPadrao, primeiroJaneiro, trintaUmDezembro);
                media.setValor(valor);
                media.setInformarValor(Short.valueOf((short)0));
                return media;
            }
            if (evt.getValor() > 0.0) {
                valor = ContatoFormatUtil.arrredondarNumero((Double)(evt.getValor() * avosParciais), (int)2);
            }
            media.setReferencia(Double.valueOf(0.0));
            media.setValor(ContatoFormatUtil.arrredondarNumero((Double)valor, (int)2));
            media.setInformarValor(Short.valueOf((short)1));
            return media;
        }
        return null;
    }

    private void atualizarMedia13Ferias(Media13oSalarioColaborador mediaEncontrada, Double referencia, Double valor, Date primeiroJaneiro, Date trintaUmDezembro) throws ExceptionService {
        if (mediaEncontrada.getTipoRemuneracao().equals((short)2)) {
            if (mediaEncontrada.getTipoEvento().equals(EnumConstEventoMedias.MEDIA_REFERENCIA.getValue())) {
                referencia = mediaEncontrada.getReferencia() + referencia;
                mediaEncontrada.setReferencia(referencia);
                valor = this.calcularEventoDecimoTerceiro(mediaEncontrada.getSalario13Colaborador(), mediaEncontrada.getTpCalculo().getEvento(), referencia, primeiroJaneiro, trintaUmDezembro);
                mediaEncontrada.setValor(valor);
            } else {
                valor = mediaEncontrada.getValor() + valor;
                mediaEncontrada.setValor(valor);
            }
        }
    }

    public Media13oSalarioColaborador createMedia13oSalarioColaborador(EventoColaborador evt, Salario13oColaborador vo, Date primeiroJaneiro, Date trintaUmDezembro) throws ExceptionService {
        Media13oSalarioColaborador media = new Media13oSalarioColaborador();
        Double valor = 0.0;
        Double referenciaPadrao = this.getTipoReferencia(evt.getTipoCalculoEvento().getEvento(), vo.getColaborador());
        if (evt.getValor() > 0.0) {
            valor = ContatoFormatUtil.arrredondarNumero((Double)(evt.getValor() * 12.0), (int)2);
            media.setInformarValor(Short.valueOf((short)1));
            media.setReferencia(Double.valueOf(0.0));
            media.setTipoEvento(Short.valueOf(EnumConstEventoMedias.MEDIA_VALOR.getValue()));
        } else {
            valor = this.calcularEventoDecimoTerceiro(vo, evt.getTipoCalculoEvento().getEvento(), referenciaPadrao, primeiroJaneiro, trintaUmDezembro);
            valor = ContatoFormatUtil.arrredondarNumero((Double)(valor * 12.0), (int)2);
            media.setInformarValor(Short.valueOf((short)0));
            media.setReferencia(Double.valueOf(referenciaPadrao * 12.0));
            media.setTipoEvento(Short.valueOf(EnumConstEventoMedias.MEDIA_REFERENCIA.getValue()));
        }
        media.setTpCalculo(evt.getTipoCalculoEvento());
        media.setSalario13Colaborador(vo);
        media.setTipoRemuneracao(Short.valueOf((short)0));
        media.setValor(valor);
        media.setValorOriginal(valor);
        return media;
    }

    public static Double getAvosFerias(Date pInicial, Date pFinal) {
        if (pFinal.before(pInicial)) {
            return 0.0;
        }
        boolean continuar = true;
        Integer avos = 0;
        GregorianCalendar periodoInicial = new GregorianCalendar();
        GregorianCalendar periodoFinal = new GregorianCalendar();
        periodoInicial.setTime(pInicial);
        periodoFinal.setTime(pFinal);
        continuar = true;
        avos = UtilCalculoPagamentoDecimoTerceiro.getPrimeiroAvoFerias(periodoInicial.getTime(), periodoFinal.getTime());
        periodoInicial.add(2, 1);
        periodoInicial.getTime();
        do {
            if (periodoInicial.before(periodoFinal) && 15 < DateUtil.diferenceDayBetweenDates(periodoInicial.getTime(), periodoFinal.getTime()) + 1) {
                avos = avos + 1;
            } else {
                periodoInicial.getTime();
                avos = UtilCalculoPagamentoDecimoTerceiro.getUltimoAvoFerias(periodoInicial.getTime(), periodoFinal.getTime()) + avos;
                continuar = false;
            }
            periodoInicial.add(2, 1);
            periodoInicial.getTime();
        } while (continuar);
        if (avos > 12) {
            avos = 12;
        }
        return avos.doubleValue();
    }

    private static Integer getPrimeiroAvoFerias(Date dataFerias, Date dataDemissao) {
        Integer aux1;
        GregorianCalendar dataFinalFerias = new GregorianCalendar();
        dataFinalFerias.setTime(dataFerias);
        GregorianCalendar dataFinalDemissao = new GregorianCalendar();
        dataFinalDemissao.setTime(dataDemissao);
        GregorianCalendar aux = new GregorianCalendar();
        aux.setTime(dataFerias);
        aux.add(2, 1);
        if (dataFinalDemissao.get(2) == dataFinalFerias.get(2) && dataFinalDemissao.get(1) == dataFinalFerias.get(1) ? (aux1 = Integer.valueOf(dataFinalDemissao.get(5) - dataFinalFerias.get(5) + 1)) >= 15 : (aux1 = Integer.valueOf(DateUtil.diferenceDayBetweenDates(dataFerias, aux.getTime()) + 1)) >= 15) {
            return 1;
        }
        return 0;
    }

    private static Integer getUltimoAvoFerias(Date dataFerias, Date dataDemissao) {
        GregorianCalendar dataFinalFerias = new GregorianCalendar();
        dataFinalFerias.setTime(dataFerias);
        GregorianCalendar dataFinalDemissao = new GregorianCalendar();
        dataFinalDemissao.setTime(dataDemissao);
        Integer aux = DateUtil.diferenceDayBetweenDates(dataFerias, dataDemissao) + 1;
        if (aux >= 15) {
            return 1;
        }
        return 0;
    }

    public Double calcularEventoDecimoTerceiro(Salario13oColaborador vo, Evento e, Double referencia, Date periodoInicial, Date periodoFinal) throws ExceptionService {
        JEP myParser = new JEP();
        if (e.getFormula() != null && !e.getFormula().isEmpty()) {
            List tokens = ToolString.getReplaceTokens((String)e.getFormula());
            String formulaFinal = e.getFormula();
            for (Object o : tokens) {
                StringToken s = (StringToken)o;
                if (s.getChave().equalsIgnoreCase("valor_dia")) {
                    s.setValor(UtilCalculoPagamentoDecimoTerceiro.getValorDia(vo.getColaborador(), periodoFinal));
                } else if (s.getChave().equalsIgnoreCase("dias_horas_por_jornada")) {
                    s.setValor(UtilCalculoPagamentoDecimoTerceiro.getDiasLiquidos(vo.getColaborador(), periodoInicial, periodoFinal));
                } else if (s.getChave().equalsIgnoreCase("valor_hora")) {
                    s.setValor(UtilCalculoPagamentoDecimoTerceiro.getValorHora(vo.getColaborador(), periodoFinal));
                } else if (s.getChave().equalsIgnoreCase("salario_nominal")) {
                    s.setValor(UtilCalculoPagamentoDecimoTerceiro.getSalarioNominal(vo.getColaborador(), periodoFinal));
                } else if (s.getChave().equalsIgnoreCase("valor_hora_com_adicionais")) {
                    s.setValor(UtilCalculoPagamentoDecimoTerceiro.getValorHora(vo.getColaborador(), periodoFinal));
                } else if (s.getChave().equalsIgnoreCase("salario")) {
                    s.setValor(UtilCalculoPagamentoDecimoTerceiro.getSalarioNominal(vo.getColaborador(), periodoFinal));
                } else if (s.getChave().equalsIgnoreCase("dias_trabalhados")) {
                    s.setValor("0");
                } else if (s.getChave().equalsIgnoreCase("dias_faltosos")) {
                    s.setValor("0");
                } else if (s.getChave().equalsIgnoreCase("dias_desconto_dsr")) {
                    s.setValor("0");
                } else if (s.getChave().equalsIgnoreCase("dias_folgas")) {
                    s.setValor("0");
                } else if (s.getChave().equalsIgnoreCase("dias_feriados")) {
                    s.setValor("0");
                } else if (s.getChave().equalsIgnoreCase("horas_mes")) {
                    s.setValor(vo.getColaborador().getHorasMesColaborador().toString());
                } else if (s.getChave().equalsIgnoreCase("dias_uteis")) {
                    s.setValor("0");
                } else if (s.getChave().equalsIgnoreCase("salario_minimo")) {
                    s.setValor(UtilCalculoPagamentoDecimoTerceiro.getSalarioMinimo(vo.getDataPagamento(), vo.getDataPagamento()));
                } else if (s.getChave().equalsIgnoreCase("adiantamento_salario")) {
                    s.setValor("0");
                } else if (s.getChave().equalsIgnoreCase("total_valores_eventos_fixos")) {
                    s.setValor("0");
                } else if (s.getChave().equalsIgnoreCase("referencia")) {
                    if (referencia == null || referencia == 0.0) {
                        referencia = 0.0;
                    }
                    s.setValor(referencia.toString());
                } else if (s.getChave().equalsIgnoreCase("salario_mes")) {
                    s.setValor(UtilCalculoPagamentoDecimoTerceiro.getSalarioNominal(vo.getColaborador(), periodoFinal));
                } else {
                    Evento ev = UtilCalculoPagamentoDecimoTerceiro.findEventoFormula(s.getChave());
                    if (ev != null) {
                        formulaFinal = formulaFinal.replaceAll("@" + s.getChave() + "@", "(@" + s.getChave() + "@)");
                        Double referenciaPadrao = this.getTipoReferencia(ev, vo.getColaborador());
                        Double vr = this.calcularEventoDecimoTerceiro(vo, ev, referenciaPadrao, periodoInicial, periodoFinal);
                        s.setValor(vr.toString());
                    } else {
                        s.setValor("0.0");
                    }
                }
                myParser.addVariable(s.getChave(), (Object)new Double(s.getValor()));
            }
            myParser.parseExpression(UtilCalculoPagamentoDecimoTerceiro.clearArrobas(formulaFinal));
            Double valor = myParser.getValue();
            if (valor.isInfinite() || valor.isNaN()) {
                return 0.0;
            }
            return ContatoFormatUtil.arrredondarNumero((Double)valor, (int)2);
        }
        return 0.0;
    }

    public static String clearArrobas(String formula) {
        char[] aux = formula.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < aux.length; ++i) {
            if (aux[i] == '@') continue;
            sb.append(aux[i]);
        }
        return sb.toString();
    }

    public static Evento findEventoFormula(String chave) throws ExceptionService {
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("chave", chave);
        Evento e = (Evento)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOEvento(), "chave", chave, 0);
        return e;
    }

    public static String getValorDia(Colaborador colaborador, Date periodoFinal) throws ExceptionService {
        String cod = colaborador.getTipoSalario().getCodigo();
        Integer codigo = new Integer(cod);
        Double valor = new UtilApuracaoValoreDecimoTerceiro().findVrSalarioMaiorColaboradorSalarioNoPeriodo(colaborador, periodoFinal);
        switch (codigo) {
            case 1: {
                valor = valor / colaborador.getDiasJornada();
                return valor.toString();
            }
            case 2: {
                valor = valor / colaborador.getDiasJornada();
                return valor.toString();
            }
            case 3: {
                valor = valor / colaborador.getDiasJornada();
                return valor.toString();
            }
            case 4: {
                return valor.toString();
            }
            case 5: {
                valor = valor * colaborador.getHorasTrabDia();
                return valor.toString();
            }
            case 6: {
                return valor.toString();
            }
            case 7: {
                return valor.toString();
            }
        }
        return valor.toString();
    }

    public static String getDiasLiquidos(Colaborador colaborador, Date periodoInicial, Date periodoFinal) {
        String cod = colaborador.getTipoSalario().getCodigo();
        Integer codigo = new Integer(cod);
        Double valor = 0.0;
        switch (codigo) {
            case 1: {
                valor = colaborador.getDiasJornada();
                return valor.toString();
            }
            case 2: {
                valor = colaborador.getDiasJornada();
                return valor.toString();
            }
            case 3: {
                valor = colaborador.getDiasJornada();
                return valor.toString();
            }
            case 4: {
                valor = 1.0;
                return valor.toString();
            }
            case 5: {
                valor = colaborador.getHorasTrabDia() * colaborador.getDiasJornada();
                return valor.toString();
            }
            case 6: {
                return valor.toString();
            }
            case 7: {
                return valor.toString();
            }
        }
        return valor.toString();
    }

    public static String getValorHora(Colaborador colaborador, Date periodoFinal) throws ExceptionService {
        String cod = colaborador.getTipoSalario().getCodigo();
        Integer codigo = new Integer(cod);
        Double valor = new UtilApuracaoValoreDecimoTerceiro().findVrSalarioMaiorColaboradorSalarioNoPeriodo(colaborador, periodoFinal);
        switch (codigo) {
            case 1: {
                valor = valor / colaborador.getDiasJornada() / colaborador.getHorasTrabDia();
                return valor.toString();
            }
            case 2: {
                valor = valor / colaborador.getDiasJornada() / colaborador.getHorasTrabDia();
                return valor.toString();
            }
            case 3: {
                valor = valor / colaborador.getDiasJornada() / colaborador.getHorasTrabDia();
                return valor.toString();
            }
            case 4: {
                return valor.toString();
            }
            case 5: {
                return valor.toString();
            }
            case 6: {
                return valor.toString();
            }
            case 7: {
                return valor.toString();
            }
        }
        return valor.toString();
    }

    private static String getSalarioNominal(Colaborador colaborador, Date periodoFinal) throws ExceptionService {
        String cod = colaborador.getTipoSalario().getCodigo();
        System.err.println(colaborador.toString() + "Metodo");
        Integer codigo = new Integer(cod);
        Double valor = new UtilApuracaoValoreDecimoTerceiro().findVrSalarioMaiorColaboradorSalarioNoPeriodo(colaborador, periodoFinal);
        switch (codigo) {
            case 1: {
                return valor.toString();
            }
            case 2: {
                return valor.toString();
            }
            case 3: {
                return valor.toString();
            }
            case 4: {
                valor = valor * colaborador.getDiasJornada();
                return valor.toString();
            }
            case 5: {
                valor = valor * colaborador.getDiasJornada() * colaborador.getHorasTrabDia();
                valor = ContatoFormatUtil.arrredondarNumero((Double)valor, (int)2);
                return valor.toString();
            }
            case 6: {
                return valor.toString();
            }
            case 7: {
                return valor.toString();
            }
        }
        return valor.toString();
    }

    public static String getSalarioMinimo(Date periodoInicial, Date periodoFinal) throws ExceptionService {
        Session s = null;
        Query q = null;
        s = CoreBdUtil.getInstance().getSession();
        q = s.createQuery(" from TabelaINSS t where t.dataInicial <= :periodoInicial and t.dataFinal >= :periodoFinal");
        q.setDate("periodoInicial", periodoInicial);
        q.setDate("periodoFinal", periodoFinal);
        TabelaINSS tabela = (TabelaINSS)q.uniqueResult();
        return tabela.getVrSalarioMinimo().toString();
    }

    public Media13oSalarioColaborador createMedia13oSalarioColaborador(EventoColaborador evt, Salario13oColaborador vo, List medias) throws ExceptionService {
        Double valor = 0.0;
        Double referenciaPadrao = this.getTipoReferencia(evt.getTipoCalculoEvento().getEvento(), vo.getColaborador());
        Date primeiroJaneiro = DateUtil.intToDate(DateUtil.yearFromDate(vo.getDataPagamento()), 1, 1);
        Date trintaUmDezembro = DateUtil.intToDate(DateUtil.yearFromDate(vo.getDataPagamento()), 12, 31);
        Double avos = vo.getNrAvos().doubleValue();
        if (!this.existeMedia(vo, evt, medias, primeiroJaneiro, trintaUmDezembro)) {
            Media13oSalarioColaborador media = new Media13oSalarioColaborador();
            if (evt.getValor() > 0.0) {
                valor = ContatoFormatUtil.arrredondarNumero((Double)(evt.getValor() * avos), (int)2);
                media.setInformarValor(Short.valueOf((short)1));
                media.setReferencia(Double.valueOf(0.0));
                media.setTipoEvento(Short.valueOf(EnumConstEventoMedias.MEDIA_VALOR.getValue()));
            } else {
                valor = this.calcularEventoDecimoTerceiro(vo, evt.getTipoCalculoEvento().getEvento(), referenciaPadrao, primeiroJaneiro, trintaUmDezembro);
                valor = ContatoFormatUtil.arrredondarNumero((Double)(valor * avos), (int)2);
                media.setInformarValor(Short.valueOf((short)0));
                media.setReferencia(Double.valueOf(referenciaPadrao * avos));
                media.setTipoEvento(Short.valueOf(EnumConstEventoMedias.MEDIA_REFERENCIA.getValue()));
            }
            media.setTpCalculo(evt.getTipoCalculoEvento());
            media.setSalario13Colaborador(vo);
            media.setTipoRemuneracao(Short.valueOf((short)0));
            media.setValor(valor);
            media.setValorOriginal(valor);
            return media;
        }
        return null;
    }

    public void itensLancamentosPagamentoDecimoTerceiro(Salario13oColaborador vo, Double percCalculo, TipoCalculoEvento eventoPagDecimoTerceiro, TipoCalculoEvento maternidade) throws ExceptionService {
        Double valorItem;
        boolean achouAddDec = false;
        for (ItemMovimentoFolhaDec item : vo.getItemMovimentoFolha()) {
            if (!item.getEventoColaborador().getTipoCalculoEvento().getEvento().getCodigo().equals(1010L)) continue;
            if (item.getInformarValor().equals((short)0)) {
                Double salarioNominal = new Double(UtilCalculoPagamentoDecimoTerceiro.getSalarioNominal(vo.getColaborador(), vo.getDataPagamento()));
                valorItem = ContatoFormatUtil.arrredondarNumero((Double)(salarioNominal / 12.0 * (double)vo.getNrAvos().intValue() * (percCalculo / 100.0)), (int)2);
                if (valorItem.isInfinite() || valorItem.isNaN()) {
                    valorItem = 0.0;
                }
                item.setValor(valorItem);
            }
            achouAddDec = true;
            break;
        }
        if (!achouAddDec) {
            EventoColaborador evtC = this.createEventoColaborador13o(eventoPagDecimoTerceiro, vo);
            Double salarioNominal = new Double(UtilCalculoPagamentoDecimoTerceiro.getSalarioNominal(vo.getColaborador(), vo.getDataPagamento()));
            Double referencia = vo.getNrAvos().doubleValue();
            ItemMovimentoFolhaDec item = this.createItemMovimentoFolha(evtC, 0.0, referencia, (short)0, vo);
            Object valorItem2 = ContatoFormatUtil.arrredondarNumero((Double)(salarioNominal / 12.0 * (double)vo.getNrAvos().intValue() * (percCalculo / 100.0)), (int)2);
            if (((Double)valorItem2).isInfinite() || ((Double)valorItem2).isNaN()) {
                valorItem2 = 0.0;
            }
            item.setValor((Double)valorItem2);
            vo.getItemMovimentoFolha().add(item);
        }
        Double valorMediaMaternidade = 0.0;
        for (Media13oSalarioColaborador media : vo.getMedia13salario()) {
            Double valorItem3;
            ItemMovimentoFolhaDec item2;
            boolean achouMedia = false;
            for (ItemMovimentoFolhaDec item2 : vo.getItemMovimentoFolha()) {
                if (!media.getTpCalculo().getIdentificador().equals(item2.getEventoColaborador().getTipoCalculoEvento().getIdentificador())) continue;
                if (item2.getInformarValor().equals((short)0)) {
                    valorItem3 = ContatoFormatUtil.arrredondarNumero((Double)(media.getValor() / (double)vo.getNrAvos().intValue() / 12.0 * (double)vo.getNrAvos().intValue() * (percCalculo / 100.0)), (int)2);
                    if (valorItem3.isInfinite() || valorItem3.isNaN()) {
                        valorItem3 = 0.0;
                    }
                    item2.setValor(valorItem3);
                    valorMediaMaternidade = valorMediaMaternidade + media.getValor();
                    item2.setReferencia(media.getReferencia());
                }
                achouMedia = true;
                break;
            }
            if (achouMedia) continue;
            EventoColaborador evtC = this.createEventoColaborador13o(media.getTpCalculo(), vo);
            item2 = this.createItemMovimentoFolha(evtC, 0.0, 0.0, (short)0, vo);
            valorItem3 = ContatoFormatUtil.arrredondarNumero((Double)(media.getValor() / (double)vo.getNrAvos().intValue() / 12.0 * (double)vo.getNrAvos().intValue() * (percCalculo / 100.0)), (int)2);
            if (valorItem3.isInfinite() || valorItem3.isNaN()) {
                valorItem3 = 0.0;
            }
            item2.setValor(valorItem3);
            valorMediaMaternidade = valorMediaMaternidade + media.getValor();
            item2.setReferencia(media.getReferencia());
            vo.getItemMovimentoFolha().add(item2);
        }
        if (vo.getNrAvosMaternidade() > 0) {
            if (maternidade != null) {
                EventoColaborador evtC = this.createEventoColaborador13o(maternidade, vo);
                ItemMovimentoFolhaDec item = this.createItemMovimentoFolha(evtC, 0.0, 0.0, (short)0, vo);
                valorItem = ContatoFormatUtil.arrredondarNumero((Double)((vo.getSalarioNominal() + valorMediaMaternidade / (double)vo.getNrAvos().intValue()) / 365.0 * (double)vo.getNrAvosMaternidade().intValue() * (percCalculo / 100.0)), (int)2);
                if (valorItem.isInfinite() || valorItem.isNaN()) {
                    valorItem = 0.0;
                }
                item.setValor(valorItem);
                item.setReferencia(Double.valueOf(vo.getNrAvosMaternidade().doubleValue()));
                vo.getItemMovimentoFolha().add(item);
            } else {
                throw new ExceptionService("Evento de Maternidade Pago pela Previdencia, n\u00e3o parametrizado na Empresa Rh");
            }
        }
    }

    public void itensLancamentosAdiantamentoDecimoTerceiro(Salario13oColaborador vo, Double percCalculo) throws ExceptionService {
        Double valorItem;
        if (vo.getColaborador().getNumeroRegistro().equals("328")) {
            // empty if block
        }
        boolean achouAddDec = false;
        for (ItemMovimentoFolhaDec item : vo.getItemMovimentoFolha()) {
            if (!item.getEventoColaborador().getTipoCalculoEvento().getEvento().getCodigo().equals(1009L)) continue;
            if (item.getInformarValor().equals((short)0)) {
                Double salarioNominal = new Double(UtilCalculoPagamentoDecimoTerceiro.getSalarioNominal(vo.getColaborador(), vo.getDataPagamento()));
                Double referencia = vo.getNrAvos().doubleValue();
                valorItem = ContatoFormatUtil.arrredondarNumero((Double)(salarioNominal / 12.0 * (double)vo.getNrAvos().intValue() * (percCalculo / 100.0)), (int)2);
                item.setValor(valorItem);
                item.setReferencia(referencia);
            }
            achouAddDec = true;
            break;
        }
        if (!achouAddDec) {
            EventoColaborador evtC = this.createEventoColaborador13o(this.getEventoAddDecimoTerceiro(), vo);
            Double salarioNominal = new Double(UtilCalculoPagamentoDecimoTerceiro.getSalarioNominal(vo.getColaborador(), vo.getDataPagamento()));
            Double referencia = vo.getNrAvos().doubleValue();
            ItemMovimentoFolhaDec item = this.createItemMovimentoFolha(evtC, 0.0, referencia, (short)0, vo);
            item.setSalarioDec(vo);
            valorItem = ContatoFormatUtil.arrredondarNumero((Double)(salarioNominal / 12.0 * (double)vo.getNrAvos().intValue() * (percCalculo / 100.0)), (int)2);
            item.setValor(valorItem);
            item.setReferencia(referencia);
            vo.getItemMovimentoFolha().add(item);
        }
        for (Media13oSalarioColaborador media : vo.getMedia13salario()) {
            Double valorItem2;
            ItemMovimentoFolhaDec item2;
            boolean achouMedia = false;
            for (ItemMovimentoFolhaDec item2 : vo.getItemMovimentoFolha()) {
                if (!media.getTpCalculo().getIdentificador().equals(item2.getEventoColaborador().getTipoCalculoEvento().getIdentificador())) continue;
                if (item2.getInformarValor().equals((short)0)) {
                    valorItem2 = ContatoFormatUtil.arrredondarNumero((Double)(media.getValor() / (double)vo.getNrAvos().intValue() / 12.0 * (double)vo.getNrAvos().intValue() * (percCalculo / 100.0)), (int)2);
                    item2.setValor(valorItem2);
                    item2.setReferencia(media.getReferencia());
                }
                achouMedia = true;
                break;
            }
            if (achouMedia) continue;
            EventoColaborador evtC = this.createEventoColaborador13o(media.getTpCalculo(), vo);
            item2 = this.createItemMovimentoFolha(evtC, 0.0, 0.0, (short)0, vo);
            valorItem2 = ContatoFormatUtil.arrredondarNumero((Double)(media.getValor() / (double)vo.getNrAvos().intValue() / 12.0 * (double)vo.getNrAvos().intValue() * (percCalculo / 100.0)), (int)2);
            item2.setValor(valorItem2);
            item2.setReferencia(media.getReferencia());
            vo.getItemMovimentoFolha().add(item2);
        }
    }

    public EventoColaborador createEventoColaborador13o(TipoCalculoEvento tipoCalculo, Salario13oColaborador sal13) {
        EventoColaborador e = new EventoColaborador();
        e.setColaborador(sal13.getColaborador());
        e.setTipoCalculoEvento(tipoCalculo);
        e.setDataInicial(this.setDataInicial(sal13.getDataPagamento()));
        e.setDataFinal(this.setDataFinal(sal13.getDataPagamento()));
        e.setValor(Double.valueOf(0.0));
        e.setTipoOcorrencia(EnumConstTipoOcorrenciaEvtColaborador.TP_OCORRENCIA_ESPECIFICAMENTE_PERIODO.getEnumId());
        e.setAtivo(Short.valueOf((short)0));
        return e;
    }

    private Date setDataInicial(Date data) {
        GregorianCalendar aux = new GregorianCalendar();
        aux.setTime(data);
        aux.set(5, aux.getMinimum(5));
        return aux.getTime();
    }

    private Date setDataFinal(Date data) {
        GregorianCalendar aux = new GregorianCalendar();
        aux.setTime(data);
        aux.set(5, aux.getMaximum(5));
        return aux.getTime();
    }

    private TipoCalculoEvento getEventoDescontoAddDecimoTerceiro() throws ExceptionService {
        TipoCalculoEvento tp = (TipoCalculoEvento)CoreBdUtil.getInstance().getSession().createQuery("from TipoCalculoEvento tp where tp.evento.codigo = 1011").list().get(0);
        if (tp == null) {
            throw new ExceptionService("Erro ao Calcular Desconto Adiantamento de Decimo Terceiro. Entre em contato com o Suporte T\u00e9cnico.");
        }
        return tp;
    }

    private TipoCalculoEvento getEventoAddDecimoTerceiro() throws ExceptionService {
        TipoCalculoEvento tp = (TipoCalculoEvento)CoreBdUtil.getInstance().getSession().createQuery("from TipoCalculoEvento tp where tp.evento.codigo = 1009").list().get(0);
        if (tp == null) {
            throw new ExceptionService("Erro ao Calcular Adiantamento de Decimo Terceiro. Entre em contato com o Suporte T\u00e9cnico.");
        }
        return tp;
    }

    public ItemMovimentoFolhaDec createItemMovimentoFolha(EventoColaborador e, Double valorItem, Double referencia, Short informarValor, Salario13oColaborador vo) {
        ItemMovimentoFolhaDec i = new ItemMovimentoFolhaDec();
        i.setValor(valorItem);
        i.setReferencia(referencia);
        i.setInformarValor(informarValor);
        i.setEventoColaborador(e);
        i.setSalarioDec(vo);
        return i;
    }

    public void lancamentoAdiantamentoDecimoTerceiro(Salario13oColaborador vo, Integer ano, Long arredAnt, Long arredProx) throws ExceptionService {
        boolean achou = false;
        Double valorDesconto = this.findValorDescontoAdiantamentoDecimoTerceiro(vo.getColaborador(), ano, arredAnt, arredProx);
        if (valorDesconto > 0.0) {
            for (ItemMovimentoFolhaDec item : vo.getItemMovimentoFolha()) {
                if (!item.getEventoColaborador().getTipoCalculoEvento().getEvento().getCodigo().equals(1011L)) continue;
                item.setValor(valorDesconto);
                achou = true;
                break;
            }
            if (!achou) {
                ItemMovimentoFolhaDec item;
                EventoColaborador e = this.createEventoColaborador13o(this.getEventoDescontoAddDecimoTerceiro(), vo);
                item = this.createItemMovimentoFolha(e, valorDesconto, 0.0, (short)0, vo);
                vo.getItemMovimentoFolha().add(item);
            }
        }
    }

    public Double findValorDescontoAdiantamentoDecimoTerceiro(Colaborador colaborador, Integer ano, Long arredAnt, Long arredProx) {
        Double valorDesconto = 0.0;
        Double resultado = 0.0;
        String hql = " select sum(item.valor) as VALOR, item.eventoColaborador.tipoCalculoEvento.evento.tipoEvento as TIPO_EVENTO from ItemMovimentoFolha item  where  item.movimentoFolha.colaborador.identificador = :idColaborador  and  item.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :addDec  and  extract(year from item.movimentoFolha.aberturaPeriodo.dataInicio) = :ano  and  item.eventoColaborador.tipoCalculoEvento.evento.codigo != :arredAnt  and  item.eventoColaborador.tipoCalculoEvento.evento.codigo != :arredProx  group by item.eventoColaborador.tipoCalculoEvento.evento.tipoEvento ";
        List hash = CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("idColaborador", colaborador.getIdentificador().longValue()).setShort("addDec", EnumConstTipoCalculoEvento.CALCULO_ADIANTAMENTO_13O.getValue().shortValue()).setInteger("ano", ano.intValue()).setLong("arredAnt", arredAnt.longValue()).setLong("arredProx", arredProx.longValue()).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        hql = " select sum(coalesce(item.valor,0))  from ItemMovimentoFolha item  where  item.eventoColaborador.tipoCalculoEvento.evento.codigo = 1009  and  item.movimentoFolha.colaborador = :colaborador  and  item.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento  and  extract(year from item.movimentoFolha.aberturaPeriodo.dataInicio) = :ano ";
        valorDesconto = (Double)CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setShort("folhaPagamento", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue()).setInteger("ano", ano.intValue()).uniqueResult();
        if (valorDesconto == null) {
            valorDesconto = 0.0;
        }
        if (hash != null) {
            Double valorProvento = 0.0;
            Double valorDescontoEvento = 0.0;
            for (Object obj : hash) {
                HashMap h = (HashMap)obj;
                if (h.get("TIPO_EVENTO").equals(EnumConstEventoParamFolha.EVENTO_DESCONTO.getValue())) {
                    valorDescontoEvento = (Double)h.get("VALOR");
                    continue;
                }
                valorProvento = (Double)h.get("VALOR");
            }
            resultado = valorProvento - valorDescontoEvento;
        }
        return ContatoFormatUtil.arrredondarNumero((Double)(resultado + valorDesconto), (int)2);
    }

    private Double getTipoReferencia(Evento evento, Colaborador colaborador) {
        if (evento.getTipoReferenciaPadrao().equals(EnumConstEventoTipoReferenciaPadrao.REFERENCIA_VALOR.getValue())) {
            return evento.getValorReferenciaPadrao();
        }
        if (evento.getTipoReferenciaPadrao().equals(EnumConstEventoTipoReferenciaPadrao.REFERENCIA_DIAS_HORA_JORNADA.getValue())) {
            if (colaborador.getTipoSalario().getCodigo().equals("1")) {
                return colaborador.getDiasJornada();
            }
            return colaborador.getHorasTrabDia() * colaborador.getDiasJornada();
        }
        return 0.0;
    }

    private Double getAvosDecimoTerceiro(EventoColaborador evt, Date primeiroJaneiro, Date trintaUmDezembro) {
        if (evt.getDataInicial().before(primeiroJaneiro) && (evt.getDataFinal() == null || evt.getDataFinal().after(trintaUmDezembro))) {
            return 12.0;
        }
        if (evt.getDataInicial().after(primeiroJaneiro) && evt.getDataFinal() != null && evt.getDataFinal().before(trintaUmDezembro)) {
            return this.avos(evt.getDataInicial(), evt.getDataFinal());
        }
        if (evt.getDataInicial().before(primeiroJaneiro) && evt.getDataFinal() != null && evt.getDataFinal().before(trintaUmDezembro)) {
            return this.avos(primeiroJaneiro, evt.getDataFinal());
        }
        if (evt.getDataInicial().after(primeiroJaneiro) && (evt.getDataFinal() == null || evt.getDataFinal().after(trintaUmDezembro))) {
            return this.avos(evt.getDataInicial(), trintaUmDezembro);
        }
        return 0.0;
    }

    private Double avos(Date dataInicial, Date dataFinal) {
        Integer avos = DateUtil.monthFromDate(dataFinal) - DateUtil.monthFromDate(dataInicial) + 1;
        return avos.doubleValue();
    }

    private boolean existeMedia(Salario13oColaborador vo, EventoColaborador evt, List medias, Date primeiroJaneiro, Date trintaUmDezembro) throws ExceptionService {
        Double valor = 0.0;
        Double avos = this.getAvosDecimoTerceiro(evt, primeiroJaneiro, trintaUmDezembro);
        Double referenciaPadrao = this.getTipoReferencia(evt.getTipoCalculoEvento().getEvento(), vo.getColaborador());
        for (Object obj : medias) {
            Media13oSalarioColaborador media = (Media13oSalarioColaborador)obj;
            if (!media.getTpCalculo().equals((Object)evt.getTipoCalculoEvento())) continue;
            if (evt.getValor() > 0.0) {
                valor = ContatoFormatUtil.arrredondarNumero((Double)(evt.getValor() * avos), (int)2);
                media.setInformarValor(Short.valueOf((short)1));
                media.setReferencia(Double.valueOf(0.0));
                media.setTipoEvento(Short.valueOf(EnumConstEventoMedias.MEDIA_VALOR.getValue()));
            } else {
                valor = this.calcularEventoDecimoTerceiro(vo, evt.getTipoCalculoEvento().getEvento(), referenciaPadrao, primeiroJaneiro, trintaUmDezembro);
                valor = ContatoFormatUtil.arrredondarNumero((Double)(valor * avos), (int)2);
                media.setInformarValor(Short.valueOf((short)0));
                media.setReferencia(Double.valueOf(referenciaPadrao * avos));
                media.setTipoEvento(Short.valueOf(EnumConstEventoMedias.MEDIA_REFERENCIA.getValue()));
            }
            media.setTpCalculo(evt.getTipoCalculoEvento());
            media.setSalario13Colaborador(vo);
            media.setTipoRemuneracao(Short.valueOf((short)0));
            media.setValor(valor);
            media.setValorOriginal(valor);
            return true;
        }
        return false;
    }
}

