/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.atestado;

import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.rh.calculofolha.CalculoFolhaPagamentoUtilities;

public class UtilLancamentoAtestado {
    public HashMap findAtestadoPorPeriodo(MovimentoFolha vo, TipoCalculoEvento tpAtestadoDia, TipoCalculoEvento tpAtestadoHora) throws ExceptionService {
        String hql = " from LancamentoAtestado atestado  where  atestado.colaborador = :colaborador  and  atestado.integradoFolha = :nao  and  (atestado.inicioAtestado >= :dataInicio  or  atestado.fimAtestado <= :dataFinal)  and  atestado.referenciaAtestado = :dia ";
        List results = new ArrayList();
        results = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)vo.getColaborador()).setDate("dataInicio", vo.getAberturaPeriodo().getDataInicio()).setDate("dataFinal", vo.getAberturaPeriodo().getDataFinal()).setShort("dia", (short)2).setShort("nao", (short)0).list();
        if (results != null && !results.isEmpty()) {
            return this.setarReferenciaAtestado(results, vo.getAberturaPeriodo().getDataInicio(), vo.getAberturaPeriodo().getDataFinal(), vo);
        }
        return null;
    }

    private HashMap setarReferenciaAtestado(List results, Date dataInicioAbertura, Date dataFinalAbertura, MovimentoFolha vo) throws ExceptionService {
        return null;
    }

    private HashMap createHashDiasAtestado() {
        HashMap<String, Double> hash = new HashMap<String, Double>();
        hash.put("UTEIS_DIA", 0.0);
        hash.put("FERIADO_DIA", 0.0);
        hash.put("FOLGA_DIA", 0.0);
        hash.put("UTEIS_HORAS", 0.0);
        hash.put("FERIADO_HORAS", 0.0);
        hash.put("FOLGA_HORAS", 0.0);
        hash.put("TOTAL_DIA_ATESTADO", 0.0);
        hash.put("TOTAL_HORAS_ATESTADO", 0.0);
        return hash;
    }

    private void verificarDiasIntervalo(HashMap hashDiasAtestado, Date inicioAtestado, Date finalAtestado, Long idEmpresa) throws ExceptionService {
        Double folgas = 0.0;
        Double feriados = 0.0;
        Double uteis = 0.0;
        Double auxFeriados = 0.0;
        Double auxUteis = 0.0;
        HashMap hashRetorno = new CalculoFolhaPagamentoUtilities().findDiasPeriodoApuracao(inicioAtestado, finalAtestado, idEmpresa, "ATESTADO");
        folgas = (Double)hashRetorno.get("DIAS_FOLGA");
        uteis = (Double)hashRetorno.get("DIAS_UTEIS");
        feriados = (Double)hashRetorno.get("DIAS_FERIADOS");
        auxUteis = (Double)hashDiasAtestado.get("UTEIS_DIA");
        Double auxFolgas = (Double)hashDiasAtestado.get("FOLGA_DIA");
        auxFeriados = (Double)hashDiasAtestado.get("FERIADO_DIA");
        hashDiasAtestado.put("UTEIS_DIA", uteis + auxUteis);
        hashDiasAtestado.put("FOLGA_DIA", folgas + auxFolgas);
        hashDiasAtestado.put("FERIADO_DIA", feriados + auxFeriados);
    }

    private void verificarDiaAtestadoHora(HashMap hashDiasAtestado, Timestamp inicioAtestado, Long idEmpresa) throws ExceptionService {
        Double folgas = 0.0;
        Double feriados = 0.0;
        Double uteis = 0.0;
        Double auxFeriados = 0.0;
        Double auxUteis = 0.0;
        HashMap hashRetorno = new CalculoFolhaPagamentoUtilities().findDiasPeriodoApuracao(inicioAtestado, inicioAtestado, idEmpresa, "ATESTADO");
        folgas = (Double)hashRetorno.get("DIAS_FOLGA");
        uteis = (Double)hashRetorno.get("DIAS_UTEIS");
        feriados = (Double)hashRetorno.get("DIAS_FERIADOS");
        auxUteis = (Double)hashDiasAtestado.get("UTEIS_HORAS");
        Double auxFolgas = (Double)hashDiasAtestado.get("FOLGA_HORAS");
        auxFeriados = (Double)hashDiasAtestado.get("FERIADO_HORAS");
        hashDiasAtestado.put("UTEIS_HORAS", uteis + auxUteis);
        hashDiasAtestado.put("FOLGA_HORAS", folgas + auxFolgas);
        hashDiasAtestado.put("FERIADO_HORAS", feriados + auxFeriados);
    }

    private void consolidacaoDias(HashMap hashDiasAtestado, MovimentoFolha vo) throws ExceptionService {
        HashMap hashAfastamento;
        Double uteisDia = 0.0;
        Double uteisHora = 0.0;
        Double folgasDia = 0.0;
        Double folgasHora = 0.0;
        Double feriadosDia = 0.0;
        Double feriadosHora = 0.0;
        Double diasFolgasFerias = 0.0;
        Double diasFeriadosFerias = 0.0;
        Double diasUteisFerias = 0.0;
        Double diasFolgasMaternidade = 0.0;
        Double diasFeriadosMaternidade = 0.0;
        Double diasUteisMaternidade = 0.0;
        Double diasUteisAfastamento = 0.0;
        Double diasFolgasAfastamento = 0.0;
        Double diasFeriadosAfastamento = 0.0;
        Double diasFolgasSegundaFerias = 0.0;
        Double diasFeriadosSegundaFerias = 0.0;
        Double diasUteisSegundaFerias = 0.0;
        Double uteisSegundoAfastamento = 0.0;
        Double feriadosSegundoAfastamento = 0.0;
        Double folgasSegundoAfastamento = 0.0;
        uteisDia = (Double)hashDiasAtestado.get("UTEIS_DIA");
        feriadosDia = (Double)hashDiasAtestado.get("FERIADO_DIA");
        folgasDia = (Double)hashDiasAtestado.get("FOLGA_DIA");
        uteisHora = (Double)hashDiasAtestado.get("UTEIS_HORAS");
        feriadosHora = (Double)hashDiasAtestado.get("FERIADO_HORAS");
        folgasHora = (Double)hashDiasAtestado.get("FOLGA_HORAS");
        HashMap hash = new CalculoFolhaPagamentoUtilities().findDiasPeriodoApuracao(vo.getAberturaPeriodo().getDataInicio(), vo.getAberturaPeriodo().getDataFinal(), vo.getEmpresa().getIdentificador(), "ATESTADO");
        Double diasFolgas = (Double)hash.get("DIAS_FOLGA");
        Double diasUteis = (Double)hash.get("DIAS_UTEIS");
        Double diasFeriados = (Double)hash.get("DIAS_FERIADOS");
        if (vo.getDataInicialAfastamento() != null && vo.getDataFinalAfastamento() != null) {
            hashAfastamento = new CalculoFolhaPagamentoUtilities().findDiasPeriodoApuracao(vo.getDataInicialAfastamento(), vo.getDataFinalAfastamento(), vo.getEmpresa().getIdentificador(), "ATESTADO");
            diasFolgasAfastamento = (Double)hashAfastamento.get("DIAS_FOLGA");
            diasUteisAfastamento = (Double)hashAfastamento.get("DIAS_UTEIS");
            diasFeriadosAfastamento = (Double)hashAfastamento.get("DIAS_FERIADOS");
        }
        if (vo.getDataInicialSegundoAfastamento() != null && vo.getDataFinalSegundoAfastamento() != null) {
            hashAfastamento = new CalculoFolhaPagamentoUtilities().findDiasPeriodoApuracao(vo.getDataInicialSegundoAfastamento(), vo.getDataFinalSegundoAfastamento(), vo.getEmpresa().getIdentificador(), "ATESTADO");
            folgasSegundoAfastamento = (Double)hashAfastamento.get("DIAS_FOLGA");
            uteisSegundoAfastamento = (Double)hashAfastamento.get("DIAS_UTEIS");
            feriadosSegundoAfastamento = (Double)hashAfastamento.get("DIAS_FERIADOS");
        }
        if (vo.getDataInicialFerias() != null && vo.getDataFinalFerias() != null) {
            HashMap hashFerias = new CalculoFolhaPagamentoUtilities().findDiasPeriodoApuracao(vo.getDataInicialFerias(), vo.getDataFinalFerias(), vo.getEmpresa().getIdentificador(), "ATESTADO");
            diasFolgasFerias = (Double)hashFerias.get("DIAS_FOLGA");
            diasUteisFerias = (Double)hashFerias.get("DIAS_UTEIS");
            diasFeriadosFerias = (Double)hashFerias.get("DIAS_FERIADOS");
        }
        if (vo.getDataInicialSegundaFerias() != null && vo.getDataFinalSegundaFerias() != null) {
            HashMap hashSegundaFerias = new CalculoFolhaPagamentoUtilities().findDiasPeriodoApuracao(vo.getDataInicialSegundaFerias(), vo.getDataFinalSegundaFerias(), vo.getEmpresa().getIdentificador(), "FERIAS");
            diasFolgasSegundaFerias = (Double)hashSegundaFerias.get("DIAS_FOLGA");
            diasUteisSegundaFerias = (Double)hashSegundaFerias.get("DIAS_UTEIS");
            diasFeriadosSegundaFerias = (Double)hashSegundaFerias.get("DIAS_FERIADOS");
        }
        if (vo.getDataInicialMaternidade() != null && vo.getDataFinalMaternidade() != null) {
            HashMap hashMaternidade = new CalculoFolhaPagamentoUtilities().findDiasPeriodoApuracao(vo.getDataInicialMaternidade(), vo.getDataFinalMaternidade(), vo.getEmpresa().getIdentificador(), "ATESTADO");
            diasFolgasMaternidade = (Double)hashMaternidade.get("DIAS_FOLGA");
            diasUteisMaternidade = (Double)hashMaternidade.get("DIAS_UTEIS");
            diasFeriadosMaternidade = (Double)hashMaternidade.get("DIAS_FERIADOS");
        }
        diasUteis = diasUteis - (uteisDia + uteisHora + diasUteisAfastamento + diasUteisFerias + diasUteisMaternidade + diasUteisSegundaFerias + uteisSegundoAfastamento);
        diasFolgas = diasFolgas - (folgasDia + folgasHora + diasFolgasAfastamento + diasFolgasFerias + diasFolgasMaternidade + diasFolgasSegundaFerias + folgasSegundoAfastamento);
        diasFeriados = diasFeriados - (feriadosDia + feriadosHora + diasFeriadosAfastamento + diasFeriadosFerias + diasFeriadosMaternidade + diasFeriadosSegundaFerias + feriadosSegundoAfastamento);
        if (vo.getColaborador().getTipoSalario().getCodigo().equals("1")) {
            Double resumoDiasPeriodo = vo.getDiasAfastamentos() + vo.getDiasAfastamentoMaternidade() + vo.getDiasFerias() + diasFeriados + diasFolgas + diasUteis + uteisDia + folgasDia + feriadosDia;
            if (resumoDiasPeriodo > 30.0) {
                if (diasUteis > 0.0) {
                    diasUteis = diasUteis - 1.0;
                } else if (diasFolgas > 0.0) {
                    diasFolgas = diasFolgas - 1.0;
                } else {
                    diasFeriados = diasFeriados - 1.0;
                }
            }
            vo.setDiasFolgas(diasFolgas);
            vo.setDiasFeriados(diasFeriados);
            vo.setDiasTrabalhados(diasUteis);
        } else {
            vo.setDiasFolgas(Double.valueOf(diasFolgas * vo.getColaborador().getHorasTrabDia()));
            vo.setDiasFeriados(Double.valueOf(diasFeriados * vo.getColaborador().getHorasTrabDia()));
            vo.setDiasTrabalhados(Double.valueOf(diasUteis * vo.getColaborador().getHorasTrabDia()));
        }
    }
}

