/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.beneficiova;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FornecedoraTicketAlimentacao;
import com.touchcomp.basementor.model.vo.GeracaoArquivoVA;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.rh.beneficiova.UtilityFechamentoBeneficioVA;
import mentorcore.service.impl.rh.beneficiova.UtilityGeracaoArquivoVASA;
import mentorcore.service.impl.rh.beneficiova.UtilityGeracaoArquivoVAVR;

public class ServiceFechamentoBeneficioVA
extends CoreService {
    public static final String PROCESSAR_BENEFICIO_VA = "processarBeneficioVA";
    public static final String BUSCA_PERSONALIZADA_VA = "buscaPersonalizadaVA";
    public static final String GERAR_ARQUIVO_FECHAMENTO_VA = "gerarArquivoFechamentoVA";
    public static final String FIND_BENEFICIOS_GERACAO_VA = "findBeneficiosGeracaoVA";

    public Object processarBeneficioVA(CoreRequestContext request) throws ExceptionService {
        Date dataInicioPonto = (Date)request.getAttribute("dataInicioPonto");
        Date dataFinalPonto = (Date)request.getAttribute("dataFinalPonto");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        Date periodoFolhaInicial = (Date)request.getAttribute("periodoFolhaInicial");
        Date periodoFolhaFinal = (Date)request.getAttribute("periodoFolhaFinal");
        return new UtilityFechamentoBeneficioVA().processarPagamentoBeneficioVA(dataInicioPonto, dataFinalPonto, empresa, periodoFolhaInicial, periodoFolhaFinal);
    }

    public List buscaPersonalizadaVA(CoreRequestContext request) throws ExceptionService {
        List colaboradores = (List)request.getAttribute("colaboradores");
        Date periodoInicial = (Date)request.getAttribute("inicioApuracao");
        Date periodoFinal = (Date)request.getAttribute("finalApuracao");
        Date periodoInicialPonto = (Date)request.getAttribute("dataInicio");
        Date periodoFinalPonto = (Date)request.getAttribute("dataFinal");
        return new UtilityFechamentoBeneficioVA().calcularBeneficioPersonalizado(colaboradores, periodoInicial, periodoFinal, periodoInicialPonto, periodoFinalPonto);
    }

    public void gerarArquivoFechamentoVA(CoreRequestContext request) throws IOException, ExceptionService {
        File arquivo = (File)request.getAttribute("arquivo");
        GeracaoArquivoVA vo = (GeracaoArquivoVA)request.getAttribute("vo");
        Usuario usuario = (Usuario)request.getAttribute("usuario");
        if (ToolString.refina((String)vo.getFornecedorTicket().getPessoa().getComplemento().getCnpj()).equals("47866934000174")) {
            if (vo.getNumeroConvenio() == null || vo.getNumeroConvenio().length() < 1) {
                throw new ExceptionService("Informe o numero do Convenio");
            }
            new UtilityGeracaoArquivoVASA().geracaoArquivoFechamentoVA(arquivo, vo, usuario);
        } else {
            new UtilityGeracaoArquivoVAVR().geracaoArquivoFechamentoVA(arquivo, vo);
        }
    }

    public List findBeneficiosGeracaoVA(CoreRequestContext r) throws ExceptionService {
        Empresa empresa = (Empresa)r.getAttribute("empresa");
        Date periodo = (Date)r.getAttribute("periodo");
        Short todasEmpresa = (Short)r.getAttribute("todasEmpresas");
        Short tipoArquivo = (Short)r.getAttribute("tipoArquivo");
        Date dataAgendamento = (Date)r.getAttribute("dataAgendamento");
        Short grupo = (Short)r.getAttribute("grupo");
        FornecedoraTicketAlimentacao fornecedora = (FornecedoraTicketAlimentacao)r.getAttribute("fornecedora");
        return new UtilityGeracaoArquivoVAVR().buscarBeneficiosVA(empresa, todasEmpresa, tipoArquivo, periodo, grupo, fornecedora);
    }
}

