/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.beneficiova;

import com.touchcomp.basementor.model.vo.AfastamentoColaborador;
import com.touchcomp.basementor.model.vo.CadastroBeneficioRefeicaoCesta;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FeriasColaborador;
import com.touchcomp.basementor.model.vo.HorarioTrabalho;
import com.touchcomp.basementor.model.vo.InfoHorarioTrabalho;
import contatocore.util.ContatoFormatUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.tools.DateUtil;

public class UtilityFechamentoBeneficioVA {
    public List processarPagamentoBeneficioVA(Date dataInicioPonto, Date dataFinalPonto, Empresa empresa, Date periodoFolhaInicial, Date periodoFolhaFinal) throws ExceptionService {
        String hql = " select distinct beneficio  from CadastroBeneficioRefeicaoCesta beneficio  where  beneficio.colaborador.empresa = :empresa   and  (beneficio.colaborador.dataDemissao is null or beneficio.colaborador.dataDemissao > :dataInicialFolha)  and  beneficio.colaborador.ativo = :sim  and  not exists ( select af.colaborador               from AfastamentoColaborador af  where  af.dataAfastamento != null  and               af.colaborador = beneficio.colaborador               and               af.afastamentoSefip.codigo != :aposentadoria               and               af.dataAfastamento < :dataInicio               and               (af.dataRetorno is null or af.dataRetorno > :dataFinal))  and  not exists  (from CadastroBeneficioRefeicaoCesta ben               where ben.colaborador = beneficio.colaborador               and ben.periodoBeneficio > beneficio.periodoBeneficio)";
        List ret = CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("dataInicio", periodoFolhaInicial).setDate("dataFinal", periodoFolhaFinal).setDate("dataInicialFolha", periodoFolhaInicial).setString("aposentadoria", "U1").setEntity("empresa", (Object)empresa).setShort("sim", (short)1).list();
        ArrayList list = new ArrayList();
        for (Object object : ret) {
            CadastroBeneficioRefeicaoCesta cadBeneficio = (CadastroBeneficioRefeicaoCesta)object;
            HashMap<String, Object> newHash = new HashMap<String, Object>();
            newHash.put("CAD_BENEFICIO", cadBeneficio);
            if (cadBeneficio.getDiasApuracaoVA() <= 0.0) {
                Date dataFinalAux = null;
                dataFinalAux = cadBeneficio.getColaborador().getDataDemissao() != null && cadBeneficio.getColaborador().getDataDemissao().before(periodoFolhaFinal) ? cadBeneficio.getColaborador().getDataDemissao() : periodoFolhaFinal;
                this.getDiasApuracaoVale(newHash, cadBeneficio, periodoFolhaInicial, dataFinalAux, dataInicioPonto, dataFinalPonto);
            } else {
                newHash.put("DIAS_A_PAGAR", cadBeneficio.getDiasApuracaoVA());
                newHash.put("DIAS_COMPETENCIA", cadBeneficio.getDiasApuracaoVA());
            }
            list.add(newHash);
        }
        return list;
    }

    private void getDiasApuracaoVale(HashMap hash, CadastroBeneficioRefeicaoCesta cadBeneficio, Date inicioApuracao, Date finalApuracao, Date inicioApuracaoPonto, Date finalApuracaoPonto) throws ExceptionService {
        Double referenciaGeral = 0.0;
        Double diasFerias = 0.0;
        Double diasAfastados = 0.0;
        Double diasDesconto = 0.0;
        System.out.println(cadBeneficio.getColaborador().toString());
        Colaborador colaborador = cadBeneficio.getColaborador();
        if (colaborador.getHorarioTrabalho().getEsocCadastroHorario() == null) {
            throw new ExceptionService("Verifique o cadastro do Horario: " + colaborador.getHorarioTrabalho().getIdentificador() + " do colaborador: " + colaborador.toString());
        }
        if (colaborador == null || colaborador.getHorarioTrabalho() == null || colaborador.getHorarioTrabalho().getTurnoDeTrabalho() == null) {
            hash.put("DIAS_A_PAGAR", 0.0);
        }
        System.err.println(colaborador);
        if (colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)0)) {
            referenciaGeral = this.calcularReferenciaJornadaSemanal(cadBeneficio, inicioApuracao, finalApuracao);
            if (colaborador.getLocalTrabalhoColaboradorCidade().getLocalTrabalhoColaborador().getEfetuaPagamentoCestaFerias().equals((short)0)) {
                diasFerias = this.getDiasFerias(cadBeneficio, inicioApuracao, finalApuracao);
            }
            diasAfastados = this.getDiasAfastamentos(cadBeneficio, inicioApuracao, finalApuracao);
        }
        if (colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)1)) {
            referenciaGeral = this.calcularReferenciaJornadaRevezamento(colaborador, inicioApuracao, finalApuracao);
            if (colaborador.getLocalTrabalhoColaboradorCidade().getLocalTrabalhoColaborador().getEfetuaPagamentoCestaFerias().equals((short)0)) {
                diasFerias = this.getDiasFerias(cadBeneficio, inicioApuracao, finalApuracao);
            }
            diasAfastados = this.getDiasAfastamentos(cadBeneficio, inicioApuracao, finalApuracao);
        }
        if (colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)2)) {
            referenciaGeral = this.calcularReferenciaJornada1236(colaborador, inicioApuracao, finalApuracao);
            if (colaborador.getLocalTrabalhoColaboradorCidade().getLocalTrabalhoColaborador().getEfetuaPagamentoCestaFerias().equals((short)0)) {
                diasFerias = this.getDiasFerias(cadBeneficio, inicioApuracao, finalApuracao);
            }
            diasAfastados = this.getDiasAfastamentos(cadBeneficio, inicioApuracao, finalApuracao);
        }
        diasDesconto = this.getDiasDesconto(colaborador, inicioApuracaoPonto, finalApuracaoPonto);
        hash.put("DIAS_COMPETENCIA", referenciaGeral);
        hash.put("DIAS_A_PAGAR", referenciaGeral - diasFerias - diasAfastados - diasDesconto);
    }

    private Double calcularReferenciaJornadaSemanal(CadastroBeneficioRefeicaoCesta b, Date inicioApuracao, Date finalApuracao) throws ExceptionService {
        Colaborador colaborador = b.getColaborador();
        return this.calculoSemanalSemDiaDiferente(b, inicioApuracao, finalApuracao);
    }

    private Double calculoSemanalSemDiaDiferente(CadastroBeneficioRefeicaoCesta b, Date inicioApuracao, Date finalApuracao) throws ExceptionService {
        Colaborador colaborador = b.getColaborador();
        HorarioTrabalho horario = colaborador.getHorarioTrabalho();
        Date inicioParametro = null;
        inicioParametro = colaborador.getDataAdmissao().after(inicioApuracao) ? colaborador.getDataAdmissao() : inicioApuracao;
        Integer contador = 0;
        block0: do {
            Integer diaParametro = this.getDiaSemanal(inicioParametro);
            if (!this.diaNaoFeriado(inicioParametro, colaborador.getEmpresa().getIdentificador())) continue;
            for (InfoHorarioTrabalho dia : horario.getEsocCadastroHorario().getListaHorario()) {
                if (!dia.getDiaSemana().getDia().equals(diaParametro.shortValue()) || !dia.getFolga().equals((short)0)) continue;
                Double ref = DateUtil.calcularDifHoras(dia.getHorarioInicial(), dia.getHorarioFinal());
                if (!b.getNaoValidarDias().equals((short)1) && !(ref >= 6.0)) continue block0;
                System.out.println("Dia " + String.valueOf(dia.getDiaSemana()));
                contador = contador + 1;
                continue block0;
            }
        } while (finalApuracao.after(inicioParametro = DateUtil.nextDays(inicioParametro, 1)) || finalApuracao.equals(inicioParametro));
        return contador.doubleValue();
    }

    private Integer getDiaSemanal(Date inicioParametro) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(inicioParametro);
        return g.get(7);
    }

    private boolean diaNaoFeriado(Date inicioParametro, Long idEmpresa) throws ExceptionService {
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("periodoInicial", inicioParametro);
        request.setAttribute("periodoFinal", inicioParametro);
        request.setAttribute("idEmpresa", idEmpresa);
        List retorno = (List)CoreServiceFactory.getServiceFeriado().execute(request, "findFeriadoPorPeriodo");
        return retorno == null || retorno.isEmpty();
    }

    private Double getDiasFerias(CadastroBeneficioRefeicaoCesta b, Date inicioApuracao, Date finalApuracao) throws ExceptionService {
        Colaborador colaborador = b.getColaborador();
        Double diasFerias = 0.0;
        String hql = " from FeriasColaborador ferias  where  ferias.periodoAqFeriasColab.colaborador = :colaborador  and  (ferias.dataGozoInicial between :inicioApuracao and :finalApuracao  or  ferias.dataGozoFinal between :inicioApuracao and :finalApuracao)";
        List aux = new ArrayList();
        aux = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setDate("inicioApuracao", inicioApuracao).setDate("finalApuracao", finalApuracao).list();
        if (aux == null || aux.isEmpty()) {
            return diasFerias;
        }
        for (Object object : aux) {
            FeriasColaborador ferias = (FeriasColaborador)object;
            Date parametroInicial = null;
            Date parametroFinal = null;
            parametroInicial = ferias.getDataGozoInicial().after(inicioApuracao) ? ferias.getDataGozoInicial() : inicioApuracao;
            parametroFinal = ferias.getDataGozoFinal().after(finalApuracao) ? finalApuracao : ferias.getDataGozoFinal();
            System.err.println(colaborador.toString());
            if (colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)0)) {
                diasFerias = this.calcularReferenciaJornadaSemanal(b, parametroInicial, parametroFinal);
            }
            if (colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)1)) {
                diasFerias = this.calcularReferenciaJornadaRevezamento(colaborador, parametroInicial, parametroFinal);
            }
            if (!colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)2)) continue;
            diasFerias = this.calcularReferenciaJornada1236(colaborador, parametroInicial, parametroFinal);
        }
        return diasFerias;
    }

    private Double getDiasAfastamentos(CadastroBeneficioRefeicaoCesta b, Date inicioApuracao, Date finalApuracao) throws ExceptionService {
        Colaborador colaborador = b.getColaborador();
        Double diasAfastamento = 0.0;
        List aux = new ArrayList();
        String hql = " from AfastamentoColaborador af  where  af.dataAfastamento != null  and  af.colaborador = :colaborador  and  (af.dataAfastamento between :inicioApuracao and :finalApuracao  or  (af.dataRetorno is not null   and   af.dataRetorno between :inicioApuracao and :finalApuracao)) ";
        aux = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setDate("inicioApuracao", inicioApuracao).setDate("finalApuracao", finalApuracao).list();
        if (aux == null || aux.isEmpty()) {
            return diasAfastamento;
        }
        for (Object obj : aux) {
            AfastamentoColaborador af = (AfastamentoColaborador)obj;
            Date parametroInicial = null;
            Date parametroFinal = null;
            parametroInicial = af.getDataAfastamento().after(inicioApuracao) ? af.getDataAfastamento() : inicioApuracao;
            parametroFinal = af.getDataRetorno() == null ? finalApuracao : (af.getDataRetorno().after(finalApuracao) ? finalApuracao : DateUtil.nextDays(af.getDataRetorno(), -1));
            System.err.println(colaborador.toString());
            if (colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)0)) {
                diasAfastamento = this.calcularReferenciaJornadaSemanal(b, parametroInicial, parametroFinal);
            }
            if (colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)1)) {
                diasAfastamento = this.calcularReferenciaJornadaRevezamento(colaborador, parametroInicial, parametroFinal);
            }
            if (!colaborador.getHorarioTrabalho().getTurnoDeTrabalho().getTipoJornada().equals((short)2)) continue;
            diasAfastamento = this.calcularReferenciaJornada1236(colaborador, parametroInicial, parametroFinal);
        }
        return diasAfastamento;
    }

    private Double calcularReferenciaJornadaRevezamento(Colaborador colaborador, Date inicioApuracao, Date finalApuracao) {
        Date dataAdmissao;
        HorarioTrabalho horario = colaborador.getHorarioTrabalho();
        Date inicioParametro = dataAdmissao = colaborador.getDataAdmissao();
        Integer contador = 0;
        Integer diasTrabalho = horario.getHorasTrabalhadasRevezamento().intValue();
        Integer diasFolga = horario.getHorasFolgasRevezamento().intValue();
        Integer diasAContar = diasTrabalho + diasFolga;
        boolean menor = true;
        Date dataProjecao = inicioParametro;
        if (dataAdmissao.before(inicioApuracao)) {
            while (menor = (dataProjecao = DateUtil.nextDays(dataProjecao, diasAContar)).before(inicioApuracao)) {
            }
            menor = true;
            if (dataProjecao.equals(inicioApuracao)) {
                do {
                    Date dataUltimaProjecao = dataProjecao;
                    if ((dataProjecao = DateUtil.nextDays(dataProjecao, diasAContar)).before(finalApuracao)) {
                        contador = contador + horario.getHorasTrabalhadasRevezamento().intValue();
                        menor = true;
                        continue;
                    }
                    if (dataProjecao.equals(finalApuracao)) {
                        contador = contador + 1;
                        menor = false;
                        continue;
                    }
                    Integer difDias = DateUtil.diferenceDayBetweenDates(dataUltimaProjecao, finalApuracao);
                    if (difDias == diasAContar) {
                        difDias = difDias - 1;
                    }
                    contador = contador + difDias;
                    menor = false;
                } while (menor);
                return ContatoFormatUtil.arrredondarNumero((Double)contador.doubleValue(), (int)2);
            }
            if (dataProjecao.after(inicioApuracao)) {
                contador = 0;
                menor = true;
                Date dataUltimaProjecao = DateUtil.nextDays(dataProjecao, -diasAContar.intValue());
                Integer difDias = DateUtil.diferenceDayBetweenDates(dataUltimaProjecao, inicioApuracao) + 1;
                Integer aux = 0;
                if (difDias == diasAContar) {
                    contador = contador + 0;
                } else {
                    aux = diasAContar - difDias;
                    contador = contador + aux;
                }
                dataProjecao = inicioApuracao;
                dataProjecao = DateUtil.nextDays(dataProjecao, aux - 1);
                do {
                    dataUltimaProjecao = dataProjecao;
                    if ((dataProjecao = DateUtil.nextDays(dataProjecao, diasAContar)).before(finalApuracao)) {
                        contador = contador + diasTrabalho;
                        menor = true;
                        continue;
                    }
                    if (dataProjecao.equals(finalApuracao)) {
                        menor = false;
                        continue;
                    }
                    difDias = DateUtil.diferenceDayBetweenDates(dataUltimaProjecao, finalApuracao);
                    difDias = difDias - diasFolga;
                    contador = contador + difDias;
                    menor = false;
                } while (menor);
                return ContatoFormatUtil.arrredondarNumero((Double)contador.doubleValue(), (int)2);
            }
        } else {
            contador = 0;
            menor = true;
            dataProjecao = dataAdmissao;
            do {
                Date dataUltimaProjecao = dataProjecao;
                if ((dataProjecao = DateUtil.nextDays(dataProjecao, diasAContar)).before(finalApuracao)) {
                    contador = contador + diasTrabalho;
                    menor = true;
                    continue;
                }
                if (dataProjecao.equals(finalApuracao)) {
                    menor = false;
                    continue;
                }
                Integer difDias = DateUtil.diferenceDayBetweenDates(dataUltimaProjecao, finalApuracao) + 1;
                if (difDias == diasAContar) {
                    difDias = difDias - diasFolga;
                    contador = contador + difDias;
                    menor = false;
                    continue;
                }
                contador = contador + difDias;
                menor = false;
            } while (menor);
            return ContatoFormatUtil.arrredondarNumero((Double)contador.doubleValue(), (int)2);
        }
        return 0.0;
    }

    private Double calcularReferenciaJornada1236(Colaborador colaborador, Date inicioApuracao, Date finalApuracao) {
        Date dataAdmissao;
        Date inicioParametro;
        Date dataProjecao = inicioParametro = (dataAdmissao = colaborador.getDataAdmissao());
        Integer contador = 0;
        boolean menor = true;
        if (dataAdmissao.before(inicioApuracao)) {
            while (menor = (dataProjecao = DateUtil.nextDays(DateUtil.dataSemHora(dataProjecao), 2)).before(inicioApuracao)) {
            }
        }
        menor = true;
        contador = contador + 1;
        do {
            if ((dataProjecao = DateUtil.nextDays(dataProjecao, 2)).before(finalApuracao)) {
                contador = contador + 1;
                menor = true;
                continue;
            }
            if (dataProjecao.equals(finalApuracao)) {
                contador = contador + 1;
                menor = false;
                continue;
            }
            menor = false;
        } while (menor);
        return ContatoFormatUtil.arrredondarNumero((Double)contador.doubleValue(), (int)2);
    }

    private Double getDiasDesconto(Colaborador colaborador, Date inicioApuracaoPonto, Date finalApuracaoPonto) {
        String hql = " select count(movPonto.identificador)  from MovPtoColaborador movPonto  where  movPonto.dataOcorrencia between :dataInicio and :dataFinal  and  movPonto.colaborador = :colaborador  and  (movPonto.tipoOcorrencia.statusPonto.status = :faltas  or  movPonto.tipoOcorrencia.statusPonto.status = :atestado  or  movPonto.tipoOcorrencia.statusPonto.status = :faltasHoras  or  movPonto.tipoOcorrencia.statusPonto.status = :atestadoHoras)";
        Long retorno = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("dataInicio", inicioApuracaoPonto).setDate("dataFinal", finalApuracaoPonto).setEntity("colaborador", (Object)colaborador).setInteger("faltas", 4).setInteger("atestado", 3).setInteger("faltasHoras", 10).setInteger("atestadoHoras", 6).uniqueResult();
        if (retorno == null || (double)retorno.longValue() == 0.0) {
            return 0.0;
        }
        return retorno.doubleValue();
    }

    public List calcularBeneficioPersonalizado(List ret, Date dataInicio, Date dataFinal, Date inicioPonto, Date finalPonto) throws ExceptionService {
        ArrayList list = new ArrayList();
        for (Object object : ret) {
            CadastroBeneficioRefeicaoCesta cadBeneficio = (CadastroBeneficioRefeicaoCesta)object;
            if (cadBeneficio.getColaborador().getNumeroRegistro().equals("722")) {
                System.out.println("");
            }
            HashMap<String, Object> newHash = new HashMap<String, Object>();
            newHash.put("CAD_BENEFICIO", cadBeneficio);
            if (cadBeneficio.getDiasApuracaoVA() <= 0.0) {
                this.getDiasApuracaoVale(newHash, cadBeneficio, inicioPonto, finalPonto, dataInicio, dataFinal);
            } else {
                newHash.put("DIAS_A_PAGAR", cadBeneficio.getDiasApuracaoVA());
                newHash.put("DIAS_COMPETENCIA", cadBeneficio.getDiasApuracaoVA());
            }
            list.add(newHash);
        }
        return list;
    }
}

