/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.beneficiova;

import com.touchcomp.basementor.model.vo.BeneficioGeracaoVA;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.GeracaoArquivoVA;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.rh.beneficiova.UtilityMetodosTXT;

public class UtilityGeracaoArquivoVASA {
    private Integer numeroSequencial = 1;
    private Integer totalFuncionario = 0;
    private Double valorTotal = 0.0;

    public void geracaoArquivoFechamentoVA(File arquivo, GeracaoArquivoVA vo, Usuario usuario) throws IOException, ExceptionService {
        this.createBlocoHeader(arquivo, vo, usuario);
        this.createBlooPedido(arquivo, vo, usuario);
        this.createUnidadeEntrega(arquivo, vo, usuario);
        for (BeneficioGeracaoVA beneficio : vo.getBeneficios()) {
            if (!beneficio.getDesativar().equals((short)0)) continue;
            Double valor = 0.0;
            valor = beneficio.getFechamento().getSomarCesta().equals((short)0) ? beneficio.getFechamento().getValorTotal() : ContatoFormatUtil.arrredondarNumero((Double)(beneficio.getFechamento().getValorTotal() + beneficio.getFechamento().getValorCesta()), (int)2);
            if (!(valor > 0.0)) continue;
            this.createBlocoFuncionario(beneficio, arquivo, vo, valor);
            this.totalFuncionario = this.totalFuncionario + 1;
            this.valorTotal = this.valorTotal + ContatoFormatUtil.arrredondarNumero((Double)valor, (int)2);
            this.valorTotal = this.valorTotal + ContatoFormatUtil.arrredondarNumero((Double)this.valorTotal, (int)2);
        }
        this.trailerPedido(arquivo, vo, usuario);
        this.trailerArquivo(arquivo, vo, usuario);
    }

    private void createBlocoHeader(File arquivo, GeracaoArquivoVA vo, Usuario usuario) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        p.append("LSUP5");
        p.append(UtilityMetodosTXT.completarComBrancoDireita(usuario.getUsuarioBasico().getPessoa().getNome().toUpperCase(), 8));
        p.append(UtilityMetodosTXT.completarComBrancoDireita("", 11));
        p.append(UtilityMetodosTXT.formatarDatas8DigitosAnoMesDia(vo.getDataCadastro()));
        p.append("11.11.11");
        p.append("LAYOUT-16/06/2014");
        p.append(UtilityMetodosTXT.completarComBrancoDireita("", 107));
        p.println();
        p.flush();
        p.close();
    }

    private void createBlooPedido(File arquivo, GeracaoArquivoVA vo, Usuario usuario) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        p.append("T");
        if (vo.getTipoArquivo().equals((short)0)) {
            p.append("R");
        } else {
            p.append("A");
        }
        p.append("02");
        p.append("0");
        if (vo.getTipoArquivo().equals((short)0)) {
            p.append("R");
        } else {
            p.append("A");
        }
        p.append(UtilityMetodosTXT.completarComZeroEsquerda(vo.getNumeroConvenio(), 10));
        p.append(UtilityMetodosTXT.completarComBrancoDireita(vo.getEmpresa().getPessoa().getNome().toUpperCase(), 24));
        p.append(UtilityMetodosTXT.completarComBrancoDireita("", 6));
        p.append(UtilityMetodosTXT.formatarDatas8DigitosAnoMesDia(vo.getDataAgendamento()));
        p.append(UtilityMetodosTXT.formatarDatas8DigitosAnoMesDia(vo.getPeriodo()));
        p.append(UtilityMetodosTXT.completarComBrancoDireita("", 17));
        p.append(UtilityMetodosTXT.completarComZeroEsquerda(ToolDate.monthFromDate((Date)vo.getDataAgendamento()).toString(), 2));
        p.append(UtilityMetodosTXT.completarComBrancoDireita("", 19));
        p.append("04");
        if (vo.getTipoArquivo().equals((short)0)) {
            p.append("34");
        } else {
            p.append("33");
        }
        p.append(UtilityMetodosTXT.completarComBrancoDireita("", 48));
        p.append("SUP   ");
        p.append(UtilityMetodosTXT.completarComZeroEsquerda(this.numeroSequencial.toString(), 6));
        this.numeroSequencial = this.numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void createUnidadeEntrega(File arquivo, GeracaoArquivoVA vo, Usuario usuario) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        p.append("T");
        if (vo.getTipoArquivo().equals((short)0)) {
            p.append("R");
        } else {
            p.append("A");
        }
        p.append("02");
        p.append("2");
        p.append(UtilityMetodosTXT.completarComBrancoDireita(vo.getEmpresa().getPessoa().getNome().toUpperCase(), 26));
        p.append(UtilityMetodosTXT.completarComBrancoDireita("rua", 4));
        p.append(UtilityMetodosTXT.completarComBrancoDireita(ToolString.clearStringXml((String)vo.getEmpresa().getPessoa().getEndereco().getLogradouro()), 30));
        p.append(UtilityMetodosTXT.completarComBrancoDireita(vo.getEmpresa().getPessoa().getEndereco().getNumero(), 6));
        p.append(UtilityMetodosTXT.completarComBrancoDireita("", 10));
        p.append(UtilityMetodosTXT.completarComBrancoDireita(ToolString.clearStringXml((String)vo.getEmpresa().getPessoa().getEndereco().getCidade().getDescricao()), 25));
        p.append(UtilityMetodosTXT.completarComBrancoDireita(ToolString.clearStringXml((String)vo.getEmpresa().getPessoa().getEndereco().getBairro()), 15));
        p.append(vo.getEmpresa().getPessoa().getEndereco().getCep().subSequence(0, 5));
        p.append("MG");
        p.append(UtilityMetodosTXT.completarComBrancoDireita(usuario.getUsuarioBasico().getPessoa().getNome(), 20));
        p.append(vo.getEmpresa().getPessoa().getEndereco().getCep().substring(5, 8));
        p.append(UtilityMetodosTXT.completarComBrancoDireita("", 7));
        p.append(UtilityMetodosTXT.completarComZeroEsquerda(this.numeroSequencial.toString(), 6));
        this.numeroSequencial = this.numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void createBlocoFuncionario(BeneficioGeracaoVA beneficio, File arquivo, GeracaoArquivoVA vo, Double valor) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        Colaborador colaborador = beneficio.getFechamento().getColaborador();
        p.append("T");
        if (vo.getTipoArquivo().equals((short)0)) {
            p.append("R");
        } else {
            p.append("A");
        }
        p.append("02");
        p.append("3");
        p.append(UtilityMetodosTXT.completarComBrancoDireita(vo.getEmpresa().getIdentificador().toString(), 26));
        p.append(UtilityMetodosTXT.completarComZeroEsquerda(colaborador.getNumeroRegistro(), 12));
        p.append(UtilityMetodosTXT.formatarDatas8Digitos(colaborador.getPessoa().getComplemento().getDataNascimento()));
        p.append(UtilityMetodosTXT.completarComBrancoDireita("", 18));
        p.append(UtilityMetodosTXT.completarComBrancoDireita(vo.getEmpresa().getPessoa().getNome(), 26));
        p.append("00101");
        p.append(UtilityMetodosTXT.completarComZeroEsquerda(UtilityMetodosTXT.formatarValor(valor), 9));
        if (vo.getTipoArquivo().equals((short)0)) {
            p.append("R");
        } else {
            p.append("A");
        }
        p.append("E");
        p.append(UtilityMetodosTXT.completarComBrancoDireita(ToolString.clearStringXml((String)colaborador.getPessoa().getNome()), 30));
        p.append("      ");
        p.append(UtilityMetodosTXT.completarComZeroEsquerda(colaborador.getPessoa().getComplemento().getCnpj(), 11));
        p.append(UtilityMetodosTXT.completarComZeroEsquerda(this.numeroSequencial.toString(), 6));
        this.numeroSequencial = this.numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void trailerPedido(File arquivo, GeracaoArquivoVA vo, Usuario usuario) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        p.append("T");
        if (vo.getTipoArquivo().equals((short)0)) {
            p.append("R");
        } else {
            p.append("A");
        }
        p.append("02");
        p.append("9");
        p.append(UtilityMetodosTXT.completarComBrancoDireita(this.totalFuncionario.toString(), 8));
        p.append(UtilityMetodosTXT.completarComZeroEsquerda(UtilityMetodosTXT.formatarValor(this.valorTotal), 14));
        p.append(UtilityMetodosTXT.completarComBrancoDireita("", 131));
        p.append(UtilityMetodosTXT.completarComZeroEsquerda(this.numeroSequencial.toString(), 6));
        this.numeroSequencial = this.numeroSequencial + 1;
        p.println();
        p.flush();
        p.close();
    }

    private void trailerArquivo(File arquivo, GeracaoArquivoVA vo, Usuario usuario) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        p.append("LSUP9");
        p.append(UtilityMetodosTXT.completarComZeroEsquerda("1", 9));
        p.append(UtilityMetodosTXT.completarComZeroEsquerda("1", 9));
        this.numeroSequencial = this.numeroSequencial - 2;
        p.append(UtilityMetodosTXT.completarComZeroEsquerda(this.numeroSequencial.toString(), 9));
        p.append(UtilityMetodosTXT.completarComBrancoDireita("", 277));
        p.println();
        p.flush();
        p.close();
    }
}

