/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.beneficiova;

import com.touchcomp.basementor.model.vo.BeneficioGeracaoVA;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FechamentoVAColaborador;
import com.touchcomp.basementor.model.vo.FornecedoraTicketAlimentacao;
import com.touchcomp.basementor.model.vo.GeracaoArquivoVA;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.rh.beneficiova.UtilityMetodosTXT;

public class UtilityGeracaoArquivoVAVR {
    private Integer numeroSequencial = 3;

    public void geracaoArquivoFechamentoVA(File arquivo, GeracaoArquivoVA vo) throws IOException, ExceptionService {
        FechamentoVAColaborador beneficio;
        HashMap<String, Object> hash;
        this.createBloco00(arquivo, vo.getEmpresa());
        this.createBloco10(arquivo, vo.getEmpresa());
        String codigoProduto = this.getCodigoProduto(vo.getTipoArquivo());
        List beneficios = vo.getBeneficios();
        for (BeneficioGeracaoVA b : beneficios) {
            if (!b.getDesativar().equals((short)0)) continue;
            hash = new HashMap<String, Object>();
            beneficio = b.getFechamento();
            if (vo.getTipoArquivo().equals((short)2)) {
                hash.put("COLABORADOR", beneficio.getColaborador());
                hash.put("VALOR", beneficio.getValorCesta());
                hash.put("FAIXA", "01");
                hash.put("TIPO_BENEFICIO", beneficio.getTipoTicket());
                if (beneficio.getValorCesta() <= 0.0) {
                    continue;
                }
            } else {
                hash.put("COLABORADOR", beneficio.getColaborador());
                if (beneficio.getSomarCesta().equals((short)0)) {
                    hash.put("VALOR", beneficio.getValorTotal());
                } else {
                    hash.put("VALOR", ContatoFormatUtil.arrredondarNumero((Double)(beneficio.getValorTotal() + beneficio.getValorCesta()), (int)2));
                }
                hash.put("FAIXA", "01");
                hash.put("TIPO_BENEFICIO", beneficio.getTipoTicket());
                if ((Double)hash.get("VALOR") <= 0.0) continue;
            }
            this.createBloco30(arquivo, vo.getEmpresa(), hash);
            this.numeroSequencial = this.numeroSequencial + 1;
        }
        this.createBloco50(arquivo, vo.getEmpresa(), codigoProduto, vo.getDataAgendamento());
        this.numeroSequencial = this.numeroSequencial + 1;
        for (BeneficioGeracaoVA b : beneficios) {
            hash = new HashMap();
            beneficio = b.getFechamento();
            if (vo.getTipoArquivo().equals((short)2)) {
                hash.put("COLABORADOR", beneficio.getColaborador());
                hash.put("VALOR", beneficio.getValorCesta());
                hash.put("FAIXA", "01");
                hash.put("TIPO_BENEFICIO", beneficio.getTipoTicket());
                if (beneficio.getValorCesta() <= 0.0) {
                    continue;
                }
            } else {
                hash.put("COLABORADOR", beneficio.getColaborador());
                if (beneficio.getSomarCesta().equals((short)0)) {
                    hash.put("VALOR", beneficio.getValorTotal());
                } else {
                    hash.put("VALOR", ContatoFormatUtil.arrredondarNumero((Double)(beneficio.getValorTotal() + beneficio.getValorCesta()), (int)2));
                }
                hash.put("FAIXA", "01");
                hash.put("TIPO_BENEFICIO", beneficio.getTipoTicket());
                if ((Double)hash.get("VALOR") <= 0.0) continue;
            }
            this.createBloco60(arquivo, vo.getEmpresa(), hash, codigoProduto);
            this.numeroSequencial = this.numeroSequencial + 1;
        }
        this.createBloco90(arquivo, vo.getEmpresa());
    }

    private void createBloco00(File arquivo, Empresa empresa) throws IOException, ExceptionService {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        String aux = "";
        p.append("00");
        p.append("011");
        aux = empresa.getPessoa().getComplemento().getCnpj();
        if (aux == null || aux.isEmpty()) {
            throw new ExceptionService("EMPRESA SEM CNPJ");
        }
        p.append(aux);
        p.append(UtilityMetodosTXT.completarComBrancoDireita(empresa.getPessoa().getNome(), 40));
        p.append(UtilityMetodosTXT.completarComBrancoDireita("", 282));
        p.append("000000001");
        p.println();
        p.flush();
        p.close();
    }

    private void createBloco10(File arquivo, Empresa empresa) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        p.append("10");
        p.append(UtilityMetodosTXT.completarComZeroEsquerda(empresa.getPessoa().getComplemento().getCnpj(), 14));
        p.append(UtilityMetodosTXT.completarComBrancoDireita(empresa.getPessoa().getComplemento().getCnpj(), 30));
        p.append(UtilityMetodosTXT.completarComBrancoDireita(empresa.getPessoa().getNome(), 80));
        p.append(UtilityMetodosTXT.completarComBrancoDireita("Rua", 20));
        p.append(UtilityMetodosTXT.completarComBrancoDireita(ToolString.clearStringXml((String)empresa.getPessoa().getEndereco().getLogradouro()), 40));
        p.append(UtilityMetodosTXT.completarComZeroEsquerda(empresa.getPessoa().getEndereco().getNumero(), 6));
        p.append(UtilityMetodosTXT.completarComBrancoDireita(empresa.getPessoa().getEndereco().getComplemento(), 20));
        p.append(UtilityMetodosTXT.completarComBrancoDireita(empresa.getPessoa().getEndereco().getBairro(), 30));
        p.append(UtilityMetodosTXT.completarComBrancoDireita(ToolString.clearStringXml((String)empresa.getPessoa().getEndereco().getCidade().getDescricao()), 30));
        p.append(empresa.getPessoa().getEndereco().getCidade().getUf().getSigla().toUpperCase());
        p.append(empresa.getPessoa().getEndereco().getCep());
        p.append(UtilityMetodosTXT.completarComBrancoDireita("ATILA JORGE MIRANDA FERREIRA", 30));
        p.append(UtilityMetodosTXT.completarComBrancoDireita("", 29));
        p.append("000000002");
        p.println();
        p.flush();
        p.close();
    }

    private void createBloco30(File arquivo, Empresa empresa, HashMap hash) throws IOException, ExceptionService {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        Colaborador colaborador = (Colaborador)hash.get("COLABORADOR");
        Double valor = (Double)hash.get("VALOR");
        String faixa = (String)hash.get("FAIXA");
        p.append("30");
        p.append(UtilityMetodosTXT.completarComZeroEsquerda(empresa.getPessoa().getComplemento().getCnpj(), 14));
        if (colaborador.getPessoa().getComplemento().getCnpj() == null || colaborador.getPessoa().getComplemento().getCnpj().isEmpty()) {
            throw new ExceptionService("Colaborador: " + colaborador.toString() + " sem CPF");
        }
        p.append(UtilityMetodosTXT.completarComZeroEsquerda(colaborador.getPessoa().getComplemento().getCnpj(), 11));
        p.append(UtilityMetodosTXT.completarComBrancoDireita(empresa.getPessoa().getComplemento().getCnpj(), 30));
        p.append(UtilityMetodosTXT.completarComBrancoDireita("", 12));
        p.append(UtilityMetodosTXT.completarComBrancoDireita(colaborador.getNumeroRegistro(), 10));
        p.append(UtilityMetodosTXT.completarComBrancoDireita(colaborador.getPessoa().getNome(), 40));
        p.append(UtilityMetodosTXT.completarComBrancoDireita("", 24));
        p.append(UtilityMetodosTXT.formatarDatas8Digitos(colaborador.getPessoa().getComplemento().getDataNascimento()));
        if (colaborador.getSexo().equals((short)0)) {
            p.append("M");
        } else {
            p.append("F");
        }
        p.append("01");
        p.append(UtilityMetodosTXT.completarComBrancoDireita("", 187));
        p.append(UtilityMetodosTXT.completarComZeroEsquerda(this.numeroSequencial.toString(), 9));
        p.println();
        p.flush();
        p.close();
    }

    public List buscarBeneficiosVA(Empresa empresa, Short todasEmpresas, Short tipoArquivo, Date periodoApuracao, Short grupo, FornecedoraTicketAlimentacao fornecedora) throws ExceptionService {
        if (tipoArquivo.equals((short)1)) {
            return this.buscarSomenteValeAlimentacaoTicketRefeicao(empresa, todasEmpresas, tipoArquivo, periodoApuracao, grupo, fornecedora);
        }
        if (tipoArquivo.equals((short)0)) {
            return this.buscarSomenteValeAlimentacaoTicketRefeicao(empresa, todasEmpresas, tipoArquivo, periodoApuracao, grupo, fornecedora);
        }
        if (tipoArquivo.equals((short)2)) {
            return this.buscarCestaBasica(empresa, todasEmpresas, tipoArquivo, periodoApuracao, grupo);
        }
        if (tipoArquivo.equals((short)3)) {
            System.out.println("");
        }
        throw new ExceptionService("Verifique as informa\u00e7\u00f5es no recurso de Gera\u00e7\u00e3o do Arquivo");
    }

    private List buscarSomenteValeAlimentacaoTicketRefeicao(Empresa empresa, Short todasEmpresas, Short tipoArquivo, Date periodoApuracao, Short grupo, FornecedoraTicketAlimentacao fornecedora) {
        Long idFornecedora = fornecedora == null ? 0L : fornecedora.getIdentificador();
        String hql = " select distinct beneficio  from FechamentoVAColaborador beneficio  where  (:idFornecedor = 0 or beneficio.fornecedorTicket.identificador = :idFornecedor )  and  beneficio.fechamentoVA.periodoDistribuicao = :periodoApuracao  and  beneficio.colaborador.localTrabalhoColaboradorCidade.localTrabalhoColaborador.grupoBeneficio = :grupo  and  beneficio.tipoTicket = :valeAlimentacao  and  (:todasEmpresas = 1 or beneficio.fechamentoVA.empresa = :empresa )";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("periodoApuracao", periodoApuracao).setLong("idFornecedor", idFornecedora.longValue()).setShort("valeAlimentacao", tipoArquivo.shortValue()).setShort("todasEmpresas", todasEmpresas.shortValue()).setShort("grupo", grupo.shortValue()).setEntity("empresa", (Object)empresa).list();
    }

    private void createBloco50(File arquivo, Empresa empresa, String codigoProduto, Date dataAgendamento) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        p.append("50");
        p.append(UtilityMetodosTXT.completarComZeroEsquerda(empresa.getPessoa().getComplemento().getCnpj(), 14));
        p.append(codigoProduto);
        p.append(UtilityMetodosTXT.formatarDatas8Digitos(dataAgendamento));
        p.append(UtilityMetodosTXT.completarComBrancoDireita("", 314));
        p.append(UtilityMetodosTXT.completarComZeroEsquerda(this.numeroSequencial.toString(), 9));
        p.println();
        p.flush();
        p.close();
    }

    private String getCodigoProduto(Short tipoArquivo) {
        if (tipoArquivo.equals((short)0)) {
            return "VBR";
        }
        if (tipoArquivo.equals((short)1)) {
            return "VBA";
        }
        if (tipoArquivo.equals((short)2)) {
            return "VCA";
        }
        return "err";
    }

    private void createBloco60(File arquivo, Empresa empresa, HashMap hash, String codigoProduto) throws IOException, ExceptionService {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        Colaborador colaborador = (Colaborador)hash.get("COLABORADOR");
        Double valor = (Double)hash.get("VALOR");
        p.append("60");
        p.append(UtilityMetodosTXT.completarComZeroEsquerda(empresa.getPessoa().getComplemento().getCnpj(), 14));
        p.append(codigoProduto);
        if (colaborador.getPessoa().getComplemento().getCnpj() == null || colaborador.getPessoa().getComplemento().getCnpj().isEmpty()) {
            throw new ExceptionService("Colaborador sem CPF: " + colaborador.getPessoa().getNome());
        }
        p.append(UtilityMetodosTXT.completarComZeroEsquerda(colaborador.getPessoa().getComplemento().getCnpj(), 11));
        p.append(UtilityMetodosTXT.completarComBrancoDireita("", 40));
        p.append(UtilityMetodosTXT.completarComZeroEsquerda(UtilityMetodosTXT.formatarValor(valor), 11));
        p.append(UtilityMetodosTXT.completarComBrancoDireita("", 260));
        p.append(UtilityMetodosTXT.completarComZeroEsquerda(this.numeroSequencial.toString(), 9));
        p.println();
        p.flush();
        p.close();
    }

    private void createBloco90(File arquivo, Empresa empresa) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        String aux = "";
        p.append("99");
        aux = empresa.getPessoa().getComplemento().getCnpj();
        p.append(aux);
        p.append(UtilityMetodosTXT.completarComBrancoDireita("", 325));
        p.append(UtilityMetodosTXT.completarComZeroEsquerda(this.numeroSequencial.toString(), 9));
        p.println();
        p.flush();
        p.close();
    }

    private List buscarCestaBasica(Empresa empresa, Short todasEmpresas, Short tipoArquivo, Date periodoApuracao, Short grupo) {
        String hql = " select distinct beneficio  from FechamentoVAColaborador beneficio  where  beneficio.fechamentoVA.periodoDistribuicao = :periodoApuracao  and  beneficio.valorCesta > 0 and  beneficio.somarCesta = :nao  and  beneficio.colaborador.localTrabalhoColaboradorCidade.localTrabalhoColaborador.grupoBeneficio = :grupo  and  (:todasEmpresas = 1 or beneficio.fechamentoVA.empresa = :empresa )";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("periodoApuracao", periodoApuracao).setShort("grupo", grupo.shortValue()).setShort("nao", (short)0).setShort("todasEmpresas", todasEmpresas.shortValue()).setEntity("empresa", (Object)empresa).list();
    }
}

