/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.beneficiovt;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FechamentoColaboradorVT;
import com.touchcomp.basementor.model.vo.GeracaoArquivoVT;
import com.touchcomp.basementor.model.vo.ImportacaoArquivoValeTransporte;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.rh.beneficiovt.UtilityFechamentoBeneficioVT;
import mentorcore.service.impl.rh.beneficiovt.UtilityGeracaoArquivoVTRRb;
import mentorcore.service.impl.rh.beneficiovt.UtilityGeracaoArquivoVTTransfacil;
import mentorcore.service.impl.rh.beneficiovt.UtilityGeracaoArquivoValeTransporte;

public class ServiceFechamentoBeneficioVT
extends CoreService {
    public static final String CALCULAR_BENEFICIO_VT = "calcularBeneficioVT";
    public static final String BUSCA_PERSONALIZADA_VT = "buscaPersonalizadaVT";
    public static final String EXCLUIR_BENEFICIO_VT = "excluirFechamentoVT";
    public static final String BUSCAR_COLABORADORES_IMPORTACAO_TXT = "buscarColaboradoresImportacaoTxt";
    public static final String GERAR_ARQUIVO_VT = "gerarArquivoVt";

    public List calcularBeneficioVT(CoreRequestContext request) throws ExceptionService {
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        Date inicioApuracao = (Date)request.getAttribute("inicioApuracao");
        Date finalApuracao = (Date)request.getAttribute("finalApuracao");
        Short filtrarEmpresa = (Short)request.getAttribute("filtrarEmpresa");
        Date dataInicio = (Date)request.getAttribute("dataInicio");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        return new UtilityFechamentoBeneficioVT().calcularBeneficioVT(filtrarEmpresa, inicioApuracao, finalApuracao, empresa, dataInicio, dataFinal);
    }

    public List buscaPersonalizadaVT(CoreRequestContext request) throws ExceptionService {
        List colaboradores = (List)request.getAttribute("colaboradores");
        Date periodoInicialPonto = (Date)request.getAttribute("inicioApuracao");
        Date periodoFinalPonto = (Date)request.getAttribute("finalApuracao");
        Date periodoInicial = (Date)request.getAttribute("dataInicio");
        Date periodoFinal = (Date)request.getAttribute("dataFinal");
        return new UtilityFechamentoBeneficioVT().calcularBeneficioVTPersonalizado(colaboradores, periodoInicial, periodoFinal, periodoInicialPonto, periodoFinalPonto);
    }

    public void excluirFechamentoVT(CoreRequestContext request) throws ExceptionDatabase {
        FechamentoColaboradorVT vo = (FechamentoColaboradorVT)request.getAttribute("vo");
        CoreDAOFactory.getInstance().getDAOFechamentoColaboradorVT().delete(vo);
    }

    public List buscarColaboradoresImportacaoTxt(CoreRequestContext r) {
        Date periodo = (Date)r.getAttribute("periodo");
        ImportacaoArquivoValeTransporte importacao = (ImportacaoArquivoValeTransporte)r.getAttribute("fornecedora");
        return new UtilityGeracaoArquivoValeTransporte().getBeneficiosValeTransporte(periodo, importacao.getOperadora());
    }

    public void gerarArquivoVt(CoreRequestContext r) throws ExceptionService, IOException {
        File file = (File)r.getAttribute("file");
        GeracaoArquivoVT vo = (GeracaoArquivoVT)r.getAttribute("vo");
        String cnpj = ToolString.refina((String)vo.getImportacao().getOperadora().getComplemento().getCnpj());
        if (cnpj.equalsIgnoreCase("04398505000107")) {
            new UtilityGeracaoArquivoVTTransfacil().gerarArquivoVTTransfacil(file, vo);
        } else if (cnpj.equalsIgnoreCase("60498417001049")) {
            new UtilityGeracaoArquivoVTRRb().gerarArquivoVTTransfacil(file, vo);
        } else {
            throw new ExceptionService("Operadora n\u00e3o disponivel para gera\u00e7\u00e3o do Arquivo");
        }
    }
}

