/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.beneficiovt;

import com.touchcomp.basementor.model.vo.BeneficioGeracaoVT;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GeracaoArquivoVT;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.rh.beneficiova.UtilityMetodosTXT;

public class UtilityGeracaoArquivoVTRRb {
    private Integer numeroSequencial = 1;
    private Integer totalFunc = 0;

    public void gerarArquivoVTTransfacil(File arquivo, GeracaoArquivoVT vo) throws ExceptionService, IOException {
        List beneficios = vo.getBeneficios();
        this.createBlocoEmpresa(arquivo, vo.getEmpresa());
        this.createBlocoLocalEntrega(arquivo, vo.getEmpresa());
        for (BeneficioGeracaoVT beneficio : beneficios) {
            if (!(beneficio.getLinhaFechamento().getValorTotal() > 0.0)) continue;
            this.totalFunc = this.totalFunc + 1;
            this.createBlocoRegistroFuncionario(beneficio, vo.getEmpresa(), arquivo);
        }
        for (BeneficioGeracaoVT beneficio : beneficios) {
            if (!(beneficio.getLinhaFechamento().getValorTotal() > 0.0)) continue;
            this.createRegistroBeneficio(beneficio, vo.getEmpresa(), arquivo);
        }
        this.createBlocoRodape(vo.getEmpresa(), arquivo, this.totalFunc);
    }

    private void createBlocoLocalEntrega(File arquivo, Empresa empresa) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        String aux = "";
        p.append(UtilityMetodosTXT.completarComZeroEsquerda(this.numeroSequencial.toString(), 5));
        this.numeroSequencial = this.numeroSequencial + 1;
        p.append("2");
        p.append(ToolString.refina((String)empresa.getPessoa().getComplemento().getCnpj()));
        p.append("999");
        p.append(ToolString.refina((String)empresa.getPessoa().getEndereco().getCep()));
        p.append(ToolString.clearInvalidUTF8Char((String)UtilityMetodosTXT.completarComBrancoDireita(empresa.getPessoa().getEndereco().getLogradouro(), 60)));
        p.append(UtilityMetodosTXT.completarComZeroEsquerda(empresa.getPessoa().getEndereco().getNumero(), 10));
        p.append(UtilityMetodosTXT.completarComBrancoDireita("", 30));
        p.append(UtilityMetodosTXT.completarComBrancoDireita(empresa.getPessoa().getEndereco().getBairro(), 40));
        p.append(UtilityMetodosTXT.completarComBrancoDireita(empresa.getPessoa().getEndereco().getCidade().getDescricao(), 40));
        p.append("MG");
        p.println();
        p.flush();
        p.close();
    }

    private void createBlocoEmpresa(File arquivo, Empresa empresa) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        String aux = "";
        p.append(UtilityMetodosTXT.completarComZeroEsquerda(this.numeroSequencial.toString(), 5));
        this.numeroSequencial = this.numeroSequencial + 1;
        p.append("1");
        p.append(ToolString.refina((String)empresa.getPessoa().getComplemento().getCnpj()));
        p.append(UtilityMetodosTXT.completarComBrancoDireita(empresa.getPessoa().getNome(), 80));
        p.append(UtilityMetodosTXT.completarComBrancoDireita("ADRIANO MIRANDA", 60));
        p.append(UtilityMetodosTXT.completarComBrancoDireita(empresa.getPessoa().getComplemento().getEmailPrincipal(), 80));
        p.println();
        p.flush();
        p.close();
    }

    private void createBlocoRegistroFuncionario(BeneficioGeracaoVT beneficio, Empresa empresa, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        p.append(UtilityMetodosTXT.completarComZeroEsquerda(this.numeroSequencial.toString(), 5));
        this.numeroSequencial = this.numeroSequencial + 1;
        p.append("3");
        p.append(ToolString.refina((String)empresa.getPessoa().getComplemento().getCnpj()));
        p.append(UtilityMetodosTXT.completarComBrancoEsquerda(beneficio.getLinhaFechamento().getFechamento().getColaborador().getNumeroRegistro(), 12));
        p.append(UtilityMetodosTXT.completarComBrancoDireita(beneficio.getLinhaFechamento().getFechamento().getColaborador().getPessoa().getNome(), 60));
        p.append(UtilityMetodosTXT.completarComBrancoDireita(beneficio.getLinhaFechamento().getFechamento().getColaborador().getCentroCusto().getNome(), 40));
        p.append(UtilityMetodosTXT.completarComBrancoDireita(beneficio.getLinhaFechamento().getFechamento().getColaborador().getFuncao().getDescricao(), 40));
        p.append(UtilityMetodosTXT.formatarDatas6Digitos(beneficio.getLinhaFechamento().getFechamento().getColaborador().getPessoa().getComplemento().getDataNascimento()));
        p.append(beneficio.getLinhaFechamento().getFechamento().getColaborador().getPessoa().getComplemento().getCnpj());
        p.append(UtilityMetodosTXT.completarComBrancoDireita(beneficio.getLinhaFechamento().getFechamento().getColaborador().getPessoa().getComplemento().getRg(), 14));
        if (beneficio.getLinhaFechamento().getFechamento().getColaborador().getSexo().equals((short)1)) {
            p.append("F");
        } else {
            p.append("M");
        }
        p.append(UtilityMetodosTXT.completarComBrancoDireita(beneficio.getLinhaFechamento().getFechamento().getColaborador().getNomeMae(), 40));
        p.append(ToolString.refina((String)beneficio.getLinhaFechamento().getFechamento().getColaborador().getPessoa().getEndereco().getCep()));
        p.append(UtilityMetodosTXT.completarComBrancoDireita(ToolString.refina((String)beneficio.getLinhaFechamento().getFechamento().getColaborador().getPessoa().getEndereco().getLogradouro()), 60));
        p.append(UtilityMetodosTXT.completarComZeroEsquerda(beneficio.getLinhaFechamento().getFechamento().getColaborador().getPessoa().getEndereco().getNumero(), 10));
        p.append(UtilityMetodosTXT.completarComBrancoDireita("", 30));
        p.append(UtilityMetodosTXT.completarComBrancoDireita(beneficio.getLinhaFechamento().getFechamento().getColaborador().getPessoa().getEndereco().getBairro(), 40));
        p.append(UtilityMetodosTXT.completarComBrancoDireita(beneficio.getLinhaFechamento().getFechamento().getColaborador().getPessoa().getEndereco().getCidade().getDescricao(), 40));
        p.append(beneficio.getLinhaFechamento().getFechamento().getColaborador().getPessoa().getEndereco().getCidade().getUf().getSigla());
        p.append("999");
        p.append("999999999999999");
        p.println();
        p.flush();
        p.close();
    }

    private void createRegistroBeneficio(BeneficioGeracaoVT beneficio, Empresa empresa, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        p.append(UtilityMetodosTXT.completarComZeroEsquerda(this.numeroSequencial.toString(), 5));
        this.numeroSequencial = this.numeroSequencial + 1;
        p.append("4");
        p.append(ToolString.refina((String)empresa.getPessoa().getComplemento().getCnpj()));
        p.append(UtilityMetodosTXT.completarComBrancoEsquerda(beneficio.getLinhaFechamento().getFechamento().getColaborador().getNumeroRegistro(), 12));
        p.append("111111111111");
        p.append(UtilityMetodosTXT.completarComBrancoDireita("VALE TRANSPORTE VB", 60));
        Integer quantidade = beneficio.getLinhaFechamento().getQuantidade().intValue();
        p.append(UtilityMetodosTXT.completarComZeroEsquerda(quantidade.toString(), 4));
        p.append(UtilityMetodosTXT.completarComZeroEsquerda(UtilityMetodosTXT.formatarValor(beneficio.getLinhaFechamento().getValorTotal()), 11));
        p.println();
        p.flush();
        p.close();
    }

    private void createBlocoRodape(Empresa empresa, File arquivo, Integer total) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        p.append(UtilityMetodosTXT.completarComZeroEsquerda(this.numeroSequencial.toString(), 5));
        this.numeroSequencial = this.numeroSequencial + 1;
        p.append("3");
        p.append(ToolString.refina((String)empresa.getPessoa().getComplemento().getCnpj()));
        p.append(UtilityMetodosTXT.completarComZeroEsquerda(total.toString(), 5));
        p.println();
        p.flush();
        p.close();
    }
}

