/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.beneficiovt;

import com.touchcomp.basementor.model.vo.BeneficioGeracaoVT;
import com.touchcomp.basementor.model.vo.GeracaoArquivoVT;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.rh.beneficiova.UtilityMetodosTXT;

public class UtilityGeracaoArquivoVTTransfacil {
    public void gerarArquivoVTTransfacil(File arquivo, GeracaoArquivoVT vo) throws ExceptionService, IOException {
        List beneficios = vo.getBeneficios();
        for (BeneficioGeracaoVT beneficio : beneficios) {
            if (beneficio.getLinhaFechamento().getValorTotal() > 0.0 && beneficio.getLinhaFechamento().getValorTotal() <= 650.0) {
                System.err.println(beneficio.getLinhaFechamento().getFechamento().getColaborador().toString());
                this.gerarLinha(beneficio, arquivo);
                continue;
            }
            if (!(beneficio.getLinhaFechamento().getValorTotal() > 650.0)) continue;
            throw new ExceptionService("N\u00e3o \u00e9 possivel ter um carregamento maior do que 650,00");
        }
    }

    private void gerarLinha(BeneficioGeracaoVT beneficio, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        String numeroMatricula = beneficio.getLinhaFechamento().getFechamento().getColaborador().getNumeroRegistro();
        Double valor = beneficio.getLinhaFechamento().getValorTotal();
        p.append(UtilityMetodosTXT.completarComBrancoDireita(numeroMatricula, 15));
        p.append(UtilityMetodosTXT.completarComBrancoEsquerda(UtilityMetodosTXT.formatarValor(valor), 5));
        p.println();
        p.flush();
        p.close();
    }
}

