/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.calculofolha;

import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Feriado;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.tools.ContatoFormatUtil;
import mentorcore.tools.DateUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class CalculoFolhaPagamentoUtilities {
    private static final Integer MES_MARCO = 3;

    public Long findDescontoContribuicaoSindical(Colaborador colaborador, Date dataFolha) {
        Integer ano = DateUtil.yearFromDate(dataFolha);
        Date mesMarcoCorrente = DateUtil.intToDate(ano, MES_MARCO, 1);
        String hql = " select count(mov.identificador)  from MovimentoFolha mov  where  mov.colaborador.identificador = :colaborador and  mov.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento  and mov.aberturaPeriodo.dataInicio < :dataFolha  and  extract(year from mov.aberturaPeriodo.dataInicio) >= :marco  and  mov.colaborador.dataUltimaContribuicaoSindical < :mesMarcoCorrente";
        Long countFolha = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("colaborador", colaborador.getIdentificador().longValue()).setShort("folhaPagamento", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue()).setInteger("marco", MES_MARCO.intValue()).setDate("mesMarcoCorrente", mesMarcoCorrente).setDate("dataFolha", dataFolha).uniqueResult();
        return countFolha;
    }

    public Double findSalarioNominal(Colaborador c, Date periodo) throws ExceptionService {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select c.valorSalario as VALOR_SALARIO from ColaboradorSalario c where c.periodo = (select max(cc.periodo)  from ColaboradorSalario cc                    where (cc.periodo <= :periodo) and cc.colaborador.identificador = :colaborador) and c.colaborador.identificador = :colaborador");
        q.setLong("colaborador", c.getIdentificador().longValue());
        q.setDate("periodo", periodo);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        if (q.list() == null || q.list().isEmpty()) {
            return 0.0;
        }
        if (q.list().size() > 1) {
            throw new ExceptionService("Existe mais de uma salario com a ultima data informada");
        }
        HashMap h = (HashMap)q.list().get(0);
        return (Double)h.get("VALOR_SALARIO");
    }

    public Double findSalarioNominalEsocial(Colaborador c) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select c.valorSalario  from ColaboradorSalario c where c.periodo = (select max(cc.periodo)  from ColaboradorSalario cc                    where cc.colaborador.identificador = :colaborador) and c.colaborador.identificador = :colaborador");
        q.setLong("colaborador", c.getIdentificador().longValue());
        if (q.uniqueResult() == null) {
            return 0.0;
        }
        return (Double)q.uniqueResult();
    }

    public HashMap findDiasPeriodoApuracao(Date dataInicio, Date dataFinal, Long idEmpresa, String nome) throws ExceptionService {
        boolean continua = true;
        Date dataParametro = dataInicio;
        GregorianCalendar aux = new GregorianCalendar();
        Integer ano = DateUtil.yearFromDate(dataInicio);
        aux.setTime(dataInicio);
        Double diasFolgas = 0.0;
        Double diasUteis = 0.0;
        Double diasFeriados = 0.0;
        do {
            Integer diaSemana;
            if ((diaSemana = Integer.valueOf(aux.get(7))).equals(1)) {
                System.err.println(DateUtil.dateToStr(dataParametro) + " -- FOLGAS-" + nome);
                diasFolgas = diasFolgas + 1.0;
            } else {
                diasUteis = diasUteis + 1.0;
                System.err.println(DateUtil.dateToStr(dataParametro) + " -- UTEIS-" + nome);
            }
            if (DateUtil.compareDate(dataParametro, dataFinal).booleanValue()) {
                continua = false;
                continue;
            }
            aux.add(7, 1);
            dataParametro = aux.getTime();
            continua = true;
        } while (continua);
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("periodoFinal", dataFinal);
        request.setAttribute("periodoInicial", dataInicio);
        request.setAttribute("idEmpresa", idEmpresa);
        List feriadoNacional = (List)CoreServiceFactory.getServiceFeriado().execute(request, "findFeriadoPorPeriodo");
        for (Object obj : feriadoNacional) {
            Feriado f = (Feriado)obj;
            dataParametro = DateUtil.intToDate(ano, f.getMes(), f.getDia());
            Integer diaSemana = DateUtil.diaDaSemana(dataParametro);
            if (diaSemana.equals(1)) {
                diasFolgas = diasFolgas - 1.0;
                diasFeriados = diasFeriados + 1.0;
                continue;
            }
            if (!dataParametro.after(dataInicio) && !dataParametro.equals(dataInicio) || !dataParametro.before(dataFinal) && !dataParametro.equals(dataFinal)) continue;
            diasUteis = diasUteis - 1.0;
            diasFeriados = diasFeriados + 1.0;
        }
        HashMap<String, Double> hash = new HashMap<String, Double>();
        hash.put("DIAS_FOLGA", diasFolgas);
        hash.put("DIAS_UTEIS", diasUteis);
        hash.put("DIAS_FERIADOS", diasFeriados);
        hash.put("TOTAL_DIAS", diasFolgas + diasUteis + diasFeriados);
        return hash;
    }

    public Double findSalarioMensal(Colaborador colaborador, Date periodo) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select coalesce(c.valorSalario,0)  from ColaboradorSalario c where c.periodo = (select max(cc.periodo)  from ColaboradorSalario cc                    where (cc.periodo <= :periodo) and cc.colaborador.identificador = :colaborador) and c.colaborador.identificador = :colaborador");
        q.setLong("colaborador", colaborador.getIdentificador().longValue());
        q.setDate("periodo", periodo);
        Double valor = (Double)q.uniqueResult();
        if (valor == null) {
            return 0.0;
        }
        Integer codigo = new Integer(colaborador.getTipoSalario().getCodigo());
        switch (codigo) {
            case 1: {
                return valor;
            }
            case 2: {
                return valor;
            }
            case 3: {
                return valor;
            }
            case 4: {
                valor = valor * colaborador.getDiasJornada();
                return valor;
            }
            case 5: {
                valor = valor * colaborador.getDiasJornada() * colaborador.getHorasTrabDia();
                valor = ContatoFormatUtil.arrredondarNumero(valor, 2);
                return valor;
            }
            case 6: {
                return valor;
            }
            case 7: {
                return valor;
            }
        }
        return valor;
    }
}

