/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.calculofolha;

import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.FeriasColaborador;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.PeriodoFerias;
import com.touchcomp.basementor.model.vo.Recisao;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.rh.calculofolha.UtilCalculoEventosFeriasRescisao;
import mentorcore.service.impl.rh.calculofolha.UtilCalculoFolhaPagamento;
import mentorcore.tools.DateUtil;

public class ServiceFeriasColaborador
extends CoreService {
    public static final String FIND_DIAS_TRABALHADOS_FERIAS_COLABORADOR = "findDiasTrabalhadoFerias";
    public static final String FIND_EVENTOS_FERIAS_RESCISAO = "findEventosFeriasRescisao";
    public static final String FIND_ADICIONAL_FERIAS_NAO_PAGAS = "findAdicionalFeriasNaoPagas";
    public static final String ATUALIZAR_MAIOR_SALARIO_FERIAS = "atualizarMaiorSalarioFerias";
    public static final String VERIFICAR_PAGAMENTO_ADD_DEC = "verificarPagamentoAddDec";
    public static final String VERIFICAR_EXISTENCIA_FERIAS_PERIODO = "verificarExistenciaFeriasPeriodo";
    public static final String EXCLUIR_FERIAS_SEM_ENVIO = "excluirFeriasSemEnvio";
    public static final String EXCLUIR_FERIAS_SEM_ENVIO_INDIVIDUAL = "excluirFeriasSemEnvioIndividual";
    public static final String FIND_ECONSIGNADO_FERIAS = "findEconsignadoFerias";

    public void findDiasTrabalhadoFerias(CoreRequestContext r) throws ExceptionService {
        Date dataInicial = (Date)r.getAttribute("DATA_INICIO_ABERTURA");
        Date dataFinal = (Date)r.getAttribute("DATA_FINAL_ABERTURA");
        MovimentoFolha mov = (MovimentoFolha)r.getAttribute("MOVIMENTO_FOLHA");
        Short tipoCalculo = (Short)r.getAttribute("TIPO_FOLHA");
        EmpresaRh empresaRh = (EmpresaRh)r.getAttribute("EMPRESA_RH");
        CoreDAOFactory.getInstance().getDAOFeriasColaborador().getDiasTrabalhadosFerias(dataInicial, dataFinal, mov, tipoCalculo, empresaRh);
    }

    public void findEventosFeriasRescisao(CoreRequestContext request) {
        Recisao vo = (Recisao)request.getAttribute("recisao");
        EmpresaRh empresaRh = (EmpresaRh)request.getAttribute("empresaRh");
        new UtilCalculoEventosFeriasRescisao().buscarEventoFeriasRescisao(vo, empresaRh);
    }

    public void findAdicionalFeriasNaoPagas(CoreRequestContext request) {
        Recisao vo = (Recisao)request.getAttribute("recisao");
        EmpresaRh empresaRh = (EmpresaRh)request.getAttribute("empresaRh");
        new UtilCalculoEventosFeriasRescisao().buscarAdicionalFeriasNaoPagas(vo, empresaRh);
    }

    public Double atualizarMaiorSalarioFerias(CoreRequestContext request) {
        FeriasColaborador ferias = (FeriasColaborador)request.getAttribute("ferias");
        Date periodo = (Date)request.getAttribute("periodo");
        EmpresaRh empresaRh = (EmpresaRh)request.getAttribute("empresaRh");
        return new UtilCalculoFolhaPagamento().maiorSalarioFerias(ferias, periodo, empresaRh);
    }

    public Integer verificarPagamentoAddDec(CoreRequestContext request) {
        Colaborador colaborador = (Colaborador)request.getAttribute("colaborador");
        Date periodo = (Date)request.getAttribute("periodo");
        return new UtilCalculoEventosFeriasRescisao().verificarPagamentoDecimoTerceiroFerias(colaborador, periodo);
    }

    public Integer verificarExistenciaFeriasPeriodo(CoreRequestContext request) {
        FeriasColaborador feriasColaborador = (FeriasColaborador)request.getAttribute("feriasColaborador");
        return new UtilCalculoEventosFeriasRescisao().verificarExistenciaFeriasPeriodo(feriasColaborador);
    }

    public void excluirFeriasSemEnvio(CoreRequestContext r) throws ExceptionDatabase {
        PeriodoFerias vo = (PeriodoFerias)r.getAttribute("periodoFerias");
        for (FeriasColaborador ferias : vo.getFeriasColaborador()) {
            if (ferias.getPreEventosEsocial().isEmpty()) continue;
            List eventos = ferias.getPreEventosEsocial();
            ferias.setPreEventosEsocial(new ArrayList());
            for (EsocPreEvento e : eventos) {
                e.setFeriasColaborador(null);
                CoreDAOFactory.getInstance().getDAOEsocPreEvento().delete(e);
            }
        }
        CoreDAOFactory.getInstance().getDAOPeriodoFerias().delete(vo);
    }

    public void excluirFeriasSemEnvioIndividual(CoreRequestContext r) throws ExceptionDatabase {
        FeriasColaborador ferias = (FeriasColaborador)r.getAttribute("ferias");
        if (!ferias.getPreEventosEsocial().isEmpty()) {
            List eventos = ferias.getPreEventosEsocial();
            ferias.setPreEventosEsocial(new ArrayList());
            for (EsocPreEvento e : eventos) {
                e.setFeriasColaborador(null);
                CoreDAOFactory.getInstance().getDAOEsocPreEvento().delete(e);
            }
        }
        CoreDAOFactory.getInstance().getDAOFeriasColaborador().delete(ferias);
    }

    public List findEconsignadoFerias(CoreRequestContext r) {
        Colaborador colaborador = (Colaborador)r.getAttribute("colaborador");
        Date dataInicioGozo = (Date)r.getAttribute("dataInicioGozo");
        String hql = " from EventoColaborador evt  where  evt.colaborador = :colaborador  and  extract(month from evt.dataInicial) = :mesGozo   and  extract(year from evt.dataInicial) = :anoGozo  and  evt.eventoConsignado != null ";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setInteger("mesGozo", DateUtil.monthFromDate(dataInicioGozo).intValue()).setInteger("anoGozo", DateUtil.yearFromDate(dataInicioGozo).intValue()).setParameter("colaborador", (Object)colaborador).list();
    }
}

