/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.calculofolha;

import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoOcorrenciaEvtColaborador;
import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoParamFolha;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.EventoColaborador;
import com.touchcomp.basementor.model.vo.FeriasColaborador;
import com.touchcomp.basementor.model.vo.ItemIntegracaoFeriasFolha;
import com.touchcomp.basementor.model.vo.ItemMovimentoFerias;
import com.touchcomp.basementor.model.vo.ItemMovimentoFolha;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.TabelaINSS;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import contatocore.util.ContatoFormatUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionService;
import mentorcore.finder.BaseCriteria;
import mentorcore.service.CoreService;
import mentorcore.tools.DateUtil;

public class UtilCalculoEventosFeriasFolha {
    public void buscarEventosFeriasPorColaborador(MovimentoFolha mov, FeriasColaborador ferias, Date dataInicio, Date dataFinal, EmpresaRh empresaRh) throws ExceptionService {
        boolean achou = false;
        Integer diasGozoFerias = ferias.getDiasGozoFerias().intValue();
        if (DateUtil.monthFromDate(ferias.getDataGozoInicial()).equals(DateUtil.monthFromDate(ferias.getDataGozoFinal()))) {
            for (ItemMovimentoFerias itemFerias : ferias.getItemMovimentoFerias()) {
                for (ItemMovimentoFolha itemFolha : mov.getItensMovimentoFolha()) {
                    System.err.println(itemFolha.getValor());
                    if ((itemFolha.getItemFeriasFolha() == null || !itemFolha.getItemFeriasFolha().getItemFerias().equals((Object)itemFerias)) && (itemFolha.getItemMovRescisao() == null || itemFolha.getItemMovRescisao().getItemFeriasRescisao() == null || !itemFolha.getItemMovRescisao().getItemFeriasRescisao().getItemFerias().equals((Object)itemFerias))) continue;
                    achou = true;
                    break;
                }
                if (!achou && itemFerias.getValor() > 0.0 && (itemFerias.getLancado() == null || itemFerias.getLancado().equals((short)0))) {
                    ItemIntegracaoFeriasFolha itemInteg = new ItemIntegracaoFeriasFolha();
                    itemInteg.setItemFerias(itemFerias);
                    itemInteg.setValorEvento(itemFerias.getValor());
                    itemInteg.setVlrIrrf(ferias.getVrIrrfFerias());
                    itemInteg.setAliquotaIrrfFerias(ferias.getAliqIrrfFerias());
                    itemInteg.setBcIrrfFerias(ferias.getBcIrrfFerias());
                    itemInteg.setItemFolha(this.createItemMovimentoFolha(itemInteg, mov, diasGozoFerias));
                    mov.getItensMovimentoFolha().add(itemInteg.getItemFolha());
                }
                achou = false;
            }
        } else if (ferias.getDataGozoFinal().after(dataFinal)) {
            boolean calcular_novo_liquido = false;
            Short descontar_irrf = 1;
            Integer diasFeriasMes = DateUtil.dayFromDate(dataFinal) - DateUtil.dayFromDate(ferias.getDataGozoInicial()) + 1;
            for (ItemMovimentoFerias itemFerias : ferias.getItemMovimentoFerias()) {
                if (!(itemFerias.getValor() > 0.0) || itemFerias.getLancado() != null && !itemFerias.getLancado().equals((short)0)) continue;
                if (itemFerias.getItensFolhaFerias().isEmpty()) {
                    this.calculoDiasParciais(mov, diasGozoFerias, diasFeriasMes, itemFerias, empresaRh);
                    calcular_novo_liquido = true;
                    continue;
                }
                this.calculoDescontandoMesAnterior(mov, itemFerias, diasFeriasMes);
                descontar_irrf = 0;
            }
            descontar_irrf = 1;
            if (calcular_novo_liquido) {
                this.calcularNovoValorLiquido(ferias, mov, empresaRh, diasFeriasMes, diasGozoFerias, descontar_irrf, dataInicio, dataFinal);
                calcular_novo_liquido = false;
            }
        } else if (ferias.getDataGozoInicial().before(dataInicio)) {
            boolean calcular_novo_liquido = false;
            Short descontar_irrf = 0;
            Integer diasFeriasMes = DateUtil.dayFromDate(ferias.getDataGozoFinal()) - DateUtil.dayFromDate(dataInicio) + 1;
            for (ItemMovimentoFerias itemFerias : ferias.getItemMovimentoFerias()) {
                if (!(itemFerias.getValor() > 0.0) || itemFerias.getLancado() != null && !itemFerias.getLancado().equals((short)0)) continue;
                if (itemFerias.getItensFolhaFerias().isEmpty()) {
                    this.calculoDiasParciais(mov, diasGozoFerias, diasFeriasMes, itemFerias, empresaRh);
                    calcular_novo_liquido = true;
                    descontar_irrf = 0;
                    continue;
                }
                this.calculoDescontandoMesAnterior(mov, itemFerias, diasFeriasMes);
                calcular_novo_liquido = true;
                descontar_irrf = 0;
            }
            if (calcular_novo_liquido) {
                this.calcularNovoValorLiquido(ferias, mov, empresaRh, diasFeriasMes, diasGozoFerias, descontar_irrf, dataInicio, dataFinal);
                calcular_novo_liquido = false;
            }
        }
        this.verificarEConsignado(mov, empresaRh, dataInicio, dataFinal);
    }

    private ItemMovimentoFolha createItemMovimentoFolha(ItemIntegracaoFeriasFolha itemInteg, MovimentoFolha mov, Integer diasFeriasMes) {
        ItemMovimentoFolha item = new ItemMovimentoFolha();
        item.setValor(itemInteg.getValorEvento());
        item.setReferencia(Double.valueOf(diasFeriasMes.doubleValue()));
        item.setInformarValor(Short.valueOf((short)1));
        item.setGeraFeriDecRec(EnumConstTipoCalculoEvento.CALCULO_FERIAS.getValue());
        item.setEventoColaborador(itemInteg.getItemFerias().getEventoColaborador());
        item.setItemFeriasFolha(itemInteg);
        item.setMovimentoFolha(mov);
        return item;
    }

    private void calculoDiasParciais(MovimentoFolha mov, Integer diasGozoFerias, Integer diasFeriasMes, ItemMovimentoFerias itemFerias, EmpresaRh empresaRh) {
        boolean achou = false;
        Double valorEvento = 0.0;
        for (ItemMovimentoFolha itemFolha : mov.getItensMovimentoFolha()) {
            if (itemFolha.getItemFeriasFolha() == null || !itemFolha.getItemFeriasFolha().getItemFerias().equals((Object)itemFerias)) continue;
            achou = true;
            break;
        }
        if (!achou) {
            System.err.println(itemFerias.getEventoColaborador().getTipoCalculoEvento().getEvento().getDescricao());
            valorEvento = !itemFerias.getEventoColaborador().getTipoCalculoEvento().equals((Object)empresaRh.getTpAddDec()) && !itemFerias.getEventoColaborador().getTipoCalculoEvento().equals((Object)empresaRh.getTpliquidoAddDec()) ? ContatoFormatUtil.arrredondarNumero((Double)(itemFerias.getValor() / (double)diasGozoFerias.intValue() * (double)diasFeriasMes.intValue()), (int)2) : itemFerias.getValor();
            Double vlrIrrf = itemFerias.getFerias().getVrIrrfFerias();
            if (itemFerias.getEventoColaborador().getTipoCalculoEvento().getEvento().getCodigo().equals(1017L) && vlrIrrf > 0.0) {
                Double vlrIrrfLiquido = ContatoFormatUtil.arrredondarNumero((Double)(vlrIrrf / (double)diasGozoFerias.intValue() * (double)diasFeriasMes.intValue()), (int)2);
                valorEvento = valorEvento - (vlrIrrf - vlrIrrfLiquido);
            } else if (itemFerias.getRatearValores().equals((short)0) && !itemFerias.getEventoColaborador().getTipoCalculoEvento().getEvento().getCodigo().equals(1017L)) {
                valorEvento = itemFerias.getValor();
                diasFeriasMes = 0;
            }
            ItemIntegracaoFeriasFolha itemInteg = new ItemIntegracaoFeriasFolha();
            itemInteg.setItemFerias(itemFerias);
            itemInteg.setValorEvento(valorEvento);
            itemInteg.setVlrIrrf(vlrIrrf);
            itemInteg.setAliquotaIrrfFerias(itemFerias.getFerias().getAliqIrrfFerias());
            itemInteg.setBcIrrfFerias(itemFerias.getFerias().getBcIrrfFerias());
            itemInteg.setItemFolha(this.createItemMovimentoFolha(itemInteg, mov, diasFeriasMes));
            mov.getItensMovimentoFolha().add(itemInteg.getItemFolha());
        }
        achou = false;
    }

    private void calculoDescontandoMesAnterior(MovimentoFolha mov, ItemMovimentoFerias itemFerias, Integer diasGozoFerias) {
        boolean achou = false;
        for (ItemMovimentoFolha itemFolha : mov.getItensMovimentoFolha()) {
            if (itemFolha.getItemFeriasFolha() == null || !itemFolha.getItemFeriasFolha().getItemFerias().equals((Object)itemFerias)) continue;
            achou = true;
            break;
        }
        if (!achou) {
            Double vlrIrrfDescontado = 0.0;
            Double vlrEventoDescontado = 0.0;
            for (ItemIntegracaoFeriasFolha itemInteg : itemFerias.getItensFolhaFerias()) {
                vlrIrrfDescontado = vlrIrrfDescontado + itemInteg.getVlrIrrf();
                vlrEventoDescontado = vlrEventoDescontado + itemInteg.getValorEvento();
            }
            vlrIrrfDescontado = ContatoFormatUtil.arrredondarNumero((Double)vlrIrrfDescontado, (int)2);
            vlrEventoDescontado = ContatoFormatUtil.arrredondarNumero((Double)vlrEventoDescontado, (int)2);
            ItemIntegracaoFeriasFolha itemInteg = new ItemIntegracaoFeriasFolha();
            itemInteg.setItemFerias(itemFerias);
            itemInteg.setValorEvento(Double.valueOf(itemFerias.getValor() - vlrEventoDescontado));
            itemInteg.setVlrIrrf(Double.valueOf(itemFerias.getFerias().getVrIrrfFerias() - vlrIrrfDescontado));
            itemInteg.setAliquotaIrrfFerias(itemFerias.getFerias().getAliqIrrfFerias());
            itemInteg.setBcIrrfFerias(itemFerias.getFerias().getBcIrrfFerias());
            itemInteg.setItemFolha(this.createItemMovimentoFolha(itemInteg, mov, diasGozoFerias));
            mov.getItensMovimentoFolha().add(itemInteg.getItemFolha());
        }
        achou = false;
    }

    private static Double getTruncarInss(Double valor) {
        BigDecimal bd = BigDecimal.valueOf(valor);
        bd = bd.setScale(2, 1);
        return bd.doubleValue();
    }

    private void calcularNovoValorLiquido(FeriasColaborador ferias, MovimentoFolha mov, EmpresaRh empresaRh, Integer diasFeriasMes, Integer diasGozoFerias, Short descontar_irrf, Date dataInicio, Date dataFinal) throws ExceptionService {
        ItemMovimentoFerias itemLiquidoFerias = null;
        TipoCalculoEvento tpAdd13 = empresaRh.getTpAddDec();
        TipoCalculoEvento tpLiquido13 = empresaRh.getTpliquidoAddDec();
        Double valorNovoLiquido = 0.0;
        for (ItemMovimentoFerias item : ferias.getItemMovimentoFerias()) {
            System.out.println(item.getEventoColaborador().getTipoCalculoEvento().getEvento().getDescricao());
            if (!(item.getEventoColaborador().getTipoCalculoEvento().equals((Object)tpAdd13) || item.getEventoColaborador().getTipoCalculoEvento().equals((Object)tpLiquido13) || empresaRh.getTpEventoSaldoFerias() != null && item.getEventoColaborador().getTipoCalculoEvento().equals((Object)empresaRh.getTpEventoSaldoFerias()) || item.getEventoColaborador().getTipoCalculoEvento().getEvento().getCodigo().equals(1017L))) {
                Double valor;
                if (item.getEventoColaborador().getTipoCalculoEvento().getEvento().getTipoEvento().equals(EnumConstEventoParamFolha.EVENTO_DESCONTO.getValue())) {
                    valor = 0.0;
                    valor = item.getRatearValores().equals((short)1) ? ContatoFormatUtil.arrredondarNumero((Double)(item.getValor() / (double)diasGozoFerias.intValue() * (double)diasFeriasMes.intValue()), (int)2) : ContatoFormatUtil.arrredondarNumero((Double)item.getValor(), (int)2);
                    valorNovoLiquido = valorNovoLiquido - valor;
                    continue;
                }
                valor = 0.0;
                valor = item.getRatearValores().equals((short)1) ? ContatoFormatUtil.arrredondarNumero((Double)(item.getValor() / (double)diasGozoFerias.intValue() * (double)diasFeriasMes.intValue()), (int)2) : ContatoFormatUtil.arrredondarNumero((Double)item.getValor(), (int)2);
                valorNovoLiquido = valorNovoLiquido + valor;
                continue;
            }
            if (!item.getEventoColaborador().getTipoCalculoEvento().getEvento().getCodigo().equals(1017L)) continue;
            itemLiquidoFerias = item;
        }
        Double bcInssFerias = ContatoFormatUtil.arrredondarNumero((Double)(ferias.getBcInssFerias() / (double)diasGozoFerias.intValue() * (double)diasFeriasMes.intValue()), (int)2);
        bcInssFerias = this.verificarLimiteBaseInss(bcInssFerias, dataInicio, dataFinal);
        Double vlrInss = UtilCalculoEventosFeriasFolha.getTruncarInss(ferias.getVrInssFerias() / (double)diasGozoFerias.intValue() * (double)diasFeriasMes.intValue());
        Double vlrIrrf = 0.0;
        if (descontar_irrf.equals((short)1)) {
            vlrIrrf = ferias.getVrIrrfFerias();
        }
        if ((valorNovoLiquido = Double.valueOf(valorNovoLiquido - (vlrInss + vlrIrrf))) != 0.0 && valorNovoLiquido > 0.0) {
            for (ItemMovimentoFolha item : mov.getItensMovimentoFolha()) {
                if (!item.getEventoColaborador().getTipoCalculoEvento().getEvento().getCodigo().equals(1017L) || !item.getItemFeriasFolha().getItemFerias().equals((Object)itemLiquidoFerias)) continue;
                if (itemLiquidoFerias.getItensFolhaFerias().isEmpty()) {
                    item.getItemFeriasFolha().setValorEvento(ContatoFormatUtil.arrredondarNumero((Double)valorNovoLiquido, (int)2));
                    item.setValor(ContatoFormatUtil.arrredondarNumero((Double)valorNovoLiquido, (int)2));
                } else {
                    Double valorDescontado = 0.0;
                    for (ItemIntegracaoFeriasFolha itemInteg : itemLiquidoFerias.getItensFolhaFerias()) {
                        if (item.getItemFeriasFolha().equals((Object)itemInteg)) continue;
                        valorDescontado = valorDescontado + itemInteg.getValorEvento();
                    }
                    if ((valorDescontado = ContatoFormatUtil.arrredondarNumero((Double)valorDescontado, (int)2)) < itemLiquidoFerias.getValor()) {
                        item.getItemFeriasFolha().setValorEvento(ContatoFormatUtil.arrredondarNumero((Double)(itemLiquidoFerias.getValor() - valorDescontado), (int)2));
                        item.setValor(ContatoFormatUtil.arrredondarNumero((Double)(itemLiquidoFerias.getValor() - valorDescontado), (int)2));
                    } else {
                        item.getItemFeriasFolha().setValorEvento(ContatoFormatUtil.arrredondarNumero((Double)(itemLiquidoFerias.getValor() - valorNovoLiquido), (int)2));
                        item.setValor(ContatoFormatUtil.arrredondarNumero((Double)valorNovoLiquido, (int)2));
                    }
                }
                break;
            }
        } else if (valorNovoLiquido < 0.0) {
            if (empresaRh.getTpEventoSaldoFerias() == null) {
                throw new ExceptionService("Informe na Empresa Rh, o evento para saldo insuficiente de Ferias");
            }
            boolean achou = false;
            valorNovoLiquido = Math.abs(valorNovoLiquido);
            for (ItemMovimentoFolha item : mov.getItensMovimentoFolha()) {
                if (!item.getEventoColaborador().getTipoCalculoEvento().equals((Object)empresaRh.getTpEventoSaldoFerias()) || !itemLiquidoFerias.getItensFolhaFerias().isEmpty()) continue;
                item.setValor(ContatoFormatUtil.arrredondarNumero((Double)valorNovoLiquido, (int)2));
                achou = true;
                break;
            }
            if (!achou) {
                ItemMovimentoFolha item;
                EventoColaborador evento = this.createEventoColaborador(mov, empresaRh.getTpEventoSaldoFerias(), dataInicio, dataFinal);
                item = this.createItemMovimentoFolha(mov, valorNovoLiquido, evento);
                mov.getItensMovimentoFolha().add(item);
            }
        }
    }

    public void buscarEventosSegundaFeriasPorColaborador(MovimentoFolha mov, FeriasColaborador ferias, Date dataInicio, Date dataFinal, EmpresaRh empresaRh) throws ExceptionService {
        boolean achou = false;
        Integer diasGozoFerias = ferias.getDiasGozoFerias().intValue();
        if (DateUtil.monthFromDate(ferias.getDataGozoInicial()).equals(DateUtil.monthFromDate(ferias.getDataGozoFinal()))) {
            for (ItemMovimentoFerias itemFerias : ferias.getItemMovimentoFerias()) {
                for (ItemMovimentoFolha itemFolha : mov.getItensMovimentoFolha()) {
                    System.err.println(itemFolha.getValor());
                    if ((itemFolha.getItemFeriasFolha() == null || !itemFolha.getItemFeriasFolha().getItemFerias().equals((Object)itemFerias)) && (itemFolha.getItemMovRescisao() == null || itemFolha.getItemMovRescisao().getItemFeriasRescisao() == null || !itemFolha.getItemMovRescisao().getItemFeriasRescisao().getItemFerias().equals((Object)itemFerias))) continue;
                    achou = true;
                    break;
                }
                if (!achou && itemFerias.getValor() > 0.0 && (itemFerias.getLancado() == null || itemFerias.getLancado().equals((short)0))) {
                    ItemIntegracaoFeriasFolha itemInteg = new ItemIntegracaoFeriasFolha();
                    itemInteg.setItemFerias(itemFerias);
                    itemInteg.setValorEvento(itemFerias.getValor());
                    itemInteg.setVlrIrrf(ferias.getVrIrrfFerias());
                    itemInteg.setAliquotaIrrfFerias(ferias.getAliqIrrfFerias());
                    itemInteg.setBcIrrfFerias(ferias.getBcIrrfFerias());
                    itemInteg.setItemFolha(this.createItemMovimentoFolha(itemInteg, mov, diasGozoFerias));
                    mov.getItensMovimentoFolha().add(itemInteg.getItemFolha());
                }
                achou = false;
            }
        } else if (ferias.getDataGozoFinal().after(dataFinal)) {
            boolean calcular_novo_liquido = false;
            Short descontar_irrf = 1;
            Integer diasFeriasMes = DateUtil.dayFromDate(dataFinal) - DateUtil.dayFromDate(ferias.getDataGozoInicial()) + 1;
            for (ItemMovimentoFerias itemFerias : ferias.getItemMovimentoFerias()) {
                if (!(itemFerias.getValor() > 0.0) || itemFerias.getLancado() != null && !itemFerias.getLancado().equals((short)0)) continue;
                if (itemFerias.getItensFolhaFerias().isEmpty()) {
                    this.calculoDiasParciais(mov, diasGozoFerias, diasFeriasMes, itemFerias, empresaRh);
                    calcular_novo_liquido = true;
                    continue;
                }
                this.calculoDescontandoMesAnterior(mov, itemFerias, diasFeriasMes);
                descontar_irrf = 0;
            }
            if (calcular_novo_liquido) {
                this.calcularNovoValorLiquido(ferias, mov, empresaRh, diasFeriasMes, diasGozoFerias, descontar_irrf, dataInicio, dataFinal);
                calcular_novo_liquido = false;
            }
        } else if (ferias.getDataGozoInicial().before(dataInicio)) {
            boolean calcular_novo_liquido = false;
            Short descontar_irrf = 0;
            Integer diasFeriasMes = DateUtil.dayFromDate(ferias.getDataGozoFinal()) - DateUtil.dayFromDate(dataInicio) + 1;
            for (ItemMovimentoFerias itemFerias : ferias.getItemMovimentoFerias()) {
                if (!(itemFerias.getValor() > 0.0) || itemFerias.getLancado() != null && !itemFerias.getLancado().equals((short)0)) continue;
                if (itemFerias.getItensFolhaFerias().isEmpty()) {
                    this.calculoDiasParciais(mov, diasGozoFerias, diasFeriasMes, itemFerias, empresaRh);
                    calcular_novo_liquido = true;
                    descontar_irrf = 1;
                    continue;
                }
                this.calculoDescontandoMesAnterior(mov, itemFerias, diasFeriasMes);
                calcular_novo_liquido = true;
                descontar_irrf = 0;
            }
            if (calcular_novo_liquido) {
                this.calcularNovoValorLiquido(ferias, mov, empresaRh, diasFeriasMes, diasGozoFerias, descontar_irrf, dataInicio, dataFinal);
                calcular_novo_liquido = false;
            }
        }
    }

    private Double verificarLimiteBaseInss(Double vlrInss, Date dataInicio, Date dataFinal) throws ExceptionService {
        BaseCriteria bc = BaseCriteria.create(CoreDAOFactory.getInstance().getDAOTabelaINSS().getVOClass());
        bc.and().lessEqual("dataInicial", dataInicio);
        bc.and().greaterEqual("dataFinal", dataFinal);
        TabelaINSS t = (TabelaINSS)CoreService.executeSearchUniqueResult(bc);
        if (vlrInss > t.getVrLimiteMaximoInss()) {
            return t.getVrLimiteMaximoInss();
        }
        return vlrInss;
    }

    public void integrarQuitacaoUmTerco(MovimentoFolha mov, List ret) {
        boolean achou = false;
        for (Object object : ret) {
            FeriasColaborador ferias = (FeriasColaborador)object;
            for (ItemMovimentoFerias itemFerias : ferias.getItemMovimentoFerias()) {
                for (ItemMovimentoFolha itemFolha : mov.getItensMovimentoFolha()) {
                    System.err.println(itemFolha.getValor());
                    if ((itemFolha.getItemFeriasFolha() == null || !itemFolha.getItemFeriasFolha().getItemFerias().equals((Object)itemFerias)) && (itemFolha.getItemMovRescisao() == null || itemFolha.getItemMovRescisao().getItemFeriasRescisao() == null || !itemFolha.getItemMovRescisao().getItemFeriasRescisao().getItemFerias().equals((Object)itemFerias))) continue;
                    achou = true;
                    break;
                }
                if (!achou && itemFerias.getValor() > 0.0 && (itemFerias.getLancado() == null || itemFerias.getLancado().equals((short)0))) {
                    ItemIntegracaoFeriasFolha itemInteg = new ItemIntegracaoFeriasFolha();
                    itemInteg.setItemFerias(itemFerias);
                    itemInteg.setValorEvento(itemFerias.getValor());
                    itemInteg.setVlrIrrf(ferias.getVrIrrfFerias());
                    itemInteg.setAliquotaIrrfFerias(ferias.getAliqIrrfFerias());
                    itemInteg.setBcIrrfFerias(ferias.getBcIrrfFerias());
                    itemInteg.setItemFolha(this.createItemMovimentoFolha(itemInteg, mov, itemFerias.getFerias().getDiasGozoFerias().intValue()));
                    mov.getItensMovimentoFolha().add(itemInteg.getItemFolha());
                }
                achou = false;
            }
        }
    }

    private EventoColaborador createEventoColaborador(MovimentoFolha vo, TipoCalculoEvento tp, Date dataInicio, Date dataFinal) {
        EventoColaborador eventoC = new EventoColaborador();
        eventoC.setColaborador(vo.getColaborador());
        eventoC.setDataInicial(dataInicio);
        eventoC.setDataFinal(dataFinal);
        eventoC.setTipoCalculoEvento(tp);
        eventoC.setTipoOcorrencia(EnumConstTipoOcorrenciaEvtColaborador.TP_OCORRENCIA_ESPECIFICAMENTE_PERIODO.getEnumId());
        eventoC.setValor(Double.valueOf(0.0));
        return eventoC;
    }

    private ItemMovimentoFolha createItemMovimentoFolha(MovimentoFolha vo, Double valorNovoLiquido, EventoColaborador e) {
        ItemMovimentoFolha i = new ItemMovimentoFolha();
        i.setMovimentoFolha(vo);
        valorNovoLiquido = ContatoFormatUtil.arrredondarNumero((Double)valorNovoLiquido, (int)2);
        i.setValor(valorNovoLiquido);
        i.setReferencia(Double.valueOf(0.0));
        i.setInformarValor(Short.valueOf((short)1));
        i.setEventoColaborador(e);
        return i;
    }

    private void verificarEConsignado(MovimentoFolha mov, EmpresaRh empresaRh, Date dataInicio, Date dataFinal) {
        ArrayList<ItemMovimentoFolha> aux = new ArrayList<ItemMovimentoFolha>();
        for (ItemMovimentoFolha itemMov : mov.getItensMovimentoFolha()) {
            if (empresaRh.getTpEconsginado() == null || empresaRh.getTpEconsginadoProvisao() == null || !itemMov.getEventoColaborador().getTipoCalculoEvento().equals((Object)empresaRh.getTpEconsginadoProvisao())) continue;
            ItemMovimentoFolha item = new ItemMovimentoFolha();
            item.setValor(itemMov.getValor());
            item.setReferencia(itemMov.getReferencia());
            item.setInformarValor(Short.valueOf((short)1));
            item.setGeraFeriDecRec(EnumConstTipoCalculoEvento.CALCULO_FERIAS.getValue());
            EventoColaborador evte = this.createEventoColaborador(mov, empresaRh.getTpEconsginado(), dataInicio, dataFinal);
            item.setEventoColaborador(evte);
            item.setMovimentoFolha(mov);
            aux.add(item);
        }
        mov.getItensMovimentoFolha().addAll(aux);
    }
}

