/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.calculofolha;

import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoParamFolha;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.FeriasColaborador;
import com.touchcomp.basementor.model.vo.ItemIntegracaoFeriasFolha;
import com.touchcomp.basementor.model.vo.ItemMovimentoFerias;
import com.touchcomp.basementor.model.vo.ItemMovimentoRescisao;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import contatocore.util.ContatoFormatUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.tools.DateUtil;

public class UtilCalculoEventosFeriasRescisao {
    public void buscarAdicionalFeriasNaoPagas(Recisao vo, EmpresaRh empresaRh) {
        Colaborador colaborador = vo.getColaborador();
        HashMap h = this.getAdicionalUmTercoNaoPago(colaborador);
        if (h == null) {
            return;
        }
        ItemMovimentoFerias item = (ItemMovimentoFerias)h.get("ITEM");
        Double valorTotal = (Double)h.get("VALOR_TOTAL");
        ItemIntegracaoFeriasFolha itemInteg = new ItemIntegracaoFeriasFolha();
        itemInteg.setBcIrrfFerias(Double.valueOf(0.0));
        itemInteg.setAliquotaIrrfFerias(Double.valueOf(0.0));
        itemInteg.setVlrIrrf(Double.valueOf(0.0));
        itemInteg.setItemFerias(item);
        itemInteg.setValorEvento(valorTotal);
        itemInteg.setItemRecisao(this.createItemRescisao(itemInteg, vo));
        vo.getItemRescisao().add(itemInteg.getItemRecisao());
    }

    public void buscarEventoFeriasRescisao(Recisao vo, EmpresaRh empresaRh) {
        Colaborador colaborador = vo.getColaborador();
        Date dataAfastamento = vo.getDataAfastamento();
        Date primeiroDiaMes = this.findPrimeiroDiaMes(dataAfastamento);
        List<FeriasColaborador> f = this.findFeriasAberto(colaborador, dataAfastamento);
        for (FeriasColaborador ferias : f) {
            if (ferias == null) {
                return;
            }
            Integer diasGozoFerias = DateUtil.diferenceDayBetweenDates(ferias.getDataGozoInicial(), ferias.getDataGozoFinal()) + 1;
            Integer diasFeriasMes = DateUtil.dayFromDate(ferias.getDataGozoFinal());
            if (DateUtil.monthFromDate(ferias.getDataGozoInicial()).equals(DateUtil.monthFromDate(ferias.getDataGozoFinal()))) {
                for (ItemMovimentoFerias item : ferias.getItemMovimentoFerias()) {
                    if (!(item.getValor() > 0.0) || item.getLancado() != null && !item.getLancado().equals((short)0)) continue;
                    ItemIntegracaoFeriasFolha itemInteg = new ItemIntegracaoFeriasFolha();
                    itemInteg.setBcIrrfFerias(ferias.getBcIrrfFerias());
                    itemInteg.setAliquotaIrrfFerias(ferias.getAliqIrrfFerias());
                    itemInteg.setVlrIrrf(ferias.getVrIrrfFerias());
                    itemInteg.setItemFerias(item);
                    itemInteg.setValorEvento(item.getValor());
                    itemInteg.setItemRecisao(this.createItemRescisao(itemInteg, vo));
                    vo.getItemRescisao().add(itemInteg.getItemRecisao());
                }
                continue;
            }
            if (!ferias.getDataGozoInicial().before(primeiroDiaMes)) continue;
            for (ItemMovimentoFerias itemFerias : ferias.getItemMovimentoFerias()) {
                if (!(itemFerias.getValor() > 0.0) || itemFerias.getLancado() != null && !itemFerias.getLancado().equals((short)0)) continue;
                this.calculoDescontandoMesAnterior(vo, itemFerias);
            }
        }
    }

    private List<FeriasColaborador> findFeriasAberto(Colaborador colaborador, Date dataAfastamento) {
        String hql = " from FeriasColaborador ferias  where  ferias.periodoAqFeriasColab.colaborador = :colaborador  and   extract(month from ferias.dataGozoFinal) = :mesAfastamento  and  extract(year from ferias.dataGozoFinal) = :anoAfastamento ";
        List ret = CoreBdUtil.getInstance().getSession().createQuery(hql).setInteger("anoAfastamento", DateUtil.yearFromDate(dataAfastamento).intValue()).setInteger("mesAfastamento", DateUtil.monthFromDate(dataAfastamento).intValue()).setEntity("colaborador", (Object)colaborador).list();
        if (ret == null || ret.isEmpty()) {
            return new ArrayList<FeriasColaborador>();
        }
        return ret;
    }

    private Date findPrimeiroDiaMes(Date dataAfastamento) {
        Integer ano = DateUtil.yearFromDate(dataAfastamento);
        Integer mes = DateUtil.monthFromDate(dataAfastamento);
        return DateUtil.intToDate(ano, mes, 1);
    }

    private ItemMovimentoRescisao createItemRescisao(ItemIntegracaoFeriasFolha itemInteg, Recisao vo) {
        ItemMovimentoRescisao itemRescisao = new ItemMovimentoRescisao();
        itemRescisao.setCompoeMediaRescisao(Short.valueOf((short)0));
        itemRescisao.setInformarValor(Short.valueOf((short)1));
        itemRescisao.setRecisao(vo);
        itemRescisao.setValor(itemInteg.getValorEvento());
        itemRescisao.setEventoColaborador(itemInteg.getItemFerias().getEventoColaborador());
        itemRescisao.setReferencia(Double.valueOf(0.0));
        itemRescisao.setItemFeriasRescisao(itemInteg);
        itemRescisao.setCampo(itemInteg.getItemFerias().getEventoColaborador().getTipoCalculoEvento().getEvento().getCodigo().toString());
        return itemRescisao;
    }

    private void calculoDescontandoMesAnterior(Recisao vo, ItemMovimentoFerias itemFerias) {
        Double irrfMesAnterior = 0.0;
        Double valorEventoMesAnterior = 0.0;
        for (ItemIntegracaoFeriasFolha itemInteg : itemFerias.getItensFolhaFerias()) {
            irrfMesAnterior = itemInteg.getVlrIrrf() + irrfMesAnterior;
            valorEventoMesAnterior = itemInteg.getValorEvento() + valorEventoMesAnterior;
        }
        ItemIntegracaoFeriasFolha itemInteg = new ItemIntegracaoFeriasFolha();
        itemInteg.setItemFerias(itemFerias);
        itemInteg.setValorEvento(Double.valueOf(itemFerias.getValor() - valorEventoMesAnterior));
        itemInteg.setVlrIrrf(Double.valueOf(itemFerias.getFerias().getVrIrrfFerias() - irrfMesAnterior));
        itemInteg.setBcIrrfFerias(itemFerias.getFerias().getBcIrrfFerias());
        itemInteg.setAliquotaIrrfFerias(itemFerias.getFerias().getAliqIrrfFerias());
        itemInteg.setItemRecisao(this.createItemRescisao(itemInteg, vo));
        vo.getItemRescisao().add(itemInteg.getItemRecisao());
    }

    private void calcularNovoValorLiquido(FeriasColaborador ferias, Recisao vo, EmpresaRh empresaRh, Integer diasFeriasMes, Integer diasGozoFerias, Short descontar_irrf) {
        TipoCalculoEvento tpAdd13 = empresaRh.getTpAddDec();
        TipoCalculoEvento tpLiquido13 = empresaRh.getTpliquidoAddDec();
        Double valorNovoLiquido = 0.0;
        for (ItemMovimentoFerias item : ferias.getItemMovimentoFerias()) {
            Double valor;
            if (item.getEventoColaborador().getTipoCalculoEvento().equals((Object)tpAdd13) || item.getEventoColaborador().getTipoCalculoEvento().equals((Object)tpLiquido13) || item.getEventoColaborador().getTipoCalculoEvento().getEvento().getCodigo().equals(1017L)) continue;
            if (item.getEventoColaborador().getTipoCalculoEvento().getEvento().getTipoEvento().equals(EnumConstEventoParamFolha.EVENTO_DESCONTO.getValue())) {
                valor = 0.0;
                valor = item.getRatearValores().equals((short)1) ? ContatoFormatUtil.arrredondarNumero((Double)(item.getValor() / (double)diasGozoFerias.intValue() * (double)diasFeriasMes.intValue()), (int)2) : ContatoFormatUtil.arrredondarNumero((Double)(item.getValor() / (double)diasGozoFerias.intValue() * (double)diasFeriasMes.intValue()), (int)2);
                valorNovoLiquido = valorNovoLiquido - valor;
                continue;
            }
            valor = 0.0;
            valor = item.getRatearValores().equals((short)1) ? ContatoFormatUtil.arrredondarNumero((Double)(item.getValor() / (double)diasGozoFerias.intValue() * (double)diasFeriasMes.intValue()), (int)2) : ContatoFormatUtil.arrredondarNumero((Double)(item.getValor() / (double)diasGozoFerias.intValue() * (double)diasFeriasMes.intValue()), (int)2);
            valorNovoLiquido = valorNovoLiquido + valor;
        }
        Double vlrInss = ContatoFormatUtil.arrredondarNumero((Double)(ferias.getVrInssFerias() / (double)diasGozoFerias.intValue() * (double)diasFeriasMes.intValue()), (int)2);
        Double vlrIrrf = 0.0;
        if (descontar_irrf.equals((short)1)) {
            vlrIrrf = ferias.getVrIrrfFerias();
        }
        if ((valorNovoLiquido = Double.valueOf(valorNovoLiquido - (vlrInss + vlrIrrf))) != 0.0) {
            for (ItemMovimentoRescisao item : vo.getItemRescisao()) {
                if (!item.getEventoColaborador().getTipoCalculoEvento().getEvento().getCodigo().equals(1017L) || !item.getItemFeriasRescisao().getItemFerias().getFerias().equals((Object)ferias)) continue;
                item.getItemFeriasRescisao().setValorEvento(ContatoFormatUtil.arrredondarNumero((Double)(item.getValor() - valorNovoLiquido), (int)2));
                item.setValor(ContatoFormatUtil.arrredondarNumero((Double)valorNovoLiquido, (int)2));
                break;
            }
        }
    }

    public Integer verificarPagamentoDecimoTerceiroFerias(Colaborador colaborador, Date periodo) {
        String hql = " select coalesce(sum(i.valor),0)  from ItemMovimentoFolha i  where  i.movimentoFolha.colaborador = :colaborador  and  i.eventoColaborador.tipoCalculoEvento.evento.codigo = 1009  and  extract(year from i.movimentoFolha.aberturaPeriodo.dataInicio) = :ano ";
        Double valorDesconto = (Double)CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setInteger("ano", DateUtil.yearFromDate(periodo).intValue()).uniqueResult();
        if (valorDesconto != null && valorDesconto > 0.0) {
            return 1;
        }
        return 0;
    }

    public Integer verificarExistenciaFeriasPeriodo(FeriasColaborador ferias) {
        Colaborador colaborador = ferias.getPeriodoAqFeriasColab().getColaborador();
        Date dataInicial = ferias.getDataGozoInicial();
        Date dataFinal = ferias.getDataGozoFinal();
        Long idFerias = ferias.getIdentificador() != null ? ferias.getIdentificador() : 0L;
        String hql = " select coalesce(count(f.identificador),0)  from FeriasColaborador f  where  f.periodoAqFeriasColab.colaborador = :colaborador  and  (:dataInicial between f.dataGozoInicial and f.dataGozoFinal or :dataFinal between f.dataGozoInicial and f.dataGozoFinal)  and  f.identificador != :newId ";
        Long retorno = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setDate("dataInicial", dataInicial).setDate("dataFinal", dataFinal).setLong("newId", idFerias.longValue()).uniqueResult();
        if (retorno == null || retorno == 0L) {
            return 0;
        }
        return 1;
    }

    private HashMap getAdicionalUmTercoNaoPago(Colaborador colaborador) {
        String hql = " from ItemMovimentoFerias item  where  item.eventoColaborador.tipoCalculoEvento.evento.codigo = :adicionalUmTerco  and  item.ferias.descartarUmTercoFerias = :sim  and  item.ferias.periodoAqFeriasColab.colaborador = :colaborador ";
        List ret = CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("sim", (short)1).setEntity("colaborador", (Object)colaborador).setLong("adicionalUmTerco", 1015L).list();
        if (ret == null || ret.isEmpty()) {
            return null;
        }
        Double valorTotal = 0.0;
        for (Object object : ret) {
            ItemMovimentoFerias item = (ItemMovimentoFerias)object;
            valorTotal = valorTotal + item.getValorProvisionado();
        }
        HashMap<String, Double> h = new HashMap<String, Double>();
        h.put("VALOR_TOTAL", valorTotal);
        h.put("ITEM", (Double)ret.get(0));
        return h;
    }
}

