/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.calculofolha;

import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.FeriasColaborador;
import contatocore.util.ContatoFormatUtil;
import java.util.Date;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.tools.DateUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class UtilCalculoFolhaPagamento {
    private static final Integer MES_MARCO = 3;

    public Long findDescontoContribuicaoSindical(Colaborador colaborador, Date dataFolha) {
        Integer ano = DateUtil.yearFromDate(dataFolha);
        Date mesMarcoCorrente = DateUtil.intToDate(ano, MES_MARCO, 1);
        String hql = " select count(mov.identificador)  from MovimentoFolha mov  where  mov.colaborador.identificador = :colaborador and  mov.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento  and mov.aberturaPeriodo.dataInicio < :dataFolha  and  extract(year from mov.aberturaPeriodo.dataInicio) >= :marco  and  mov.colaborador.dataUltimaContribuicaoSindical < :mesMarcoCorrente";
        Long countFolha = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("colaborador", colaborador.getIdentificador().longValue()).setShort("folhaPagamento", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue()).setInteger("marco", MES_MARCO.intValue()).setDate("mesMarcoCorrente", mesMarcoCorrente).setDate("dataFolha", dataFolha).uniqueResult();
        return countFolha;
    }

    public Double salarioProvisao(Colaborador colaborador) {
        String cod = colaborador.getTipoSalario().getCodigo();
        System.err.println(colaborador.toString() + "Metodo");
        Integer codigo = new Integer(cod);
        Double vlrSalario = colaborador.getValorSalario();
        if (vlrSalario == null) {
            return 0.0;
        }
        Double valor = vlrSalario;
        switch (codigo) {
            case 1: {
                return valor;
            }
            case 2: {
                return valor;
            }
            case 3: {
                return valor;
            }
            case 4: {
                valor = valor * colaborador.getDiasJornada();
                return valor;
            }
            case 5: {
                valor = valor * colaborador.getDiasJornada() * colaborador.getHorasTrabDia();
                valor = ContatoFormatUtil.arrredondarNumero((Double)valor, (int)2);
                return valor;
            }
            case 6: {
                return valor;
            }
            case 7: {
                return valor;
            }
        }
        return valor;
    }

    public Double findSalarioNominal(Colaborador colaborador, Date periodo) {
        String cod = colaborador.getTipoSalario().getCodigo();
        System.err.println(colaborador.toString() + "Metodo");
        Integer codigo = new Integer(cod);
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select c.valorSalario  from ColaboradorSalario c where c.periodo = (select max(cc.periodo)  from ColaboradorSalario cc                    where (cc.periodo <= :periodo) and cc.colaborador.identificador = :colaborador) and c.colaborador.identificador = :colaborador");
        q.setLong("colaborador", colaborador.getIdentificador().longValue());
        q.setDate("periodo", periodo);
        if (q.uniqueResult() == null) {
            return 0.0;
        }
        Double valor = (Double)q.uniqueResult();
        switch (codigo) {
            case 1: {
                return valor;
            }
            case 2: {
                return valor;
            }
            case 3: {
                return valor;
            }
            case 4: {
                valor = valor * colaborador.getDiasJornada();
                return valor;
            }
            case 5: {
                valor = valor * colaborador.getDiasJornada() * colaborador.getHorasTrabDia();
                valor = ContatoFormatUtil.arrredondarNumero((Double)valor, (int)2);
                return valor;
            }
            case 6: {
                return valor;
            }
            case 7: {
                return valor;
            }
        }
        return valor;
    }

    public List findEventosRecisaoComplementar(Colaborador c, Date dataInicio, Date dataFinal) {
        String hql = " select distinct(itemRecisao)  from ItemMovimentoRescisao itemRecisao  where  itemRecisao.recisao.colaborador = :colaborador  and  itemRecisao.recisao.dataPagamento between :dataInicio and :dataFinal  and  itemRecisao.recisao.recisaoComplementar = :sim  and  (itemRecisao.lancado is null or itemRecisao.lancado = :nao )";
        List l = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)c).setDate("dataInicio", dataInicio).setDate("dataFinal", dataFinal).setShort("nao", (short)0).setShort("sim", (short)1).list();
        return l;
    }

    public Short findProxNrIndiceAbertura(Date dataInicial, Date dataFinal, Long idEmpresa) {
        String hql = " select max(coalesce(ab.indice,0))  from AberturaPeriodo ab  where  ab.dataInicio = :dataInicio  and  ab.dataFinal = :dataFinal  and  ab.empresa.identificador = :idEmpresa ";
        return (Short)CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("dataInicio", dataInicial).setDate("dataFinal", dataFinal).setLong("idEmpresa", idEmpresa.longValue()).uniqueResult();
    }

    public Double maiorSalarioFerias(FeriasColaborador ferias, Date periodo, EmpresaRh empresaRh) {
        Colaborador colaborador = ferias.getPeriodoAqFeriasColab().getColaborador();
        String cod = colaborador.getTipoSalario().getCodigo();
        System.err.println(colaborador.toString() + "Metodo");
        Integer codigo = new Integer(cod);
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select c.valorSalario  from ColaboradorSalario c where c.periodo = (select max(cc.periodo)  from ColaboradorSalario cc                    where (cc.periodo <= :periodo) and cc.colaborador.identificador = :colaborador) and c.colaborador.identificador = :colaborador");
        q.setLong("colaborador", colaborador.getIdentificador().longValue());
        q.setDate("periodo", periodo);
        if (q.uniqueResult() == null) {
            return 0.0;
        }
        Double valor = (Double)q.uniqueResult();
        switch (codigo) {
            case 1: {
                return valor;
            }
            case 2: {
                return valor;
            }
            case 3: {
                return valor;
            }
            case 4: {
                valor = valor * colaborador.getDiasJornada();
                return valor;
            }
            case 5: {
                if (empresaRh.getFeriasHoristaJornadaVariavel().equals((short)0)) {
                    valor = valor * colaborador.getHorasTrabDia() * colaborador.getDiasJornada();
                    valor = ContatoFormatUtil.arrredondarNumero((Double)valor, (int)2);
                    return valor;
                }
                return 0.0;
            }
            case 6: {
                return valor;
            }
            case 7: {
                return valor;
            }
        }
        return valor;
    }

    private Double diasPeriodoAquisitivo(Colaborador c, Date dataInicial, Date dataFinal) {
        Integer difDias = DateUtil.diferenceDayBetweenDates(dataInicial, dataFinal) + 1;
        return c.getHorasTrabDia() * difDias.doubleValue() / 12.0;
    }
}

