/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.calculofolha;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.model.vo.GeracaoReciboRpa;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.ParametrizacaoFinanceiraFolha;
import com.touchcomp.basementor.model.vo.TipoCalculo;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesfinanceiras.HelperOpcoesFinanceiras;
import com.touchcomp.basementorspringcontext.Context;
import java.util.ArrayList;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.tools.DateUtil;

public class UtilGeracaoTituloRpa {
    public void criarTituloRPA(GeracaoReciboRpa vo, OpcoesFinanceiras opcoesFinanceiras) throws ExceptionService {
        Titulo t = new Titulo();
        TipoCalculo tpCalculo = this.getTipoCalculo();
        ParametrizacaoFinanceiraFolha parametrizacaoFinanceira = (ParametrizacaoFinanceiraFolha)CoreServiceFactory.getServiceParametrizacaoFinanceiraFolha().execute(CoreRequestContext.newInstance().setAttribute("centroCusto", vo.getColaborador().getCentroCusto()).setAttribute("tipoFolha", tpCalculo).setAttribute("tipoColaborador", vo.getColaborador().getTipoColaborador()), "findParametrizacaoFinancFolha");
        t.setPagRec(Short.valueOf((short)0));
        t.setProvisao(Short.valueOf((short)1));
        t.setTipoDoc(opcoesFinanceiras.getTipoDocFinanceiroFolhaPagamento());
        if (vo.getDescricaoServico() == null || vo.getDescricaoServico().isEmpty()) {
            t.setObservacao("RPA colaborador: " + vo.getColaborador().getPessoa().getNome());
        } else {
            t.setObservacao("RPA colaborador: " + vo.getColaborador().getPessoa().getNome() + " " + vo.getDescricaoServico());
        }
        t.setValor(vo.getLiquido());
        t.setNumParcTituloEstnota(Short.valueOf((short)1));
        t.setPessoa(vo.getColaborador().getPessoa());
        t.setClassificacaoPessoa(opcoesFinanceiras.getClassificacaoClientes());
        t.setTipoPessoa(EnumConstPessoa.COLABORADOR.getEnumId());
        t.setDataEmissao(vo.getDataPagamento());
        t.setDataVencimento(vo.getDataPagamento());
        t.setDataVencimentoBase(vo.getDataPagamento());
        t.setDataCompetencia(vo.getDataPagamento());
        t.setDataEntradaSaida(t.getDataCompetencia());
        t.setEmpresa(vo.getEmpresa());
        t.setDataCadastro(vo.getDataCadastro());
        t.setPlanoConta(parametrizacaoFinanceira.getPlanoContaContabil());
        t.setCarteiraCobranca(((HelperOpcoesFinanceiras)Context.get(HelperOpcoesFinanceiras.class)).build(opcoesFinanceiras).getCarteiraCobranca(t.getPagRec().shortValue()));
        t.setMeioPagamento(opcoesFinanceiras.getMeioPagamento());
        LancamentoCtbGerencial lancGerencial = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, DateUtil.getDateLastMonthDay(vo.getDataPagamento()), t.getDataVencimento(), Short.valueOf(EnumLancamentoCTBGerencial.DEBITO.getValue()), vo.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.SIM.getValue()), "Titulo referente ao Pagamento do RPA do colaborador: " + vo.getColaborador().getPessoa().getNome(), parametrizacaoFinanceira.getPlanoContaGerencial(), t.getProvisao(), Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), vo.getColaborador().getCentroCusto(), vo.getLiquido(), null);
        ArrayList<LancamentoCtbGerencial> lanc = new ArrayList<LancamentoCtbGerencial>();
        lanc.add(lancGerencial);
        t.setLancCtbGerencial(lanc);
        vo.setTitulo(t);
    }

    private TipoCalculo getTipoCalculo() {
        String hql = " from TipoCalculo tp  where  tp.tipoFolha = :folhaPagamento ";
        return (TipoCalculo)CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("folhaPagamento", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue()).setMaxResults(1).uniqueResult();
    }
}

