/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.colaborador;

import com.touchcomp.basementor.model.vo.AdvertenciaColaborador;
import com.touchcomp.basementor.model.vo.Colaborador;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.rh.colaborador.UtilityAdvertenciaColaborador;

public class ServiceAdvertenciaColaborador
extends CoreService {
    public static final String FIND_ADVERTENCIAS_ANTERIORES = "findAdvertenciasAnteriores";
    public static final String VALIDAR_QUANTIDADE_ADVERTENCIAS_COLABORADOR = "validarQuantidadeAdvertencias";

    public Integer findAdvertenciasAnteriores(CoreRequestContext request) {
        Colaborador colaborador = (Colaborador)request.getAttribute("colaborador");
        return new UtilityAdvertenciaColaborador().findAdvertenciasAnteriores(colaborador);
    }

    public Object validarQuantidadeAdvertencias(CoreRequestContext request) throws ExceptionService, ExceptionDatabase {
        Short qtdade = (Short)request.getAttribute("qtdade");
        Short duracao = (Short)request.getAttribute("duracao");
        AdvertenciaColaborador advertencia = (AdvertenciaColaborador)request.getAttribute("advertencia");
        Integer qtdadePorCodigo = new UtilityAdvertenciaColaborador().verificarQtdadeAdvertenciaPorColaborador(advertencia, advertencia.getColaborador(), duracao);
        if (qtdadePorCodigo < qtdade.intValue()) {
            return CoreDAOFactory.getInstance().getDAOAdvertenciaColaborador().saveOrUpdate(advertencia);
        }
        throw new ExceptionService("Numero de Advertencia por codigo foi Atingido. Verifique o Limite na Empresa RH");
    }
}

