/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.colaborador;

import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringTokenizer;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.rh.colaborador.model.LeiuteRetornoQualificacao;
import org.apache.commons.lang3.StringUtils;

public class UtilQualificacaoCadastral {
    public List findColaboradorQualificacaoCadastral(Empresa empresa) {
        String hql = " from Colaborador c  where  c.empresa = :empresa  and  c.ativo = :sim  and  c.dataDemissao is null and  (c.tipoColaborador.identificador = :empregado  or   c.tipoColaborador.identificador = :socio  or  c.tipoColaborador.identificador = :menorAprendiz) ";
        List ret = CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("sim", (short)1).setLong("empregado", EnumConstTipoColaborador.EMPREGADO.getValue()).setLong("socio", EnumConstTipoColaborador.SOCIO_DIRETOR.getValue()).setEntity("empresa", (Object)empresa).setLong("menorAprendiz", EnumConstTipoColaborador.MENOR_APRENDIZ.getValue()).list();
        return ret;
    }

    public void gerarArquivo(List colaboradores, File arquivo) throws IOException {
        this.criarArquivo(colaboradores, arquivo);
    }

    private void criarArquivo(List colaboradores, File arquivo) throws IOException {
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        for (Object object : colaboradores) {
            Colaborador c = (Colaborador)object;
            String cpf = ToolString.refina((String)c.getPessoa().getComplemento().getCnpj());
            String pis = c.getNumeroPis();
            String nome = c.getPessoa().getNome();
            String dataNascimento = UtilQualificacaoCadastral.formatarDatas8Digitos(c.getPessoa().getComplemento().getDataNascimento());
            p.append(UtilQualificacaoCadastral.completarComZeroEsquerda(cpf, 11));
            p.append(";");
            p.append(UtilQualificacaoCadastral.completarComZeroEsquerda(pis, 11));
            p.append(";");
            p.append(UtilQualificacaoCadastral.completarComBrancoDireita(ToolString.clearStringXml((String)c.getPessoa().getNome()), 60));
            p.append(";");
            p.append(dataNascimento);
            p.println();
        }
        p.println();
        p.flush();
        p.close();
    }

    public static String completarComZeroEsquerda(String st, int tam) {
        if (st.length() > tam) {
            return st.substring(0, tam);
        }
        return StringUtils.leftPad((String)st, (int)tam, (String)"0");
    }

    public static String completarComBrancoDireita(String st, int tam) {
        if (st.length() > tam) {
            return st.substring(0, tam);
        }
        return StringUtils.rightPad((String)st, (int)tam, (String)" ");
    }

    public static String formatarDatas8Digitos(Date data) {
        if (data != null) {
            SimpleDateFormat dataFormatada = new SimpleDateFormat("ddMMyyyy");
            String dataVenc = dataFormatada.format(data);
            return dataVenc;
        }
        return "        ";
    }

    public List<LeiuteRetornoQualificacao> processarRetorno(File arquivo, Empresa empresa) throws FileNotFoundException, IOException, ExceptionService {
        FileReader file = new FileReader(arquivo);
        BufferedReader buffer = new BufferedReader(file);
        ArrayList<LeiuteRetornoQualificacao> retorno = new ArrayList<LeiuteRetornoQualificacao>();
        boolean inserir = true;
        while (buffer.ready()) {
            LeiuteRetornoQualificacao l = new LeiuteRetornoQualificacao();
            String linha = buffer.readLine();
            System.out.println(linha);
            if (!linha.isEmpty() && !linha.substring(0, 3).equals("CPF")) {
                List<StringToken> list = UtilQualificacaoCadastral.getReplaceTokens(linha);
                for (StringToken t : list) {
                    if (t.getChave().equals("1")) {
                        if (this.existeColaboradorEmpresa(t.getValor(), empresa)) {
                            l.setCpf(t.getValor());
                            continue;
                        }
                        inserir = false;
                        break;
                    }
                    if (t.getChave().equals("2")) {
                        l.setPis(t.getValor());
                        continue;
                    }
                    if (t.getChave().equals("3")) {
                        l.setNome(t.getValor());
                        continue;
                    }
                    if (t.getChave().equals("4")) {
                        l.setDataNascimento(t.getValor());
                        continue;
                    }
                    if (t.getChave().equals("5")) {
                        l.setCOD_NIS_INV(this.getValorToken(t.getValor(), "NIS INVALIDO"));
                        continue;
                    }
                    if (t.getChave().equals("6")) {
                        l.setCOD_CPF_INV(this.getValorToken(t.getValor(), "CPF INVALIDO"));
                        continue;
                    }
                    if (t.getChave().equals("7")) {
                        l.setCOD_NOME_INV(this.getValorToken(t.getValor(), "NOME INVALIDO"));
                        continue;
                    }
                    if (t.getChave().equals("8")) {
                        l.setCOD_DN_INV(this.getValorToken(t.getValor(), "DN INVALIDO"));
                        continue;
                    }
                    if (t.getChave().equals("9")) {
                        l.setCOD_CNIS_NIS(this.getValorToken(t.getValor(), "NIS INCONSISTENTE"));
                        continue;
                    }
                    if (t.getChave().equals("10")) {
                        l.setCOD_CNIS_DN(this.getValorToken(t.getValor(), "DN DIVERGE DA EXISTENTE NO CNIS"));
                        continue;
                    }
                    if (t.getChave().equals("11")) {
                        l.setCOD_CNIS_OBITO(this.getValorToken(t.getValor(), "NIS COM OBITO NO CNIS"));
                        continue;
                    }
                    if (t.getChave().equals("12")) {
                        l.setCOD_CNIS_CPF(this.getValorToken(t.getValor(), "CPF INFORMADO DIVERGE DO EXISTENTE DO CNIS"));
                        continue;
                    }
                    if (t.getChave().equals("13")) {
                        l.setCOD_CNIS_CPF_NAO_INF(this.getValorToken(t.getValor(), "CPF N\u00c3O PREENCHIDO NO CNIS"));
                        continue;
                    }
                    if (t.getChave().equals("14")) {
                        l.setCOD_CPF_NAO_CONSTA(this.getValorToken(t.getValor(), "CPF INFORMADO N\u00c3O CONSTA O CADASTRO CPF"));
                        continue;
                    }
                    if (t.getChave().equals("15")) {
                        l.setCOD_CPF_NULO(this.getValorToken(t.getValor(), "CPF INFORMADO NULO NO CADASTRO CPF"));
                        continue;
                    }
                    if (t.getChave().equals("16")) {
                        l.setCOD_CPF_CANCELADO(this.getValorToken(t.getValor(), "CPF INFORMADO CANCELADO NO CADASTRO CPF"));
                        continue;
                    }
                    if (t.getChave().equals("17")) {
                        l.setCOD_CPF_SUSPENSO(this.getValorToken(t.getValor(), "CPF INFORMADO SUSPENSO NO CADASTRO CPF"));
                        continue;
                    }
                    if (t.getChave().equals("18")) {
                        l.setCOD_CPF_DN(this.getValorToken(t.getValor(), "DN DIVERGE DA EXISTENTE NO CADASTRO CPF"));
                        continue;
                    }
                    if (t.getChave().equals("19")) {
                        l.setCOD_CPF_NOME(this.getValorToken(t.getValor(), "NOME DIVERGEDO EXISTENTE DO CADASTRO CPF: " + t.getValor()));
                        continue;
                    }
                    if (t.getChave().equals("20")) {
                        l.setCOD_ORIENTACAO_CPF(this.getValorToken(t.getValor(), "PROCURAR CONVENIADAS DA RFB"));
                        continue;
                    }
                    if (t.getChave().equals("21")) {
                        l.setCOD_ORIENTACAO_NIS(this.getValorToken(t.getValor(), "ATUALIZAR NIS NO INSS OU CAIXA"));
                        continue;
                    }
                    throw new ExceptionService("Erro ao importar o Arquivo");
                }
                if (inserir) {
                    retorno.add(l);
                }
                inserir = true;
                continue;
            }
            if (!linha.isEmpty()) continue;
            break;
        }
        return retorno;
    }

    public static List<StringToken> getReplaceTokens(String modelo) {
        modelo = ";" + (String)modelo;
        StringTokenizer tokens = new StringTokenizer((String)modelo, ";", true);
        LinkedHashSet<StringToken> inTokens = new LinkedHashSet<StringToken>();
        Integer cont = 1;
        while (tokens.hasMoreTokens()) {
            StringToken token;
            String tempKey;
            String key;
            String t = tokens.nextToken();
            if (";".equals(t)) {
                key = null;
                while (tokens.hasMoreTokens() && !";".equals(tempKey = tokens.nextToken())) {
                    key = tempKey;
                }
                token = new StringToken(cont.toString(), key);
                cont = cont + 1;
                inTokens.add(token);
                continue;
            }
            key = null;
            tempKey = t;
            if (";".equals(tempKey)) break;
            key = tempKey;
            token = new StringToken(cont.toString(), key);
            cont = cont + 1;
            inTokens.add(token);
        }
        System.out.println("InTokens:" + String.valueOf(inTokens));
        return new ArrayList<StringToken>(inTokens);
    }

    private String getValorToken(String valor, String string) {
        if (valor.equals("0")) {
            return "OK";
        }
        return string;
    }

    private boolean existeColaboradorEmpresa(String cpf, Empresa empresa) {
        String hql = " select sum(c.identificador)  from Colaborador c  where  c.pessoa.complemento.cnpj = :cpf  and  c.empresa.identificador = :empresa ";
        Long cont = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("empresa", empresa.getIdentificador().longValue()).setString("cpf", cpf).uniqueResult();
        return cont != null;
    }
}

