/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.colaborador;

import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;

public class UtilQualificacaoCadastralCEF {
    public List findColaboradores(Empresa empresa) {
        String hql = " select c  from Colaborador c  where  c.empresa = :empresa  and  c.ativo = :sim  and  c.dataDemissao is null  and  (c.tipoColaborador.identificador = :empregado  or  c.tipoColaborador.identificador = :socio  or  c.tipoColaborador.identificador = :menorAprendiz )";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("empresa", (Object)empresa).setShort("sim", (short)1).setLong("empregado", EnumConstTipoColaborador.EMPREGADO.getValue()).setLong("socio", EnumConstTipoColaborador.SOCIO_DIRETOR.getValue()).setLong("menorAprendiz", EnumConstTipoColaborador.MENOR_APRENDIZ.getValue()).list();
    }

    public void gerarArquivoQualificacaoCEF(Empresa empresa, List colaboradores, File arquivo, Date dataRemessa) throws IOException, ExceptionService {
        Integer dia = 0;
        Integer mes = 0;
        Integer ano = 0;
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        Integer cont = 1;
        this.createBlocoReader(p, empresa, dataRemessa);
        for (Object object : colaboradores) {
            Colaborador colaborador = (Colaborador)object;
            this.createBlocoDetalhe(p, colaborador);
            cont = cont + 1;
        }
        cont = cont + 1;
        this.createBlocoTrailler(cont, arquivo.getName(), p);
        p.println();
        p.flush();
        p.close();
    }

    private void createBlocoReader(PrintWriter p, Empresa empresa, Date dataRemessa) {
        String aux = null;
        p.append("C");
        aux = ToolString.refina((String)empresa.getPessoa().getComplemento().getCnpj());
        p.append(ToolString.completaEspacos((String)aux, (int)14, (boolean)false));
        p.append(ToolString.completaEspacos((String)empresa.getPessoa().getNome(), (int)40, (boolean)false));
        p.append("O");
        p.append(this.formatarData(dataRemessa));
        p.append("0014");
        p.println();
    }

    private String formatarData(Date data) {
        if (data != null) {
            SimpleDateFormat dataFormatada = new SimpleDateFormat("ddMMyyyy");
            String dataVenc = dataFormatada.format(data);
            return dataVenc;
        }
        return "        ";
    }

    private void createBlocoDetalhe(PrintWriter p, Colaborador colaborador) throws ExceptionService {
        String aux = null;
        p.append("P");
        p.append(ToolString.completaEspacos((String)colaborador.getNumeroRegistro(), (int)58, (boolean)false));
        p.append(ToolString.completaEspacos((String)colaborador.getPessoa().getNome(), (int)70, (boolean)false));
        p.append(this.formatarData(colaborador.getPessoa().getComplemento().getDataNascimento()));
        p.append(ToolString.completaEspacos((String)colaborador.getNomeMae(), (int)70, (boolean)false));
        aux = colaborador.getNomePai();
        if (aux == null) {
            aux = "IGNORADO";
        }
        p.append(ToolString.completaEspacos((String)aux, (int)70, (boolean)false));
        p.append(colaborador.getCidadeNascimento().getUf().getCodIbge() + colaborador.getCidadeNascimento().getCodIbge());
        p.append(colaborador.getSexo().equals((short)0) ? "M" : "F");
        p.append("  ");
        p.append("0010");
        p.append("1");
        p.append("    ");
        aux = ToolString.refina((String)colaborador.getPessoa().getComplemento().getCnpj());
        p.append(aux);
        p.append(ToolString.completaEspacos((String)"", (int)21));
        p.append(ToolString.completaEspacos((String)"", (int)52));
        p.append(ToolString.completaEspacos((String)colaborador.getCarteiraProfissional(), (int)7, (boolean)false));
        p.append(ToolString.completaEspacos((String)colaborador.getSerieCarteiraProfissional(), (int)5, (boolean)false));
        p.append(this.getUfCarteira(colaborador));
        p.append(this.getDataEmissaoCTPS(colaborador));
        p.append(ToolString.completaEspacos((String)"", (int)87));
        aux = ToolString.refina((String)colaborador.getPessoa().getEndereco().getCep());
        p.append(aux);
        p.append("1");
        p.append("RES");
        aux = ToolString.clearSpecialCharacXML((String)colaborador.getPessoa().getEndereco().getLogradouro());
        p.append(ToolString.completaEspacos((String)aux, (int)40, (boolean)false));
        p.append("NUMER");
        p.append(ToolString.completaEspacos((String)colaborador.getPessoa().getEndereco().getNumero(), (int)7, (boolean)false));
        p.append(ToolString.completaEspacos((String)colaborador.getPessoa().getEndereco().getComplemento(), (int)15, (boolean)false));
        p.append(ToolString.completaEspacos((String)colaborador.getPessoa().getEndereco().getBairro(), (int)40, (boolean)false));
        p.append(ToolString.completaEspacos((String)(colaborador.getPessoa().getEndereco().getCidade().getUf().getCodIbge() + colaborador.getPessoa().getEndereco().getCidade().getCodIbge()), (int)7, (boolean)false));
        p.append(ToolString.completaEspacos((String)"", (int)15));
        p.append(ToolString.completaEspacos((String)colaborador.getPessoa().getEndereco().getCep(), (int)8, (boolean)false));
        p.append("59");
        p.append(ToolString.completaEspacos((String)ToolString.refina((String)colaborador.getEmpresa().getPessoa().getComplemento().getCnpj()), (int)14, (boolean)false));
        p.append(this.formatarData(colaborador.getDataAdmissao()));
        p.println();
    }

    private String getUfCarteira(Colaborador c) throws ExceptionService {
        if (c.getUfCarteiraProfissional() == null) {
            throw new ExceptionService("Primeiro, informe a UF da Carteira de Trabalho para o Colaboraodr: " + c.toString());
        }
        return ToolString.completaEspacos((String)c.getUfCarteiraProfissional().getSigla(), (int)2, (boolean)false);
    }

    private String getDataEmissaoCTPS(Colaborador c) throws ExceptionService {
        if (c.getDataEmissaoCTPS() == null) {
            throw new ExceptionService("Primeiro, informe a Data de Emiss\u00e3o da Carteira de Trabalho para o Colaboraodr: " + c.getNumeroRegistro() + "-" + c.toString());
        }
        return this.formatarData(c.getDataEmissaoCTPS());
    }

    private void createBlocoTrailler(Integer cont, String nomeArquivo, PrintWriter p) {
        p.append(ToolString.completaZeros((String)cont.toString(), (int)9, (boolean)true));
        p.append(ToolString.completaEspacos((String)nomeArquivo, (int)35, (boolean)false));
    }
}

