/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.convencaocoletiva;

import com.touchcomp.basementor.model.vo.CadastroConvencaoColetiva;
import com.touchcomp.basementor.model.vo.CalculoComplementoSalario;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ColaboradorSalario;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EventoConvencaoColetiva;
import com.touchcomp.basementor.model.vo.FeriasColaborador;
import com.touchcomp.basementor.model.vo.ItemCompSalarioEventoPeriodo;
import com.touchcomp.basementor.model.vo.ItemComplementoSalarioColaboradores;
import com.touchcomp.basementor.model.vo.ItemComplementoSalarioEvento;
import com.touchcomp.basementor.model.vo.ItemConvColetivaAtSalarial;
import com.touchcomp.basementor.model.vo.ItemFaixaComplementoSalario;
import com.touchcomp.basementor.model.vo.ItemMovimentoFerias;
import com.touchcomp.basementor.model.vo.Sindicato;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.tools.ContatoFormatUtil;

public class ServiceConvencaoColetiva
extends CoreService {
    public static final String FIND_LAST_CONVENCAO_POR_SINDICATO = "findLastConvencaoPorSindicato";
    public static final String FIND_COLABORADORES_AT_SALARIAL_CONVENCAO = "findColaboradoresAtSalarialConvencao";
    public static final String FIND_FUNCAO_POR_CONVENCAO = "findFuncaoPorConvencao";
    public static final String GERAR_COMPLEMENTO_SALARIAL_POR_CONVENCAO = "gerarComplementoSalarialPorConvencao";
    public static final String SALVAR_CONVENCAO_COLETIVA = "salvarConvencaoColetiva";
    public static final String DELETAR_CADASTRO_CONVENCAO = "deletarCadastroConvencao";

    public CadastroConvencaoColetiva findLastConvencaoPorSindicato(CoreRequestContext request) {
        Sindicato sindicato = (Sindicato)request.getAttribute("sindicato");
        Date data = (Date)request.getAttribute("data");
        return CoreDAOFactory.getInstance().getDAOCadastroConvencaoColetiva().lastConvencaoColetivaPorSindicato(sindicato, data);
    }

    public List findColaboradoresAtSalarialConvencao(CoreRequestContext request) {
        List sindicatos = (List)request.getAttribute("sindicatos");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        Date data = (Date)request.getAttribute("data");
        return CoreDAOFactory.getInstance().getDAOCadastroConvencaoColetiva().findColaboradoresAtSalarialConvencao(sindicatos, empresa, data);
    }

    public List findFuncaoPorConvencao(CoreRequestContext request) {
        List sindicatos = (List)request.getAttribute("sindicatos");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        Date data = (Date)request.getAttribute("data");
        return CoreDAOFactory.getInstance().getDAOCadastroConvencaoColetiva().findFuncaoPorConvencao(sindicatos, empresa, data);
    }

    public Object gerarComplementoSalarialPorConvencao(CoreRequestContext r) throws ExceptionDatabase {
        CadastroConvencaoColetiva vo = (CadastroConvencaoColetiva)r.getAttribute("vo");
        CalculoComplementoSalario calculoComplemento = this.getComplementoSalario(vo);
        ServiceConvencaoColetiva.processamentoComplementoSalario(calculoComplemento, vo.getPeriodoInicial(), vo.getPeriodoFinal());
        this.processarFeriasPagasPosteriores(vo, calculoComplemento);
        vo.setComplementoSalario(calculoComplemento);
        vo = (CadastroConvencaoColetiva)CoreDAOFactory.getInstance().getDAOCadastroConvencaoColetiva().saveOrUpdate(vo);
        return vo;
    }

    private CalculoComplementoSalario getComplementoSalario(CadastroConvencaoColetiva vo) {
        CalculoComplementoSalario complemento = new CalculoComplementoSalario();
        complemento.setTipoCalculoFolha(vo.getTipoCalculo());
        complemento.setDataCadastro(new Date());
        complemento.setEmpresa(vo.getEmpresa());
        complemento.setDataPagamento(vo.getDataPagamento());
        complemento.setPeriodoInicial(vo.getPeriodoInicial());
        complemento.setPeriodoFinal(vo.getPeriodoFinal());
        complemento.setAno(vo.getAno());
        complemento.setIncluirFolhaDec(vo.getComporFolhaDec());
        complemento.setItensFaixaSalarial(this.getItensFaixaSalarial(vo, complemento));
        complemento.setItensColaboradores(this.getColaboradores(vo, complemento));
        complemento.setItensEvento(this.getEventos(vo, complemento));
        return complemento;
    }

    private List<ItemFaixaComplementoSalario> getItensFaixaSalarial(CadastroConvencaoColetiva vo, CalculoComplementoSalario complemento) {
        ArrayList<ItemFaixaComplementoSalario> salarios = new ArrayList<ItemFaixaComplementoSalario>();
        for (ItemConvColetivaAtSalarial i : vo.getItensAtualizacao()) {
            ItemFaixaComplementoSalario item = new ItemFaixaComplementoSalario();
            item.setPercAumento(i.getPercValorAtualizacao());
            item.setSalarioMensalAte(item.getSalarioMensalAte());
            item.setSequencia(item.getSequencia());
            item.setComplementoSalario(complemento);
            salarios.add(item);
        }
        return salarios;
    }

    private List<ItemComplementoSalarioColaboradores> getColaboradores(CadastroConvencaoColetiva vo, CalculoComplementoSalario complemento) {
        ArrayList<ItemComplementoSalarioColaboradores> colaboradores = new ArrayList<ItemComplementoSalarioColaboradores>();
        for (ColaboradorSalario i : vo.getSalarios()) {
            ItemComplementoSalarioColaboradores c = new ItemComplementoSalarioColaboradores();
            c.setColaborador(i.getColaborador());
            c.setComplementoSalario(complemento);
            c.setPercAumento(i.getPercAumento());
            colaboradores.add(c);
        }
        return colaboradores;
    }

    private List<ItemComplementoSalarioEvento> getEventos(CadastroConvencaoColetiva vo, CalculoComplementoSalario complemento) {
        ArrayList<ItemComplementoSalarioEvento> eventos = new ArrayList<ItemComplementoSalarioEvento>();
        for (EventoConvencaoColetiva evt : vo.getEventosConvencao()) {
            ItemComplementoSalarioEvento item = new ItemComplementoSalarioEvento();
            item.setTipoCalculo(evt.getTipoCalculoEvento());
            item.setComplementoSalario(complemento);
            eventos.add(item);
        }
        return eventos;
    }

    static void processamentoComplementoSalario(CalculoComplementoSalario complementoSalario, Date periodoInicio, Date periodoFinal) {
        for (ItemComplementoSalarioEvento itemEvento : complementoSalario.getItensEvento()) {
            Date data;
            Object valor;
            Long idColaborador;
            ItemCompSalarioEventoPeriodo itemCompPeriodo;
            HashMap hash;
            System.err.print(itemEvento.getTipoCalculo().toString());
            boolean achou = false;
            ArrayList<ItemCompSalarioEventoPeriodo> itens = new ArrayList<ItemCompSalarioEventoPeriodo>();
            List ret = CoreDAOFactory.getInstance().getDAOCalculoComplementoSalario().getEventosCompoemComplementoSalario(itemEvento.getTipoCalculo(), periodoInicio, periodoFinal);
            for (Object obj : ret) {
                hash = (HashMap)obj;
                itemCompPeriodo = new ItemCompSalarioEventoPeriodo();
                idColaborador = (Long)hash.get("idColaborador");
                for (ItemComplementoSalarioColaboradores oo : complementoSalario.getItensColaboradores()) {
                    if (!oo.getColaborador().getIdentificador().equals(idColaborador)) continue;
                    itemCompPeriodo.setColaborador(oo.getColaborador());
                    itemCompPeriodo.setPercAumento(oo.getPercAumento());
                    achou = true;
                    break;
                }
                if (achou) {
                    valor = (Double)hash.get("valor");
                    itemCompPeriodo.setValorEvento((Double)valor);
                    data = (Date)hash.get("periodo");
                    itemCompPeriodo.setPeriodo(data);
                    itemCompPeriodo.setValorComplemento(ContatoFormatUtil.arrredondarNumero(itemCompPeriodo.getValorEvento() * (itemCompPeriodo.getPercAumento() / 100.0), 2));
                    itemCompPeriodo.setItemEvento(itemEvento);
                    itens.add(itemCompPeriodo);
                }
                achou = false;
            }
            if (complementoSalario.getIncluirFolhaDec().equals((short)1)) {
                ret = CoreDAOFactory.getInstance().getDAOCalculoComplementoSalario().getEventosCompoemComplementoDecimoTerceiro(itemEvento.getTipoCalculo(), complementoSalario.getAno(), periodoInicio, periodoFinal);
                for (Object obj : ret) {
                    hash = (HashMap)obj;
                    itemCompPeriodo = new ItemCompSalarioEventoPeriodo();
                    idColaborador = (Long)hash.get("idColaborador");
                    for (ItemComplementoSalarioColaboradores oo : complementoSalario.getItensColaboradores()) {
                        if (!oo.getColaborador().getIdentificador().equals(idColaborador)) continue;
                        itemCompPeriodo.setColaborador(oo.getColaborador());
                        itemCompPeriodo.setPercAumento(oo.getPercAumento());
                        achou = true;
                        break;
                    }
                    if (achou) {
                        valor = (Double)hash.get("valor");
                        itemCompPeriodo.setValorEvento((Double)valor);
                        data = (Date)hash.get("periodo");
                        itemCompPeriodo.setPeriodo(data);
                        itemCompPeriodo.setValorComplemento(ContatoFormatUtil.arrredondarNumero(itemCompPeriodo.getValorEvento() * (itemCompPeriodo.getPercAumento() / 100.0), 2));
                        itemCompPeriodo.setItemEvento(itemEvento);
                        itens.add(itemCompPeriodo);
                    }
                    achou = false;
                }
            }
            itemEvento.setEventosPeriodo(itens);
        }
        if (complementoSalario.getTpValorAdicional() != null) {
            for (ItemComplementoSalarioColaboradores colaborador : complementoSalario.getItensColaboradores()) {
                if (!(colaborador.getValorAdicional() > 0.0)) continue;
                ItemComplementoSalarioEvento itemEvento = new ItemComplementoSalarioEvento();
                itemEvento.setTipoCalculo(complementoSalario.getTpValorAdicional());
                itemEvento.setComplementoSalario(complementoSalario);
                ItemCompSalarioEventoPeriodo itemCompPeriodo = new ItemCompSalarioEventoPeriodo();
                itemCompPeriodo.setColaborador(colaborador.getColaborador());
                itemCompPeriodo.setItemEvento(itemEvento);
                itemCompPeriodo.setPercAumento(Double.valueOf(0.0));
                itemCompPeriodo.setValorComplemento(colaborador.getValorAdicional());
                itemCompPeriodo.setPeriodo(complementoSalario.getPeriodoFinal());
                itemEvento.getEventosPeriodo().add(itemCompPeriodo);
                complementoSalario.getItensEvento().add(itemEvento);
            }
        }
    }

    public Object salvarConvencaoColetiva(CoreRequestContext r) throws ExceptionService, ExceptionDatabase {
        CadastroConvencaoColetiva vo = (CadastroConvencaoColetiva)r.getAttribute("vo");
        for (ColaboradorSalario salColaborador : vo.getSalarios()) {
            Colaborador c = (Colaborador)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOColaborador(), salColaborador.getColaborador().getIdentificador());
            c.setFuncao(salColaborador.getFuncao());
            c.setValorSalario(salColaborador.getValorSalario());
            CoreDAOFactory.getInstance().getDAOColaborador().saveOrUpdate(c);
        }
        vo = (CadastroConvencaoColetiva)CoreDAOFactory.getInstance().getDAOCadastroConvencaoColetiva().saveOrUpdate(vo);
        return vo;
    }

    public void deletarCadastroConvencao(CoreRequestContext r) throws ExceptionDatabase {
        CadastroConvencaoColetiva vo = (CadastroConvencaoColetiva)r.getAttribute("vo");
        List salarios = vo.getSalarios();
        vo.setSalarios(new ArrayList());
        for (ColaboradorSalario salario : salarios) {
            Colaborador colaborador = salario.getColaborador();
            salario.setConvencao(null);
            CoreDAOFactory.getInstance().getDAOColaboradorSalario().delete(salario);
            ColaboradorSalario c = this.findUltimaFuncao(colaborador);
            if (c == null || c.getFuncao() == null) continue;
            colaborador.setFuncao(c.getFuncao());
            colaborador.setValorSalario(c.getValorSalario());
            CoreDAOFactory.getInstance().getDAOColaborador().saveOrUpdate(colaborador);
        }
        CoreDAOFactory.getInstance().getDAOCadastroConvencaoColetiva().delete(vo);
    }

    public ColaboradorSalario findUltimaFuncao(Colaborador colaborador) {
        String hql = " select c  from ColaboradorSalario c where  c.periodo = ( select max(cc.periodo)                from ColaboradorSalario cc                where                 cc.colaborador = :colaborador) and  c.colaborador = :colaborador  and  c.colaborador.empresa.identificador = :empresa ";
        return (ColaboradorSalario)CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setLong("empresa", colaborador.getEmpresa().getIdentificador().longValue()).uniqueResult();
    }

    private void processarFeriasPagasPosteriores(CadastroConvencaoColetiva vo, CalculoComplementoSalario c) {
        for (ColaboradorSalario ii : vo.getSalarios()) {
            List ferias;
            Colaborador colaborador = ii.getColaborador();
            System.err.println(colaborador.toString());
            if (colaborador.getNumeroRegistro() == "2269") {
                System.out.println("");
            }
            if (!(ferias = this.getFeriasPosteriores(colaborador, vo.getDataLiberacao(), ii.getValorSalarioAnterior())).isEmpty()) {
                System.out.println("");
            }
            this.processarFerias(ferias, c);
        }
    }

    private List getFeriasPosteriores(Colaborador colaborador, Date dataLiberacao, Double salarioAnterior) {
        String hql = " from FeriasColaborador f  where  f.periodoAqFeriasColab.colaborador = :colaborador  and  f.salarioNominal = :salarioAnterior  and  f.dataGozoInicial >= :dataLiberacao ";
        List ret = CoreBdUtil.getInstance().getSession().createQuery(hql).setParameter("colaborador", (Object)colaborador).setParameter("salarioAnterior", (Object)salarioAnterior).setParameter("dataLiberacao", (Object)dataLiberacao).list();
        return ret;
    }

    private void processarFerias(List ferias, CalculoComplementoSalario c) {
        for (Object obj : ferias) {
            FeriasColaborador f = (FeriasColaborador)obj;
            for (ItemMovimentoFerias item : f.getItemMovimentoFerias()) {
                for (ItemComplementoSalarioEvento itemEvento : c.getItensEvento()) {
                    if (!item.getEventoColaborador().getTipoCalculoEvento().equals((Object)itemEvento.getTipoCalculo())) continue;
                    System.err.print(itemEvento.getTipoCalculo().toString());
                    boolean achou = false;
                    ArrayList<ItemCompSalarioEventoPeriodo> itens = new ArrayList<ItemCompSalarioEventoPeriodo>();
                    ItemCompSalarioEventoPeriodo itemCompPeriodo = new ItemCompSalarioEventoPeriodo();
                    Long idColaborador = f.getPeriodoAqFeriasColab().getColaborador().getIdentificador();
                    for (ItemComplementoSalarioColaboradores oo : c.getItensColaboradores()) {
                        if (!oo.getColaborador().getIdentificador().equals(idColaborador)) continue;
                        itemCompPeriodo.setColaborador(oo.getColaborador());
                        itemCompPeriodo.setPercAumento(oo.getPercAumento());
                        achou = true;
                        break;
                    }
                    if (achou && item.getValor() > 0.0) {
                        Double valor = item.getValor();
                        itemCompPeriodo.setValorEvento(valor);
                        Date data = f.getDataGozoInicial();
                        itemCompPeriodo.setPeriodo(data);
                        itemCompPeriodo.setValorComplemento(ContatoFormatUtil.arrredondarNumero(itemCompPeriodo.getValorEvento() * (itemCompPeriodo.getPercAumento() / 100.0), 2));
                        itemCompPeriodo.setItemEvento(itemEvento);
                        itens.add(itemCompPeriodo);
                    }
                    achou = false;
                    itemEvento.getEventosPeriodo().addAll(itens);
                }
            }
        }
    }
}

