/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.envioemailenvelope;

import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.OpcoesRelacionamento;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.ServidorEmail;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataOutputBI;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.email.Email;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import mentorcore.exceptions.ExceptionExportRelatorio;
import mentorcore.utilities.impl.jasperreports.auxiliar.FormImpressaoExporterPDF;
import net.sf.jasperreports.engine.JasperPrint;

public class AuxEmailEnvelopePagamento {
    public static Email criarEmailEnvelope(JasperPrint jasper, Usuario usuario, OpcoesRelacionamento op, MovimentoFolha movimentoFolha, String texto, String emailCopia) throws ExceptionExportRelatorio {
        Email email = null;
        if (op != null && op.getServidorEmailHolerite() != null) {
            ServidorEmail servidor = op.getServidorEmailHolerite();
            email = new Email(true);
            email.setRemetente(servidor.getEmail());
            email.setDestinatariosStr(AuxEmailEnvelopePagamento.getDestinatarios(movimentoFolha.getColaborador().getPessoa(), emailCopia));
            email.setAssunto("ENVELOPE PAGAMENTO PERIODO " + ToolDate.dateToStr((Date)movimentoFolha.getAberturaPeriodo().getDataFinal()));
            email.setCorpoMensagem(texto);
            email.setServidor(new Email.ServidorEmail(servidor.getServidor(), servidor.getServidorImap(), servidor.getServidorPop(), servidor.getEmail(), servidor.getSenha(), servidor.getPortaEmail(), servidor.getNaoAutenticarEmail(), servidor.getLogin(), servidor.getServerProperties(), servidor.getGerarArquivoExtensaoEml(), servidor.getDebugServer()));
            email.addAnexos(AuxEmailEnvelopePagamento.getAnexos(jasper, movimentoFolha));
            email.setZiparAnexos(false);
            return email;
        }
        return null;
    }

    private static HashSet<String> getDestinatarios(Pessoa pessoa, String emailCopia) {
        HashSet<String> emails = new HashSet<String>();
        emails.add(pessoa.getComplemento().getEmailPrincipal());
        if (ToolMethods.isStrWithData((String)emailCopia)) {
            emails.add(emailCopia);
        }
        return emails;
    }

    private static List<File> getAnexos(JasperPrint jasper, MovimentoFolha movimentoFolha) throws ExceptionExportRelatorio {
        ArrayList<File> anexos = new ArrayList<File>();
        File f = AuxEmailEnvelopePagamento.getEnvelope(jasper, movimentoFolha);
        anexos.add(f);
        return anexos;
    }

    private static File getEnvelope(JasperPrint jp, MovimentoFolha movimentoFolha) throws ExceptionExportRelatorio {
        DataOutputBI out = new DataOutputBI(jp);
        File file = new FormImpressaoExporterPDF().buildOutputReport(out);
        String nome = ToolDate.dayFromDate((Date)movimentoFolha.getAberturaPeriodo().getDataFinal()) + "-" + ToolDate.monthFromDate((Date)movimentoFolha.getAberturaPeriodo().getDataFinal()) + "-" + ToolDate.yearFromDate((Object)movimentoFolha.getAberturaPeriodo().getDataFinal());
        nome = nome + " " + movimentoFolha.toString();
        File renamed = new File(file.getParent() + File.separator + nome + ".pdf");
        file.renameTo(renamed);
        return renamed;
    }
}

