/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.ferias;

import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ColaboradorDadosFerias;
import com.touchcomp.basementor.model.vo.FeriasColaborador;
import com.touchcomp.basementor.model.vo.PeriodoAqFeriasColab;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;
import mentorcore.tools.DateUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class UtilityPeriodoAquisitivoColaborador {
    public HashMap findDataFinalPeriodoAquisitivoAbertoColaborador(Colaborador c) throws ExceptionService {
        Session s = CoreBdUtil.getInstance().getSession();
        HashMap<String, Integer> h = new HashMap<String, Integer>();
        List l = new ArrayList();
        Query q = s.createQuery("from PeriodoAqFeriasColab p where p.colaborador.identificador = :idcolaborador and p.dataFinal = (select max(pp.dataFinal)                from PeriodoAqFeriasColab pp                where pp.colaborador.identificador = :idcolaborador )");
        q.setLong("idcolaborador", c.getIdentificador().longValue());
        l = q.list();
        Integer diasGozados = 0;
        Object resul = null;
        if (l.size() == 1) {
            diasGozados = this.fechouPeriodoDadosPeriodoAquisitivo(l);
            resul = l.get(0);
            h.put("resul", (Integer)resul);
            h.put("diasGozados", diasGozados);
        } else if (l.size() > 1) {
            diasGozados = this.fechouPeriodoDadosPeriodoAquisitivo(l);
            resul = l.get(l.size() - 1);
            h.put("resul", (Integer)resul);
            h.put("diasGozados", diasGozados);
        }
        if (resul != null) {
            h.put("resul", (Integer)resul);
            return h;
        }
        String hql = "from ColaboradorDadosFerias a where a.colaborador.identificador = :idcolaborador and a.dataFimPeriodo = (select max(aa.dataFimPeriodo) from ColaboradorDadosFerias aa where aa.colaborador.identificador = :idcolaborador)";
        Query q2 = s.createQuery(hql);
        q2.setLong("idcolaborador", c.getIdentificador().longValue());
        l = q2.list();
        if (l.size() == 1) {
            diasGozados = this.fechouPeriodoDadosColaborador(l);
            resul = l.get(0);
            h.put("resul", (Integer)resul);
            h.put("diasGozados", diasGozados);
        } else if (l.size() > 1) {
            diasGozados = this.fechouPeriodoDadosColaborador(l);
            resul = l.get(l.size() - 1);
            h.put("resul", (Integer)resul);
            h.put("diasGozados", diasGozados);
        }
        if (resul != null) {
            h.put("resul", (Integer)resul);
            return h;
        }
        h.put("resul", (Integer)c);
        h.put("diasGozados", 0);
        return h;
    }

    private Integer fechouPeriodoDadosColaborador(List l) {
        Integer diasGozados = 0;
        for (Object obj : l) {
            ColaboradorDadosFerias dados = (ColaboradorDadosFerias)obj;
            if (dados.getFechado().equals((short)0)) {
                diasGozados = DateUtil.diferenceDayBetweenDates(dados.getInicioGozoFerias(), dados.getFimGozoFerias()) + 1 + diasGozados;
                continue;
            }
            return 30;
        }
        return diasGozados;
    }

    private Integer fechouPeriodoDadosPeriodoAquisitivo(List l) throws ExceptionService {
        Integer diasGozados = 0;
        for (Object obj : l) {
            PeriodoAqFeriasColab periodoFerias = (PeriodoAqFeriasColab)obj;
            if (periodoFerias.getFechado() != null && periodoFerias.getFechado().equals((short)0)) {
                FeriasColaborador ferias = (FeriasColaborador)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOFeriasColaborador(), "periodoAqFeriasColab", periodoFerias, 0);
                diasGozados = ferias.getDiasGozoFerias().intValue() + diasGozados;
                continue;
            }
            return 30;
        }
        return diasGozados;
    }
}

