/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.geracaoarquivos.caged;

import com.touchcomp.basementor.model.vo.EmpresaRh;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.rh.geracaoarquivos.caged.UtilityCagedAcerto;
import mentorcore.service.impl.rh.geracaoarquivos.caged.UtilityCagedDiario;
import mentorcore.service.impl.rh.geracaoarquivos.caged.UtilityCagedMensal;
import mentorcore.service.impl.rh.geracaoarquivos.caged.UtilityDadosCaged;

public class ServiceGeracaoCaged
extends CoreService {
    public static final String FIND_TRANSFERENCIA_SAIDA_COLABORADOR = "findTransferenciaSaidaColaborador";
    public static final String FIND_TRANSFERENCIA_ENTRADA_COLABORADOR = "findTransferenciaEntradaColaborador";
    public static final String FIND_COLABORADORES_DEMITIDOS_CAGED = "findColaboradoresDemitidosCaged";
    public static final String COLABORADORES_ADMITIDOS_CAGED_MENSAL = "colaboradoresAdmitidosCagedMensal";
    public static final String FIND_TOTAL_FUNCIONARIOS_MES = "findtotalFuncionariosMes";
    public static String FIND_DIA_SAIDA_COLABORADOR = "findDiaSaidaColaborador";
    public static final String TOTAL_FUNCIONARIO_NO_PERIODO = "totalFuncionarioNoPeriodo";
    public static final String FIND_COLABORADORES_ADMITIDOS_CAGED = "findColaboradoresAdmitidosCaged";
    public static final String GERAR_ARQUIVO_CAGED_MENSAL = "gerarArquivoCagedMensal";
    public static final String GERAR_ARQUIVO_CAGED_DIARIO = "gerarArquivoCagedDiario";
    public static final String GERAR_ARQUIVO_CAGED_ACERTO = "gerarArquivoCagedAcerto";

    public List findTransferenciaSaidaColaborador(CoreRequestContext request) {
        Long empresa = (Long)request.getAttribute("empresa");
        Date periodo = (Date)request.getAttribute("PERIODO");
        return new UtilityDadosCaged().findTransferenciaSaidaColaboradores(empresa, periodo);
    }

    public List findTransferenciaEntradaColaborador(CoreRequestContext request) {
        Long empresa = (Long)request.getAttribute("empresa");
        Date periodo = (Date)request.getAttribute("PERIODO");
        return new UtilityDadosCaged().findTransferenciaEntradaColaboradores(empresa, periodo);
    }

    public static List findColaboradoresDemitidosCaged(CoreRequestContext r) {
        Date periodo = (Date)r.getAttribute("PERIODO");
        Long empresa = (Long)r.getAttribute("empresa");
        return new UtilityDadosCaged().findColaboradoresDemitidosCaged(periodo, empresa);
    }

    public List colaboradoresAdmitidosCagedMensal(CoreRequestContext request) {
        Long idEmpresa = (Long)request.getAttribute("empresa");
        Date periodo = (Date)request.getAttribute("PERIODO");
        return new UtilityDadosCaged().findColaboradoresAdmitidosCagedMensal(periodo, idEmpresa);
    }

    public static Long findtotalFuncionariosMes(CoreRequestContext r) {
        Date periodo = (Date)r.getAttribute("primeiroDiaMes");
        Long empresa = (Long)r.getAttribute("empresa");
        Date dataApuracao = (Date)r.getAttribute("dataApuracao");
        return new UtilityDadosCaged().findTotalFuncionariosMes(periodo, empresa, dataApuracao);
    }

    public static String findDiaSaidaColaborador(CoreRequestContext r) {
        return new UtilityDadosCaged().findDiaSaidaColaborador(r);
    }

    public Long totalFuncionarioNoPeriodo(CoreRequestContext request) {
        Date periodo = (Date)request.getAttribute("periodo");
        Date primeiroDia = (Date)request.getAttribute("primeiroDiaMes");
        Long empresa = (Long)request.getAttribute("empresa");
        return new UtilityDadosCaged().totalFuncionarioNoPeriodo(empresa, periodo, primeiroDia);
    }

    public static List findColaboradoresAdmitidosCaged(CoreRequestContext r) {
        Date periodo = (Date)r.getAttribute("PERIODO");
        Long empresa = (Long)r.getAttribute("empresa");
        return new UtilityDadosCaged().findColaboradoresAdmitidosCaged(periodo, empresa);
    }

    public boolean gerarArquivoCagedMensal(CoreRequestContext request) throws IOException, ExceptionService {
        File file = (File)request.getAttribute("file");
        HashMap hash = (HashMap)request.getAttribute("hash");
        String nome = (String)request.getAttribute("nome");
        EmpresaRh empresaRh = (EmpresaRh)request.getAttribute("empresaRh");
        return new UtilityCagedMensal().gerarArquivoCagedMensal(hash, file, nome, empresaRh);
    }

    public boolean gerarArquivoCagedDiario(CoreRequestContext request) throws IOException, ExceptionService {
        File file = (File)request.getAttribute("file");
        HashMap hash = (HashMap)request.getAttribute("hash");
        String nome = (String)request.getAttribute("nome");
        EmpresaRh empresa = (EmpresaRh)request.getAttribute("empresaRh");
        return new UtilityCagedDiario().gerarArquivoCagedDiario(hash, file, nome, empresa);
    }

    public Boolean gerarArquivoCagedAcerto(CoreRequestContext request) throws IOException, ExceptionService {
        File file = (File)request.getAttribute("file");
        HashMap hash = (HashMap)request.getAttribute("hash");
        String nome = (String)request.getAttribute("nome");
        EmpresaRh empresa = (EmpresaRh)request.getAttribute("empresaRh");
        return new UtilityCagedAcerto().gerarArquivoCagedAcerto(hash, file, nome, empresa);
    }
}

