/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.geracaoarquivos.caged;

import com.touchcomp.basementor.model.vo.CadastroExameColaborador;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionService;
import mentorcore.finder.BaseCriteria;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.CoreServiceFactory;
import mentorcore.service.impl.rh.calculofolha.CalculoFolhaPagamentoUtilities;
import mentorcore.service.impl.rh.geracaoarquivos.UtilityFilesRH;
import mentorcore.tools.DateUtil;

public class UtilityCagedDiario {
    private TLogger logger = TLogger.get(UtilityCagedDiario.class);
    private Integer numeroSequencial = 1;

    public boolean gerarArquivoCagedDiario(HashMap h, File arquivo, String nome, EmpresaRh empresaRh) throws IOException, ExceptionService {
        List colaboradoresAdmitidos = new ArrayList();
        boolean retValue = true;
        Date dataPeriodo = (Date)h.get("PERIODO");
        Long empresa = (Long)h.get("empresa");
        colaboradoresAdmitidos = (List)CoreServiceFactory.getServiceGeracaoCaged().execute(CoreRequestContext.newInstance().setAttribute("PERIODO", h.get("PERIODO")).setAttribute("empresa", empresa), "findColaboradoresAdmitidosCaged");
        h.put("MOVIMENTACOES", colaboradoresAdmitidos.size());
        retValue = this.escreverRegistroA(h, arquivo, empresaRh);
        if (!retValue) {
            arquivo.delete();
            return false;
        }
        retValue = this.escreverRegistroB(h, arquivo, empresaRh);
        if (!retValue) {
            arquivo.delete();
            return false;
        }
        for (Object obj : colaboradoresAdmitidos) {
            Colaborador c = (Colaborador)obj;
            retValue = this.escreverRegistroCAdmitidos(h, arquivo, c, empresaRh, dataPeriodo);
            if (retValue) continue;
            arquivo.delete();
            return false;
        }
        return true;
    }

    private boolean escreverRegistroA(HashMap h, File arquivo, EmpresaRh empresaRh) throws IOException, ExceptionService {
        Date periodo = (Date)h.get("PERIODO");
        String alteracao = (String)h.get("ALTERACAO");
        Integer totalMovimentacoes = (Integer)h.get("MOVIMENTACOES");
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        String aux = null;
        p.append("A");
        p.append("L2009");
        p.append("   ");
        p.append(UtilityFilesRH.completarComZeroEsquerda(this.getPeriodo(periodo), 6));
        p.append(alteracao);
        p.append(UtilityFilesRH.completarComZeroEsquerda(this.numeroSequencial.toString(), 5));
        Integer n = this.numeroSequencial;
        this.numeroSequencial = this.numeroSequencial + 1;
        p.append(this.getTipoIdentificador(empresaRh.getPessoaResponsavel()));
        if (empresaRh.getPessoaResponsavel().getComplemento().getCnpj().length() == 14) {
            p.append(empresaRh.getPessoaResponsavel().getComplemento().getCnpj());
        } else if (empresaRh.getPessoaResponsavel().getComplemento().getCodCei() != null) {
            p.append(UtilityFilesRH.completarComZeroEsquerda(empresaRh.getPessoaResponsavel().getComplemento().getCodCei(), 14));
        } else {
            throw new ExceptionService("Codigo CEI n\u00e3o informado na Pessoa Responsavel");
        }
        p.append(UtilityFilesRH.completarComBrancoDireita(empresaRh.getPessoaResponsavel().getNome().toUpperCase(), 35));
        p.append(UtilityFilesRH.completarComBrancoDireita(this.escreverEndereco(empresaRh.getPessoaResponsavel()), 40));
        aux = ToolString.refina((String)empresaRh.getPessoaResponsavel().getEndereco().getCep());
        p.append(UtilityFilesRH.completarComBrancoDireita(aux, 8));
        p.append(UtilityFilesRH.completarComBrancoDireita(empresaRh.getPessoaResponsavel().getEndereco().getCidade().getUf().getSigla(), 2));
        if (empresaRh.getPessoaResponsavel().getComplemento().getFone1() == null) {
            throw new ExceptionService("Telefone n\u00e3o informado no cadastro do Autorizado.");
        }
        p.append(UtilityFilesRH.completarComZeroEsquerda(empresaRh.getPessoaResponsavel().getComplemento().getFone1(), 12));
        p.append("00000");
        p.append("00001");
        p.append(UtilityFilesRH.completarComZeroEsquerda(totalMovimentacoes.toString(), 5));
        p.append(UtilityFilesRH.completarComBrancoDireita("", 92));
        p.println();
        p.flush();
        p.close();
        return true;
    }

    private String escreverEndereco(Pessoa pessoa) {
        String logradouro = pessoa.getEndereco().getLogradouro();
        String numero = pessoa.getEndereco().getNumero();
        String complemento = pessoa.getEndereco().getComplemento();
        return logradouro.toUpperCase() + " " + numero + " " + complemento.toUpperCase();
    }

    private String getPeriodo(Date periodo) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(periodo);
        Integer mes = g.get(2) + 1;
        Integer ano = g.get(1);
        return mes.toString() + ano.toString();
    }

    private String getTipoIdentificador(Pessoa pessoa) {
        if (pessoa.getComplemento().getCnpj().length() == 14) {
            return "1";
        }
        return "2";
    }

    private boolean escreverRegistroB(HashMap h, File f, EmpresaRh empresaRh) throws IOException, ExceptionService {
        String declaracao = (String)h.get("DECLARACAO");
        String alteracao = (String)h.get("ALTERACAO");
        Long afastados = (Long)h.get("AFASTADOS");
        FileWriter fileWriter = new FileWriter(f, true);
        PrintWriter p = new PrintWriter(fileWriter);
        String aux = null;
        p.append("B");
        p.append(this.getTipoIdentificador(empresaRh.getEmpresa().getPessoa()));
        p.append(this.getNumeroIdentificador(empresaRh));
        p.append(UtilityFilesRH.completarComZeroEsquerda(this.numeroSequencial.toString(), 5));
        Integer n = this.numeroSequencial;
        this.numeroSequencial = this.numeroSequencial + 1;
        p.append(declaracao);
        p.append(alteracao);
        aux = ToolString.refina((String)empresaRh.getEmpresa().getPessoa().getEndereco().getCep());
        p.append(UtilityFilesRH.completarComBrancoDireita(aux, 8));
        p.append("     ");
        p.append(UtilityFilesRH.completarComBrancoDireita(empresaRh.getEmpresa().getPessoa().getNome().toUpperCase(), 40));
        p.append(UtilityFilesRH.completarComBrancoDireita(this.escreverEndereco(empresaRh.getEmpresa().getPessoa()), 40));
        p.append(UtilityFilesRH.completarComBrancoDireita(empresaRh.getEmpresa().getPessoa().getEndereco().getBairro().toUpperCase(), 20));
        p.append(UtilityFilesRH.completarComBrancoDireita(empresaRh.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getSigla(), 2));
        Date primeiroDiaMes = this.primeiroDiaMes((Date)h.get("PERIODO"));
        Long totalFunc = (Long)CoreServiceFactory.getServiceGeracaoCaged().execute(CoreRequestContext.newInstance().setAttribute("periodo", h.get("PERIODO")).setAttribute("empresa", empresaRh.getEmpresa().getIdentificador()).setAttribute("primeiroDiaMes", primeiroDiaMes), "totalFuncionarioNoPeriodo");
        p.append(UtilityFilesRH.completarComZeroEsquerda(totalFunc.toString(), 5));
        p.append(UtilityFilesRH.completarComZeroEsquerda(empresaRh.getPorteEstabelecimento().getCodigo(), 1));
        p.append(UtilityFilesRH.completarComZeroEsquerda(empresaRh.getCodCNAE(), 7));
        if (empresaRh.getEmpresa().getPessoa().getComplemento().getFone1() == null) {
            throw new ExceptionService("Telefone n\u00e3o informado no cadastro do Autorizado.");
        }
        p.append(UtilityFilesRH.completarComZeroEsquerda(this.getTelefoneEmpresa(empresaRh), 12));
        p.append(UtilityFilesRH.completarComBrancoDireita(empresaRh.getEmailResponsavel(), 50));
        p.append(UtilityFilesRH.completarComBrancoDireita("", 27));
        p.println();
        p.flush();
        p.close();
        return true;
    }

    private String getTelefoneEmpresa(EmpresaRh empresa) {
        return empresa.getEmpresa().getPessoa().getComplemento().getFone1();
    }

    private String getSexo(Colaborador c) {
        if (c.getSexo().equals((short)0)) {
            return "1";
        }
        return "2";
    }

    private String getNumeroIdentificador(EmpresaRh empresaRh) {
        if (empresaRh.getEmpresa().getPessoa().getComplemento().getCnpj().length() == 14) {
            return empresaRh.getEmpresa().getPessoa().getComplemento().getCnpj();
        }
        return empresaRh.getEmpresa().getPessoa().getComplemento().getCodCei();
    }

    private String getAprendiz(Colaborador c) {
        if (c.getTipoColaborador().getIdentificador().equals(3L)) {
            return "1";
        }
        return "2";
    }

    private String getTipoDeficiencia(Colaborador c) {
        if (c.getTipoDeficiencia() != null) {
            return "1";
        }
        return "2";
    }

    private String getCodigoDeficiencia(Colaborador c) {
        if (c.getTipoDeficiencia() != null) {
            return c.getTipoDeficiencia().getCodigo();
        }
        return " ";
    }

    public static Double getSalarioNominal(Colaborador colaborador, Date periodoInicial) throws ExceptionService {
        String cod = colaborador.getTipoSalario().getCodigo();
        Integer codigo = new Integer(cod);
        Double valor = 0.0;
        switch (codigo) {
            case 1: {
                valor = UtilityCagedDiario.findVrSalarioMaiorColaboradorSalarioNoPeriodo(colaborador, periodoInicial);
                return valor;
            }
            case 2: {
                valor = UtilityCagedDiario.findVrSalarioMaiorColaboradorSalarioNoPeriodo(colaborador, periodoInicial);
                return valor;
            }
            case 3: {
                valor = UtilityCagedDiario.findVrSalarioMaiorColaboradorSalarioNoPeriodo(colaborador, periodoInicial);
                return valor;
            }
            case 4: {
                valor = UtilityCagedDiario.findVrSalarioMaiorColaboradorSalarioNoPeriodo(colaborador, periodoInicial);
                valor = valor * colaborador.getDiasJornada();
                return valor;
            }
            case 5: {
                valor = UtilityCagedDiario.findVrSalarioMaiorColaboradorSalarioNoPeriodo(colaborador, periodoInicial);
                valor = valor * colaborador.getDiasJornada() * colaborador.getHorasTrabDia();
                valor = ContatoFormatUtil.arrredondarNumero((Double)valor, (int)2);
                return valor;
            }
            case 6: {
                return valor;
            }
            case 7: {
                return valor;
            }
        }
        return valor;
    }

    public static Double findVrSalarioMaiorColaboradorSalarioNoPeriodo(Colaborador c, Date periodoInicial) {
        return new CalculoFolhaPagamentoUtilities().findSalarioNominalEsocial(c);
    }

    private boolean escreverRegistroCAdmitidos(HashMap h, File f, Colaborador c, EmpresaRh empresaRh, Date periodo) throws IOException, ExceptionService {
        String aux = "";
        FileWriter fileWriter = new FileWriter(f, true);
        PrintWriter p = new PrintWriter(fileWriter);
        p.append("C");
        p.append(this.getTipoIdentificador(empresaRh.getEmpresa().getPessoa()));
        p.append(this.getNumeroIdentificador(empresaRh));
        p.append(UtilityFilesRH.completarComZeroEsquerda(this.numeroSequencial.toString(), 5));
        Integer n = this.numeroSequencial;
        this.numeroSequencial = this.numeroSequencial + 1;
        aux = ToolString.refina((String)c.getNumeroPis());
        p.append(UtilityFilesRH.completarComZeroEsquerda(aux, 11));
        p.append(this.getSexo(c));
        p.append(UtilityFilesRH.formatarDatas8Digitos(c.getPessoa().getComplemento().getDataNascimento()));
        p.append(UtilityFilesRH.completarComZeroEsquerda(c.getGrauInstrucao().getCodigo(), 2));
        p.append(UtilityFilesRH.completarComBrancoDireita("", 4));
        Double valorSalario = UtilityCagedDiario.getSalarioNominal(c, periodo);
        aux = ContatoFormatUtil.formataNumero((Number)valorSalario, (int)2);
        aux = ToolString.refina((String)aux);
        p.append(UtilityFilesRH.completarComZeroEsquerda(aux, 8));
        p.append(UtilityFilesRH.completarComZeroEsquerda(c.getJornadaSemanalTrabalho().toString(), 2));
        p.append(UtilityFilesRH.formatarDatas8Digitos(c.getDataAdmissao()));
        p.append(UtilityFilesRH.completarComZeroEsquerda(c.getTipoAdmissaoCaged().getCodigo() + "  ", 4));
        p.append(UtilityFilesRH.completarComBrancoDireita(c.getPessoa().getNome(), 40));
        p.append(UtilityFilesRH.completarComZeroEsquerda(c.getCarteiraProfissional(), 8));
        p.append(UtilityFilesRH.completarComZeroEsquerda(c.getSerieCarteiraProfissional(), 4));
        p.append("       ");
        p.append(c.getRacaCor().getCodigo());
        p.append(this.getTipoDeficiencia(c));
        aux = ToolString.refina((String)c.getFuncao().getCbo().getCodigo());
        p.append(UtilityFilesRH.completarComZeroEsquerda(aux, 6));
        p.append(this.getAprendiz(c));
        p.append(c.getUfCarteiraProfissional().getSigla());
        p.append(this.getCodigoDeficiencia(c));
        p.append(c.getPessoa().getComplemento().getCnpj());
        p.append(c.getPessoa().getEndereco().getCep());
        if (c.getFuncao().getCbo().getObrigatoriedadeExameToxicologico() != null && c.getFuncao().getCbo().getObrigatoriedadeExameToxicologico().equals((short)0)) {
            p.append(UtilityFilesRH.completarComBrancoDireita("", 51));
        } else {
            CadastroExameColaborador exame = this.getExameColaborador(c);
            if (exame != null) {
                p.append(UtilityFilesRH.completarComZeroEsquerda(exame.getCodigoExame(), 17));
                p.append(UtilityFilesRH.formatarDatas8Digitos(exame.getDataExame()));
                p.append(UtilityFilesRH.completarComZeroEsquerda(ToolString.refina((String)exame.getCnpjLaboratorio()), 14));
                p.append(exame.getUfCrm().getSigla());
                p.append(UtilityFilesRH.completarComZeroEsquerda(exame.getCrm(), 10));
                p.append(UtilityFilesRH.completarComBrancoDireita("", 30));
            } else {
                p.append(UtilityFilesRH.completarComBrancoDireita("", 51));
            }
        }
        if (c.getTrabalhoParcial().equals((short)1)) {
            p.append("1");
        } else {
            p.append("2");
        }
        if (c.getTeleTrabalho().equals((short)1)) {
            p.append("1");
        } else {
            p.append("2");
        }
        if (c.getTrabalhoInterminente().equals((short)1)) {
            p.append("1");
        } else {
            p.append("2");
        }
        p.append(UtilityFilesRH.completarComBrancoDireita("", 27));
        p.println();
        p.flush();
        p.close();
        return true;
    }

    private Date primeiroDiaMes(Date date) {
        GregorianCalendar periodo = new GregorianCalendar();
        periodo.setTime(date);
        return DateUtil.intToDate(periodo.get(1), periodo.get(2) + 1, 1);
    }

    private CadastroExameColaborador getExameColaborador(Colaborador c) throws ExceptionService {
        if (c.getDataDemissao() != null) {
            BaseCriteria bc = BaseCriteria.create(CoreDAOFactory.getInstance().getDAOCadastroExameColaborador().getVOClass());
            bc.and().equal("colaborador", c);
            bc.and().equal("exameDemissional", (short)1);
            CadastroExameColaborador exame = (CadastroExameColaborador)CoreService.executeSearchUniqueResult(bc);
            return exame;
        }
        BaseCriteria bc = BaseCriteria.create(CoreDAOFactory.getInstance().getDAOCadastroExameColaborador().getVOClass());
        bc.and().equal("colaborador", c);
        bc.and().equal("exameDemissional", (short)0);
        CadastroExameColaborador exame = (CadastroExameColaborador)CoreService.executeSearchUniqueResult(bc);
        return exame;
    }
}

