/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.geracaoarquivos.caged;

import com.touchcomp.basementor.model.vo.CadastroExameColaborador;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.TransferenciaColaborador;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.finder.BaseCriteria;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.CoreServiceFactory;
import mentorcore.service.impl.rh.calculofolha.CalculoFolhaPagamentoUtilities;
import mentorcore.service.impl.rh.geracaoarquivos.UtilityFilesRH;
import mentorcore.service.impl.rh.geracaoarquivos.caged.ServiceGeracaoCaged;
import mentorcore.tools.DateUtil;
import org.apache.commons.lang3.StringUtils;

public class UtilityCagedMensal {
    private TLogger logger = TLogger.get(UtilityCagedMensal.class);
    private Integer numeroSequencial = 1;

    public boolean gerarArquivoCagedMensal(HashMap h, File arquivo, String nome, EmpresaRh empresaRh) throws IOException, ExceptionService {
        TransferenciaColaborador t;
        Colaborador c;
        List colaboradoresAdmitidos = new ArrayList();
        List colaboradoresDemitidos = new ArrayList();
        List transferenciaEntrada = new ArrayList();
        List transferenciaSaida = new ArrayList();
        if (arquivo.exists()) {
            arquivo.delete();
            arquivo.createNewFile();
        }
        boolean retValue = true;
        Date dataPeriodo = (Date)h.get("PERIODO");
        Integer mes = DateUtil.monthFromDate(dataPeriodo);
        mes = mes.equals(1) ? Integer.valueOf(12) : Integer.valueOf(mes - 1);
        Long empresa = (Long)h.get("empresa");
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("empresa", empresa);
        request.setAttribute("PERIODO", h.get("PERIODO"));
        this.validarInformacaoExameToxicologico(empresa, dataPeriodo);
        colaboradoresDemitidos = (List)CoreServiceFactory.getServiceGeracaoCaged().execute(request, "findColaboradoresDemitidosCaged");
        colaboradoresAdmitidos = (List)CoreServiceFactory.getServiceGeracaoCaged().execute(request, "colaboradoresAdmitidosCagedMensal");
        transferenciaEntrada = (List)CoreServiceFactory.getServiceGeracaoCaged().execute(request, "findTransferenciaEntradaColaborador");
        transferenciaSaida = (List)CoreServiceFactory.getServiceGeracaoCaged().execute(request, "findTransferenciaSaidaColaborador");
        h.put("MOVIMENTACOES", colaboradoresDemitidos.size() + colaboradoresAdmitidos.size());
        retValue = this.escreverRegistroA(h, arquivo, empresaRh);
        if (!retValue) {
            arquivo.delete();
            return false;
        }
        retValue = this.escreverRegistroB(h, arquivo, empresaRh, colaboradoresAdmitidos.size());
        if (!retValue) {
            arquivo.delete();
            return false;
        }
        for (Object obj : colaboradoresDemitidos) {
            c = (Colaborador)obj;
            retValue = this.escreverRegistroC(h, arquivo, c, empresaRh, dataPeriodo);
            if (retValue) continue;
            arquivo.delete();
            return false;
        }
        for (Object obj : colaboradoresAdmitidos) {
            c = (Colaborador)obj;
            retValue = this.escreverRegistroCAdmitidos(h, arquivo, c, empresaRh, dataPeriodo);
            if (retValue) continue;
            arquivo.delete();
            return false;
        }
        for (Object obj : transferenciaSaida) {
            t = (TransferenciaColaborador)obj;
            retValue = this.escreverRegistroCTransferenciaSaida(h, arquivo, t, empresaRh, dataPeriodo);
            if (retValue) continue;
            arquivo.delete();
            return false;
        }
        for (Object obj : transferenciaEntrada) {
            t = (TransferenciaColaborador)obj;
            retValue = this.escreverRegistroCTransferenciaEntrada(h, arquivo, t, empresaRh, dataPeriodo);
        }
        return true;
    }

    private boolean escreverRegistroA(HashMap h, File arquivo, EmpresaRh empresaRh) throws IOException, ExceptionService {
        Date periodo = (Date)h.get("PERIODO");
        String alteracao = (String)h.get("ALTERACAO");
        Integer totalMovimentacoes = (Integer)h.get("MOVIMENTACOES");
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        String aux = null;
        p.append("A");
        p.append("L2009");
        p.append("   ");
        p.append(UtilityFilesRH.completarComZeroEsquerda(this.getPeriodo(periodo), 6));
        p.append(alteracao);
        p.append(UtilityFilesRH.completarComZeroEsquerda(this.numeroSequencial.toString(), 5));
        Integer n = this.numeroSequencial;
        this.numeroSequencial = this.numeroSequencial + 1;
        p.append(this.getTipoIdentificador(empresaRh.getPessoaResponsavel()));
        if (empresaRh.getPessoaResponsavel().getComplemento().getCnpj().length() == 14) {
            p.append(empresaRh.getPessoaResponsavel().getComplemento().getCnpj());
        } else if (empresaRh.getPessoaResponsavel().getComplemento().getCodCei() != null) {
            p.append(UtilityFilesRH.completarComZeroEsquerda(empresaRh.getPessoaResponsavel().getComplemento().getCodCei(), 14));
        } else {
            throw new ExceptionService("Codigo CEI n\u00e3o informado na Empresa Contabilidade");
        }
        p.append(UtilityFilesRH.completarComBrancoDireita(empresaRh.getPessoaResponsavel().getNome().toUpperCase(), 35));
        p.append(UtilityFilesRH.completarComBrancoDireita(this.escreverEndereco(empresaRh.getPessoaResponsavel()), 40));
        aux = ToolString.refina((String)empresaRh.getPessoaResponsavel().getEndereco().getCep());
        p.append(UtilityFilesRH.completarComBrancoDireita(aux, 8));
        p.append(UtilityFilesRH.completarComBrancoDireita(empresaRh.getPessoaResponsavel().getEndereco().getCidade().getUf().getSigla(), 2));
        if (empresaRh.getEmpresa().getPessoa().getComplemento().getFone1() == null) {
            throw new ExceptionService("Telefone n\u00e3o informado no cadastro do Autorizado.");
        }
        p.append(UtilityFilesRH.completarComZeroEsquerda(empresaRh.getPessoaResponsavel().getComplemento().getFone1(), 12));
        p.append("00000");
        p.append("00001");
        p.append(UtilityFilesRH.completarComZeroEsquerda(totalMovimentacoes.toString(), 5));
        p.append(UtilityFilesRH.completarComBrancoDireita("", 92));
        p.println();
        p.flush();
        p.close();
        return true;
    }

    private String escreverEndereco(Pessoa pessoa) {
        String logradouro = pessoa.getEndereco().getLogradouro();
        String numero = pessoa.getEndereco().getNumero();
        String complemento = pessoa.getEndereco().getComplemento();
        return logradouro.toUpperCase() + " " + numero + " " + complemento.toUpperCase();
    }

    private String getPeriodo(Date periodo) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(periodo);
        Integer mes = g.get(2);
        Integer ano = g.get(1);
        Integer anoCompetencia = this.getAnoCompetencia(periodo);
        ano = ano != anoCompetencia ? anoCompetencia : ano;
        mes = mes != 0 ? mes : 12;
        return mes.toString() + ano.toString();
    }

    private String getTipoIdentificador(Pessoa pessoa) {
        if (pessoa.getComplemento().getCnpj().length() == 14) {
            return "1";
        }
        return "2";
    }

    private boolean escreverRegistroB(HashMap h, File f, EmpresaRh empresaRh, Integer qtdadeAdmitidos) throws IOException, ExceptionService {
        String declaracao = (String)h.get("DECLARACAO");
        String alteracao = (String)h.get("ALTERACAO");
        Long afastados = (Long)h.get("AFASTADOS");
        FileWriter fileWriter = new FileWriter(f, true);
        PrintWriter p = new PrintWriter(fileWriter);
        String aux = null;
        p.append("B");
        p.append(this.getTipoIdentificador(empresaRh.getEmpresa().getPessoa()));
        p.append(this.getNumeroIdentificador(empresaRh));
        p.append(UtilityFilesRH.completarComZeroEsquerda(this.numeroSequencial.toString(), 5));
        Integer n = this.numeroSequencial;
        this.numeroSequencial = this.numeroSequencial + 1;
        p.append(declaracao);
        p.append(alteracao);
        aux = ToolString.refina((String)empresaRh.getEmpresa().getPessoa().getEndereco().getCep());
        p.append(UtilityFilesRH.completarComBrancoDireita(aux, 8));
        p.append("     ");
        p.append(UtilityFilesRH.completarComBrancoDireita(empresaRh.getEmpresa().getPessoa().getNome().toUpperCase(), 40));
        p.append(UtilityFilesRH.completarComBrancoDireita(this.escreverEndereco(empresaRh.getEmpresa().getPessoa()), 40));
        p.append(UtilityFilesRH.completarComBrancoDireita(empresaRh.getEmpresa().getPessoa().getEndereco().getBairro().toUpperCase(), 20));
        p.append(UtilityFilesRH.completarComBrancoDireita(empresaRh.getEmpresa().getPessoa().getEndereco().getCidade().getUf().getSigla(), 2));
        Date primeiroDiaMes = this.primeiroDiaMes((Date)h.get("PERIODO"));
        Long totalFunc = (Long)CoreServiceFactory.getServiceGeracaoCaged().execute(CoreRequestContext.newInstance().setAttribute("primeiroDiaMes", primeiroDiaMes).setAttribute("empresa", empresaRh.getEmpresa().getIdentificador()).setAttribute("dataApuracao", (Date)h.get("PERIODO")), "findtotalFuncionariosMes");
        p.append(UtilityFilesRH.completarComZeroEsquerda(totalFunc.toString(), 5));
        p.append(UtilityFilesRH.completarComZeroEsquerda(empresaRh.getPorteEstabelecimento().getCodigo(), 1));
        p.append(UtilityFilesRH.completarComZeroEsquerda(empresaRh.getCodCNAE(), 7));
        if (empresaRh.getEmpresa().getPessoa().getComplemento().getFone1() == null) {
            throw new ExceptionService("Telefone n\u00e3o informado no cadastro do Autorizado.");
        }
        p.append(UtilityFilesRH.completarComZeroEsquerda(this.getTelefoneEmpresa(empresaRh), 12));
        p.append(UtilityFilesRH.completarComBrancoDireita(empresaRh.getEmailResponsavel(), 50));
        p.append(UtilityFilesRH.completarComBrancoDireita("", 27));
        p.println();
        p.flush();
        p.close();
        return true;
    }

    private String getTelefoneEmpresa(EmpresaRh empresa) {
        return empresa.getEmpresa().getPessoa().getComplemento().getFone1();
    }

    private boolean escreverRegistroC(HashMap h, File f, Colaborador c, EmpresaRh empresaRh, Date periodo) throws IOException, ExceptionService {
        String aux = "";
        FileWriter fileWriter = new FileWriter(f, true);
        PrintWriter p = new PrintWriter(fileWriter);
        p.append("C");
        p.append(this.getTipoIdentificador(empresaRh.getEmpresa().getPessoa()));
        p.append(this.getNumeroIdentificador(empresaRh));
        p.append(UtilityFilesRH.completarComZeroEsquerda(this.numeroSequencial.toString(), 5));
        Integer n = this.numeroSequencial;
        this.numeroSequencial = this.numeroSequencial + 1;
        aux = ToolString.refina((String)c.getNumeroPis());
        p.append(UtilityFilesRH.completarComZeroEsquerda(aux, 11));
        p.append(this.getSexo(c));
        p.append(UtilityFilesRH.formatarDatas8Digitos(c.getPessoa().getComplemento().getDataNascimento()));
        p.append(UtilityFilesRH.completarComZeroEsquerda(c.getGrauInstrucao().getCodigo(), 2));
        p.append(UtilityFilesRH.completarComBrancoDireita("", 4));
        Double valorSalario = UtilityCagedMensal.getSalarioNominal(c, periodo);
        aux = ContatoFormatUtil.formataNumero((Number)valorSalario, (int)2);
        aux = ToolString.refina((String)aux);
        p.append(UtilityFilesRH.completarComZeroEsquerda(aux, 8));
        p.append(UtilityFilesRH.completarComZeroEsquerda(c.getJornadaSemanalTrabalho().toString(), 2));
        p.append(UtilityFilesRH.formatarDatas8Digitos(c.getDataAdmissao()));
        p.append(UtilityFilesRH.completarComZeroEsquerda(this.getTipoMovimento(c, h), 4));
        p.append(UtilityFilesRH.completarComBrancoDireita(c.getPessoa().getNome(), 40));
        p.append(UtilityFilesRH.completarComZeroEsquerda(c.getCarteiraProfissional(), 8));
        p.append(UtilityFilesRH.completarComZeroEsquerda(c.getSerieCarteiraProfissional(), 4));
        p.append("       ");
        p.append(c.getRacaCor().getCodigo());
        p.append(this.getTipoDeficiencia(c));
        aux = ToolString.refina((String)c.getFuncao().getCbo().getCodigo());
        p.append(UtilityFilesRH.completarComZeroEsquerda(aux, 6));
        p.append(this.getAprendiz(c));
        p.append(c.getUfCarteiraProfissional().getSigla());
        p.append(this.getCodigoDeficiencia(c));
        p.append(c.getPessoa().getComplemento().getCnpj());
        p.append(c.getPessoa().getEndereco().getCep());
        if (c.getFuncao().getCbo().getObrigatoriedadeExameToxicologico() != null && c.getFuncao().getCbo().getObrigatoriedadeExameToxicologico().equals((short)0)) {
            p.append(UtilityFilesRH.completarComBrancoDireita("", 51));
        } else {
            CadastroExameColaborador exame = this.getExameColaborador(c);
            if (exame != null) {
                p.append(UtilityFilesRH.completarComZeroEsquerda(exame.getCodigoExame(), 17));
                p.append(UtilityFilesRH.formatarDatas8Digitos(exame.getDataExame()));
                p.append(UtilityFilesRH.completarComZeroEsquerda(ToolString.refina((String)exame.getCnpjLaboratorio()), 14));
                p.append(exame.getUfCrm().getSigla());
                p.append(UtilityFilesRH.completarComZeroEsquerda(exame.getCrm(), 10));
                p.append(UtilityFilesRH.completarComBrancoDireita("", 30));
            } else {
                p.append(UtilityFilesRH.completarComBrancoDireita("", 51));
            }
        }
        if (c.getTrabalhoParcial().equals((short)1)) {
            p.append("1");
        } else {
            p.append("2");
        }
        if (c.getTeleTrabalho().equals((short)1)) {
            p.append("1");
        } else {
            p.append("2");
        }
        if (c.getTrabalhoInterminente().equals((short)1)) {
            p.append("1");
        } else {
            p.append("2");
        }
        p.append(UtilityFilesRH.completarComBrancoDireita("", 27));
        p.println();
        p.flush();
        p.close();
        return true;
    }

    private String getSexo(Colaborador c) {
        if (c.getSexo().equals((short)0)) {
            return "1";
        }
        return "2";
    }

    private String getNumeroIdentificador(EmpresaRh empresaRh) {
        if (empresaRh.getEmpresa().getPessoa().getComplemento().getCnpj().length() == 14) {
            return empresaRh.getEmpresa().getPessoa().getComplemento().getCnpj();
        }
        return empresaRh.getEmpresa().getPessoa().getComplemento().getCodCei();
    }

    private String getAprendiz(Colaborador c) {
        if (c.getTipoColaborador().getIdentificador().equals(3L)) {
            return "1";
        }
        return "2";
    }

    private String getTipoMovimento(Colaborador c, HashMap h) throws ExceptionService {
        return (String)CoreServiceFactory.getServiceGeracaoCaged().execute(CoreRequestContext.newInstance().setAttribute("colaborador", c).setAttribute("PERIODO", h.get("PERIODO")), ServiceGeracaoCaged.FIND_DIA_SAIDA_COLABORADOR);
    }

    private String getTipoDeficiencia(Colaborador c) {
        if (c.getTipoDeficiencia() != null) {
            return "1";
        }
        return "2";
    }

    private String getCodigoDeficiencia(Colaborador c) {
        if (c.getTipoDeficiencia() != null) {
            return c.getTipoDeficiencia().getCodigo();
        }
        return " ";
    }

    public static Double getSalarioNominal(Colaborador colaborador, Date periodoInicial) throws ExceptionService {
        String cod = colaborador.getTipoSalario().getCodigo();
        Integer codigo = new Integer(cod);
        Double valor = 0.0;
        switch (codigo) {
            case 1: {
                valor = UtilityCagedMensal.findVrSalarioMaiorColaboradorSalarioNoPeriodo(colaborador, periodoInicial);
                return valor;
            }
            case 2: {
                valor = UtilityCagedMensal.findVrSalarioMaiorColaboradorSalarioNoPeriodo(colaborador, periodoInicial);
                return valor;
            }
            case 3: {
                valor = UtilityCagedMensal.findVrSalarioMaiorColaboradorSalarioNoPeriodo(colaborador, periodoInicial);
                return valor;
            }
            case 4: {
                valor = UtilityCagedMensal.findVrSalarioMaiorColaboradorSalarioNoPeriodo(colaborador, periodoInicial);
                valor = valor * colaborador.getDiasJornada();
                return valor;
            }
            case 5: {
                valor = UtilityCagedMensal.findVrSalarioMaiorColaboradorSalarioNoPeriodo(colaborador, periodoInicial);
                valor = valor * colaborador.getDiasJornada() * colaborador.getHorasTrabDia();
                valor = ContatoFormatUtil.arrredondarNumero((Double)valor, (int)2);
                return valor;
            }
            case 6: {
                return valor;
            }
            case 7: {
                return valor;
            }
        }
        return valor;
    }

    public static Double findVrSalarioMaiorColaboradorSalarioNoPeriodo(Colaborador c, Date periodoInicial) {
        return new CalculoFolhaPagamentoUtilities().findSalarioNominalEsocial(c);
    }

    private boolean escreverRegistroCAdmitidos(HashMap h, File f, Colaborador c, EmpresaRh empresaRh, Date periodo) throws IOException, ExceptionService {
        String aux = "";
        FileWriter fileWriter = new FileWriter(f, true);
        PrintWriter p = new PrintWriter(fileWriter);
        p.append("C");
        p.append(this.getTipoIdentificador(empresaRh.getEmpresa().getPessoa()));
        p.append(this.getNumeroIdentificador(empresaRh));
        p.append(UtilityFilesRH.completarComZeroEsquerda(this.numeroSequencial.toString(), 5));
        Integer n = this.numeroSequencial;
        this.numeroSequencial = this.numeroSequencial + 1;
        aux = ToolString.refina((String)c.getNumeroPis());
        p.append(UtilityFilesRH.completarComZeroEsquerda(aux, 11));
        p.append(this.getSexo(c));
        p.append(UtilityFilesRH.formatarDatas8Digitos(c.getPessoa().getComplemento().getDataNascimento()));
        p.append(UtilityFilesRH.completarComZeroEsquerda(c.getGrauInstrucao().getCodigo(), 2));
        p.append(UtilityFilesRH.completarComBrancoDireita("", 4));
        Double valorSalario = UtilityCagedMensal.getSalarioNominal(c, periodo);
        aux = ContatoFormatUtil.formataNumero((Number)valorSalario, (int)2);
        aux = ToolString.refina((String)aux);
        p.append(UtilityFilesRH.completarComZeroEsquerda(aux, 8));
        p.append(UtilityFilesRH.completarComZeroEsquerda(c.getJornadaSemanalTrabalho().toString(), 2));
        p.append(UtilityFilesRH.formatarDatas8Digitos(c.getDataAdmissao()));
        p.append(UtilityFilesRH.completarComZeroEsquerda(c.getTipoAdmissaoCaged().getCodigo() + "  ", 4));
        p.append(UtilityFilesRH.completarComBrancoDireita(c.getPessoa().getNome(), 40));
        p.append(UtilityFilesRH.completarComZeroEsquerda(c.getCarteiraProfissional() + c.getSerieCarteiraProfissional(), 12));
        p.append("       ");
        p.append(c.getRacaCor().getCodigo());
        p.append(this.getTipoDeficiencia(c));
        aux = ToolString.refina((String)c.getFuncao().getCbo().getCodigo());
        p.append(UtilityFilesRH.completarComZeroEsquerda(aux, 6));
        p.append(this.getAprendiz(c));
        if (c.getUfCarteiraProfissional() != null) {
            p.append(c.getUfCarteiraProfissional().getSigla());
        }
        p.append(this.getCodigoDeficiencia(c));
        p.append(c.getPessoa().getComplemento().getCnpj());
        p.append(c.getPessoa().getEndereco().getCep());
        if (c.getFuncao().getCbo().getObrigatoriedadeExameToxicologico() != null && c.getFuncao().getCbo().getObrigatoriedadeExameToxicologico().equals((short)0)) {
            p.append(UtilityFilesRH.completarComBrancoDireita("", 51));
        } else {
            CadastroExameColaborador exame = this.getExameColaborador(c);
            if (exame == null) {
                throw new ExceptionService("Verifique as informa\u00e7\u00f5es do Exame Toxicologico para o colaborador: " + c.toString());
            }
            if (exame != null) {
                p.append(UtilityFilesRH.completarComZeroEsquerda(exame.getCodigoExame(), 17));
                p.append(UtilityFilesRH.formatarDatas8Digitos(exame.getDataExame()));
                p.append(UtilityFilesRH.completarComZeroEsquerda(ToolString.refina((String)exame.getCnpjLaboratorio()), 14));
                p.append(exame.getUfCrm().getSigla());
                p.append(UtilityFilesRH.completarComZeroEsquerda(exame.getCrm(), 10));
                p.append(UtilityFilesRH.completarComBrancoDireita("", 30));
            } else {
                p.append(UtilityFilesRH.completarComBrancoDireita("", 51));
            }
        }
        if (c.getTrabalhoParcial().equals((short)1)) {
            p.append("1");
        } else {
            p.append("2");
        }
        if (c.getTeleTrabalho().equals((short)1)) {
            p.append("1");
        } else {
            p.append("2");
        }
        if (c.getTrabalhoInterminente().equals((short)1)) {
            p.append("1");
        } else {
            p.append("2");
        }
        p.append(UtilityFilesRH.completarComBrancoDireita("", 27));
        p.println();
        p.flush();
        p.close();
        return true;
    }

    private Date primeiroDiaMes(Date date) {
        date = DateUtil.nextMonth(date, -1);
        return DateUtil.intToDate(DateUtil.yearFromDate(date), DateUtil.monthFromDate(date), 1);
    }

    public static String completarComZeroEsquerda(String st, int tam) {
        if (st.length() > tam) {
            return st.substring(0, tam);
        }
        return StringUtils.leftPad((String)st, (int)tam, (String)"0");
    }

    public static String completarComBrancoDireita(String st, int tam) {
        if (st.length() > tam) {
            return st.substring(0, tam);
        }
        return StringUtils.rightPad((String)st, (int)tam, (String)" ");
    }

    public static String formatarDatas6Digitos(Date data) {
        if (data != null) {
            SimpleDateFormat dataFormatada = new SimpleDateFormat("ddMMyy");
            String dataVenc = dataFormatada.format(data);
            return dataVenc;
        }
        return "000000";
    }

    public static String formatarDatas6DigitosAnoMes(Date data) {
        if (data != null) {
            SimpleDateFormat dataFormatada = new SimpleDateFormat("yyyyMM");
            String dataVenc = dataFormatada.format(data);
            return dataVenc;
        }
        return "      ";
    }

    public static String formatarDatas8Digitos(Date data) {
        if (data != null) {
            SimpleDateFormat dataFormatada = new SimpleDateFormat("ddMMyyyy");
            String dataVenc = dataFormatada.format(data);
            return dataVenc;
        }
        return "        ";
    }

    public static String completarComBrancoEsquerda(String st, int tam) {
        return StringUtils.leftPad((String)st, (int)tam, (String)" ");
    }

    public static String completarComNove(int tam) {
        Object aux = "";
        for (int i = 0; i < tam; ++i) {
            aux = (String)aux + "9";
        }
        return aux;
    }

    public static final int getMonthsDifference(Date date1, Date date2) {
        GregorianCalendar g = new GregorianCalendar();
        GregorianCalendar g1 = new GregorianCalendar();
        g.setTime(date1);
        g1.setTime(date2);
        int m1 = g.get(1) * 12 + g.get(2);
        int m2 = g1.get(1) * 12 + g1.get(2);
        return m2 - m1 + 1;
    }

    private boolean escreverRegistroCTransferenciaSaida(HashMap h, File f, TransferenciaColaborador t, EmpresaRh empresaRh, Date dataPeriodo) throws ExceptionService, IOException {
        String aux = "";
        FileWriter fileWriter = new FileWriter(f, true);
        PrintWriter p = new PrintWriter(fileWriter);
        p.append("C");
        p.append(this.getTipoIdentificador(empresaRh.getEmpresa().getPessoa()));
        p.append(this.getNumeroIdentificador(empresaRh));
        p.append(UtilityFilesRH.completarComZeroEsquerda(this.numeroSequencial.toString(), 5));
        Integer n = this.numeroSequencial;
        this.numeroSequencial = this.numeroSequencial + 1;
        aux = ToolString.refina((String)t.getColaborador().getNumeroPis());
        p.append(UtilityFilesRH.completarComZeroEsquerda(aux, 11));
        p.append(this.getSexo(t.getColaborador()));
        p.append(UtilityFilesRH.formatarDatas8Digitos(t.getColaborador().getPessoa().getComplemento().getDataNascimento()));
        p.append(UtilityFilesRH.completarComZeroEsquerda(t.getColaborador().getGrauInstrucao().getCodigo(), 2));
        p.append(UtilityFilesRH.completarComBrancoDireita("", 4));
        Double valorSalario = UtilityCagedMensal.getSalarioNominal(t.getColaborador(), dataPeriodo);
        aux = ContatoFormatUtil.formataNumero((Number)valorSalario, (int)2);
        aux = ToolString.refina((String)aux);
        p.append(UtilityFilesRH.completarComZeroEsquerda(aux, 8));
        p.append(UtilityFilesRH.completarComZeroEsquerda(t.getColaborador().getJornadaSemanalTrabalho().toString(), 2));
        p.append(UtilityFilesRH.formatarDatas8Digitos(t.getColaborador().getDataAdmissao()));
        p.append(t.getAfastamentoCagedSaida().getCodigo() + UtilityFilesRH.completarComZeroEsquerda(DateUtil.dayFromDate(t.getDataTransferencia()).toString(), 2));
        p.append(UtilityFilesRH.completarComBrancoDireita(t.getColaborador().getPessoa().getNome(), 40));
        p.append(UtilityFilesRH.completarComZeroEsquerda(t.getColaborador().getCarteiraProfissional(), 8));
        p.append(UtilityFilesRH.completarComZeroEsquerda(t.getColaborador().getSerieCarteiraProfissional(), 4));
        p.append("       ");
        p.append(t.getColaborador().getRacaCor().getCodigo());
        p.append(this.getTipoDeficiencia(t.getColaborador()));
        aux = ToolString.refina((String)t.getColaborador().getFuncao().getCbo().getCodigo());
        p.append(UtilityFilesRH.completarComZeroEsquerda(aux, 6));
        p.append(this.getAprendiz(t.getColaborador()));
        p.append(t.getColaborador().getUfCarteiraProfissional().getSigla());
        p.append(this.getCodigoDeficiencia(t.getColaborador()));
        p.append(t.getColaborador().getPessoa().getComplemento().getCnpj());
        p.append(t.getColaborador().getPessoa().getEndereco().getCep());
        p.append(UtilityFilesRH.completarComBrancoDireita("", 81));
        if (t.getColaborador().getTrabalhoParcial().equals((short)1)) {
            p.append("1");
        } else {
            p.append("2");
        }
        if (t.getColaborador().getTeleTrabalho().equals((short)1)) {
            p.append("1");
        } else {
            p.append("2");
        }
        if (t.getColaborador().getTrabalhoInterminente().equals((short)1)) {
            p.append("1");
        } else {
            p.append("2");
        }
        p.append(UtilityFilesRH.completarComBrancoDireita("", 27));
        p.println();
        p.flush();
        p.close();
        return true;
    }

    private boolean escreverRegistroCTransferenciaEntrada(HashMap h, File arquivo, TransferenciaColaborador t, EmpresaRh empresaRh, Date dataPeriodo) throws IOException, ExceptionService {
        String aux = "";
        FileWriter fileWriter = new FileWriter(arquivo, true);
        PrintWriter p = new PrintWriter(fileWriter);
        p.append("C");
        p.append(this.getTipoIdentificador(empresaRh.getEmpresa().getPessoa()));
        p.append(this.getNumeroIdentificador(empresaRh));
        p.append(UtilityFilesRH.completarComZeroEsquerda(this.numeroSequencial.toString(), 5));
        Integer n = this.numeroSequencial;
        this.numeroSequencial = this.numeroSequencial + 1;
        aux = ToolString.refina((String)t.getColaborador().getNumeroPis());
        p.append(UtilityFilesRH.completarComZeroEsquerda(aux, 11));
        p.append(this.getSexo(t.getColaborador()));
        p.append(UtilityFilesRH.formatarDatas8Digitos(t.getColaborador().getPessoa().getComplemento().getDataNascimento()));
        p.append(UtilityFilesRH.completarComZeroEsquerda(t.getColaborador().getGrauInstrucao().getCodigo(), 2));
        p.append(UtilityFilesRH.completarComBrancoDireita("", 4));
        Double valorSalario = UtilityCagedMensal.getSalarioNominal(t.getColaborador(), dataPeriodo);
        aux = ContatoFormatUtil.formataNumero((Number)valorSalario, (int)2);
        aux = ToolString.refina((String)aux);
        p.append(UtilityFilesRH.completarComZeroEsquerda(aux, 8));
        p.append(UtilityFilesRH.completarComZeroEsquerda(t.getColaborador().getJornadaSemanalTrabalho().toString(), 2));
        p.append(UtilityFilesRH.formatarDatas8Digitos(t.getDataTransferenciaEntrada()));
        p.append(t.getAfastamentoCaged().getCodigo() + UtilityFilesRH.completarComZeroEsquerda(DateUtil.dayFromDate(t.getDataTransferencia()).toString(), 2));
        p.append(UtilityFilesRH.completarComBrancoDireita(t.getColaborador().getPessoa().getNome(), 40));
        p.append(UtilityFilesRH.completarComZeroEsquerda(t.getColaborador().getCarteiraProfissional(), 8));
        p.append(UtilityFilesRH.completarComZeroEsquerda(t.getColaborador().getSerieCarteiraProfissional(), 4));
        p.append("       ");
        p.append(t.getColaborador().getRacaCor().getCodigo());
        p.append(this.getTipoDeficiencia(t.getColaborador()));
        aux = ToolString.refina((String)t.getColaborador().getFuncao().getCbo().getCodigo());
        p.append(UtilityFilesRH.completarComZeroEsquerda(aux, 6));
        p.append(this.getAprendiz(t.getColaborador()));
        p.append(t.getColaborador().getUfCarteiraProfissional().getSigla());
        p.append(this.getCodigoDeficiencia(t.getColaborador()));
        p.append(t.getColaborador().getPessoa().getComplemento().getCnpj());
        p.append(t.getColaborador().getPessoa().getEndereco().getCep());
        p.append(UtilityFilesRH.completarComBrancoDireita("", 81));
        if (t.getColaborador().getTrabalhoParcial().equals((short)1)) {
            p.append("1");
        } else {
            p.append("2");
        }
        if (t.getColaborador().getTeleTrabalho().equals((short)1)) {
            p.append("1");
        } else {
            p.append("2");
        }
        if (t.getColaborador().getTrabalhoInterminente().equals((short)1)) {
            p.append("1");
        } else {
            p.append("2");
        }
        p.append(UtilityFilesRH.completarComBrancoDireita("", 27));
        p.println();
        p.flush();
        p.close();
        return true;
    }

    private Integer getAnoCompetencia(Date periodo) {
        periodo = DateUtil.nextMonth(periodo, -1);
        Integer ano = DateUtil.yearFromDate(periodo);
        return ano;
    }

    private CadastroExameColaborador getExameColaborador(Colaborador c) throws ExceptionService {
        if (c.getDataDemissao() != null) {
            BaseCriteria bc = BaseCriteria.create(CoreDAOFactory.getInstance().getDAOCadastroExameColaborador().getVOClass());
            bc.and().equal("colaborador", c);
            bc.and().equal("exameDemissional", (short)1);
            CadastroExameColaborador exame = (CadastroExameColaborador)CoreService.executeSearchUniqueResult(bc);
            return exame;
        }
        BaseCriteria bc = BaseCriteria.create(CoreDAOFactory.getInstance().getDAOCadastroExameColaborador().getVOClass());
        bc.and().equal("colaborador", c);
        bc.and().equal("exameDemissional", (short)0);
        CadastroExameColaborador exame = (CadastroExameColaborador)CoreService.executeSearchUniqueResult(bc);
        return exame;
    }

    private void validarInformacaoExameToxicologico(Long empresa, Date dataPeriodo) throws ExceptionService {
        String hql = " select c  from Colaborador c  where  c.dataAdmissao between :dataInicial and :dataFinal  and  c.dataDemissao between :dataInicial and :dataFinal  and  c.empresa.identificador = :empresa  and  c.funcao.cbo.obrigatoriedadeExameToxicologico = :sim  and  not exists (select cad              from CadastroExameColaborador cad              where              cad.colaborador = c ) ";
        List list = CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("dataInicial", DateUtil.getDateFirstMonthDay(dataPeriodo)).setDate("dataFinal", DateUtil.getDateLastMonthDay(dataPeriodo)).setShort("sim", (short)1).setLong("empresa", empresa.longValue()).list();
        if (list != null && !list.isEmpty()) {
            Object ret = "";
            for (Object object : list) {
                Colaborador c = (Colaborador)object;
                ret = (String)ret + c.toString() + "\n";
            }
            throw new ExceptionService("Verifique as informa\u00e7\u00f5es de Exame dos Seguintes Colaboradores: \n " + (String)ret);
        }
    }
}

