/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.geracaoarquivos.caged;

import com.touchcomp.basementor.model.vo.Colaborador;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.impl.rh.geracaoarquivos.UtilityFilesRH;
import mentorcore.tools.DateUtil;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilityDadosCaged {
    public List findTransferenciaSaidaColaboradores(Long empresa, Date periodo) {
        periodo = DateUtil.nextMonth(periodo, -1);
        String hql = " select t  from TransferenciaColaborador t  where  t.dataTransferencia between :dataInicio and :dataFinal  and  t.empresa = :empresa ";
        List retorno = CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("empresa", empresa.longValue()).setDate("dataInicio", DateUtil.getDateFirstMonthDay(periodo)).setDate("dataFinal", DateUtil.getDateLastMonthDay(periodo)).list();
        if (retorno != null && !retorno.isEmpty()) {
            return retorno;
        }
        return new ArrayList();
    }

    public List findTransferenciaEntradaColaboradores(Long empresa, Date periodo) {
        periodo = DateUtil.nextMonth(periodo, -1);
        String hql = " select t  from TransferenciaColaborador t  where  t.dataTransferenciaEntrada between :dataInicio and :dataFinal  and  t.empresaNova = :empresa ";
        List retorno = CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("empresa", empresa.longValue()).setDate("dataInicio", DateUtil.getDateFirstMonthDay(periodo)).setDate("dataFinal", DateUtil.getDateLastMonthDay(periodo)).list();
        if (retorno != null && !retorno.isEmpty()) {
            return retorno;
        }
        return new ArrayList();
    }

    public List findColaboradoresDemitidosCaged(Date periodo, Long empresa) {
        String hql = " from Colaborador c  where c.ativo = 1        and        (c.tipoColaborador = 0 or c.tipoColaborador = 3 )       and        (exists  (select r.colaborador                         from Recisao r                         where ((extract(month from r.dataAfastamento)) = :mesPeriodo)                         and (extract(year from r.dataAfastamento)) = :anoPeriodo                          and r.colaborador = c ) )    and  c.empresa.identificador = :empresa ";
        List l = CoreBdUtil.getInstance().getSession().createQuery(hql).setInteger("mesPeriodo", this.getMesPeriodo(periodo) - 1 != 0 ? this.getMesPeriodo(periodo) - 1 : 12).setInteger("anoPeriodo", this.getAnoPeriodoCaged(periodo)).setLong("empresa", empresa.longValue()).list();
        return l;
    }

    public List findColaboradoresAdmitidosCagedMensal(Date periodo, Long empresa) {
        String hql = " from Colaborador c  where c.empresa.identificador = :empresa and c.ativo = 1  and  (c.tipoColaborador = 0 or c.tipoColaborador = 3) and  ((extract(month from c.dataAdmissao)  =:mesPeriodo)  and     (extract(year from c.dataAdmissao) =:anoPeriodo))  and  c.recebimentoSeguroDesemprego = :nao ";
        List aux = CoreBdUtil.getInstance().getSession().createQuery(hql).setInteger("mesPeriodo", this.getMesPeriodo(periodo) - 1 != 0 ? this.getMesPeriodo(periodo) - 1 : 12).setInteger("anoPeriodo", this.getAnoPeriodoCaged(periodo)).setLong("empresa", empresa.longValue()).setShort("nao", (short)0).list();
        return aux;
    }

    private int getMesPeriodo(Date periodo) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(periodo);
        return g.get(2) + 1;
    }

    private int getAnoPeriodoCaged(Date periodo) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(periodo);
        Integer ano = g.get(1);
        Integer anoCompetencia = this.getAnoCompetencia(periodo);
        ano = ano != anoCompetencia ? anoCompetencia : ano;
        return ano;
    }

    private Integer getAnoCompetencia(Date periodo) {
        periodo = DateUtil.nextMonth(periodo, -1);
        Integer ano = DateUtil.yearFromDate(periodo);
        return ano;
    }

    public Long findTotalFuncionariosMes(Date primeiroDiaMes, Long empresa, Date dataApuracao) {
        String hql = " select coalesce(count(c.identificador),0)  from Colaborador c  where  c.ativo = :sim  and  (c.dataDemissao is null or c.dataDemissao >= :primeiroDiaMes  )  and  (c.dataAdmissao < :primeiroDiaMes or(c.dataAdmissao >= :primeiroDiaMes and c.dataAdmissao < :dataApuracao and c.recebimentoSeguroDesemprego = :sim)) and  (c.empresa.identificador  = :empresa   or  exists( from TransferenciaColaborador t          where          t.colaborador = c          and          t.dataTransferencia between :primeiroDiaMes and :dataApuracao)) and  (c.tipoColaborador.identificador = 0 or c.tipoColaborador.identificador = 3 )  ";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("sim", (short)1).setLong("empresa", empresa.longValue()).setDate("dataApuracao", dataApuracao).setDate("primeiroDiaMes", primeiroDiaMes).uniqueResult();
        return ret;
    }

    public String findDiaSaidaColaborador(CoreRequestContext r) {
        Date periodo = (Date)r.getAttribute("PERIODO");
        Colaborador c = (Colaborador)r.getAttribute("colaborador");
        String hql = " select r.dataAfastamento as DATA_DEMISSAO ,  r.cadastroRecisao.desligamentoCaged.codigo as CODIGO_DESLIGAMENTO  from Recisao r  where  r.colaborador = :colaborador  and  (extract(month from r.dataAfastamento)) = :mesPeriodo  and  r.recisaoComplementar = :nao ";
        HashMap h = (HashMap)CoreBdUtil.getInstance().getSession().createQuery(hql).setInteger("mesPeriodo", this.getPeriodo(periodo) - 1 != 0 ? this.getPeriodo(periodo) - 1 : 12).setEntity("colaborador", (Object)c).setShort("nao", (short)0).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).uniqueResult();
        if (h == null) {
            return c.getTipoAdmissaoCaged().getCodigo() + "  ";
        }
        String codigo = (String)h.get("CODIGO_DESLIGAMENTO");
        Date dataDemissao = (Date)h.get("DATA_DEMISSAO");
        return codigo + UtilityFilesRH.completarComZeroEsquerda(this.getDiaSaida(dataDemissao), 2);
    }

    private int getPeriodo(Date periodo) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(periodo);
        return g.get(2) + 1;
    }

    private String getDiaSaida(Date dataDemissao) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(dataDemissao);
        Integer diaSaida = g.get(5);
        return diaSaida.toString();
    }

    public Long totalFuncionarioNoPeriodo(Long idEmpresa, Date dataApuracao, Date primeiroDiaMes) {
        String hql = " select coalesce(count(c.identificador),0)  from Colaborador c  where  c.ativo = :sim  and  (c.dataDemissao is null or c.dataDemissao > :primeiroDiaMes )  and  (c.dataAdmissao < :primeiroDiaMes or (c.dataAdmissao >= :primeiroDiaMes and c.dataAdmissao < :dataApuracao and c.recebimentoSeguroDesemprego = :sim)) and  c.empresa.identificador  = :empresa and (c.tipoColaborador.identificador = 0 or c.tipoColaborador.identificador = 3 ) ";
        Long ret = (Long)CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("sim", (short)1).setLong("empresa", idEmpresa.longValue()).setDate("dataApuracao", dataApuracao).setDate("primeiroDiaMes", primeiroDiaMes).uniqueResult();
        return ret;
    }

    public List findColaboradoresAdmitidosCaged(Date periodo, Long empresa) {
        String hql = " from Colaborador c  where  c.empresa.identificador = :empresa  and  c.ativo = 1  and  (c.tipoColaborador = 0 or c.tipoColaborador = 3) and  c.dataAdmissao  = :periodo  and  c.recebimentoSeguroDesemprego = :sim";
        List aux = CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("periodo", periodo).setLong("empresa", empresa.longValue()).setShort("sim", (short)1).list();
        return aux;
    }
}

