/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.homolognet;

import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoParamFolha;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.AfastamentoColaborador;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.DeParaEventosHomolognet;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.Evento;
import com.touchcomp.basementor.model.vo.ItemMovimentoFolha;
import com.touchcomp.basementor.model.vo.ItemMovimentoRescisao;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementor.model.vo.TabelaRubricaHomolognet;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.rh.homolognet.CausaDoAfastamentoTipo;
import mentorcore.service.impl.rh.homolognet.DadosCalculoVerbasTipo;
import mentorcore.service.impl.rh.homolognet.Empregador;
import mentorcore.service.impl.rh.homolognet.EnderecoTipo;
import mentorcore.service.impl.rh.homolognet.MotivoTipo;
import mentorcore.service.impl.rh.homolognet.ObjectFactory;
import mentorcore.service.impl.rh.homolognet.UfTipo;
import mentorcore.service.impl.rh.homolognet.UtilDadosHomolognet;
import mentorcore.tools.DateUtil;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class ServiceCriacaoHomolognet
extends CoreService {
    public static final String CRIACAO_XML_HOMOLOGNET = "criacaoXmlHomolognet";
    private TLogger logger = TLogger.get(ServiceCriacaoHomolognet.class);

    public Empregador criacaoXmlHomolognet(CoreRequestContext request) throws DatatypeConfigurationException, JAXBException, ExceptionService {
        Recisao r = (Recisao)request.getAttribute("rescisao");
        EmpresaRh empresarh = (EmpresaRh)request.getAttribute("empresaRh");
        Integer comprovacaoEmprego = (Integer)request.getAttribute("comprovacaoEmprego");
        Integer dispensadoAviso = (Integer)request.getAttribute("dispensadoAviso");
        List feriasMentor = (List)request.getAttribute("feriasMentor");
        List afastamentosColaboradores = (List)request.getAttribute("afastamentosColaboradores");
        JAXBElement<BigInteger> valor = null;
        Empregador empregador = new Empregador();
        Empregador.DadosIniciais dadosIniciais = new ObjectFactory().createEmpregadorDadosIniciais();
        Double aux = r.getJrnSemanalIntegral().doubleValue();
        aux = aux == 1.0 ? 1.0 : 2.0;
        dadosIniciais.setTPJornadaCumpridaIntegralmente(this.formatarNumeroInteger(aux));
        aux = r.getSabadoCompensado().doubleValue();
        aux = aux == 1.0 ? 1.0 : 2.0;
        valor = new ObjectFactory().createEmpregadorDadosIniciaisTPJornadaSemana(this.formatarNumeroInteger(aux));
        dadosIniciais.setTPJornadaSemana(valor);
        DadosCalculoVerbasTipo formaCalculo = new ObjectFactory().createDadosCalculoVerbasTipo();
        formaCalculo.setNRDuracaoAvisoPrevio(this.formatarNumeroInteger(r.getDiasAviso()));
        valor = new ObjectFactory().createDadosCalculoVerbasTipoTPCalculoMediasVariaveisDecimoTerceiro(this.formatarNumeroInteger(empresarh.getFormulaCalculoVerbas().doubleValue()));
        formaCalculo.setTPCalculoMediasVariaveisDecimoTerceiro(valor);
        valor = new ObjectFactory().createDadosCalculoVerbasTipoTPCalculoMediasVariaveisFerias(this.formatarNumeroInteger(empresarh.getFormulaCalculoVerbas().doubleValue()));
        formaCalculo.setTPCalculoMediasVariaveisFerias(valor);
        valor = new ObjectFactory().createDadosCalculoVerbasTipoTPCalculoMediasVariaveisAvisoPrevio(this.formatarNumeroInteger(empresarh.getFormulaCalculoVerbas().doubleValue()));
        formaCalculo.setTPCalculoMediasVariaveisAvisoPrevio(valor);
        dadosIniciais.setFormaCalculo(new ObjectFactory().createEmpregadorDadosIniciaisFormaCalculo(formaCalculo));
        empregador.setDadosIniciais(dadosIniciais);
        empregador.setTPInscricao(this.formatarNumeroInteger(1.0));
        String cnpj = ToolString.refina((String)r.getEmpresa().getPessoa().getComplemento().getCnpj());
        empregador.setNRCnpjCei(this.formatarNumeroInteger(new Double(cnpj)));
        String nomeEmpregador = r.getEmpresa().getPessoa().getNome();
        empregador.setNORazaoSocial(nomeEmpregador);
        if (empresarh.getSindicato() != null) {
            empregador.setNRCnpjEspCees(this.formatarNumeroIntegerString(empresarh.getSindicato().getPessoa().getComplemento().getCnpj()));
            empregador.setNRCodigoSindicalEspCees(empresarh.getSindicato().getCodigoSindical());
        }
        empregador.setCnae(this.formatarNumeroInteger(new Double(empresarh.getCodCNAE())));
        String cep = ToolString.refina((String)r.getEmpresa().getPessoa().getEndereco().getCep());
        EnderecoTipo enderecoHomolognet = new ObjectFactory().createEnderecoTipo();
        enderecoHomolognet.setNRCep(cep);
        String logradouro = ToolString.refina((String)r.getEmpresa().getPessoa().getEndereco().getLogradouro());
        enderecoHomolognet.setEDLogradouro(logradouro);
        enderecoHomolognet.setNREndereco(this.formatarNumeroInteger(new Double(r.getEmpresa().getPessoa().getEndereco().getNumero())));
        String complemento = r.getEmpresa().getPessoa().getEndereco().getComplemento();
        enderecoHomolognet.setDSComplemento(complemento);
        String bairro = r.getEmpresa().getPessoa().getEndereco().getBairro();
        enderecoHomolognet.setNOBairro(bairro);
        String cidadeEmpregador = r.getEmpresa().getPessoa().getEndereco().getCidade().getDescricao();
        enderecoHomolognet.setNOMunicipio(cidadeEmpregador);
        enderecoHomolognet.setSGUF(UfTipo.MG);
        empregador.setEndereco(enderecoHomolognet);
        if (r.getColaborador() != null) {
            Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario salario;
            List pagDecimo13Salario;
            Object decimoTerceiro;
            Empregador.Empregado empregado = new Empregador.Empregado();
            String cepColaborador = ToolString.refina((String)r.getColaborador().getPessoa().getEndereco().getCep());
            EnderecoTipo enderecoHomolognetColaborador = new ObjectFactory().createEnderecoTipo();
            enderecoHomolognetColaborador.setNRCep(cepColaborador);
            String logradouroColaborador = ToolString.refina((String)r.getColaborador().getPessoa().getEndereco().getLogradouro());
            enderecoHomolognetColaborador.setEDLogradouro(logradouroColaborador);
            enderecoHomolognetColaborador.setNREndereco(this.formatarNumeroInteger(new Double(r.getColaborador().getPessoa().getEndereco().getNumero())));
            String complementoColaborador = r.getColaborador().getPessoa().getEndereco().getComplemento();
            enderecoHomolognetColaborador.setDSComplemento(complementoColaborador);
            String bairroColaborador = r.getColaborador().getPessoa().getEndereco().getBairro();
            enderecoHomolognetColaborador.setNOBairro(bairroColaborador);
            String cidadeEmpregadorColaborador = r.getColaborador().getPessoa().getEndereco().getCidade().getDescricao();
            enderecoHomolognetColaborador.setNOMunicipio(cidadeEmpregadorColaborador);
            enderecoHomolognetColaborador.setSGUF(UfTipo.MG);
            empregado.setEndereco(enderecoHomolognetColaborador);
            String nrPis = r.getColaborador().getNumeroPis();
            empregado.setNRPisPasep(nrPis);
            String cpf = r.getColaborador().getPessoa().getComplemento().getCnpj();
            empregado.setNRCpf(cpf);
            String nomeFuncionario = r.getColaborador().getPessoa().getNome();
            empregado.setNOEmpregado(nomeFuncionario);
            empregado.setDTNascimento(this.formatarNumeroInteger(new Double(this.formatarDataPadrao8Digitos(r.getColaborador().getPessoa().getComplemento().getDataNascimento()))));
            String nomeMae = r.getColaborador().getNomeMae();
            empregado.setNOMae(nomeMae);
            String cepEmpregado = r.getColaborador().getPessoa().getEndereco().getCep();
            empregado.getEndereco().setNRCep(cepEmpregado);
            String logradouroEmpregado = r.getColaborador().getPessoa().getEndereco().getLogradouro();
            empregado.getEndereco().setEDLogradouro(logradouroEmpregado);
            empregado.getEndereco().setNREndereco(this.formatarNumeroInteger(new Double(r.getColaborador().getPessoa().getEndereco().getNumero())));
            String complementoEmpregado = r.getColaborador().getPessoa().getEndereco().getComplemento();
            if (complementoEmpregado != null && !complementoEmpregado.isEmpty()) {
                empregado.getEndereco().setDSComplemento(complementoEmpregado);
            } else {
                empregado.getEndereco().setDSComplemento("COMPLEMENTO");
            }
            String bairroEmpregador = r.getColaborador().getPessoa().getEndereco().getBairro();
            empregado.getEndereco().setNOBairro(bairroEmpregador);
            String cidadeEmpregado = r.getColaborador().getPessoa().getEndereco().getCidade().getDescricao();
            empregado.getEndereco().setNOMunicipio(cidadeEmpregado);
            empregado.getEndereco().setSGUF(UfTipo.MG);
            String ctps = r.getColaborador().getCarteiraProfissional();
            empregado.setNRCtps(ctps);
            String serieCarteira = r.getColaborador().getSerieCarteiraProfissional();
            empregado.setNRSerieCTPS(serieCarteira);
            empregado.setSGUfCtps(UfTipo.MG);
            Empregador.Empregado.Contratos.Contrato contrato = new Empregador.Empregado.Contratos.Contrato();
            String nrCbo = ToolString.refina((String)r.getColaborador().getFuncao().getCbo().getCodigo());
            contrato.setNRCbo(nrCbo);
            String string = this.formatarDataPadrao4Digitos(empresarh.getDataBase());
            contrato.setDTBaseCategoriaProfissional(string);
            contrato.setDTAdmissao(this.formatarNumeroInteger(new Double(this.formatarDataPadrao8Digitos(r.getColaborador().getDataAdmissao()))));
            Integer jornadaSemanal = r.getColaborador().getJornadaSemanalTrabalho();
            contrato.setNRTrabalhoSemanal(this.formatarNumeroInteger(jornadaSemanal.doubleValue()));
            contrato.setDTAvisoPrevio(this.formatarNumeroInteger(new Double(this.formatarDataPadrao8Digitos(r.getDataDemissao()))));
            contrato.setDTAfastamento(this.formatarNumeroInteger(new Double(this.formatarDataPadrao8Digitos(r.getDataAfastamento()))));
            contrato.setTPCausaAfastamento(CausaDoAfastamentoTipo.fromValue(r.getCadastroRecisao().getRecisao().getCodigo()));
            String tipoContrato = r.getTipoContrato().substring(0, 1);
            contrato.setTPContratoTrabalho(this.formatarNumeroInteger(new Double(tipoContrato)));
            aux = comprovacaoEmprego.doubleValue();
            aux = aux == 1.0 ? aux : 2.0;
            contrato.setTPComprovacaoEmpregoDuranteAvisoPrevio(this.formatarNumeroInteger(aux));
            aux = dispensadoAviso.doubleValue();
            aux = aux == 1.0 ? aux : 2.0;
            contrato.setTPEmpregadoDispensadoAvisoPrevio(this.formatarNumeroInteger(aux));
            contrato.setVLPensaoAlimenticiaTRCT(BigDecimal.ZERO);
            contrato.setPCPensaoAlimenticiaTRCT(BigDecimal.ZERO);
            contrato.setPCPensaoAlimenticiaFGTS(BigDecimal.ZERO);
            contrato.setTPCategoriaTrabalhador(this.formatarNumeroInteger(new Double(r.getColaborador().getCategoriaTrabalhador().getCodigo())));
            contrato.setNRDependentesIR(this.formatarNumeroInteger(r.getNrDependentes().doubleValue()));
            contrato.setNRDependentesSalarioFamilia(this.formatarNumeroInteger(r.getNrQuota()));
            contrato.setDTTerminoContratoPrazoDeterminado(this.formatarNumeroInteger(new Double(this.formatarDataPadrao8Digitos(r.getColaborador().getSegundaDataExperiencia() == null ? r.getColaborador().getDataAdmissao() : r.getColaborador().getSegundaDataExperiencia()))));
            contrato.setTPContratoTempoParcial(this.getTempoParcialDeContratoTrabalho(r));
            contrato.setTPTrabalhador(this.formatarNumeroInteger(1.0));
            contrato.setDTQuitacaoRescisao(this.formatarNumeroInteger(new Double(this.formatarDataPadrao8Digitos(r.getDataPagamento()))));
            Empregador.Empregado.Contratos.Contrato.Ferias feriasHomolognet = new Empregador.Empregado.Contratos.Contrato.Ferias();
            Date ultimaFerias = null;
            Date inicioPeriodo = r.getColaborador().getDataAdmissao();
            Date finalPeriodo = null;
            boolean sair = false;
            ultimaFerias = r.getDataInicialFeriasVencidas() != null ? r.getDataInicialFeriasVencidas() : r.getUltimaDataFerias();
            do {
                Empregador.Empregado.Contratos.Contrato.Ferias.PeriodoAquisitivo periodoAquisitivo;
                if (inicioPeriodo.before(ultimaFerias)) {
                    finalPeriodo = DateUtil.nextMonth(inicioPeriodo, 12);
                    finalPeriodo = DateUtil.nextDays(finalPeriodo, -1);
                    periodoAquisitivo = new Empregador.Empregado.Contratos.Contrato.Ferias.PeriodoAquisitivo();
                    periodoAquisitivo.setDTInicio(this.formatarNumeroInteger(new Double(this.formatarDataPadrao8Digitos(inicioPeriodo))));
                    periodoAquisitivo.setDTFim(this.formatarNumeroInteger(new Double(this.formatarDataPadrao8Digitos(finalPeriodo))));
                    periodoAquisitivo.setTPQuitacaoFerias(this.formatarNumeroInteger(1.0));
                    periodoAquisitivo.setNRFaltas(this.formatarNumeroInteger(0.0));
                    feriasHomolognet.getPeriodoAquisitivo().add(periodoAquisitivo);
                    inicioPeriodo = DateUtil.nextDays(ultimaFerias, 1);
                    sair = false;
                    continue;
                }
                if (!ultimaFerias.equals(r.getUltimaDataFerias())) {
                    finalPeriodo = DateUtil.nextMonth(ultimaFerias, 12);
                    periodoAquisitivo = new Empregador.Empregado.Contratos.Contrato.Ferias.PeriodoAquisitivo();
                    periodoAquisitivo.setDTInicio(this.formatarNumeroInteger(new Double(this.formatarDataPadrao8Digitos(DateUtil.nextDays(ultimaFerias, 1)))));
                    periodoAquisitivo.setDTFim(this.formatarNumeroInteger(new Double(this.formatarDataPadrao8Digitos(finalPeriodo))));
                    periodoAquisitivo.setTPQuitacaoFerias(this.formatarNumeroInteger(2.0));
                    periodoAquisitivo.setNRFaltas(this.formatarNumeroInteger(0.0));
                    feriasHomolognet.getPeriodoAquisitivo().add(periodoAquisitivo);
                    Double faltas = r.getNrFaltas() + r.getFaltasDescontoFerias();
                    finalPeriodo = DateUtil.nextMonth(r.getUltimaDataFerias(), 12);
                    Empregador.Empregado.Contratos.Contrato.Ferias.PeriodoAquisitivo periodoAquisitivo1 = new Empregador.Empregado.Contratos.Contrato.Ferias.PeriodoAquisitivo();
                    periodoAquisitivo1.setDTInicio(this.formatarNumeroInteger(new Double(this.formatarDataPadrao8Digitos(DateUtil.nextDays(r.getUltimaDataFerias(), 1)))));
                    periodoAquisitivo1.setDTFim(this.formatarNumeroInteger(new Double(this.formatarDataPadrao8Digitos(finalPeriodo))));
                    periodoAquisitivo1.setTPQuitacaoFerias(this.formatarNumeroInteger(2.0));
                    periodoAquisitivo1.setNRFaltas(this.formatarNumeroInteger(faltas));
                    feriasHomolognet.getPeriodoAquisitivo().add(periodoAquisitivo1);
                } else {
                    Double faltas = r.getNrFaltas() + r.getFaltasDescontoFerias();
                    finalPeriodo = DateUtil.nextMonth(r.getUltimaDataFerias(), 12);
                    Empregador.Empregado.Contratos.Contrato.Ferias.PeriodoAquisitivo periodoAquisitivo1 = new Empregador.Empregado.Contratos.Contrato.Ferias.PeriodoAquisitivo();
                    periodoAquisitivo1.setDTInicio(this.formatarNumeroInteger(new Double(this.formatarDataPadrao8Digitos(r.getUltimaDataFerias()))));
                    periodoAquisitivo1.setDTFim(this.formatarNumeroInteger(new Double(this.formatarDataPadrao8Digitos(finalPeriodo))));
                    periodoAquisitivo1.setTPQuitacaoFerias(this.formatarNumeroInteger(2.0));
                    periodoAquisitivo1.setNRFaltas(this.formatarNumeroInteger(faltas));
                    feriasHomolognet.getPeriodoAquisitivo().add(periodoAquisitivo1);
                }
                sair = true;
            } while (!sair);
            if (!feriasHomolognet.getPeriodoAquisitivo().isEmpty()) {
                contrato.setFerias(feriasHomolognet);
            }
            Empregador.Empregado.Contratos.Contrato.DecimosTerceiros decimosTerceiros = new Empregador.Empregado.Contratos.Contrato.DecimosTerceiros();
            if (DateUtil.yearFromDate(r.getColaborador().getDataAdmissao()) < DateUtil.yearFromDate(r.getDataAfastamento())) {
                sair = false;
                Date periodoDec = r.getColaborador().getDataAdmissao();
                decimoTerceiro = null;
                do {
                    if (DateUtil.yearFromDate(periodoDec) < DateUtil.yearFromDate(r.getDataAfastamento())) {
                        decimoTerceiro = new Empregador.Empregado.Contratos.Contrato.DecimosTerceiros.DecimoTerceiro();
                        ((Empregador.Empregado.Contratos.Contrato.DecimosTerceiros.DecimoTerceiro)decimoTerceiro).setSTPago(this.formatarNumeroInteger(1.0));
                        ((Empregador.Empregado.Contratos.Contrato.DecimosTerceiros.DecimoTerceiro)decimoTerceiro).setNRAno(this.getAnoGregorianCalendar(periodoDec));
                        decimosTerceiros.getDecimoTerceiro().add((Empregador.Empregado.Contratos.Contrato.DecimosTerceiros.DecimoTerceiro)decimoTerceiro);
                    } else {
                        sair = true;
                    }
                    periodoDec = DateUtil.nextMonth(periodoDec, 12);
                } while (!sair);
            }
            if (!(pagDecimo13Salario = this.getPagamentoDecSalario(r.getColaborador(), r.getDataAfastamento())).isEmpty()) {
                for (Object obj : pagDecimo13Salario) {
                    HashMap hash = (HashMap)obj;
                    Empregador.Empregado.Contratos.Contrato.DecimosTerceiros.DecimoTerceiro decimoTerceiro2 = new Empregador.Empregado.Contratos.Contrato.DecimosTerceiros.DecimoTerceiro();
                    decimoTerceiro2.setSTPago(this.formatarNumeroInteger(1.0));
                    decimoTerceiro2.setNRAno(this.getAnoGregorianCalendar(r.getDataAfastamento()));
                    decimosTerceiros.getDecimoTerceiro().add(decimoTerceiro2);
                }
            } else {
                decimoTerceiro = new Empregador.Empregado.Contratos.Contrato.DecimosTerceiros.DecimoTerceiro();
                ((Empregador.Empregado.Contratos.Contrato.DecimosTerceiros.DecimoTerceiro)decimoTerceiro).setSTPago(this.formatarNumeroInteger(2.0));
                ((Empregador.Empregado.Contratos.Contrato.DecimosTerceiros.DecimoTerceiro)decimoTerceiro).setNRAno(this.getAnoGregorianCalendar(r.getDataAfastamento()));
                ((Empregador.Empregado.Contratos.Contrato.DecimosTerceiros.DecimoTerceiro)decimoTerceiro).setFaltasInjustificadas(this.getFaltasInjustificadas(r.getDataAfastamento(), r.getColaborador()));
                decimosTerceiros.getDecimoTerceiro().add((Empregador.Empregado.Contratos.Contrato.DecimosTerceiros.DecimoTerceiro)decimoTerceiro);
            }
            if (!decimosTerceiros.getDecimoTerceiro().isEmpty()) {
                contrato.setDecimosTerceiros(decimosTerceiros);
            }
            Empregador.Empregado.Contratos.Contrato.Movimentacoes movs = new Empregador.Empregado.Contratos.Contrato.Movimentacoes();
            for (Object obj : afastamentosColaboradores) {
                AfastamentoColaborador afastamentos = (AfastamentoColaborador)obj;
                Iterator mov = new Empregador.Empregado.Contratos.Contrato.Movimentacoes.Movimentacao();
                ((Empregador.Empregado.Contratos.Contrato.Movimentacoes.Movimentacao)((Object)mov)).setDTMovimentacao(this.formatarNumeroInteger(new Double(this.formatarDataPadrao8Digitos(afastamentos.getDataAfastamento()))));
                ((Empregador.Empregado.Contratos.Contrato.Movimentacoes.Movimentacao)((Object)mov)).setCDMotivo(MotivoTipo.fromValue(afastamentos.getAfastamentoSefip().getCodigo()));
                movs.getMovimentacao().add((Empregador.Empregado.Contratos.Contrato.Movimentacoes.Movimentacao)((Object)mov));
            }
            if (!movs.getMovimentacao().isEmpty()) {
                contrato.setMovimentacoes(movs);
            }
            Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios salarios = new Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios();
            List movsFolhas = this.findFolhaPorSalario(r.getColaborador());
            ArrayList<Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario> auxiliar = new ArrayList<Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario>();
            for (MovimentoFolha movimentoFolha : movsFolhas) {
                salario = new Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario();
                salario.setDTAnoMes(this.formatarNumeroInteger(new Double(this.formatarDataPadrao6Digitos(movimentoFolha.getAberturaPeriodo().getDataInicio()))));
                salario.setTPFormacao(BigInteger.valueOf(3L));
                valor = new ObjectFactory().createEmpregadorEmpregadoContratosContratoFinanceiroSalariosSalarioTPSalario(this.getTipoSalario(r.getColaborador().getTipoSalario().getCodigo()));
                salario.setTPSalario(valor);
                salario.setRubricas(this.getRubricas(movimentoFolha, r));
                this.getRubricasOrdenadas(salario);
                auxiliar.add(salario);
            }
            for (Object e : auxiliar) {
                salario = (Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario)e;
                salarios.getSalario().add(salario);
            }
            salarios.getSalario().add(this.getRubricasRescisao(r));
            Empregador.Empregado.Contratos.Contrato.Financeiro financeiro = new ObjectFactory().createEmpregadorEmpregadoContratosContratoFinanceiro();
            financeiro.setSalarios(salarios);
            financeiro.setVLSalarioLiquidoMesAnteriorRescisao(this.formatarNumeroDecimal(ContatoFormatUtil.arrredondarNumero((Double)r.getUltimaRemuneracao(), (int)2)));
            financeiro.setNRQuantidadeDsr(this.formatarNumeroInteger(r.getNrDiasFolgas() + r.getNrDiasferiados()));
            contrato.setFinanceiro(financeiro);
            contrato.setDesconto(this.getDescontos(r));
            Empregador.Empregado.Contratos contratos = new ObjectFactory().createEmpregadorEmpregadoContratos();
            contratos.getContrato().add(contrato);
            empregado.setContratos(contratos);
            empregador.getEmpregado().add(empregado);
            Empregador.Codigos codigos = new Empregador.Codigos();
            for (Empregador.Empregado.Contratos.Contrato c : empregado.getContratos().getContrato()) {
                if (c.getDesconto().getOutros() == null || c.getDesconto().getOutros().getOutro().isEmpty()) continue;
                for (Empregador.Empregado.Contratos.Contrato.Desconto.Outros.Outro outro : c.getDesconto().getOutros().getOutro()) {
                    Empregador.Codigos.Codigo codigo = new Empregador.Codigos.Codigo();
                    codigo.setTPCodigo(this.formatarNumeroInteger(3.0));
                    if (outro.getCDOutro().toString().length() >= 3) {
                        codigo.setCDCodigo(outro.getCDOutro().toString().substring(0, 3));
                    } else {
                        codigo.setCDCodigo(outro.getCDOutro().toString());
                    }
                    codigo.setDSCodigo("OUTROS DESCONTOS");
                    codigos.getCodigo().add(codigo);
                }
            }
            if (!codigos.getCodigo().isEmpty()) {
                empregador.setCodigos(codigos);
            }
        }
        return empregador;
    }

    private BigInteger formatarNumeroInteger(Double numero) {
        return new BigDecimal(numero.toString()).toBigInteger();
    }

    private BigDecimal formatarNumeroDecimal(Double numero) {
        return new BigDecimal(numero).setScale(2, 6);
    }

    private Integer calcularDiferencaMesesDecimoTerceito(Recisao r) {
        Integer ano = DateUtil.yearFromDate(r.getDataAfastamento());
        Date primeiroJaneiro = DateUtil.intToDate(ano, 1, 1);
        if (r.getColaborador().getDataAdmissao().before(primeiroJaneiro) || r.getColaborador().getDataAdmissao().equals(primeiroJaneiro)) {
            return DateUtil.getMesesEntreDatas(primeiroJaneiro, r.getDataAfastamento(), false);
        }
        return DateUtil.getMesesEntreDatas(r.getColaborador().getDataAdmissao(), r.getDataAfastamento(), false);
    }

    private Integer calculcarDiferencaMesesFerias(Recisao r) {
        return DateUtil.getMesesEntreDatas(r.getUltimaDataFerias(), r.getDataAfastamento(), false);
    }

    private Integer calcularDiferencaMesesAviso(Recisao r) {
        Integer difMeses = DateUtil.getMesesEntreDatas(r.getColaborador().getDataAdmissao(), r.getDataAfastamento(), false);
        if (difMeses > 12) {
            return 12;
        }
        return difMeses;
    }

    private String formatarDataPadrao8Digitos(Date data) {
        SimpleDateFormat dataFormatada = new SimpleDateFormat("yyyyMMdd");
        String dataVenc = dataFormatada.format(data);
        return dataVenc;
    }

    private String formatarDataPadrao4Digitos(Date data) {
        SimpleDateFormat dataFormatada = new SimpleDateFormat("MMdd");
        String dataVenc = dataFormatada.format(data);
        return dataVenc;
    }

    private String formatarDataPadrao6Digitos(Date data) {
        SimpleDateFormat dataFormatada = new SimpleDateFormat("yyyyMM");
        String dataVenc = dataFormatada.format(data);
        return dataVenc;
    }

    private BigInteger getTempoParcialDeContratoTrabalho(Recisao r) {
        if (r.getColaborador().getJornadaSemanalTrabalho() > 25) {
            return this.formatarNumeroInteger(2.0);
        }
        return this.formatarNumeroInteger(1.0);
    }

    private List getFaltasPeriodo(Colaborador colaborador, Date dataAfastamento, TipoCalculoEvento tpFaltas) {
        Integer ano = DateUtil.yearFromDate(dataAfastamento);
        String hql = " select item.movimentoFolha.aberturaPeriodo.dataInicio as PERIODO,  item.referencia as QUANTIDADE  from ItemMovimentoFolha item  where  extract(year from item.movimentoFolha.aberturaPeriodo.dataInicio) = :ano  and  item.eventoColaborador.tipoCalculoEvento = :faltas  and  item.movimentoFolha.colaborador = :colaborador ";
        List ret = CoreBdUtil.getInstance().getSession().createQuery(hql).setInteger("ano", ano.intValue()).setEntity("faltas", (Object)tpFaltas).setEntity("colaborador", (Object)colaborador).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        return ret;
    }

    private List getPagamentoDecSalario(Colaborador colaborador, Date dataAfastamento) {
        String hql = " select  item.movimentoFolha.aberturaPeriodo.dataInicio as PERIODO,  item.valor as VALOR  from ItemMovimentoFolha item  where  item.eventoColaborador.tipoCalculoEvento.evento.codigo = 1010  and  item.movimentoFolha.colaborador = :colaborador  and  extract(year from item.movimentoFolha.aberturaPeriodo.dataInicio) = :anoAfastamento";
        List ret = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setInteger("anoAfastamento", DateUtil.yearFromDate(dataAfastamento).intValue()).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        return ret;
    }

    private Integer getAnoGregorianCalendar(Date periodo) throws DatatypeConfigurationException {
        GregorianCalendar gcal = new GregorianCalendar();
        gcal.setTime(periodo);
        return gcal.get(1);
    }

    private BigInteger getTipoSalario(String codigo) {
        Integer tpSalario = new Integer(codigo);
        if (tpSalario.equals(1)) {
            return BigInteger.valueOf(2L);
        }
        return BigInteger.ONE;
    }

    private BigInteger formatarNumeroIntegerString(String aux) {
        return new BigDecimal(aux).toBigInteger();
    }

    private Empregador.Empregado.Contratos.Contrato.Desconto getDescontos(Recisao r) {
        Empregador.Empregado.Contratos.Contrato.Desconto desconto = new Empregador.Empregado.Contratos.Contrato.Desconto();
        Double OUTROS_DESCONTOS = 0.0;
        Double ADIANTAMENTO_SALARIAL = 0.0;
        Double ADIANTAMENTO_DECIMO_TERCEIRO = 0.0;
        Double FALTAS = 0.0;
        Double VALE_TRANSPORTES = 0.0;
        Double VALE_ALIMENTACAO = 0.0;
        Double REEMBOLSO_VALE_TRANSPORTE = 0.0;
        Double REEMBOLSO_VALE_ALIMENTACAO = 0.0;
        Double DESCONTO_CONSIGNADO = 0.0;
        Double INDENIZACAO_PELA_TERMINO_DE_CONTRATO_PELO_EMPREGADO = 0.0;
        Double CONTRIBUICAO_FAPI = 0.0;
        Double CONTRIBUICAO_SINDICAL_LABORAL = 0.0;
        ArrayList<Empregador.Empregado.Contratos.Contrato.Desconto.Outros.Outro> outrosDescontos = new ArrayList<Empregador.Empregado.Contratos.Contrato.Desconto.Outros.Outro>();
        for (ItemMovimentoRescisao item : r.getItemRescisao()) {
            DeParaEventosHomolognet deParaEventosHomolognet = this.findEventoDePara(item.getEventoColaborador().getTipoCalculoEvento());
            Evento evento = item.getEventoColaborador().getTipoCalculoEvento().getEvento();
            if (evento.getTipoEvento().equals(EnumConstEventoParamFolha.EVENTO_DESCONTO.getValue()) && deParaEventosHomolognet != null) {
                Short codigoDesconto = new Short(deParaEventosHomolognet.getDescontosHomolognet().getCodigo());
                switch (codigoDesconto) {
                    case 1: {
                        ADIANTAMENTO_DECIMO_TERCEIRO = ADIANTAMENTO_DECIMO_TERCEIRO + item.getValor();
                        break;
                    }
                    case 2: {
                        ADIANTAMENTO_DECIMO_TERCEIRO = ADIANTAMENTO_DECIMO_TERCEIRO + item.getValor();
                        break;
                    }
                    case 3: {
                        FALTAS = FALTAS + item.getReferencia();
                        break;
                    }
                    case 4: {
                        VALE_TRANSPORTES = VALE_TRANSPORTES + item.getValor();
                        break;
                    }
                    case 5: {
                        VALE_ALIMENTACAO = VALE_ALIMENTACAO + item.getValor();
                        break;
                    }
                    case 6: {
                        REEMBOLSO_VALE_TRANSPORTE = REEMBOLSO_VALE_TRANSPORTE + item.getValor();
                        break;
                    }
                    case 7: {
                        REEMBOLSO_VALE_ALIMENTACAO = REEMBOLSO_VALE_ALIMENTACAO + item.getValor();
                        break;
                    }
                    case 8: {
                        DESCONTO_CONSIGNADO = DESCONTO_CONSIGNADO + item.getValor();
                        break;
                    }
                    case 9: {
                        INDENIZACAO_PELA_TERMINO_DE_CONTRATO_PELO_EMPREGADO = INDENIZACAO_PELA_TERMINO_DE_CONTRATO_PELO_EMPREGADO + item.getValor();
                        break;
                    }
                    case 10: {
                        CONTRIBUICAO_FAPI = CONTRIBUICAO_FAPI + item.getValor();
                        break;
                    }
                    case 11: {
                        CONTRIBUICAO_SINDICAL_LABORAL = CONTRIBUICAO_SINDICAL_LABORAL + item.getValor();
                    }
                }
                continue;
            }
            if (!evento.getTipoEvento().equals(EnumConstEventoParamFolha.EVENTO_DESCONTO.getValue()) || deParaEventosHomolognet != null || evento.getCodigo().equals(1019L)) continue;
            outrosDescontos.add(this.outrosDescontos(item));
        }
        desconto.setVLAdiantamentoSalarial(this.formatarNumeroDecimal(ADIANTAMENTO_SALARIAL));
        desconto.setVLAdiantamento13Salario(this.formatarNumeroDecimal(ADIANTAMENTO_DECIMO_TERCEIRO));
        desconto.setNRFaltas(this.formatarNumeroInteger(FALTAS));
        desconto.setVLValeTransporte(this.formatarNumeroDecimal(VALE_TRANSPORTES));
        desconto.setVLValeAlimentacao(this.formatarNumeroDecimal(VALE_ALIMENTACAO));
        desconto.setVLReembolsoVT(this.formatarNumeroDecimal(REEMBOLSO_VALE_TRANSPORTE));
        desconto.setVLReembolsoVA(this.formatarNumeroDecimal(REEMBOLSO_VALE_ALIMENTACAO));
        desconto.setVLCreditoConsignado(this.formatarNumeroDecimal(DESCONTO_CONSIGNADO));
        desconto.setVLIndenizacao(this.formatarNumeroDecimal(INDENIZACAO_PELA_TERMINO_DE_CONTRATO_PELO_EMPREGADO));
        desconto.setVLContribuicaoPrevidenciaPrivada(this.formatarNumeroDecimal(0.0));
        desconto.setVLContribuicaoFapi(this.formatarNumeroDecimal(CONTRIBUICAO_FAPI));
        desconto.setVLContribuicaoSindicalLaboral(this.formatarNumeroDecimal(CONTRIBUICAO_SINDICAL_LABORAL));
        desconto.setVLOutrasDeducoesBaseCalculoIRRF(this.formatarNumeroDecimal(0.0));
        desconto.setVLComplementacaoIRRFRendimentoMesQuitacao(this.formatarNumeroDecimal(0.0));
        desconto.setVLCompensacaoDiasSalarioFeriasMesAfastamento(this.formatarNumeroDecimal(0.0));
        Empregador.Empregado.Contratos.Contrato.Desconto.Outros outros = new Empregador.Empregado.Contratos.Contrato.Desconto.Outros();
        if (!outrosDescontos.isEmpty()) {
            for (Object e : outrosDescontos) {
                Empregador.Empregado.Contratos.Contrato.Desconto.Outros.Outro outro = (Empregador.Empregado.Contratos.Contrato.Desconto.Outros.Outro)e;
                outros.getOutro().add(outro);
            }
            desconto.setOutros(outros);
        }
        return desconto;
    }

    private Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario.Rubricas getRubricas(MovimentoFolha movFolha, Recisao r) throws ExceptionService {
        Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario.Rubricas rubricas = new Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario.Rubricas();
        boolean achou = false;
        for (ItemMovimentoFolha item : movFolha.getItensMovimentoFolha()) {
            DeParaEventosHomolognet dePara = this.findEventoDePara(item.getEventoColaborador().getTipoCalculoEvento());
            Evento evento = item.getEventoColaborador().getTipoCalculoEvento().getEvento();
            if (evento.getTipoEvento().equals(EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue()) && dePara != null) {
                TabelaRubricaHomolognet tabelaRubrica = dePara.getRubricasHomolognet();
                for (Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario.Rubricas.Rubrica rubrica : rubricas.getRubrica()) {
                    if (!rubrica.getCDTipoRubrica().equals(tabelaRubrica.getCodigo()) || !tabelaRubrica.getPossuiPerc().equals((short)0) && (!tabelaRubrica.getPossuiPerc().equals((short)1) || !this.formatarNumeroDecimal(dePara.getPercentualEvento()).equals(rubrica.getPCPercentualRubrica().getValue()))) continue;
                    achou = true;
                    BigDecimal valorRubrica = (BigDecimal)rubrica.getVLRubrica().getValue();
                    BigDecimal valorEvento = this.formatarNumeroDecimal(item.getValor());
                    rubrica.setVLRubrica(new ObjectFactory().createEmpregadorEmpregadoContratosContratoFinanceiroSalariosSalarioRubricasRubricaVLRubrica(this.formatarNumeroDecimal(valorEvento.doubleValue() + valorRubrica.doubleValue())));
                    if (tabelaRubrica.getTipoValor().equals((short)0)) {
                        valorRubrica = (BigDecimal)rubrica.getNRHoras().getValue();
                        valorEvento = this.formatarNumeroDecimal(item.getReferencia());
                        rubrica.setNRHoras(new ObjectFactory().createEmpregadorEmpregadoContratosContratoFinanceiroSalariosSalarioRubricasRubricaNRHoras(this.formatarNumeroDecimal(valorRubrica.doubleValue() + valorEvento.doubleValue())));
                    }
                    if (tabelaRubrica.getPossuiPerc().equals((short)1)) {
                        rubrica.setPCPercentualRubrica(new ObjectFactory().createEmpregadorEmpregadoContratosContratoFinanceiroSalariosSalarioRubricasRubricaPCPercentualRubrica(this.formatarNumeroDecimal(dePara.getPercentualEvento())));
                    }
                    if (!tabelaRubrica.getCompoemBaseCalculo().equals((short)1)) continue;
                    Double valorBaseCalculo = UtilDadosHomolognet.findValorFormula(r, dePara.getBaseCalculoEvento());
                    rubrica.setVLBaseCalculo(new ObjectFactory().createEmpregadorEmpregadoContratosContratoFinanceiroSalariosSalarioRubricasRubricaVLBaseCalculo(this.formatarNumeroDecimal(valorBaseCalculo)));
                }
                if (!achou) {
                    Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario.Rubricas.Rubrica rubrica = new Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario.Rubricas.Rubrica();
                    rubrica.setCDTipoRubrica(tabelaRubrica.getCodigo());
                    rubrica.setVLRubrica(new ObjectFactory().createEmpregadorEmpregadoContratosContratoFinanceiroSalariosSalarioRubricasRubricaVLRubrica(this.formatarNumeroDecimal(item.getValor())));
                    if (tabelaRubrica.getTipoValor().equals((short)0)) {
                        rubrica.setNRHoras(new ObjectFactory().createEmpregadorEmpregadoContratosContratoFinanceiroSalariosSalarioRubricasRubricaNRHoras(this.formatarNumeroDecimal(item.getReferencia())));
                    }
                    if (tabelaRubrica.getPossuiPerc().equals((short)1)) {
                        rubrica.setPCPercentualRubrica(new ObjectFactory().createEmpregadorEmpregadoContratosContratoFinanceiroSalariosSalarioRubricasRubricaPCPercentualRubrica(this.formatarNumeroDecimal(dePara.getPercentualEvento())));
                    }
                    if (tabelaRubrica.getCompoemBaseCalculo().equals((short)1)) {
                        Double valorBaseCalculo = UtilDadosHomolognet.findValorFormula(r, dePara.getBaseCalculoEvento());
                        rubrica.setVLBaseCalculo(new ObjectFactory().createEmpregadorEmpregadoContratosContratoFinanceiroSalariosSalarioRubricasRubricaVLBaseCalculo(this.formatarNumeroDecimal(valorBaseCalculo)));
                    }
                    rubricas.getRubrica().add(rubrica);
                }
            }
            achou = false;
        }
        if (r.getColaborador().getTipoSalario().getCodigo().equals("5")) {
            this.criarHorasTrabalhadas(rubricas, 220.0);
        }
        return rubricas;
    }

    private List findFolhaPorSalario(Colaborador colaborador) {
        String hql = " from MovimentoFolha m  where  m.colaborador = :colaborador  and  m.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento  and  m.statusFolha.codigo != :recisao  order by m.aberturaPeriodo.dataInicio ";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setShort("recisao", (short)3).setShort("folhaPagamento", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue()).list();
    }

    private Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario.RubricasExternas getRubricaExternas(MovimentoFolha movimentoFolha) {
        Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario.RubricasExternas rubricasExternas = new Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario.RubricasExternas();
        for (ItemMovimentoFolha item : movimentoFolha.getItensMovimentoFolha()) {
            TipoCalculoEvento tpCalculo = item.getEventoColaborador().getTipoCalculoEvento();
            DeParaEventosHomolognet dePara = this.findEventoDePara(tpCalculo);
            if (tpCalculo.getMediaFerias().equals((short)0) || dePara != null) continue;
            Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario.RubricasExternas.RubricaExterna rubricaExterna = new Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario.RubricasExternas.RubricaExterna();
            rubricaExterna.setCDIncidenteTributacao(this.getIncidenciaTributacaoRubricaExterna(item));
            rubricaExterna.setCDIndicadorIntegracaoBaseCalculo(this.formatarNumeroIntegerString(this.getIncidenciaTributacaoRubricaExterna(item)));
            rubricaExterna.setVLVerbaRescisoria(this.formatarNumeroDecimal(item.getValor()));
            rubricaExterna.setCDRubricaExterna(this.formatarNumeroIntegerString(tpCalculo.getEvento().getCodigo().toString()));
            rubricasExternas.getRubricaExterna().add(rubricaExterna);
        }
        return rubricasExternas;
    }

    private String getIncidenciaTributacaoRubricaExterna(ItemMovimentoFolha item) {
        String fgts = item.getEventoColaborador().getTipoCalculoEvento().getIncidenciaFgts().toString();
        String inss = item.getEventoColaborador().getTipoCalculoEvento().getIncidenciaInss().toString();
        String irrf = item.getEventoColaborador().getTipoCalculoEvento().getIncidenciaIrrf().toString();
        return fgts + inss + irrf;
    }

    private String getIncidenciaTributacaoOutrosDescontos(ItemMovimentoRescisao item) {
        String fgts = item.getEventoColaborador().getTipoCalculoEvento().getIncidenciaFgts().toString();
        String inss = item.getEventoColaborador().getTipoCalculoEvento().getIncidenciaInss().toString();
        String irrf = item.getEventoColaborador().getTipoCalculoEvento().getIncidenciaIrrf().toString();
        return fgts + inss + irrf;
    }

    private String getIncidenciaTributacaoRubricaExternaRescisao(ItemMovimentoRescisao item) {
        String fgts = item.getEventoColaborador().getTipoCalculoEvento().getIncidenciaFgts().toString();
        String inss = item.getEventoColaborador().getTipoCalculoEvento().getIncidenciaInss().toString();
        String irrf = item.getEventoColaborador().getTipoCalculoEvento().getIncidenciaIrrf().toString();
        return fgts + inss + irrf;
    }

    private String getIncidenciaTributacaoOutrosDescontosRescisao(ItemMovimentoRescisao item) {
        String fgts = item.getEventoColaborador().getTipoCalculoEvento().getIncidenciaFgts().toString();
        String inss = item.getEventoColaborador().getTipoCalculoEvento().getIncidenciaInss().toString();
        String irrf = item.getEventoColaborador().getTipoCalculoEvento().getIncidenciaIrrf().toString();
        return fgts + inss + irrf;
    }

    private Empregador.Empregado.Contratos.Contrato.Desconto.Outros.Outro outrosDescontos(ItemMovimentoRescisao item) {
        Empregador.Empregado.Contratos.Contrato.Desconto.Outros.Outro outrosDesconto = new Empregador.Empregado.Contratos.Contrato.Desconto.Outros.Outro();
        outrosDesconto.setCDIncidenteTributacao(new ObjectFactory().createEmpregadorEmpregadoContratosContratoDescontoOutrosOutroCDIncidenteTributacao(this.getIncidenciaTributacaoOutrosDescontos(item)));
        if (item.getEventoColaborador().getTipoCalculoEvento().getEvento().getCodigo().toString().length() >= 3) {
            outrosDesconto.setCDOutro(this.formatarNumeroIntegerString(item.getEventoColaborador().getTipoCalculoEvento().getEvento().getCodigo().toString().substring(0, 3)));
        } else {
            outrosDesconto.setCDOutro(this.formatarNumeroIntegerString(item.getEventoColaborador().getTipoCalculoEvento().getEvento().getCodigo().toString()));
        }
        outrosDesconto.setVLDesconto(new ObjectFactory().createEmpregadorEmpregadoContratosContratoDescontoOutrosOutroVLDesconto(this.formatarNumeroDecimal(item.getValor())));
        return outrosDesconto;
    }

    private Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario getRubricasRescisao(Recisao r) throws ExceptionService {
        boolean achou = false;
        Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario salario = new Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario();
        salario.setDTAnoMes(this.formatarNumeroInteger(new Double(this.formatarDataPadrao6Digitos(r.getDataAfastamento()))));
        salario.setTPFormacao(BigInteger.valueOf(3L));
        JAXBElement<BigInteger> valor = new ObjectFactory().createEmpregadorEmpregadoContratosContratoFinanceiroSalariosSalarioTPSalario(this.getTipoSalario(r.getColaborador().getTipoSalario().getCodigo()));
        salario.setTPSalario(valor);
        Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario.Rubricas rubricas = new Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario.Rubricas();
        for (ItemMovimentoRescisao item : r.getItemRescisao()) {
            achou = false;
            TipoCalculoEvento tpCalculo = item.getEventoColaborador().getTipoCalculoEvento();
            DeParaEventosHomolognet dePara = this.findEventoDePara(tpCalculo);
            if (!tpCalculo.getEvento().getTipoEvento().equals(EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue()) || dePara == null) continue;
            TabelaRubricaHomolognet tabelaRubrica = dePara.getRubricasHomolognet();
            for (Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario.Rubricas.Rubrica rubrica : rubricas.getRubrica()) {
                if (!rubrica.getCDTipoRubrica().equals(tabelaRubrica.getCodigo()) || !tabelaRubrica.getPossuiPerc().equals((short)0) && (!tabelaRubrica.getPossuiPerc().equals((short)1) || !this.formatarNumeroDecimal(dePara.getPercentualEvento()).equals(rubrica.getPCPercentualRubrica().getValue()))) continue;
                achou = true;
                BigDecimal valorRubrica = (BigDecimal)rubrica.getVLRubrica().getValue();
                BigDecimal valorEvento = this.formatarNumeroDecimal(item.getValor());
                rubrica.setVLRubrica(new ObjectFactory().createEmpregadorEmpregadoContratosContratoFinanceiroSalariosSalarioRubricasRubricaVLRubrica(this.formatarNumeroDecimal(valorEvento.doubleValue() + valorRubrica.doubleValue())));
                if (tabelaRubrica.getTipoValor().equals((short)0)) {
                    valorRubrica = (BigDecimal)rubrica.getNRHoras().getValue();
                    valorEvento = this.formatarNumeroDecimal(item.getReferencia());
                    rubrica.setNRHoras(new ObjectFactory().createEmpregadorEmpregadoContratosContratoFinanceiroSalariosSalarioRubricasRubricaNRHoras(this.formatarNumeroDecimal(valorRubrica.doubleValue() + valorEvento.doubleValue())));
                }
                if (tabelaRubrica.getPossuiPerc().equals((short)1)) {
                    rubrica.setPCPercentualRubrica(new ObjectFactory().createEmpregadorEmpregadoContratosContratoFinanceiroSalariosSalarioRubricasRubricaPCPercentualRubrica(this.formatarNumeroDecimal(dePara.getPercentualEvento())));
                }
                if (!tabelaRubrica.getCompoemBaseCalculo().equals((short)1)) continue;
                Double valorBaseCalculo = UtilDadosHomolognet.findValorFormula(r, dePara.getBaseCalculoEvento());
                rubrica.setVLBaseCalculo(new ObjectFactory().createEmpregadorEmpregadoContratosContratoFinanceiroSalariosSalarioRubricasRubricaVLBaseCalculo(this.formatarNumeroDecimal(valorBaseCalculo)));
            }
            if (achou) continue;
            Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario.Rubricas.Rubrica rubrica = new Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario.Rubricas.Rubrica();
            rubrica.setCDTipoRubrica(tabelaRubrica.getCodigo());
            if (!tabelaRubrica.getCodigo().equals("001")) {
                rubrica.setVLRubrica(new ObjectFactory().createEmpregadorEmpregadoContratosContratoFinanceiroSalariosSalarioRubricasRubricaVLRubrica(this.formatarNumeroDecimal(item.getValor())));
            } else {
                rubrica.setVLRubrica(new ObjectFactory().createEmpregadorEmpregadoContratosContratoFinanceiroSalariosSalarioRubricasRubricaVLRubrica(this.formatarNumeroDecimal(this.getSalarioLiquido(r))));
            }
            if (tabelaRubrica.getTipoValor().equals((short)0)) {
                rubrica.setNRHoras(new ObjectFactory().createEmpregadorEmpregadoContratosContratoFinanceiroSalariosSalarioRubricasRubricaNRHoras(this.formatarNumeroDecimal(item.getReferencia())));
            }
            if (tabelaRubrica.getPossuiPerc().equals((short)1)) {
                rubrica.setPCPercentualRubrica(new ObjectFactory().createEmpregadorEmpregadoContratosContratoFinanceiroSalariosSalarioRubricasRubricaPCPercentualRubrica(this.formatarNumeroDecimal(dePara.getPercentualEvento())));
            }
            if (tabelaRubrica.getCompoemBaseCalculo().equals((short)1)) {
                Double valorBaseCalculo = UtilDadosHomolognet.findValorFormula(r, dePara.getBaseCalculoEvento());
                rubrica.setVLBaseCalculo(new ObjectFactory().createEmpregadorEmpregadoContratosContratoFinanceiroSalariosSalarioRubricasRubricaVLBaseCalculo(this.formatarNumeroDecimal(valorBaseCalculo)));
            }
            rubricas.getRubrica().add(rubrica);
        }
        if (r.getColaborador().getTipoSalario().getCodigo().equals("5")) {
            this.criarHorasTrabalhadas(rubricas, (r.getNrDiasFolgas() + r.getNrDiasferiados() + r.getNrDiasTrabalhados() - (r.getNrFaltas() - r.getNrDescontoDSR())) * r.getColaborador().getHorasTrabDia());
        }
        Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario.RubricasExternas rubricasExternas = new Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario.RubricasExternas();
        for (ItemMovimentoRescisao item : r.getItemRescisao()) {
            TipoCalculoEvento tpCalculo = item.getEventoColaborador().getTipoCalculoEvento();
            System.err.println(tpCalculo.getEvento().getDescricao());
            DeParaEventosHomolognet dePara = this.findEventoDePara(tpCalculo);
            if (tpCalculo.getMediaFerias().equals((short)0) || dePara != null || !tpCalculo.getEvento().getTipoEvento().equals(EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue())) continue;
            Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario.RubricasExternas.RubricaExterna rubricaExterna = new Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario.RubricasExternas.RubricaExterna();
            rubricaExterna.setCDIncidenteTributacao(this.getIncidenciaTributacaoRubricaExternaRescisao(item));
            rubricaExterna.setCDIndicadorIntegracaoBaseCalculo(this.formatarNumeroIntegerString(this.getIncidenciaTributacaoRubricaExternaRescisao(item)));
            rubricaExterna.setVLVerbaRescisoria(this.formatarNumeroDecimal(item.getValor()));
            rubricaExterna.setCDRubricaExterna(this.formatarNumeroIntegerString(tpCalculo.getEvento().getCodigo().toString()));
            rubricasExternas.getRubricaExterna().add(rubricaExterna);
        }
        salario.setRubricas(rubricas);
        if (!rubricasExternas.getRubricaExterna().isEmpty()) {
            salario.setRubricasExternas(rubricasExternas);
        }
        return salario;
    }

    private DeParaEventosHomolognet findEventoDePara(TipoCalculoEvento tipoCalculo) {
        String hql = " from DeParaEventosHomolognet dePara  where dePara.tipoCalculoEvento = :tipoCalculo ";
        return (DeParaEventosHomolognet)CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("tipoCalculo", (Object)tipoCalculo).uniqueResult();
    }

    private void getRubricasOrdenadas(Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario salario) {
        if (!salario.getRubricas().getRubrica().isEmpty()) {
            Collections.sort(salario.getRubricas().getRubrica(), new Comparator(this){

                public int compare(Object o1, Object o2) {
                    Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario.Rubricas.Rubrica item1 = (Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario.Rubricas.Rubrica)o1;
                    Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario.Rubricas.Rubrica item2 = (Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario.Rubricas.Rubrica)o2;
                    if (item1.getCDTipoRubrica() != null && item2.getCDTipoRubrica() != null) {
                        Double vlr1 = new Double(item1.getCDTipoRubrica());
                        Double vlr2 = new Double(item2.getCDTipoRubrica());
                        return vlr1.compareTo(vlr2);
                    }
                    return item1.getCDTipoRubrica().compareTo(item2.getCDTipoRubrica());
                }
            });
            return;
        }
    }

    private void criarHorasTrabalhadas(Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario.Rubricas rubricas, Double totalHorasTrabalhadasMes) {
        Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario.Rubricas.Rubrica rubrica = new Empregador.Empregado.Contratos.Contrato.Financeiro.Salarios.Salario.Rubricas.Rubrica();
        rubrica.setCDTipoRubrica("005");
        rubrica.setNRHoras(new ObjectFactory().createEmpregadorEmpregadoContratosContratoFinanceiroSalariosSalarioRubricasRubricaNRHoras(this.formatarNumeroDecimal(totalHorasTrabalhadasMes)));
        rubricas.getRubrica().add(rubrica);
    }

    private Empregador.Empregado.Contratos.Contrato.DecimosTerceiros.DecimoTerceiro.FaltasInjustificadas getFaltasInjustificadas(Date dataAfastamento, Colaborador c) {
        boolean sair = false;
        Integer mesDemissao = DateUtil.monthFromDate(dataAfastamento);
        Date dataCorrente = DateUtil.intToDate(DateUtil.yearFromDate(dataAfastamento), 1, 1);
        if (c.getDataAdmissao().after(dataCorrente)) {
            dataCorrente = c.getDataAdmissao();
        }
        Empregador.Empregado.Contratos.Contrato.DecimosTerceiros.DecimoTerceiro.FaltasInjustificadas.FaltaInjustificada falta = null;
        Empregador.Empregado.Contratos.Contrato.DecimosTerceiros.DecimoTerceiro.FaltasInjustificadas faltasInjustificadas = new Empregador.Empregado.Contratos.Contrato.DecimosTerceiros.DecimoTerceiro.FaltasInjustificadas();
        do {
            if (DateUtil.monthFromDate(dataCorrente) <= mesDemissao) {
                falta = new Empregador.Empregado.Contratos.Contrato.DecimosTerceiros.DecimoTerceiro.FaltasInjustificadas.FaltaInjustificada();
                falta.setDTAnoMes(new ObjectFactory().createEmpregadorEmpregadoContratosContratoDecimosTerceirosDecimoTerceiroFaltasInjustificadasFaltaInjustificadaDTAnoMes(this.formatarNumeroIntegerString(this.formatarDataPadrao6Digitos(dataCorrente))));
                falta.setNRFalta(new ObjectFactory().createEmpregadorEmpregadoContratosContratoDecimosTerceirosDecimoTerceiroFaltasInjustificadasFaltaInjustificadaNRFalta(BigInteger.ZERO));
                faltasInjustificadas.getFaltaInjustificada().add(falta);
                dataCorrente = DateUtil.nextMonth(dataCorrente, 1);
                continue;
            }
            sair = true;
        } while (!sair);
        return faltasInjustificadas;
    }

    private Double getSalarioLiquido(Recisao r) {
        if (r.getColaborador().getTipoSalario().getCodigo().equals("5")) {
            return ContatoFormatUtil.arrredondarNumero((Double)(r.getMaiorSalario() / r.getColaborador().getDiasJornada() / r.getColaborador().getHorasTrabDia()), (int)2);
        }
        return r.getMaiorSalario();
    }
}

