/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.rh.homolognet;

import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementor.model.vo.TabelaINSS;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Date;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.tools.ContatoFormatUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.nfunk.jep.JEP;

public class UtilDadosHomolognet {
    public static Double findValorFormula(Recisao r, String formula) throws ExceptionService {
        JEP myParser = new JEP();
        if (formula != null && !formula.isEmpty()) {
            List tokens = ToolString.getReplaceTokens((String)formula);
            for (Object o : tokens) {
                StringToken s = (StringToken)o;
                if (s.getChave().equalsIgnoreCase("valor_dia")) {
                    s.setValor(UtilDadosHomolognet.getValorDia(r.getColaborador(), r.getMaiorSalario()));
                } else if (s.getChave().equalsIgnoreCase("valor_hora")) {
                    s.setValor(UtilDadosHomolognet.getValorHora(r.getColaborador(), r.getMaiorSalario()));
                } else if (s.getChave().equalsIgnoreCase("salario_nominal")) {
                    s.setValor(r.getMaiorSalario().toString());
                } else if (s.getChave().equalsIgnoreCase("salario")) {
                    s.setValor(r.getMaiorSalario().toString());
                } else if (s.getChave().equalsIgnoreCase("salario_minimo")) {
                    s.setValor(UtilDadosHomolognet.getSalarioMinimo(r.getDataPagamento(), r.getDataPagamento()));
                }
                myParser.addVariable(s.getChave(), (Object)new Double(s.getValor()));
            }
            myParser.parseExpression(UtilDadosHomolognet.clearArrobas(formula));
            Double valor = myParser.getValue();
            Double retornoValor = ContatoFormatUtil.arrredondarNumero(valor, 2);
            if (retornoValor.isInfinite() || retornoValor.isNaN()) {
                return 0.0;
            }
            return retornoValor;
        }
        return 0.0;
    }

    public static String getValorDia(Colaborador colaborador, Double salarioNominal) throws ExceptionService {
        Double valor = salarioNominal;
        valor = valor / colaborador.getDiasJornada();
        return valor.toString();
    }

    public static String getValorHora(Colaborador colaborador, Double salarioNominal) throws ExceptionService {
        Double valor = salarioNominal;
        valor = valor / colaborador.getDiasJornada() / colaborador.getHorasTrabDia();
        return valor.toString();
    }

    public static String getSalarioMinimo(Date periodoInicial, Date periodoFinal) throws ExceptionService {
        Session s = null;
        Query q = null;
        s = CoreBdUtil.getInstance().getSession();
        q = s.createQuery(" from TabelaINSS t where t.dataInicial <= :periodoInicial and t.dataFinal >= :periodoFinal");
        q.setDate("periodoInicial", periodoInicial);
        q.setDate("periodoFinal", periodoFinal);
        TabelaINSS tabela = (TabelaINSS)q.uniqueResult();
        return tabela.getVrSalarioMinimo().toString();
    }

    public static String clearArrobas(String formula) {
        char[] aux = formula.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < aux.length; ++i) {
            if (aux[i] == '@') continue;
            sb.append(aux[i]);
        }
        return sb.toString();
    }
}

